/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvt.declarative.modelregistry.eclipse;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URISyntaxException;
import java.net.URL;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.qvt.declarative.modelregistry.eclipse.AccessorKindRegistryReader;
import org.eclipse.qvt.declarative.modelregistry.eclipse.ModelContentRegistryReader;
import org.eclipse.qvt.declarative.modelregistry.eclipse.ModelRegistryPlugin;
import org.eclipse.qvt.declarative.modelregistry.eclipse.ModelSerializationRegistryReader;
import org.eclipse.qvt.declarative.modelregistry.environment.AccessorKindRegistry;
import org.eclipse.qvt.declarative.modelregistry.environment.ModelContentRegistry;
import org.eclipse.qvt.declarative.modelregistry.environment.ModelRegistryEnvironment;
import org.eclipse.qvt.declarative.modelregistry.environment.ModelSerializationRegistry;

public class EclipseModelRegistryEnvironment
extends ModelRegistryEnvironment {
    public static final String ACCESSOR_KIND_PPID = "accessor_kind";
    public static final String MODEL_CONTENT_PPID = "model_content";
    public static final String MODEL_SERIALIZATION_PPID = "model_serialization";

    public File getFile(URI uri) throws URISyntaxException, IOException {
        String fileString = uri.toString();
        URL url = new URL(fileString);
        URL resolvedURL = FileLocator.toFileURL((URL)url);
        if (!"file".equals(resolvedURL.getProtocol())) {
            return null;
        }
        return new File(resolvedURL.toString().substring(5));
    }

    protected void initializeAccessorKindRegistry(AccessorKindRegistry accessorKindRegistry) {
        new AccessorKindRegistryReader(accessorKindRegistry).readRegistry();
    }

    protected void initializeModelContentRegistry(ModelContentRegistry modelContentRegistry) {
        new ModelContentRegistryReader(modelContentRegistry).readRegistry();
    }

    protected void initializeModelSerializationRegistry(ModelSerializationRegistry modelSerializationRegistry) {
        new ModelSerializationRegistryReader(modelSerializationRegistry).readRegistry();
    }

    public void logTheError(String string, Throwable e) {
        this.logException(this.newError(string, e), false);
    }

    public void logException(Throwable e, boolean showErrorDialog) {
        if (e instanceof InvocationTargetException) {
            e = ((InvocationTargetException)e).getTargetException();
        }
        IStatus status = null;
        if (e instanceof CoreException) {
            status = ((CoreException)e).getStatus();
        } else {
            String message = e.getMessage();
            if (message == null) {
                message = e.toString();
            }
            status = new Status(4, "org.eclipse.qvt.declarative.modelregistry", 0, message, e);
        }
        ModelRegistryPlugin.log(status, showErrorDialog);
    }

    public CoreException newError(String text, Throwable exception) {
        return new CoreException((IStatus)new Status(4, "org.eclipse.qvt.declarative.modelregistry", 4, "ERROR -- " + text, exception));
    }
}

