/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvt.declarative.common.framework.service;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.qvt.declarative.common.framework.service.ExecutionStrategy;
import org.eclipse.qvt.declarative.common.framework.service.Operation;
import org.eclipse.qvt.declarative.common.framework.service.Provider;
import org.eclipse.qvt.declarative.common.framework.service.ProviderDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Service
implements Provider {
    protected final Map<ProviderDescriptor.Priority, ArrayList<Provider>> providers = new HashMap<ProviderDescriptor.Priority, ArrayList<Provider>>();

    protected final List<? extends Object> execute(ExecutionStrategy strategy, Operation operation) throws Exception {
        assert (operation != null) : "null operation";
        return strategy.execute(this, operation);
    }

    public Service() {
        ProviderDescriptor.Priority[] priorityArray = ProviderDescriptor.Priority.values();
        int n = priorityArray.length;
        int n2 = 0;
        while (n2 < n) {
            ProviderDescriptor.Priority providerPriority = priorityArray[n2];
            this.providers.put(providerPriority, new ArrayList());
            ++n2;
        }
    }

    @Override
    public boolean provides(Operation operation) {
        assert (operation != null) : "null operation passed to provides(IOperation)";
        ProviderDescriptor.Priority[] priorityArray = ProviderDescriptor.Priority.values();
        int n = priorityArray.length;
        int n2 = 0;
        while (n2 < n) {
            ProviderDescriptor.Priority providerPriority = priorityArray[n2];
            for (Provider provider : this.providers.get((Object)providerPriority)) {
                if (!provider.provides(operation)) continue;
                return true;
            }
            ++n2;
        }
        return false;
    }

    protected final void addProvider(ProviderDescriptor.Priority priority, ProviderDescriptor provider) {
        assert (priority != null) : "null ProviderPriority";
        assert (provider != null) : "null ProviderDescriptor";
        this.providers.get((Object)priority).add(provider);
    }

    protected Provider getFirstProvider(Operation operation) {
        List<ProviderDescriptor.Priority> providerPriorities = Arrays.asList(ProviderDescriptor.Priority.values());
        Collections.reverse(providerPriorities);
        for (ProviderDescriptor.Priority providerPriority : providerPriorities) {
            for (Provider provider : this.providers.get((Object)providerPriority)) {
                if (!provider.provides(operation)) continue;
                return provider;
            }
        }
        return null;
    }

    protected List<Provider> getProvidersByPriorityDescending(Operation operation) {
        ArrayList<Provider> result = new ArrayList<Provider>();
        List<ProviderDescriptor.Priority> providerPriorities = Arrays.asList(ProviderDescriptor.Priority.values());
        Collections.reverse(providerPriorities);
        for (ProviderDescriptor.Priority providerPriority : providerPriorities) {
            for (Provider provider : this.providers.get((Object)providerPriority)) {
                if (!provider.provides(operation)) continue;
                result.add(provider);
            }
        }
        return result;
    }

    public Provider[] getProviders(ProviderDescriptor.Priority priority) {
        List selectedProviders = this.providers.get((Object)priority);
        return selectedProviders.toArray(new Provider[selectedProviders.size()]);
    }

    public Map<ProviderDescriptor.Priority, Provider[]> getProviders() {
        LinkedHashMap<ProviderDescriptor.Priority, Provider[]> result = new LinkedHashMap<ProviderDescriptor.Priority, Provider[]>();
        ProviderDescriptor.Priority[] priorityArray = ProviderDescriptor.Priority.values();
        int n = priorityArray.length;
        int n2 = 0;
        while (n2 < n) {
            ProviderDescriptor.Priority priority = priorityArray[n2];
            result.put(priority, this.getProviders(priority));
            ++n2;
        }
        return result;
    }
}

