/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.adt.ui.text.atl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationExtension;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import org.eclipse.m2m.atl.adt.ui.text.AtlCodeReader;
import org.eclipse.m2m.atl.adt.ui.text.IAtlLexems;
import org.eclipse.m2m.atl.adt.ui.text.atl.AtlCompletionProposal;
import org.eclipse.m2m.atl.adt.ui.text.atl.AtlCompletionProposalComparator;
import org.eclipse.m2m.atl.adt.ui.text.atl.AtlParameterListValidator;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IEditorPart;

public class AtlCompletionProcessor
implements IContentAssistProcessor {
    private AtlCompletionProposalComparator fComparator = new AtlCompletionProposalComparator();
    private char[] fProposalAutoActivationSet;
    private AtlParameterListValidator fValidator;

    public AtlCompletionProcessor(IEditorPart editor) {
    }

    private void addCompletionProposal(String proposal, List proposals, int documentOffset) {
        proposals.add(new AtlCompletionProposal(proposal, documentOffset, proposal.length(), null, String.valueOf(proposal) + " ", documentOffset));
    }

    private List addContextInformations(ITextViewer viewer, int offset) {
        ICompletionProposal[] proposals = this.internalComputeCompletionProposals(viewer, offset, -1);
        ArrayList<ContextInformationWrapper> result = new ArrayList<ContextInformationWrapper>();
        int i = 0;
        while (i < proposals.length) {
            IContextInformation contextInformation = proposals[i].getContextInformation();
            if (contextInformation != null) {
                ContextInformationWrapper wrapper = new ContextInformationWrapper(contextInformation);
                wrapper.setContextInformationPosition(offset);
                result.add(wrapper);
            }
            ++i;
        }
        return result;
    }

    public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int offset) {
        return this.internalComputeCompletionProposals(viewer, offset, this.guessContextInformationPosition(viewer, offset));
    }

    public IContextInformation[] computeContextInformation(ITextViewer viewer, int offset) {
        List result = this.addContextInformations(viewer, this.guessContextInformationPosition(viewer, offset));
        return result.toArray(new IContextInformation[result.size()]);
    }

    public char[] getCompletionProposalAutoActivationCharacters() {
        return this.fProposalAutoActivationSet;
    }

    public char[] getContextInformationAutoActivationCharacters() {
        return null;
    }

    public IContextInformationValidator getContextInformationValidator() {
        if (this.fValidator == null) {
            this.fValidator = new AtlParameterListValidator();
        }
        return this.fValidator;
    }

    public String getErrorMessage() {
        return "AtlEditor.codeassist.noCompletions";
    }

    private int guessContextInformationPosition(ITextViewer viewer, int offset) {
        int contextPosition = offset;
        IDocument document = viewer.getDocument();
        try {
            AtlCodeReader reader = new AtlCodeReader();
            reader.configureBackwardReader(document, offset, true, true);
            int nestingLevel = 0;
            int curr = reader.read();
            while (curr != -1) {
                if (')' == (char)curr) {
                    ++nestingLevel;
                } else if ('(' == (char)curr && --nestingLevel < 0) {
                    int start = reader.getOffset();
                    if (this.looksLikeRule(reader)) {
                        return start + 1;
                    }
                }
                curr = reader.read();
            }
        }
        catch (IOException iOException) {}
        return contextPosition;
    }

    private ICompletionProposal[] internalComputeCompletionProposals(ITextViewer viewer, int documentOffset, int contextOffset) {
        ArrayList proposals = new ArrayList();
        int i = 0;
        while (i < IAtlLexems.CONSTANTS.length) {
            this.addCompletionProposal(IAtlLexems.CONSTANTS[i], proposals, documentOffset);
            ++i;
        }
        i = 0;
        while (i < IAtlLexems.KEYWORDS.length) {
            this.addCompletionProposal(IAtlLexems.KEYWORDS[i], proposals, documentOffset);
            ++i;
        }
        i = 0;
        while (i < IAtlLexems.OPERATORS.length) {
            this.addCompletionProposal(IAtlLexems.OPERATORS[i], proposals, documentOffset);
            ++i;
        }
        i = 0;
        while (i < IAtlLexems.TYPES.length) {
            this.addCompletionProposal(IAtlLexems.TYPES[i], proposals, documentOffset);
            ++i;
        }
        ICompletionProposal[] results = new ICompletionProposal[proposals.size()];
        proposals.toArray(results);
        return this.order(results);
    }

    private boolean looksLikeRule(AtlCodeReader reader) throws IOException {
        int curr = reader.read();
        while (curr != -1 && Character.isWhitespace((char)curr)) {
            curr = reader.read();
        }
        if (curr == -1) {
            return false;
        }
        return Character.isJavaIdentifierPart((char)curr) || Character.isJavaIdentifierStart((char)curr);
    }

    private ICompletionProposal[] order(ICompletionProposal[] proposals) {
        Arrays.sort(proposals, this.fComparator);
        return proposals;
    }

    public void orderProposalsAlphabetically(boolean order) {
        this.fComparator.setOrderAlphabetically(order);
    }

    public void restrictProposalsToMatchingCases(boolean restrict) {
    }

    public void restrictProposalsToVisibility(boolean restrict) {
    }

    public void setCompletionProposalAutoActivationCharacters(char[] activationSet) {
        this.fProposalAutoActivationSet = activationSet;
    }

    private static class ContextInformationWrapper
    implements IContextInformation,
    IContextInformationExtension {
        private final IContextInformation fContextInformation;
        private int fPosition;

        public ContextInformationWrapper(IContextInformation contextInformation) {
            this.fContextInformation = contextInformation;
        }

        public boolean equals(Object object) {
            if (object instanceof ContextInformationWrapper) {
                return this.fContextInformation.equals((Object)((ContextInformationWrapper)object).fContextInformation);
            }
            return this.fContextInformation.equals(object);
        }

        public String getContextDisplayString() {
            return this.fContextInformation.getContextDisplayString();
        }

        public int getContextInformationPosition() {
            return this.fPosition;
        }

        public Image getImage() {
            return this.fContextInformation.getImage();
        }

        public String getInformationDisplayString() {
            return this.fContextInformation.getInformationDisplayString();
        }

        public void setContextInformationPosition(int position) {
            this.fPosition = position;
        }
    }
}

