/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xsd;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum XSDContentTypeCategory implements Enumerator
{
    EMPTY_LITERAL(0, "empty", "empty"),
    SIMPLE_LITERAL(1, "simple", "simple"),
    MIXED_LITERAL(2, "mixed", "mixed"),
    ELEMENT_ONLY_LITERAL(3, "elementOnly", "elementOnly");

    public static final int EMPTY = 0;
    public static final int SIMPLE = 1;
    public static final int MIXED = 2;
    public static final int ELEMENT_ONLY = 3;
    private static final XSDContentTypeCategory[] VALUES_ARRAY;
    public static final List<XSDContentTypeCategory> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new XSDContentTypeCategory[]{EMPTY_LITERAL, SIMPLE_LITERAL, MIXED_LITERAL, ELEMENT_ONLY_LITERAL};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static XSDContentTypeCategory get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            XSDContentTypeCategory result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static XSDContentTypeCategory getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            XSDContentTypeCategory result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static XSDContentTypeCategory get(int value) {
        switch (value) {
            case 0: {
                return EMPTY_LITERAL;
            }
            case 1: {
                return SIMPLE_LITERAL;
            }
            case 2: {
                return MIXED_LITERAL;
            }
            case 3: {
                return ELEMENT_ONLY_LITERAL;
            }
        }
        return null;
    }

    private XSDContentTypeCategory(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

