/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.codegen.ecore.genmodel.util;

import java.util.Map;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.codegen.ecore.CodeGenEcorePlugin;
import org.eclipse.emf.codegen.ecore.genmodel.GenAnnotation;
import org.eclipse.emf.codegen.ecore.genmodel.GenBase;
import org.eclipse.emf.codegen.ecore.genmodel.GenClass;
import org.eclipse.emf.codegen.ecore.genmodel.GenClassifier;
import org.eclipse.emf.codegen.ecore.genmodel.GenDataType;
import org.eclipse.emf.codegen.ecore.genmodel.GenDecoration;
import org.eclipse.emf.codegen.ecore.genmodel.GenDelegationKind;
import org.eclipse.emf.codegen.ecore.genmodel.GenEclipsePlatformVersion;
import org.eclipse.emf.codegen.ecore.genmodel.GenEnum;
import org.eclipse.emf.codegen.ecore.genmodel.GenEnumLiteral;
import org.eclipse.emf.codegen.ecore.genmodel.GenFeature;
import org.eclipse.emf.codegen.ecore.genmodel.GenJDKLevel;
import org.eclipse.emf.codegen.ecore.genmodel.GenModel;
import org.eclipse.emf.codegen.ecore.genmodel.GenModelPackage;
import org.eclipse.emf.codegen.ecore.genmodel.GenOperation;
import org.eclipse.emf.codegen.ecore.genmodel.GenPackage;
import org.eclipse.emf.codegen.ecore.genmodel.GenParameter;
import org.eclipse.emf.codegen.ecore.genmodel.GenPropertyKind;
import org.eclipse.emf.codegen.ecore.genmodel.GenProviderKind;
import org.eclipse.emf.codegen.ecore.genmodel.GenResourceKind;
import org.eclipse.emf.codegen.ecore.genmodel.GenRuntimePlatform;
import org.eclipse.emf.codegen.ecore.genmodel.GenRuntimeVersion;
import org.eclipse.emf.codegen.ecore.genmodel.GenTypeParameter;
import org.eclipse.emf.codegen.ecore.genmodel.GenTypedElement;
import org.eclipse.emf.codegen.ecore.genmodel.impl.Literals;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.emf.ecore.util.EObjectValidator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenModelValidator
extends EObjectValidator {
    public static final GenModelValidator INSTANCE = new GenModelValidator();
    public static final String DIAGNOSTIC_SOURCE = "org.eclipse.emf.codegen.ecore.genmodel";
    private static final int GENERATED_DIAGNOSTIC_CODE_COUNT = 0;
    public static final int NO_ECORE_DATA_TYPE = 1;
    public static final int WELL_FORMED_PATH = 2;
    protected static final int DIAGNOSTIC_CODE_COUNT = 2;

    protected EPackage getEPackage() {
        return GenModelPackage.eINSTANCE;
    }

    protected boolean validate(int classifierID, Object value, DiagnosticChain diagnostics, Map<Object, Object> context) {
        switch (classifierID) {
            case 0: {
                return this.validateGenModel((GenModel)value, diagnostics, context);
            }
            case 1: {
                return this.validateGenPackage((GenPackage)value, diagnostics, context);
            }
            case 2: {
                return this.validateGenClass((GenClass)value, diagnostics, context);
            }
            case 3: {
                return this.validateGenFeature((GenFeature)value, diagnostics, context);
            }
            case 4: {
                return this.validateGenBase((GenBase)value, diagnostics, context);
            }
            case 5: {
                return this.validateGenEnum((GenEnum)value, diagnostics, context);
            }
            case 6: {
                return this.validateGenEnumLiteral((GenEnumLiteral)value, diagnostics, context);
            }
            case 7: {
                return this.validateGenClassifier((GenClassifier)value, diagnostics, context);
            }
            case 8: {
                return this.validateGenDataType((GenDataType)value, diagnostics, context);
            }
            case 9: {
                return this.validateGenOperation((GenOperation)value, diagnostics, context);
            }
            case 10: {
                return this.validateGenParameter((GenParameter)value, diagnostics, context);
            }
            case 11: {
                return this.validateGenTypedElement((GenTypedElement)value, diagnostics, context);
            }
            case 12: {
                return this.validateGenAnnotation((GenAnnotation)value, diagnostics, context);
            }
            case 13: {
                return this.validateGenTypeParameter((GenTypeParameter)value, diagnostics, context);
            }
            case 14: {
                return this.validateGenProviderKind((GenProviderKind)((Object)value), diagnostics, context);
            }
            case 15: {
                return this.validateGenPropertyKind((GenPropertyKind)((Object)value), diagnostics, context);
            }
            case 16: {
                return this.validateGenResourceKind((GenResourceKind)((Object)value), diagnostics, context);
            }
            case 17: {
                return this.validateGenDelegationKind((GenDelegationKind)((Object)value), diagnostics, context);
            }
            case 18: {
                return this.validateGenJDKLevel((GenJDKLevel)((Object)value), diagnostics, context);
            }
            case 19: {
                return this.validateGenRuntimeVersion((GenRuntimeVersion)((Object)value), diagnostics, context);
            }
            case 20: {
                return this.validateGenRuntimePlatform((GenRuntimePlatform)((Object)value), diagnostics, context);
            }
            case 21: {
                return this.validateGenDecoration((GenDecoration)((Object)value), diagnostics, context);
            }
            case 22: {
                return this.validateGenEclipsePlatformVersion((GenEclipsePlatformVersion)((Object)value), diagnostics, context);
            }
            case 23: {
                return this.validatePath((String)value, diagnostics, context);
            }
        }
        return true;
    }

    public boolean validateGenModel(GenModel genModel, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(genModel, diagnostics, context);
    }

    public boolean validateGenPackage(GenPackage genPackage, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(genPackage, diagnostics, context);
    }

    public boolean validateGenClass(GenClass genClass, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(genClass, diagnostics, context);
    }

    public boolean validateGenFeature(GenFeature genFeature, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(genFeature, diagnostics, context);
    }

    public boolean validateGenBase(GenBase genBase, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(genBase, diagnostics, context);
    }

    public boolean validateGenEnum(GenEnum genEnum, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(genEnum, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(genEnum, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(genEnum, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(genEnum, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(genEnum, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(genEnum, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(genEnum, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(genEnum, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(genEnum, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateGenEnum_NoEcoreDataType(genEnum, diagnostics, context);
        }
        return result;
    }

    public boolean validateGenEnum_NoEcoreDataType(GenEnum genEnum, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (genEnum.eIsSet((EStructuralFeature)GenModelPackage.Literals.GEN_DATA_TYPE__ECORE_DATA_TYPE)) {
            if (diagnostics != null) {
                diagnostics.add((Diagnostic)this.createDiagnostic(4, DIAGNOSTIC_SOURCE, 1, "_UI_GenEnumNoEcoreDataType_diagnostic", new String[]{GenModelValidator.getObjectLabel((EObject)genEnum.getEcoreDataType(), context)}, new Object[]{genEnum, genEnum.getEcoreDataType()}, context));
            }
            return false;
        }
        return true;
    }

    protected boolean validate_MultiplicityConforms(EObject eObject, EStructuralFeature eStructuralFeature, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return eStructuralFeature == GenModelPackage.Literals.GEN_DATA_TYPE__ECORE_DATA_TYPE && eObject instanceof GenEnum || super.validate_MultiplicityConforms(eObject, eStructuralFeature, diagnostics, context);
    }

    public boolean validateGenEnumLiteral(GenEnumLiteral genEnumLiteral, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(genEnumLiteral, diagnostics, context);
    }

    public boolean validateGenClassifier(GenClassifier genClassifier, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(genClassifier, diagnostics, context);
    }

    public boolean validateGenDataType(GenDataType genDataType, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(genDataType, diagnostics, context);
    }

    public boolean validateGenOperation(GenOperation genOperation, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(genOperation, diagnostics, context);
    }

    public boolean validateGenParameter(GenParameter genParameter, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(genParameter, diagnostics, context);
    }

    public boolean validateGenTypedElement(GenTypedElement genTypedElement, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(genTypedElement, diagnostics, context);
    }

    public boolean validateGenAnnotation(GenAnnotation genAnnotation, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(genAnnotation, diagnostics, context);
    }

    public boolean validateGenTypeParameter(GenTypeParameter genTypeParameter, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(genTypeParameter, diagnostics, context);
    }

    public boolean validateGenProviderKind(GenProviderKind genProviderKind, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return true;
    }

    public boolean validateGenPropertyKind(GenPropertyKind genPropertyKind, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return true;
    }

    public boolean validateGenResourceKind(GenResourceKind genResourceKind, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return true;
    }

    public boolean validateGenDelegationKind(GenDelegationKind genDelegationKind, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return true;
    }

    public boolean validateGenJDKLevel(GenJDKLevel genJDKLevel, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return true;
    }

    public boolean validateGenRuntimeVersion(GenRuntimeVersion genRuntimeVersion, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return true;
    }

    public boolean validateGenRuntimePlatform(GenRuntimePlatform genRuntimePlatform, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return true;
    }

    public boolean validateGenDecoration(GenDecoration genDecoration, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return true;
    }

    public boolean validateGenEclipsePlatformVersion(GenEclipsePlatformVersion genEclipsePlatformVersion, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return true;
    }

    public boolean validatePath(String path, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result = this.validatePath_WellFormedPath(path, diagnostics, context);
        return result;
    }

    public boolean validatePath_WellFormedPath(String path, DiagnosticChain diagnostics, Map<Object, Object> context) {
        Status status;
        block6: {
            if ("".equals(path)) {
                return true;
            }
            try {
                IWorkspaceRoot workspaceRoot = EcorePlugin.getWorkspaceRoot();
                IPath workspacePath = new Path(path).makeAbsolute();
                status = workspaceRoot.getWorkspace().validatePath(workspacePath.toString(), 2);
                if (!status.isOK()) break block6;
                char[] cArray = path.toCharArray();
                int n = cArray.length;
                int n2 = 0;
                while (n2 < n) {
                    char c = cArray[n2];
                    if (c < ' ' || c == '\\') {
                        status = new Status(4, "org.eclipse.emf.codegen.ecore", CodeGenEcorePlugin.INSTANCE.getString("_UI_BadCharacterInPath_message", new Object[]{Literals.toCharLiteral(c, null)}));
                        break;
                    }
                    ++n2;
                }
            }
            catch (RuntimeException exception) {
                status = new Status(4, "org.eclipse.emf.codegen.ecore", exception.getMessage());
            }
        }
        if (diagnostics != null && !status.isOK()) {
            diagnostics.add((Diagnostic)this.createDiagnostic(4, DIAGNOSTIC_SOURCE, 2, "_UI_WellFormedPath_diagnostic", new Object[]{GenModelValidator.getValueLabel((EDataType)GenModelPackage.Literals.PATH, (Object)path, context), status.getMessage()}, new Object[]{path}, context));
        }
        return status.getSeverity() != 4;
    }

    public ResourceLocator getResourceLocator() {
        return CodeGenEcorePlugin.INSTANCE;
    }
}

