/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.example.databinding.project.ui.rcp.dialogs;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.databinding.EMFDataBindingContext;
import org.eclipse.emf.databinding.EMFUpdateValueStrategy;
import org.eclipse.emf.databinding.edit.EMFEditProperties;
import org.eclipse.emf.databinding.edit.IEMFEditValueProperty;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.xml.type.XMLTypeFactory;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.example.databinding.project.ui.rcp.databinding.Base64ToImageConverter;
import org.eclipse.emf.example.databinding.project.ui.rcp.databinding.EMFObservablesManager;
import org.eclipse.emf.example.databinding.project.ui.rcp.databinding.FormBuilder;
import org.eclipse.emf.examples.databinding.project.core.model.project.Person;
import org.eclipse.emf.examples.databinding.project.core.model.project.ProjectPackage;
import org.eclipse.jface.databinding.dialog.TitleAreaDialogSupport;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

public class PersonDialog
extends TitleAreaDialog {
    private final Person person;
    private final EditingDomain editingDomain;
    private final DataBindingContext ctx;

    public PersonDialog(Shell parentShell, EditingDomain editingDomain, Person person) {
        super(parentShell);
        this.person = person;
        this.editingDomain = editingDomain;
        this.ctx = new EMFDataBindingContext();
    }

    protected Control createDialogArea(Composite parent) {
        this.getShell().setText("Edit Person");
        this.setTitle("Edit Person");
        this.setMessage("Edit the data of the person and add an image (Max. 200KB and 200x200px)");
        final Composite comp = (Composite)super.createDialogArea(parent);
        EMFObservablesManager mgr = new EMFObservablesManager();
        mgr.runAndCollect(new Runnable(){

            public void run() {
                PersonDialog.this.createForm(comp).setLayoutData((Object)new GridData(1808));
            }
        });
        return comp;
    }

    private Composite createForm(Composite parent) {
        final Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout(2, false));
        Composite imgContainer = new Composite(container, 0);
        imgContainer.setLayout((Layout)new GridLayout());
        GridData gd = new GridData(200, -1);
        gd.verticalAlignment = 128;
        imgContainer.setLayoutData((Object)gd);
        final Label l = new Label(imgContainer, 2048);
        gd = new GridData(0x1000000, 4, false, false);
        l.setLayoutData((Object)gd);
        IEMFEditValueProperty mprop = EMFEditProperties.value((EditingDomain)this.editingDomain, (EStructuralFeature)ProjectPackage.Literals.PERSON__IMAGE);
        this.ctx.bindValue((IObservableValue)WidgetProperties.image().observe((Widget)l), mprop.observe((Object)this.person), null, new EMFUpdateValueStrategy().setConverter((IConverter)new Base64ToImageConverter(container.getDisplay())));
        l.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (l.getImage() != null) {
                    l.getImage().dispose();
                }
            }
        });
        Button button = new Button(imgContainer, 8);
        button.setText("Select Image ...");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PersonDialog.this.showImageSelectionDialog(container.getShell(), container);
            }
        });
        FormBuilder<IEMFEditValueProperty> builder = new FormBuilder<IEMFEditValueProperty>();
        builder.addTextEntry("Firstname", EMFEditProperties.value((EditingDomain)this.editingDomain, (EStructuralFeature)ProjectPackage.Literals.PERSON__FIRSTNAME), "Firstname must not be empty");
        builder.addTextEntry("Lastname", EMFEditProperties.value((EditingDomain)this.editingDomain, (EStructuralFeature)ProjectPackage.Literals.PERSON__LASTNAME), "Lastname must not be empty");
        builder.addTextEntry("E-Mail", EMFEditProperties.value((EditingDomain)this.editingDomain, (EStructuralFeature)ProjectPackage.Literals.PERSON__EMAIL), "E-Mail must not be empty");
        Composite formContainer = builder.build(this.ctx, container, this.person);
        formContainer.setLayoutData((Object)new GridData(1808));
        TitleAreaDialogSupport.create((TitleAreaDialog)this, (DataBindingContext)this.ctx);
        return container;
    }

    private void showImageSelectionDialog(Shell parent, Composite imgContainer) {
        FileDialog dialog = new FileDialog(parent);
        dialog.setFilterExtensions(new String[]{"*.png", "*.jpg"});
        String file = dialog.open();
        if (file != null) {
            try {
                File f = new File(file);
                if (f.length() < 204800L) {
                    int len;
                    FileInputStream in = new FileInputStream(f);
                    byte[] buf = new byte[1024];
                    ByteArrayOutputStream out = new ByteArrayOutputStream();
                    while ((len = in.read(buf)) != -1) {
                        out.write(buf, 0, len);
                    }
                    in.close();
                    String enc = XMLTypeFactory.eINSTANCE.convertBase64Binary(out.toByteArray());
                    out.close();
                    Command cmd = SetCommand.create((EditingDomain)this.editingDomain, (Object)this.person, (Object)ProjectPackage.Literals.PERSON__IMAGE, (Object)enc);
                    if (cmd.canExecute()) {
                        this.editingDomain.getCommandStack().execute(cmd);
                    }
                    imgContainer.layout(true);
                } else {
                    ErrorDialog.openError((Shell)parent, (String)"Image too big", (String)"The image selected is too big. The maximum file size is 200KB", (IStatus)new Status(4, "org.eclipse.emf.examples.databinding.project.ui.rcp", ""), (int)0x10000000);
                }
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public boolean close() {
        this.ctx.dispose();
        return super.close();
    }
}

