/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.example.databinding.project.ui.rcp.views;

import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Set;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IExecutionListener;
import org.eclipse.core.commands.NotHandledException;
import org.eclipse.core.databinding.ObservablesManager;
import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.map.IMapChangeListener;
import org.eclipse.core.databinding.observable.map.IObservableMap;
import org.eclipse.core.databinding.observable.map.MapChangeEvent;
import org.eclipse.core.databinding.observable.masterdetail.IObservableFactory;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.IValueChangeListener;
import org.eclipse.core.databinding.observable.value.ValueChangeEvent;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.emf.databinding.EMFProperties;
import org.eclipse.emf.databinding.FeaturePath;
import org.eclipse.emf.databinding.IEMFListProperty;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.example.databinding.project.ui.rcp.Activator;
import org.eclipse.emf.example.databinding.project.ui.rcp.ResourceProvider;
import org.eclipse.emf.example.databinding.project.ui.rcp.databinding.Base64ToImageConverter;
import org.eclipse.emf.examples.databinding.project.core.model.project.CommitterShip;
import org.eclipse.emf.examples.databinding.project.core.model.project.Foundation;
import org.eclipse.emf.examples.databinding.project.core.model.project.Person;
import org.eclipse.emf.examples.databinding.project.core.model.project.Project;
import org.eclipse.emf.examples.databinding.project.core.model.project.ProjectPackage;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.databinding.viewers.IViewerObservableValue;
import org.eclipse.jface.databinding.viewers.ObservableListTreeContentProvider;
import org.eclipse.jface.databinding.viewers.TreeStructureAdvisor;
import org.eclipse.jface.databinding.viewers.ViewerProperties;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StyledCellLabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.services.ISourceProviderService;

public class ProjectExplorerPart {
    private final TreeViewer viewer;
    private FormToolkit toolkit;
    private final Image projectImage;
    private final Image committerImage;
    private final IObservableValue master = new WritableValue();
    private final IExecutionListener paramListener;
    private final IViewSite site;

    public ProjectExplorerPart(IViewSite site, Composite parent, FormToolkit toolkit, Foundation foundation, ObservablesManager manager) {
        this.toolkit = toolkit;
        this.site = site;
        ImageDescriptor desc = Activator.imageDescriptorFromPlugin((String)"org.eclipse.ui", (String)"icons/full/obj16/generic_elements.gif");
        this.projectImage = desc != null ? desc.createImage() : null;
        desc = Activator.imageDescriptorFromPlugin((String)"org.eclipse.ui", (String)"icons/full/obj16/signed_yes_tbl.gif");
        this.committerImage = desc != null ? desc.createImage() : null;
        this.viewer = this.init(parent, foundation);
        this.paramListener = new CommandListener();
        ICommandService service = (ICommandService)site.getService(ICommandService.class);
        service.addExecutionListener(this.paramListener);
    }

    private TreeViewer init(Composite parent, Foundation foundation) {
        TreeViewer viewer = new TreeViewer(parent);
        ObservableListTreeContentProvider cp = new ObservableListTreeContentProvider((IObservableFactory)new TreeFactoryImpl(), (TreeStructureAdvisor)new TreeStructureAdvisorImpl());
        viewer.setContentProvider((IContentProvider)cp);
        IObservableSet set = cp.getKnownElements();
        IObservableMap[] map = new IObservableMap[]{EMFProperties.value((EStructuralFeature)ProjectPackage.Literals.PROJECT__SHORTNAME).observeDetail(set), EMFProperties.value((EStructuralFeature)ProjectPackage.Literals.PROJECT__COMMITTERS).observeDetail(set), EMFProperties.value((FeaturePath)FeaturePath.fromList((EStructuralFeature[])new EStructuralFeature[]{ProjectPackage.Literals.COMMITTER_SHIP__PERSON, ProjectPackage.Literals.PERSON__FIRSTNAME})).observeDetail(set), EMFProperties.value((FeaturePath)FeaturePath.fromList((EStructuralFeature[])new EStructuralFeature[]{ProjectPackage.Literals.COMMITTER_SHIP__PERSON, ProjectPackage.Literals.PERSON__LASTNAME})).observeDetail(set)};
        viewer.setLabelProvider((IBaseLabelProvider)new TreeLabelProviderImpl(map));
        IEMFListProperty projects = EMFProperties.list((EStructuralFeature)ProjectPackage.Literals.FOUNDATION__PROJECTS);
        viewer.setInput((Object)projects.observe((Object)foundation));
        MenuManager mgr = new MenuManager();
        mgr.add((IContributionItem)new GroupMarker("additions"));
        viewer.getControl().setMenu(mgr.createContextMenu(viewer.getControl()));
        this.site.registerContextMenu("org.eclipse.emf.examples.databinding.project.ui.rcp.projectexp", mgr, (ISelectionProvider)viewer);
        this.site.setSelectionProvider((ISelectionProvider)viewer);
        ColumnViewerToolTipSupportImpl.enableFor((ColumnViewer)viewer, this.toolkit);
        IViewerObservableValue treeObs = ViewerProperties.singleSelection().observe((Viewer)viewer);
        treeObs.addValueChangeListener(new IValueChangeListener(){

            public void handleValueChange(ValueChangeEvent event) {
                ISourceProviderService s = (ISourceProviderService)ProjectExplorerPart.this.site.getService(ISourceProviderService.class);
                ResourceProvider p = (ResourceProvider)s.getSourceProvider("modelresource");
                if (event.diff.getNewValue() instanceof Project) {
                    Project pr = (Project)event.diff.getNewValue();
                    ProjectExplorerPart.this.master.setValue((Object)pr);
                    p.setCommitter(null);
                    p.setProject(pr);
                } else if (event.diff.getNewValue() != null) {
                    CommitterShip cm = (CommitterShip)event.diff.getNewValue();
                    ProjectExplorerPart.this.master.setValue((Object)cm.getProject());
                    p.setCommitter(cm);
                    p.setProject(cm.getProject());
                } else {
                    p.setCommitter(null);
                    p.setProject(null);
                }
            }
        });
        return viewer;
    }

    public IObservableValue getProjectObservable() {
        return this.master;
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
        if (this.viewer.getTree().getItemCount() > 0) {
            this.viewer.setSelection((ISelection)new StructuredSelection(this.viewer.getTree().getItem(0).getData()));
        }
    }

    public void dispose() {
        ICommandService service = (ICommandService)this.site.getService(ICommandService.class);
        service.removeExecutionListener(this.paramListener);
        if (this.projectImage != null) {
            this.projectImage.dispose();
        }
        if (this.committerImage != null) {
            this.committerImage.dispose();
        }
    }

    public CommitterShip getCommitter() {
        Object obj = ((IStructuredSelection)this.viewer.getSelection()).getFirstElement();
        return (CommitterShip)(obj instanceof CommitterShip ? obj : null);
    }

    private static class ColumnViewerToolTipSupportImpl
    extends ColumnViewerToolTipSupport {
        private FormToolkit toolkit;

        protected ColumnViewerToolTipSupportImpl(FormToolkit toolkit, ColumnViewer viewer, int style) {
            super(viewer, style, false);
            this.setHideOnMouseDown(false);
            this.toolkit = toolkit;
        }

        protected Composite createViewerToolTipContentArea(Event event, ViewerCell cell, Composite parent) {
            if (cell.getElement() instanceof Project) {
                final Project p = (Project)cell.getElement();
                StringBuilder b = new StringBuilder();
                for (Person lead : p.getProjectleads()) {
                    if (b.length() > 0) {
                        b.append(", ");
                    }
                    b.append(String.valueOf(lead.getFirstname()) + " " + lead.getLastname());
                }
                Form form = this.toolkit.createForm(parent);
                this.toolkit.decorateFormHeading(form);
                form.setText(String.valueOf(p.getShortname()) + " - " + p.getLongname());
                Composite body = form.getBody();
                body.setLayout((Layout)new GridLayout(2, false));
                this.toolkit.createLabel(body, "Project creation:").setForeground(this.toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
                this.toolkit.createLabel(body, p.getStart() != null ? DateFormat.getDateInstance().format(p.getStart()) : "");
                this.toolkit.createLabel(body, "Project lead:").setForeground(this.toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
                this.toolkit.createLabel(body, b.toString());
                this.toolkit.createLabel(body, "Committers:").setForeground(this.toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
                this.toolkit.createLabel(body, String.valueOf(p.getCommitters().size()));
                this.toolkit.createLabel(body, "Mailing-List:").setForeground(this.toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
                if (p.getDevmail() != null) {
                    this.toolkit.createHyperlink(body, p.getDevmail(), 0).addHyperlinkListener(new IHyperlinkListener(){

                        public void linkExited(HyperlinkEvent e) {
                        }

                        public void linkEntered(HyperlinkEvent e) {
                        }

                        public void linkActivated(HyperlinkEvent e) {
                            Program.launch((String)p.getDevmail());
                        }
                    });
                } else {
                    this.toolkit.createLabel(body, "-");
                }
                this.toolkit.createLabel(body, "Homepage:").setForeground(this.toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
                if (p.getHomepage() != null) {
                    this.toolkit.createHyperlink(body, p.getHomepage(), 0).addHyperlinkListener(new IHyperlinkListener(){

                        public void linkExited(HyperlinkEvent e) {
                        }

                        public void linkEntered(HyperlinkEvent e) {
                        }

                        public void linkActivated(HyperlinkEvent e) {
                            Program.launch((String)p.getHomepage());
                        }
                    });
                } else {
                    this.toolkit.createLabel(body, "-");
                }
                return form;
            }
            final CommitterShip committership = (CommitterShip)cell.getElement();
            Form form = this.toolkit.createForm(parent);
            this.toolkit.decorateFormHeading(form);
            form.setText(String.valueOf(committership.getPerson().getFirstname()) + ", " + committership.getPerson().getLastname());
            Composite formBody = form.getBody();
            formBody.setLayout((Layout)new GridLayout(2, false));
            GridData gd = new GridData();
            final Label l = this.toolkit.createLabel(formBody, "");
            l.setLayoutData((Object)gd);
            Base64ToImageConverter c = new Base64ToImageConverter(form.getDisplay());
            l.setImage((Image)c.convert(committership.getPerson().getImage()));
            l.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    if (l.getImage() != null) {
                        l.getImage().dispose();
                    }
                }
            });
            Composite body = this.toolkit.createComposite(formBody);
            body.setLayout((Layout)new GridLayout(2, false));
            this.toolkit.createLabel(body, "Start:").setForeground(this.toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
            this.toolkit.createLabel(body, committership.getStart() != null ? DateFormat.getDateInstance().format(committership.getStart()) : "");
            this.toolkit.createLabel(body, "End:").setForeground(this.toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
            this.toolkit.createLabel(body, committership.getEnd() != null ? DateFormat.getDateInstance().format(committership.getEnd()) : "");
            this.toolkit.createLabel(body, "E-Mail:").setForeground(this.toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
            if (committership.getPerson().getEmail() != null) {
                this.toolkit.createHyperlink(body, committership.getPerson().getEmail(), 0).addHyperlinkListener(new IHyperlinkListener(){

                    public void linkExited(HyperlinkEvent e) {
                    }

                    public void linkEntered(HyperlinkEvent e) {
                    }

                    public void linkActivated(HyperlinkEvent e) {
                        Program.launch((String)committership.getPerson().getEmail());
                    }
                });
            } else {
                this.toolkit.createLabel(body, "");
            }
            return form;
        }

        static void enableFor(ColumnViewer viewer, FormToolkit toolkit) {
            new ColumnViewerToolTipSupportImpl(toolkit, viewer, 2);
        }
    }

    private class CommandListener
    implements IExecutionListener {
        private CommandListener() {
        }

        public void preExecute(String commandId, ExecutionEvent event) {
        }

        public void postExecuteSuccess(String commandId, Object returnValue) {
            if (ProjectExplorerPart.this.site.getPage() != null && ProjectExplorerPart.this.site.getPage().getActivePart() != null && ProjectExplorerPart.this.site.getPage().getActivePart().getSite() == ProjectExplorerPart.this.site) {
                if (commandId.equals("org.eclipse.emf.examples.databinding.project.ui.rcp.createtopproject") && returnValue != null) {
                    ProjectExplorerPart.this.viewer.setSelection((ISelection)new StructuredSelection(returnValue));
                } else if (commandId.equals("org.eclipse.emf.examples.databinding.project.ui.rcp.createsubproject") && returnValue != null) {
                    Project project = (Project)returnValue;
                    ArrayList<Project> path = new ArrayList<Project>();
                    path.add(project);
                    while ((project = project.getParent()) != null) {
                        path.add(0, project);
                    }
                    ProjectExplorerPart.this.viewer.expandToLevel((Object)new TreePath(path.toArray()), 0);
                    ProjectExplorerPart.this.viewer.setSelection((ISelection)new TreeSelection(new TreePath(path.toArray())));
                }
            }
        }

        public void postExecuteFailure(String commandId, ExecutionException exception) {
        }

        public void notHandled(String commandId, NotHandledException exception) {
        }
    }

    private static class TreeFactoryImpl
    implements IObservableFactory {
        private IEMFListProperty multi = EMFProperties.multiList((EStructuralFeature[])new EStructuralFeature[]{ProjectPackage.Literals.PROJECT__SUBPROJECTS, ProjectPackage.Literals.PROJECT__COMMITTERS});

        private TreeFactoryImpl() {
        }

        public IObservable createObservable(Object target) {
            if (target instanceof IObservableList) {
                return (IObservable)target;
            }
            if (target instanceof Project) {
                return this.multi.observe(target);
            }
            return null;
        }
    }

    private class TreeLabelProviderImpl
    extends StyledCellLabelProvider {
        private IMapChangeListener mapChangeListener = new IMapChangeListener(){

            public void handleMapChange(MapChangeEvent event) {
                Set affectedElements = event.diff.getChangedKeys();
                if (!affectedElements.isEmpty()) {
                    LabelProviderChangedEvent newEvent = new LabelProviderChangedEvent((IBaseLabelProvider)TreeLabelProviderImpl.this, affectedElements.toArray());
                    TreeLabelProviderImpl.this.fireLabelProviderChanged(newEvent);
                }
            }
        };

        public TreeLabelProviderImpl(IObservableMap ... attributeMaps) {
            int i = 0;
            while (i < attributeMaps.length) {
                attributeMaps[i].addMapChangeListener(this.mapChangeListener);
                ++i;
            }
        }

        public String getToolTipText(Object element) {
            return "#dummy#";
        }

        public void update(ViewerCell cell) {
            if (cell.getElement() instanceof Project) {
                Project p = (Project)cell.getElement();
                StyledString styledString = new StyledString(p.getShortname() != null ? p.getShortname() : "*noname*", null);
                String decoration = " (" + p.getCommitters().size() + " Committers)";
                styledString.append(decoration, StyledString.COUNTER_STYLER);
                cell.setText(styledString.getString());
                cell.setImage(ProjectExplorerPart.this.projectImage);
                cell.setStyleRanges(styledString.getStyleRanges());
            } else if (cell.getElement() instanceof CommitterShip) {
                Person p = ((CommitterShip)cell.getElement()).getPerson();
                String value = "*noname*";
                if (p != null) {
                    value = String.valueOf(p.getLastname()) + ", " + p.getFirstname();
                }
                StyledString styledString = new StyledString(value, null);
                cell.setText(styledString.getString());
                cell.setForeground(cell.getControl().getDisplay().getSystemColor(16));
                cell.setImage(ProjectExplorerPart.this.committerImage);
                cell.setStyleRanges(styledString.getStyleRanges());
            }
        }
    }

    private static class TreeStructureAdvisorImpl
    extends TreeStructureAdvisor {
        private TreeStructureAdvisorImpl() {
        }

        public Object getParent(Object element) {
            if (element instanceof Project) {
                return ((Project)element).getParent();
            }
            return null;
        }

        public Boolean hasChildren(Object element) {
            if (element instanceof Project && (((Project)element).getCommitters().size() > 0 || ((Project)element).getSubprojects().size() > 0)) {
                return Boolean.TRUE;
            }
            return super.hasChildren(element);
        }
    }
}

