/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.examples.jet.article2.ui;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.emf.examples.jet.article2.model.Attribute;
import org.eclipse.emf.examples.jet.article2.model.NameUtil;
import org.eclipse.emf.examples.jet.article2.model.TypesafeEnum;
import org.eclipse.emf.examples.jet.article2.ui.EditAttributeDialog;
import org.eclipse.emf.examples.jet.article2.ui.NewTypesafeEnumCreationWizardPage;
import org.eclipse.emf.examples.jet.article2.ui.NewTypesafeEnumCreationWizardPageInstances;
import org.eclipse.emf.examples.jet.article2.ui.WizardMessages;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class NewTypesafeEnumCreationWizardPageAttributes
extends WizardPage {
    private static final String PAGE_NAME = "AttributesPage";
    private final String[] COLUMN_NAMES = new String[]{WizardMessages.getString("NewEnumWizPageAttr.col.Key"), WizardMessages.getString("NewEnumWizPageAttr.col.Name"), WizardMessages.getString("NewEnumWizPageAttr.col.Type")};
    private static final int COL_KEY = 0;
    private static final int COL_NAME = 1;
    private static final int COL_TYPE = 2;
    private static final int[] COLUMN_WIDTHS = new int[]{40, 200, 200};
    private CheckboxTableViewer mTableViewer = null;
    private Table mTableWidget = null;
    private Button mButtonAdd = null;
    private Button mButtonEdit = null;
    private Button mButtonRemove = null;

    public NewTypesafeEnumCreationWizardPageAttributes() {
        super(PAGE_NAME);
        this.setTitle(WizardMessages.getString("NewEnumWizPageAttr.title"));
        this.setDescription(WizardMessages.getString("NewEnumWizPageAttr.description"));
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        container.setLayout((Layout)layout);
        container.setLayoutData((Object)new GridData(1808));
        this.createTableWidget(container);
        this.createButtonsPanel(container);
        this.hookListeners();
        this.updateEnabledState();
        this.mButtonAdd.forceFocus();
        this.setControl((Control)container);
        Dialog.applyDialogFont((Control)container);
        this.setPageComplete(false);
    }

    private void hookListeners() {
        this.mTableViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                Object element = event.getElement();
                if (element instanceof TableItem) {
                    element = ((TableItem)element).getData();
                }
                if (element instanceof Attribute) {
                    Attribute attribute = (Attribute)element;
                    attribute.setKey(event.getChecked());
                    NewTypesafeEnumCreationWizardPageAttributes.this.validatePage();
                }
            }
        });
        this.mTableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                NewTypesafeEnumCreationWizardPageAttributes.this.updateEnabledState();
            }
        });
        this.mTableViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                NewTypesafeEnumCreationWizardPageAttributes.this.handleEditPressed();
            }
        });
        this.mButtonAdd.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NewTypesafeEnumCreationWizardPageAttributes.this.handleAddPressed();
            }
        });
        this.mButtonEdit.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NewTypesafeEnumCreationWizardPageAttributes.this.handleEditPressed();
            }
        });
        this.mButtonRemove.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NewTypesafeEnumCreationWizardPageAttributes.this.handleRemovePressed();
            }
        });
    }

    private void updateEnabledState() {
        this.mTableWidget.setEnabled(this.mTableWidget.getItemCount() > 0);
        boolean enabled = this.mTableWidget.getSelectionCount() > 0;
        this.mButtonEdit.setEnabled(enabled);
        this.mButtonRemove.setEnabled(enabled);
    }

    private void handleAddPressed() {
        EditAttributeDialog dialog = new EditAttributeDialog(this.getShell());
        dialog.setAttribute(new Attribute());
        dialog.setTitle(WizardMessages.getString("NewEnumWizPageAttr.Add_Attribute"));
        int reply = dialog.open();
        if (reply == 0) {
            this.getTypesafeEnumModel().addAttribute(dialog.getAttribute());
            this.mTableViewer.refresh();
            this.mTableViewer.setSelection((ISelection)new StructuredSelection((Object)dialog.getAttribute()));
            this.mTableViewer.setChecked((Object)dialog.getAttribute(), dialog.getAttribute().isKey());
        }
        this.updateEnabledState();
        ((NewTypesafeEnumCreationWizardPageInstances)this.getNextPage()).setPageComplete(false);
        this.validatePage();
        this.mButtonAdd.forceFocus();
    }

    private void handleEditPressed() {
        Attribute attribute = this.getSelectedAttribute();
        if (attribute == null) {
            return;
        }
        EditAttributeDialog dialog = new EditAttributeDialog(this.getShell());
        dialog.setAttribute(attribute);
        dialog.setTitle(WizardMessages.getString("NewEnumWizPageAttr.Edit_Attribute"));
        dialog.open();
        this.mTableViewer.refresh();
        this.mTableViewer.setSelection((ISelection)new StructuredSelection((Object)dialog.getAttribute()));
        this.mTableViewer.setChecked((Object)dialog.getAttribute(), dialog.getAttribute().isKey());
        this.updateEnabledState();
        this.validatePage();
    }

    private void handleRemovePressed() {
        Attribute attribute = this.getSelectedAttribute();
        if (attribute == null) {
            return;
        }
        this.getTypesafeEnumModel().removeAttribute(attribute);
        this.mTableViewer.refresh();
        this.updateEnabledState();
        this.validatePage();
    }

    private Attribute getSelectedAttribute() {
        IStructuredSelection selection = (IStructuredSelection)this.mTableViewer.getSelection();
        if (selection.isEmpty()) {
            return null;
        }
        Object element = selection.getFirstElement();
        if (element instanceof TableItem) {
            element = ((TableItem)element).getData();
        }
        Attribute attribute = (Attribute)element;
        return attribute;
    }

    private void createButtonsPanel(Composite parent) {
        Composite panel = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        panel.setLayout((Layout)layout);
        this.mButtonAdd = new Button(panel, 8);
        this.mButtonEdit = new Button(panel, 8);
        this.mButtonRemove = new Button(panel, 8);
        this.mButtonAdd.setText(WizardMessages.getString("NewEnumWizPageAttr.button.Add"));
        this.mButtonEdit.setText(WizardMessages.getString("NewEnumWizPageAttr.button.Edit"));
        this.mButtonRemove.setText(WizardMessages.getString("NewEnumWizPageAttr.button.Remove"));
    }

    private void createTableWidget(Composite container) {
        this.mTableWidget = new Table(container, 68386);
        this.mTableWidget.setHeaderVisible(true);
        this.mTableWidget.setLinesVisible(true);
        int listHeight = this.mTableWidget.getItemHeight() * 10;
        Rectangle trim = this.mTableWidget.computeTrim(0, 0, 0, listHeight);
        GridData tblGD = new GridData(1808);
        tblGD.heightHint = trim.height;
        tblGD.horizontalSpan = 2;
        this.mTableWidget.setLayoutData((Object)tblGD);
        TableLayout tableLayout = new TableLayout();
        int i = 0;
        while (i < COLUMN_WIDTHS.length) {
            tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(1, COLUMN_WIDTHS[i], true));
            ++i;
        }
        this.mTableWidget.setLayout((Layout)tableLayout);
        i = 0;
        while (i < this.COLUMN_NAMES.length) {
            new TableColumn(this.mTableWidget, 0).setText(this.COLUMN_NAMES[i]);
            ++i;
        }
        this.mTableWidget.pack();
        this.mTableViewer = new CheckboxTableViewer(this.mTableWidget);
        this.mTableViewer.setColumnProperties(this.COLUMN_NAMES);
        this.mTableViewer.setLabelProvider((IBaseLabelProvider)new AttributeLabelProvider());
        this.mTableViewer.setContentProvider((IContentProvider)new AttributeContentProvider());
        this.mTableViewer.setInput((Object)this.getTypesafeEnumModel());
    }

    private void validatePage() {
        TypesafeEnum type = this.getTypesafeEnumModel();
        if (type.attributeCount() == 0) {
            this.setErrorMessage(WizardMessages.getString("NewEnumWizPageAttr.Must_have_at_least_one_attribute"));
            this.setPageComplete(false);
            return;
        }
        Iterator<Attribute> i = type.attributes();
        while (i.hasNext()) {
            Attribute attribute = i.next();
            if (attribute.getName().length() == 0) {
                this.setErrorMessage(WizardMessages.getString("NewEnumWizPageAttr.attribute_must_have_a_name"));
                this.setPageComplete(false);
                return;
            }
            if (!NameUtil.isValidIdentifier(attribute.getName())) {
                this.setErrorMessage(WizardMessages.getFormattedString("NewEnumWizPageAttr.invalid_attribute_name", attribute.getName()));
                this.setPageComplete(false);
                return;
            }
            if (attribute.getType().length() == 0) {
                this.setErrorMessage(WizardMessages.getFormattedString("NewEnumWizPageAttr.attribute_must_have_a_type", attribute.getName()));
                this.setPageComplete(false);
                return;
            }
            if (NameUtil.isValidIdentifier(attribute.getType())) continue;
            this.setErrorMessage(WizardMessages.getFormattedString("NewEnumWizPageAttr.invalid_attribute_type", attribute.getType()));
            this.setPageComplete(false);
            return;
        }
        if (!type.keyAttributes().hasNext()) {
            this.setErrorMessage(WizardMessages.getString("NewEnumWizPageAttr.missing_key_attribute"));
            this.setPageComplete(false);
            return;
        }
        this.setErrorMessage(null);
        this.setPageComplete(true);
    }

    public TypesafeEnum getTypesafeEnumModel() {
        return ((NewTypesafeEnumCreationWizardPage)this.getPreviousPage()).getTypesafeEnumModel();
    }

    protected class AttributeContentProvider
    implements IStructuredContentProvider {
        protected AttributeContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            ArrayList<Attribute> result = new ArrayList<Attribute>();
            Iterator<Attribute> i = ((TypesafeEnum)inputElement).attributes();
            while (i.hasNext()) {
                result.add(i.next());
            }
            return result.toArray();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    protected class AttributeLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        protected AttributeLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element instanceof Attribute) {
                Attribute attribute = (Attribute)element;
                switch (columnIndex) {
                    case 1: {
                        return attribute.getName() == null ? "" : attribute.getName();
                    }
                    case 2: {
                        return attribute.getType();
                    }
                    case 0: {
                        NewTypesafeEnumCreationWizardPageAttributes.this.mTableViewer.setChecked((Object)attribute, attribute.isKey());
                        return "";
                    }
                }
            }
            return null;
        }
    }
}

