/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.diagram.sequence.internal.layout.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.uml2.diagram.sequence.internal.layout.abstractgde.AbsElementPropertyAccess;
import org.eclipse.uml2.diagram.sequence.internal.layout.abstractgde.AbsNode;
import org.eclipse.uml2.diagram.sequence.internal.layout.model.JustReshapedState;
import org.eclipse.uml2.diagram.sequence.internal.layout.model.LMFrameContainer;
import org.eclipse.uml2.diagram.sequence.internal.layout.model.LMMountingLink;
import org.eclipse.uml2.diagram.sequence.internal.layout.model.LMMountingRegion;
import org.eclipse.uml2.diagram.sequence.internal.layout.model.LmReshapable;
import org.eclipse.uml2.diagram.sequence.internal.layout.vertical.input.HorizontalConstraint;
import org.eclipse.uml2.diagram.sequence.internal.layout.vertical.input.LifeLineElement;

public abstract class LMFrame
extends LMFrameContainer
implements LmReshapable {
    private LMMountingLink myPositionResponsibleLink;
    private JustReshapedState myJustReshapedState = null;
    private final AbsNode myGdeNode;
    private LMFrameContainer.ContainerFriendly myContainerFriendly;
    private final List myMountingLinks = new ArrayList(3);
    private final BackgroundLayouter myBackgroundLayouter;
    private final HorizontalConstraintImpl myTopConstraint = new HorizontalConstraintImpl(){

        protected LifeLineElement getLifeLineElement(LMMountingLink lmMountingLink) {
            return lmMountingLink.getMountingRegion().getTopLifeLineElementForConstraint();
        }

        public void elementIsResolved(LifeLineElement lifeLineElement) {
            if (!(lifeLineElement instanceof LMMountingRegion.MountingRegionLifelineElement)) {
                throw new RuntimeException("Unknown type of lifeline element " + lifeLineElement);
            }
            LMMountingRegion.MountingRegionLifelineElement mountingRegionLifelineElement = (LMMountingRegion.MountingRegionLifelineElement)lifeLineElement;
            mountingRegionLifelineElement.setConstraintInvalid(false);
        }

        public void elementIsViolated(LifeLineElement lifeLineElement) {
            if (!(lifeLineElement instanceof LMMountingRegion.MountingRegionLifelineElement)) {
                throw new RuntimeException("Unknown type of lifeline element " + lifeLineElement);
            }
            LMMountingRegion.MountingRegionLifelineElement mountingRegionLifelineElement = (LMMountingRegion.MountingRegionLifelineElement)lifeLineElement;
            mountingRegionLifelineElement.setConstraintInvalid(true);
        }

        public String toString() {
            return "TopMountingConstraint of " + LMFrame.this;
        }
    };
    private final HorizontalConstraintImpl myBottomConstraint = new HorizontalConstraintImpl(){

        protected LifeLineElement getLifeLineElement(LMMountingLink lmMountingLink) {
            return lmMountingLink.getMountingRegion().getBottomLifeLineElementForConstraint();
        }

        public String toString() {
            return "BottomMountingConstraint of " + LMFrame.this;
        }
    };

    protected LMFrame(AbsNode gdeNode) {
        this.myGdeNode = gdeNode;
        this.myBackgroundLayouter = AbsElementPropertyAccess.getInstance().getBackgroundLayouter(gdeNode);
    }

    public AbsNode getGdeNode() {
        return this.myGdeNode;
    }

    public LMFrameContainer getContainer() {
        if (this.myContainerFriendly == null) {
            return null;
        }
        return this.myContainerFriendly.getLMFrameContainer();
    }

    public abstract int getInnerHorizontalPadding();

    public abstract int getOuterHorizontalPadding();

    public int getTopInnerPadding() {
        return this.getInnerHorizontalPadding();
    }

    public int getBottomInnerPadding() {
        return this.getInnerHorizontalPadding();
    }

    public void checkConsistancy() {
    }

    public abstract void setLeftBorderPosByTool(int var1);

    public abstract void setRightBorderPosByTool(int var1);

    public abstract void setLeftBorderPosByLayout(int var1);

    public abstract void setRightBorderPosByLayout(int var1);

    abstract boolean hasVisibleMountingLinks();

    void setTopBorderPosFromMountingLink(int pos) {
        this.setTopBorderPos(pos);
        int untiedFramesAreaTopPos = this.getTopBorderPos() + this.getTopInnerPadding();
        this.layoutVerticallyUtiedFrames(untiedFramesAreaTopPos);
    }

    boolean tryToUseAsPositionResponsibleLink(LMMountingLink link) {
        if (this.myPositionResponsibleLink == null && link.isValid()) {
            this.myPositionResponsibleLink = link;
        }
        return this.myPositionResponsibleLink == link;
    }

    void flushPositionResponsibleLink() {
        this.myPositionResponsibleLink = null;
    }

    public void setTopBorderPos(int pos) {
        this.myGdeNode.setY(pos);
        if (this.myBackgroundLayouter != null) {
            this.myBackgroundLayouter.setY(pos);
        }
    }

    public void setBottomBorderPos(int pos) {
        int newHeight = pos - this.myGdeNode.getY();
        this.myGdeNode.setHeight(newHeight);
        if (this.myBackgroundLayouter != null) {
            this.myBackgroundLayouter.setHeight(newHeight);
        }
    }

    int getTopBorderPos() {
        return this.myGdeNode.getY();
    }

    int getBottomBorderPos() {
        return this.myGdeNode.getY() + this.myGdeNode.getHeight();
    }

    protected void setX(int x) {
        this.myGdeNode.setX(x);
        if (this.myBackgroundLayouter != null) {
            this.myBackgroundLayouter.setX(x);
        }
    }

    protected void setWidth(int width) {
        this.myGdeNode.setWidth(width);
        if (this.myBackgroundLayouter != null) {
            this.myBackgroundLayouter.setWidth(width);
        }
    }

    HorizontalConstraintImpl getBottomConstraint() {
        return this.myBottomConstraint;
    }

    HorizontalConstraintImpl getTopConstraint() {
        return this.myTopConstraint;
    }

    void addMountingLink(LMMountingLink mountingLink) {
        this.myMountingLinks.add(mountingLink);
    }

    void removeMountingLink(LMMountingLink mountingLink) {
        this.myMountingLinks.remove(mountingLink);
    }

    public boolean hasAnyMountingLinks() {
        return !this.myMountingLinks.isEmpty();
    }

    Enumeration mountingLinks() {
        return Collections.enumeration(this.myMountingLinks);
    }

    List getMountingLinksList() {
        return this.myMountingLinks;
    }

    void delete() {
        this.setContainer(null);
    }

    void setContainer(LMFrameContainer.ContainerFriendly containerFriendly) {
        if (containerFriendly == null) {
            if (this.myContainerFriendly != null) {
                this.myContainerFriendly.childRemove(this);
                this.myContainerFriendly = null;
            }
        } else {
            if (this.myContainerFriendly != null) {
                throw new IllegalStateException("Parent already set");
            }
            this.myContainerFriendly = containerFriendly;
        }
    }

    public String toString() {
        EObject entity = this.myGdeNode.getModelEntity();
        return "Frame$" + entity;
    }

    public void setJustReshaped(JustReshapedState justReshapedState) {
        this.myJustReshapedState = justReshapedState;
        int y = this.myGdeNode.getY();
        int height = this.myGdeNode.getHeight();
        for (LMMountingLink mountingLink : this.myMountingLinks) {
            LMMountingRegion mountingRegion = mountingLink.getMountingRegion();
            mountingRegion.setYAndHeightFromFrame(y, height, justReshapedState);
        }
    }

    public boolean isJustReshaped() {
        if (this.myJustReshapedState == null) {
            return false;
        }
        return this.myJustReshapedState.isStillJustReshaped();
    }

    public static interface BackgroundLayouter {
        public void setX(int var1);

        public void setY(int var1);

        public void setHeight(int var1);

        public void setWidth(int var1);
    }

    private abstract class HorizontalConstraintImpl
    implements HorizontalConstraint {
        private HorizontalConstraintImpl() {
        }

        public List getLifeLineElementsList() {
            ArrayList<LifeLineElement> result = new ArrayList<LifeLineElement>(LMFrame.this.myMountingLinks.size());
            int i = 0;
            while (i < LMFrame.this.myMountingLinks.size()) {
                LifeLineElement element1 = this.getLifeLineElement((LMMountingLink)LMFrame.this.myMountingLinks.get(i));
                if (element1 != null) {
                    result.add(element1);
                }
                ++i;
            }
            return result;
        }

        public void elementIsResolved(LifeLineElement lifeLineElement) {
        }

        public void elementIsViolated(LifeLineElement lifeLineElement) {
        }

        protected abstract LifeLineElement getLifeLineElement(LMMountingLink var1);
    }
}

