/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.diagram.sequence.draw2d;

import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.RectangleFigure;
import org.eclipse.draw2d.TreeSearch;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;

public class LifeLineTailShape
extends RectangleFigure {
    private int myLineRelativeX;
    private static final int SELECTABLE_WIDTH = 10;

    public LifeLineTailShape() {
        this.setOpaque(false);
        this.setFill(false);
        this.setLineStyle(2);
        this.setMinimumSize(new Dimension());
    }

    public IFigure findFigureAt(int x, int y, TreeSearch search) {
        int distToLine;
        IFigure result = super.findFigureAt(x, y, search);
        if (result == this && (distToLine = Math.abs(this.getLineAbsoluteX() - x)) >= this.getLineWidth() + 10) {
            result = null;
        }
        return result;
    }

    protected void outlineShape(Graphics graphics) {
        Rectangle bounds = this.getBounds();
        graphics.drawLine(this.getLineAbsoluteX(), bounds.y, this.getLineAbsoluteX(), bounds.y + bounds.height);
    }

    private int getLineAbsoluteX() {
        return this.bounds.x + this.bounds.width / 2;
    }

    void setLineRelativeX(int x) {
        this.myLineRelativeX = x;
    }
}

