/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.diagram.common.draw2d;

import org.eclipse.draw2d.FigureUtilities;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.tools.CellEditorLocator;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Text;
import org.eclipse.uml2.diagram.common.draw2d.RotatedImageOfString;

public class RotatedImageCellEditorLocator
implements CellEditorLocator {
    private RotatedImageOfString rotatedImage;

    public RotatedImageCellEditorLocator(RotatedImageOfString rotatedImage) {
        this.rotatedImage = rotatedImage;
    }

    public void relocate(CellEditor celleditor) {
        Text text = (Text)celleditor.getControl();
        Rectangle rect = this.rotatedImage.getBounds().getCopy();
        this.rotatedImage.translateToAbsolute((Translatable)rect);
        int avr = FigureUtilities.getFontMetrics((Font)text.getFont()).getAverageCharWidth();
        Dimension textSize = new Dimension(text.computeSize(-1, -1)).expand(avr * 2, 0);
        rect.x += 3;
        rect.y = rect.y + rect.height / 2 - textSize.height / 2;
        rect.setSize(textSize);
        if (!rect.equals((Object)new Rectangle(text.getBounds()))) {
            text.setBounds(rect.x, rect.y, rect.width, rect.height);
        }
    }
}

