/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.types.impl;

import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.EObjectImpl;
import org.eclipse.ocl.Environment;
import org.eclipse.ocl.expressions.CollectionKind;
import org.eclipse.ocl.types.CollectionType;
import org.eclipse.ocl.types.TypesPackage;
import org.eclipse.ocl.types.operations.CollectionTypeOperations;
import org.eclipse.ocl.util.OCLStandardLibraryUtil;
import org.eclipse.ocl.utilities.ASTNode;
import org.eclipse.ocl.utilities.PredefinedType;
import org.eclipse.ocl.utilities.TypedASTNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CollectionTypeImpl<C, O>
extends EObjectImpl
implements CollectionType<C, O> {
    protected static final int START_POSITION_EDEFAULT = -1;
    protected int startPosition = -1;
    protected static final int END_POSITION_EDEFAULT = -1;
    protected int endPosition = -1;
    protected static final int TYPE_START_POSITION_EDEFAULT = -1;
    protected int typeStartPosition = -1;
    protected static final int TYPE_END_POSITION_EDEFAULT = -1;
    protected int typeEndPosition = -1;
    protected C elementType;
    protected static final CollectionKind KIND_EDEFAULT = CollectionKind.SET_LITERAL;
    private String name;
    private EList<O> operations;
    private EList<O> iterators;

    protected CollectionTypeImpl() {
    }

    protected CollectionTypeImpl(C elementType) {
        this.elementType = elementType;
    }

    protected EClass eStaticClass() {
        return TypesPackage.Literals.COLLECTION_TYPE;
    }

    @Override
    public String getName() {
        if (this.name == null) {
            Environment env = Environment.Registry.INSTANCE.getEnvironmentFor(this);
            StringBuffer myName = new StringBuffer();
            switch (this.getKind()) {
                case SET_LITERAL: {
                    myName.append("Set");
                    break;
                }
                case ORDERED_SET_LITERAL: {
                    myName.append("OrderedSet");
                    break;
                }
                case BAG_LITERAL: {
                    myName.append("Bag");
                    break;
                }
                case SEQUENCE_LITERAL: {
                    myName.append("Sequence");
                    break;
                }
                default: {
                    myName.append("Collection");
                }
            }
            myName.append('(');
            C elementType = this.getElementType();
            String elementTypeName = elementType instanceof PredefinedType ? ((PredefinedType)elementType).getName() : env.getUMLReflection().getName(elementType);
            myName.append(elementTypeName);
            myName.append(')');
            this.name = myName.toString();
        }
        return this.name;
    }

    @Override
    public EList<O> oclOperations() {
        if (this.operations == null) {
            List myOperations;
            Environment env = Environment.Registry.INSTANCE.getEnvironmentFor(this);
            switch (this.getKind()) {
                case SET_LITERAL: {
                    myOperations = OCLStandardLibraryUtil.createSetOperations(env);
                    break;
                }
                case ORDERED_SET_LITERAL: {
                    myOperations = OCLStandardLibraryUtil.createOrderedSetOperations(env);
                    break;
                }
                case BAG_LITERAL: {
                    myOperations = OCLStandardLibraryUtil.createBagOperations(env);
                    break;
                }
                case SEQUENCE_LITERAL: {
                    myOperations = OCLStandardLibraryUtil.createSequenceOperations(env);
                    break;
                }
                default: {
                    myOperations = OCLStandardLibraryUtil.createCollectionOperations(env);
                }
            }
            this.operations = new BasicEList(myOperations);
        }
        return this.operations;
    }

    @Override
    public boolean checkCollectionTypeName(DiagnosticChain diagnostics, Map<Object, Object> context) {
        return CollectionTypeOperations.checkCollectionTypeName(this, diagnostics, context);
    }

    @Override
    public boolean checkNoInvalidValues(DiagnosticChain diagnostics, Map<Object, Object> context) {
        return CollectionTypeOperations.checkNoInvalidValues(this, diagnostics, context);
    }

    @Override
    public int getStartPosition() {
        return this.startPosition;
    }

    @Override
    public void setStartPosition(int newStartPosition) {
        int oldStartPosition = this.startPosition;
        this.startPosition = newStartPosition;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 0, oldStartPosition, this.startPosition));
        }
    }

    @Override
    public int getEndPosition() {
        return this.endPosition;
    }

    @Override
    public void setEndPosition(int newEndPosition) {
        int oldEndPosition = this.endPosition;
        this.endPosition = newEndPosition;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 1, oldEndPosition, this.endPosition));
        }
    }

    @Override
    public int getTypeStartPosition() {
        return this.typeStartPosition;
    }

    @Override
    public void setTypeStartPosition(int newTypeStartPosition) {
        int oldTypeStartPosition = this.typeStartPosition;
        this.typeStartPosition = newTypeStartPosition;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 2, oldTypeStartPosition, this.typeStartPosition));
        }
    }

    @Override
    public int getTypeEndPosition() {
        return this.typeEndPosition;
    }

    @Override
    public void setTypeEndPosition(int newTypeEndPosition) {
        int oldTypeEndPosition = this.typeEndPosition;
        this.typeEndPosition = newTypeEndPosition;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 3, oldTypeEndPosition, this.typeEndPosition));
        }
    }

    @Override
    public C getElementType() {
        if (this.elementType != null && ((EObject)this.elementType).eIsProxy()) {
            InternalEObject oldElementType = (InternalEObject)this.elementType;
            this.elementType = this.eResolveProxy(oldElementType);
            if (this.elementType != oldElementType && this.eNotificationRequired()) {
                this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 9, 4, (Object)oldElementType, this.elementType));
            }
        }
        return this.elementType;
    }

    public C basicGetElementType() {
        return this.elementType;
    }

    @Override
    public void setElementType(C newElementType) {
        C oldElementType = this.elementType;
        this.elementType = newElementType;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 4, oldElementType, this.elementType));
        }
    }

    @Override
    public CollectionKind getKind() {
        return CollectionKind.COLLECTION_LITERAL;
    }

    @Override
    public EList<O> oclIterators() {
        if (this.iterators == null) {
            List myIterators;
            Environment env = Environment.Registry.INSTANCE.getEnvironmentFor(this);
            switch (this.getKind()) {
                case SET_LITERAL: {
                    myIterators = OCLStandardLibraryUtil.createSetIterators(env);
                    break;
                }
                case ORDERED_SET_LITERAL: {
                    myIterators = OCLStandardLibraryUtil.createOrderedSetIterators(env);
                    break;
                }
                case BAG_LITERAL: {
                    myIterators = OCLStandardLibraryUtil.createBagIterators(env);
                    break;
                }
                case SEQUENCE_LITERAL: {
                    myIterators = OCLStandardLibraryUtil.createSequenceIterators(env);
                    break;
                }
                default: {
                    myIterators = OCLStandardLibraryUtil.createCollectionIterators(env);
                }
            }
            this.iterators = new BasicEList(myIterators);
        }
        return this.iterators;
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 0: {
                return new Integer(this.getStartPosition());
            }
            case 1: {
                return new Integer(this.getEndPosition());
            }
            case 2: {
                return new Integer(this.getTypeStartPosition());
            }
            case 3: {
                return new Integer(this.getTypeEndPosition());
            }
            case 4: {
                if (resolve) {
                    return this.getElementType();
                }
                return this.basicGetElementType();
            }
            case 5: {
                return this.getKind();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 0: {
                this.setStartPosition((Integer)newValue);
                return;
            }
            case 1: {
                this.setEndPosition((Integer)newValue);
                return;
            }
            case 2: {
                this.setTypeStartPosition((Integer)newValue);
                return;
            }
            case 3: {
                this.setTypeEndPosition((Integer)newValue);
                return;
            }
            case 4: {
                this.setElementType(newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 0: {
                this.setStartPosition(-1);
                return;
            }
            case 1: {
                this.setEndPosition(-1);
                return;
            }
            case 2: {
                this.setTypeStartPosition(-1);
                return;
            }
            case 3: {
                this.setTypeEndPosition(-1);
                return;
            }
            case 4: {
                this.setElementType(null);
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 0: {
                return this.startPosition != -1;
            }
            case 1: {
                return this.endPosition != -1;
            }
            case 2: {
                return this.typeStartPosition != -1;
            }
            case 3: {
                return this.typeEndPosition != -1;
            }
            case 4: {
                return this.elementType != null;
            }
            case 5: {
                return this.getKind() != KIND_EDEFAULT;
            }
        }
        return super.eIsSet(featureID);
    }

    public int eBaseStructuralFeatureID(int derivedFeatureID, Class<?> baseClass) {
        if (baseClass == ASTNode.class) {
            switch (derivedFeatureID) {
                case 0: {
                    return 0;
                }
                case 1: {
                    return 1;
                }
            }
            return -1;
        }
        if (baseClass == TypedASTNode.class) {
            switch (derivedFeatureID) {
                case 2: {
                    return 2;
                }
                case 3: {
                    return 3;
                }
            }
            return -1;
        }
        return super.eBaseStructuralFeatureID(derivedFeatureID, baseClass);
    }

    public int eDerivedStructuralFeatureID(int baseFeatureID, Class<?> baseClass) {
        if (baseClass == ASTNode.class) {
            switch (baseFeatureID) {
                case 0: {
                    return 0;
                }
                case 1: {
                    return 1;
                }
            }
            return -1;
        }
        if (baseClass == TypedASTNode.class) {
            switch (baseFeatureID) {
                case 2: {
                    return 2;
                }
                case 3: {
                    return 3;
                }
            }
            return -1;
        }
        return super.eDerivedStructuralFeatureID(baseFeatureID, baseClass);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (startPosition: ");
        result.append(this.startPosition);
        result.append(", endPosition: ");
        result.append(this.endPosition);
        result.append(", typeStartPosition: ");
        result.append(this.typeStartPosition);
        result.append(", typeEndPosition: ");
        result.append(this.typeEndPosition);
        result.append(')');
        return result.toString();
    }
}

