/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.ecore;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.Enumerator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EParameter;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.ocl.AbstractEvaluationEnvironment;
import org.eclipse.ocl.EvaluationEnvironment;
import org.eclipse.ocl.LazyExtentMap;
import org.eclipse.ocl.ecore.EcoreEnvironmentFactory;
import org.eclipse.ocl.ecore.internal.OCLStandardLibraryImpl;
import org.eclipse.ocl.ecore.internal.UMLReflectionImpl;
import org.eclipse.ocl.expressions.CollectionKind;
import org.eclipse.ocl.types.CollectionType;
import org.eclipse.ocl.util.CollectionUtil;
import org.eclipse.ocl.util.OCLStandardLibraryUtil;
import org.eclipse.ocl.util.ObjectUtil;
import org.eclipse.ocl.util.Tuple;
import org.eclipse.ocl.util.UnicodeSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EcoreEvaluationEnvironment
extends AbstractEvaluationEnvironment<EClassifier, EOperation, EStructuralFeature, EClass, EObject>
implements EvaluationEnvironment.Enumerations<EEnumLiteral> {
    public EcoreEvaluationEnvironment() {
    }

    public EcoreEvaluationEnvironment(EvaluationEnvironment<EClassifier, EOperation, EStructuralFeature, EClass, EObject> parent) {
        super(parent);
    }

    public Object callOperation(EOperation operation, int opcode, Object source, Object[] args) throws IllegalArgumentException {
        return this.coerceValue((ETypedElement)operation, super.callOperation((Object)operation, opcode, source, args), true);
    }

    protected Method getJavaMethodFor(EOperation operation, Object receiver) {
        Method result = null;
        String operName = operation.getName();
        int opcode = OCLStandardLibraryUtil.getOperationCode((String)operName);
        switch (opcode) {
            case 1: {
                operName = "plus";
                break;
            }
            case 2: {
                operName = "minus";
                break;
            }
            case 3: {
                operName = "times";
                break;
            }
            case 4: {
                operName = "divide";
                break;
            }
            case 67: {
                operName = "lessThan";
                break;
            }
            case 69: {
                operName = "lessThanEqual";
                break;
            }
            case 68: {
                operName = "greaterThan";
                break;
            }
            case 70: {
                operName = "greaterThanEqual";
            }
        }
        EClass container = operation.getEContainingClass();
        Class containerClass = container.getInstanceClass();
        EList parms = operation.getEParameters();
        Class[] javaParms = new Class[parms.size()];
        int i = 0;
        int n = parms.size();
        while (i < n) {
            EParameter parm = (EParameter)parms.get(i);
            javaParms[i] = parm.isMany() ? EList.class : parm.getEType().getInstanceClass();
            ++i;
        }
        try {
            result = containerClass.getMethod(operName, javaParms);
        }
        catch (NoSuchMethodException noSuchMethodException) {}
        return result;
    }

    protected Object getInvalidResult() {
        return OCLStandardLibraryImpl.OCL_INVALID;
    }

    public Object navigateProperty(EStructuralFeature property, List<?> qualifiers, Object target) throws IllegalArgumentException {
        EObject etarget;
        if (target instanceof EObject && (etarget = (EObject)target).eClass().getEAllStructuralFeatures().contains((Object)property)) {
            return this.coerceValue((ETypedElement)property, etarget.eGet(property), true);
        }
        throw new IllegalArgumentException();
    }

    private static CollectionKind getCollectionKind(ETypedElement element) {
        EClassifier oclType = UMLReflectionImpl.INSTANCE.getOCLType(element);
        CollectionKind result = null;
        if (oclType instanceof CollectionType) {
            result = ((CollectionType)oclType).getKind();
            ObjectUtil.dispose((Object)oclType);
        }
        return result;
    }

    private Object coerceValue(ETypedElement element, Object value, boolean copy) {
        CollectionKind kind = EcoreEvaluationEnvironment.getCollectionKind(element);
        if (kind != null) {
            if (value instanceof Collection) {
                return copy ? CollectionUtil.createNewCollection((CollectionKind)kind, (Collection)((Collection)value)) : value;
            }
            Collection result = CollectionUtil.createNewCollection((CollectionKind)kind);
            result.add(value);
            return result;
        }
        if (value instanceof Collection) {
            Collection collection = (Collection)value;
            return collection.isEmpty() ? null : collection.iterator().next();
        }
        return value;
    }

    public Object navigateAssociationClass(EClassifier associationClass, EStructuralFeature navigationSource, Object target) throws IllegalArgumentException {
        if (target instanceof EObject) {
            EObject etarget = (EObject)target;
            EReference ref = this.getAssociationClassReference(etarget, (EClass)associationClass);
            if (etarget.eClass().getEAllStructuralFeatures().contains((Object)ref)) {
                return etarget.eGet((EStructuralFeature)ref);
            }
        }
        throw new IllegalArgumentException();
    }

    private EReference getAssociationClassReference(EObject context, EClass associationClass) {
        EReference result = null;
        StringBuffer nameBuf = new StringBuffer(associationClass.getName());
        UnicodeSupport.setCodePointAt((StringBuffer)nameBuf, (int)0, (int)UnicodeSupport.toLowerCase((int)UnicodeSupport.codePointAt((StringBuffer)nameBuf, (int)0)));
        String name = nameBuf.toString();
        for (EReference next : context.eClass().getEAllReferences()) {
            if (!name.equals(next.getName()) || associationClass != next.getEReferenceType()) continue;
            result = next;
            break;
        }
        return result;
    }

    public Tuple<EOperation, EStructuralFeature> createTuple(EClassifier type, Map<EStructuralFeature, Object> values) {
        EClass tupleType = (EClass)type;
        EObject tuple = tupleType.getEPackage().getEFactoryInstance().create(tupleType);
        for (Map.Entry<EStructuralFeature, Object> entry : values.entrySet()) {
            EStructuralFeature property = entry.getKey();
            Object value = entry.getValue();
            if (property.isMany() && value instanceof Collection) {
                Collection coll = (Collection)tuple.eGet(property);
                coll.addAll((Collection)value);
                continue;
            }
            if (property.getEType() instanceof CollectionType && value instanceof Collection) {
                CollectionType collType = (CollectionType)property.getEType();
                tuple.eSet(property, (Object)CollectionUtil.createNewCollection((CollectionKind)collType.getKind(), (Collection)((Collection)value)));
                continue;
            }
            tuple.eSet(property, value);
        }
        Tuple result = (Tuple)tuple;
        return result;
    }

    public Map<EClass, Set<EObject>> createExtentMap(Object object) {
        if (object instanceof EObject) {
            return new LazyExtentMap<EClass, EObject>((EObject)object){

                protected boolean isInstance(EClass cls, EObject element) {
                    return cls.isInstance((Object)element);
                }
            };
        }
        return Collections.emptyMap();
    }

    public boolean isKindOf(Object object, EClassifier classifier) {
        if (object.getClass() == Integer.class && classifier.getInstanceClass() == Double.class) {
            return Boolean.TRUE;
        }
        return classifier.isInstance(object);
    }

    public boolean isTypeOf(Object object, EClassifier classifier) {
        if (classifier instanceof EClass && object instanceof EObject) {
            return ((EObject)object).eClass() == classifier;
        }
        if (!(object instanceof EObject) && !(classifier instanceof EClass)) {
            return object.getClass() == classifier.getInstanceClass();
        }
        return false;
    }

    public EClassifier getType(Object object) {
        return EcoreEnvironmentFactory.oclType(object);
    }

    public Enumerator getValue(EEnumLiteral enumerationLiteral) {
        return enumerationLiteral.getInstance();
    }
}

