/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ocl.query.impl;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.EObjectImpl;
import org.eclipse.emf.ocl.expressions.EvaluationVisitor;
import org.eclipse.emf.ocl.expressions.ExpressionsFactory;
import org.eclipse.emf.ocl.expressions.OCLExpression;
import org.eclipse.emf.ocl.expressions.Visitor;
import org.eclipse.emf.ocl.expressions.impl.EvaluationVisitorImpl;
import org.eclipse.emf.ocl.expressions.impl.ToStringVisitorImpl;
import org.eclipse.emf.ocl.expressions.impl.ValidationVisitorImpl;
import org.eclipse.emf.ocl.expressions.util.EvalEnvironment;
import org.eclipse.emf.ocl.internal.OCLPlugin;
import org.eclipse.emf.ocl.parser.EvaluationEnvironment;
import org.eclipse.emf.ocl.parser.ParserException;
import org.eclipse.emf.ocl.parser.SemanticException;
import org.eclipse.emf.ocl.query.Query;
import org.eclipse.emf.ocl.query.QueryPackage;
import org.eclipse.emf.ocl.types.util.Types;
import org.eclipse.ocl.LazyExtentMap;
import org.eclipse.ocl.internal.l10n.OCLMessages;

public class QueryImpl
extends EObjectImpl
implements Query {
    public static final String copyright = "";
    private static final String SELF = "self";
    protected static final Map EXTENT_MAP_EDEFAULT = null;
    protected Map extentMap = EXTENT_MAP_EDEFAULT;
    protected OCLExpression expression;
    private EvaluationEnvironment env;

    protected QueryImpl() {
    }

    protected QueryImpl(String qs) throws ParserException {
        this.expression = ExpressionsFactory.eINSTANCE.createOCLExpression(qs);
    }

    protected QueryImpl(OCLExpression expr) throws SemanticException {
        this.expression = expr;
        this.validate();
    }

    protected EClass eStaticClass() {
        return QueryPackage.Literals.QUERY;
    }

    public Map getExtentMap() {
        if (this.extentMap == EXTENT_MAP_EDEFAULT) {
            EvaluationEnvironment myEnv = this.getEvaluationEnvironment();
            Object context = myEnv.getValueOf(SELF);
            this.extentMap = context instanceof EObject ? new LazyExtentMap<EClass, EObject>((EObject)context){

                protected boolean isInstance(EClass cls, EObject element) {
                    return cls.isInstance((Object)element);
                }
            } : new HashMap();
        }
        return this.extentMap;
    }

    public void setExtentMap(Map newExtentMap) {
        Map oldExtentMap = this.extentMap;
        this.extentMap = newExtentMap;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 0, (Object)oldExtentMap, (Object)this.extentMap));
        }
    }

    public OCLExpression getExpression() {
        if (this.expression != null && this.expression.eIsProxy()) {
            InternalEObject oldExpression = (InternalEObject)this.expression;
            this.expression = (OCLExpression)this.eResolveProxy(oldExpression);
            if (this.expression != oldExpression && this.eNotificationRequired()) {
                this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 9, 1, (Object)oldExpression, (Object)this.expression));
            }
        }
        return this.expression;
    }

    public OCLExpression basicGetExpression() {
        return this.expression;
    }

    public Object evaluate(Object obj) {
        Object result;
        if (obj == null) {
            IllegalArgumentException error = new IllegalArgumentException(OCLMessages.NullArgExpectEObj_ERROR_);
            OCLPlugin.throwing(this.getClass(), "evaluate", error);
            throw error;
        }
        EvaluationEnvironment myEnv = this.getEvaluationEnvironment();
        myEnv.add(SELF, obj);
        EvaluationVisitor ev = EvaluationVisitorImpl.getInstance(myEnv, this.getExtentMap());
        try {
            result = this.expression.accept(ev);
        }
        finally {
            myEnv.remove(SELF);
        }
        return result;
    }

    public Object evaluate() {
        EvaluationVisitor ev = EvaluationVisitorImpl.getInstance(this.getEvaluationEnvironment(), this.getExtentMap());
        return this.expression.accept(ev);
    }

    public boolean check(Object obj) {
        if (this.resultType() != Types.OCL_BOOLEAN) {
            IllegalArgumentException error = new IllegalArgumentException(OCLMessages.BooleanQuery_ERROR_);
            OCLPlugin.throwing(this.getClass(), "check", error);
            throw error;
        }
        Object result = obj == null ? this.evaluate() : this.evaluate(obj);
        return Boolean.TRUE.equals(result);
    }

    public List evaluate(List objList) {
        if (objList == null) {
            IllegalArgumentException error = new IllegalArgumentException(OCLMessages.NullArgExpectlist_ERROR_);
            OCLPlugin.throwing(this.getClass(), "evaluate", error);
            throw error;
        }
        BasicEList result = new BasicEList();
        Iterator iter = objList.iterator();
        while (iter.hasNext()) {
            result.add(this.evaluate(iter.next()));
        }
        return result;
    }

    public boolean check(List objList) {
        if (objList == null) {
            IllegalArgumentException error = new IllegalArgumentException(OCLMessages.NullArgExpectlist_ERROR_);
            OCLPlugin.throwing(this.getClass(), "check", error);
            throw error;
        }
        if (this.resultType() != Types.OCL_BOOLEAN) {
            IllegalArgumentException error = new IllegalArgumentException(OCLMessages.BooleanQuery_ERROR_);
            OCLPlugin.throwing(this.getClass(), "check", error);
            throw error;
        }
        Iterator iter = objList.iterator();
        while (iter.hasNext()) {
            if (this.check(iter.next())) continue;
            return false;
        }
        return true;
    }

    public List select(List objList) {
        if (objList == null) {
            IllegalArgumentException error = new IllegalArgumentException(OCLMessages.NullArgExpectlist_ERROR_);
            OCLPlugin.throwing(this.getClass(), "select", error);
            throw error;
        }
        BasicEList result = new BasicEList();
        for (Object obj : objList) {
            if (!this.check(obj)) continue;
            result.add(obj);
        }
        return result;
    }

    public List reject(List objList) {
        if (objList == null) {
            IllegalArgumentException error = new IllegalArgumentException(OCLMessages.NullArgExpectlist_ERROR_);
            OCLPlugin.throwing(this.getClass(), "reject", error);
            throw error;
        }
        BasicEList result = new BasicEList();
        for (Object obj : objList) {
            if (this.check(obj)) continue;
            result.add(obj);
        }
        return result;
    }

    public EClassifier resultType() {
        return this.expression.getType();
    }

    public String queryText() {
        Visitor tsv = ToStringVisitorImpl.getInstance();
        return (String)this.expression.accept(tsv);
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 0: {
                return this.getExtentMap();
            }
            case 1: {
                if (resolve) {
                    return this.getExpression();
                }
                return this.basicGetExpression();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 0: {
                this.setExtentMap((Map)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 0: {
                this.setExtentMap(EXTENT_MAP_EDEFAULT);
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 0: {
                return EXTENT_MAP_EDEFAULT == null ? this.extentMap != null : !EXTENT_MAP_EDEFAULT.equals(this.extentMap);
            }
            case 1: {
                return this.expression != null;
            }
        }
        return super.eIsSet(featureID);
    }

    protected void validate() {
        Visitor validationVisitor = ValidationVisitorImpl.getInstance();
        this.expression.accept(validationVisitor);
    }

    public void setEvaluationEnvironment(EvaluationEnvironment env) {
        this.env = env;
    }

    public EvaluationEnvironment getEvaluationEnvironment() {
        if (this.env == null) {
            this.env = new EvalEnvironment();
        }
        return this.env;
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (expression: ");
        result.append(this.queryText());
        result.append(')');
        return result.toString();
    }
}

