/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ocl.expressions.impl;

import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ocl.expressions.AssociationClassCallExp;
import org.eclipse.emf.ocl.expressions.BooleanLiteralExp;
import org.eclipse.emf.ocl.expressions.CollectionItem;
import org.eclipse.emf.ocl.expressions.CollectionKind;
import org.eclipse.emf.ocl.expressions.CollectionLiteralExp;
import org.eclipse.emf.ocl.expressions.CollectionLiteralPart;
import org.eclipse.emf.ocl.expressions.CollectionRange;
import org.eclipse.emf.ocl.expressions.EnumLiteralExp;
import org.eclipse.emf.ocl.expressions.ExpressionsFactory;
import org.eclipse.emf.ocl.expressions.FeatureCallExp;
import org.eclipse.emf.ocl.expressions.IfExp;
import org.eclipse.emf.ocl.expressions.IntegerLiteralExp;
import org.eclipse.emf.ocl.expressions.InvalidLiteralExp;
import org.eclipse.emf.ocl.expressions.IterateExp;
import org.eclipse.emf.ocl.expressions.IteratorExp;
import org.eclipse.emf.ocl.expressions.LetExp;
import org.eclipse.emf.ocl.expressions.MessageExp;
import org.eclipse.emf.ocl.expressions.NullLiteralExp;
import org.eclipse.emf.ocl.expressions.OCLExpression;
import org.eclipse.emf.ocl.expressions.OperationCallExp;
import org.eclipse.emf.ocl.expressions.PropertyCallExp;
import org.eclipse.emf.ocl.expressions.RealLiteralExp;
import org.eclipse.emf.ocl.expressions.StateExp;
import org.eclipse.emf.ocl.expressions.StringLiteralExp;
import org.eclipse.emf.ocl.expressions.TupleLiteralExp;
import org.eclipse.emf.ocl.expressions.TupleLiteralPart;
import org.eclipse.emf.ocl.expressions.TypeExp;
import org.eclipse.emf.ocl.expressions.UnspecifiedValueExp;
import org.eclipse.emf.ocl.expressions.Variable;
import org.eclipse.emf.ocl.expressions.VariableExp;
import org.eclipse.emf.ocl.expressions.Visitor;
import org.eclipse.emf.ocl.expressions.util.AbstractVisitor;
import org.eclipse.emf.ocl.expressions.util.ExpressionsUtil;
import org.eclipse.emf.ocl.internal.OCLPlugin;
import org.eclipse.emf.ocl.parser.EcoreEnvironment;
import org.eclipse.emf.ocl.parser.Environment;
import org.eclipse.emf.ocl.types.BagType;
import org.eclipse.emf.ocl.types.CollectionType;
import org.eclipse.emf.ocl.types.OrderedSetType;
import org.eclipse.emf.ocl.types.PrimitiveBoolean;
import org.eclipse.emf.ocl.types.SequenceType;
import org.eclipse.emf.ocl.types.SetType;
import org.eclipse.emf.ocl.types.TupleType;
import org.eclipse.emf.ocl.types.TypeType;
import org.eclipse.emf.ocl.types.VoidType;
import org.eclipse.emf.ocl.types.impl.AnyTypeImpl;
import org.eclipse.emf.ocl.types.impl.TypeUtil;
import org.eclipse.emf.ocl.types.util.Types;
import org.eclipse.emf.ocl.uml.Constraint;
import org.eclipse.emf.ocl.uml.UMLPackage;
import org.eclipse.emf.ocl.utilities.ASTNode;
import org.eclipse.emf.ocl.utilities.PredefinedType;
import org.eclipse.ocl.internal.l10n.OCLMessages;

public class ValidationVisitorImpl
implements Visitor {
    private static Environment NULL_ENVIRONMENT = new NullEnvironment();
    private Environment environment = null;

    public static Visitor getInstance() {
        return new ValidationVisitorImpl(null);
    }

    public static Visitor getInstance(Environment environment) {
        return new ValidationVisitorImpl(environment);
    }

    private ValidationVisitorImpl(Environment environment) {
        this.environment = environment;
    }

    protected Environment getEnvironment(ASTNode node) {
        Environment result = this.environment;
        if (result == null) {
            if (node != null) {
                result = this.createEcoreEnvironment(node);
            }
            if (result == null) {
                result = NULL_ENVIRONMENT;
            }
            this.environment = result;
        }
        return result;
    }

    private Environment createEcoreEnvironment(ASTNode node) {
        Environment result = null;
        Object context = null;
        Constraint constraint = (Constraint)ExpressionsUtil.containerOfType(UMLPackage.Literals.CONSTRAINT, node);
        if (constraint != null && !constraint.getConstrainedElement().isEmpty()) {
            context = constraint.getConstrainedElement().get(0);
            if (context instanceof EClassifier) {
                result = ExpressionsUtil.createClassifierContext((EClassifier)context);
            } else if (context instanceof EOperation) {
                result = ExpressionsUtil.createOperationContext((EOperation)context);
            } else if (context instanceof EStructuralFeature) {
                result = ExpressionsUtil.createPropertyContext((EStructuralFeature)context);
            }
        }
        return result;
    }

    public Object visitOperationCallExp(OperationCallExp oc) {
        OCLExpression source = oc.getSource();
        EOperation oper = oc.getReferredOperation();
        int opcode = oc.getOperationCode();
        EList args = oc.getArgument();
        if (oper == null) {
            String message = OCLMessages.bind((String)OCLMessages.NullOperation_ERROR_, (Object)oc.toString());
            IllegalArgumentException error = new IllegalArgumentException(message);
            OCLPlugin.throwing(this.getClass(), "visitOperationCallExp", error);
            throw error;
        }
        if (source == null) {
            String message = OCLMessages.bind((String)OCLMessages.NullSourceOperation_ERROR_, (Object)oc.toString());
            IllegalArgumentException error = new IllegalArgumentException(message);
            OCLPlugin.throwing(this.getClass(), "visitOperationCallExp", error);
            throw error;
        }
        EClassifier sourceType = source.getType();
        int numArgs = args.size();
        String operName = oper.getName();
        int i = 0;
        while (i < numArgs) {
            ((OCLExpression)args.get(i)).accept(this);
            ++i;
        }
        this.visitFeatureCallExp(oc);
        if (opcode == 71 && !ExpressionsUtil.isInPostcondition(oc)) {
            IllegalArgumentException error = new IllegalArgumentException(OCLMessages.OCLIsNewInPostcondition_ERROR_);
            OCLPlugin.throwing(this.getClass(), "visitOperationCallExp", error);
            throw error;
        }
        source.accept(this);
        try {
            EOperation oper1 = this.getEnvironment(oc).lookupOperation(sourceType, operName, args);
            if (oper1 != oper) {
                String message = OCLMessages.bind((String)OCLMessages.IllegalOperation_ERROR_, (Object)oc.toString());
                IllegalArgumentException error = new IllegalArgumentException(message);
                OCLPlugin.throwing(this.getClass(), "visitOperationCallExp", error);
                throw error;
            }
            if (!this.getEnvironment(oc).isQuery(oper)) {
                String message = OCLMessages.bind((String)OCLMessages.NonQueryOperation_ERROR_, (Object)oper.getName());
                IllegalArgumentException error = new IllegalArgumentException(message);
                OCLPlugin.throwing(this.getClass(), "visitOperationCallExp", error);
                throw error;
            }
            EClassifier resultType = null;
            if (sourceType instanceof PredefinedType) {
                PredefinedType pt = (PredefinedType)sourceType;
                if (opcode != pt.getOperationCodeFor(operName)) {
                    String message = OCLMessages.bind((String)OCLMessages.IllegalOpcode_ERROR_, (Object)operName);
                    IllegalArgumentException error = new IllegalArgumentException(message);
                    OCLPlugin.throwing(this.getClass(), "visitOperationCallExp", error);
                    throw error;
                }
                resultType = pt.getResultTypeFor(sourceType, opcode, args);
                resultType = resultType == null ? TypeUtil.getOCLType((ETypedElement)oper) : TypeUtil.getOCLType(resultType);
            } else {
                if (opcode != AnyTypeImpl.getOperationCode(operName)) {
                    String message = OCLMessages.bind((String)OCLMessages.IllegalOpcode_ERROR_, (Object)operName);
                    IllegalArgumentException error = new IllegalArgumentException(message);
                    OCLPlugin.throwing(this.getClass(), "visitOperationCallExp", error);
                    throw error;
                }
                resultType = AnyTypeImpl.getResultType(sourceType, opcode, args);
                if (resultType == null) {
                    resultType = TypeUtil.getOCLType((ETypedElement)oper);
                }
            }
            if (TypeUtil.typeCompare(resultType, oc.getType()) != 0) {
                String message = OCLMessages.bind((String)OCLMessages.TypeConformanceOperation_ERROR_, (Object)oc.getType().toString());
                IllegalArgumentException error = new IllegalArgumentException(message);
                OCLPlugin.throwing(this.getClass(), "visitOperationCallExp", error);
                throw error;
            }
        }
        catch (Exception e) {
            IllegalArgumentException error = new IllegalArgumentException(e.getMessage());
            OCLPlugin.throwing(this.getClass(), "visitOperationCallExp", error);
            throw error;
        }
        return Boolean.TRUE;
    }

    public Object visitEnumLiteralExp(EnumLiteralExp el) {
        EEnumLiteral l = el.getReferredEnumLiteral();
        EClassifier type = el.getType();
        if (!(type instanceof EEnum) || l.getEEnum() != type) {
            String message = OCLMessages.bind((String)OCLMessages.IllegalEnumLiteral_ERROR_, (Object)el.toString());
            IllegalArgumentException error = new IllegalArgumentException(message);
            OCLPlugin.throwing(this.getClass(), "visitEnumLiteralExp", error);
            throw error;
        }
        return Boolean.TRUE;
    }

    public Object visitVariableExp(VariableExp v) {
        Variable vd = v.getReferredVariable();
        if (vd == null || v.getType() == null || vd.getName() == null || vd.getType() == null) {
            String message = OCLMessages.bind((String)OCLMessages.IncompleteVariableExp_ERROR_, (Object)v.toString());
            IllegalArgumentException error = new IllegalArgumentException(message);
            OCLPlugin.throwing(this.getClass(), "visitVariableExp", error);
            throw error;
        }
        vd.accept(this);
        if (TypeUtil.typeCompare(vd.getType(), v.getType()) != 0) {
            IllegalArgumentException error = new IllegalArgumentException(OCLMessages.bind((String)OCLMessages.VariableTypeMismatch_ERROR_, (Object)vd.getName()));
            OCLPlugin.throwing(this.getClass(), "visitVariableExp", error);
            throw error;
        }
        return Boolean.TRUE;
    }

    public Object visitPropertyCallExp(PropertyCallExp pc) {
        EStructuralFeature property = pc.getReferredProperty();
        OCLExpression source = pc.getSource();
        EClassifier type = pc.getType();
        if (property == null) {
            String message = OCLMessages.bind((String)OCLMessages.NullProperty_ERROR_, (Object)pc.toString());
            IllegalArgumentException error = new IllegalArgumentException(message);
            OCLPlugin.throwing(this.getClass(), "visitPropertyCallExp", error);
            throw error;
        }
        if (source == null) {
            String message = OCLMessages.bind((String)OCLMessages.NullNavigationSource_ERROR_, (Object)pc.toString());
            IllegalArgumentException error = new IllegalArgumentException(message);
            OCLPlugin.throwing(this.getClass(), "visitPropertyCallExp", error);
            throw error;
        }
        if (type == null) {
            String message = OCLMessages.bind((String)OCLMessages.NullNavigationType_ERROR_, (Object)pc.toString());
            IllegalArgumentException error = new IllegalArgumentException(message);
            OCLPlugin.throwing(this.getClass(), "visitPropertyCallExp", error);
            throw error;
        }
        EList qualifiers = pc.getQualifier();
        if (!qualifiers.isEmpty()) {
            EList expectedQualifierTypes = this.getEnvironment(pc).getQualifiers(property);
            if (expectedQualifierTypes.size() != qualifiers.size()) {
                String message = OCLMessages.bind((String)OCLMessages.MismatchedQualifiers_ERROR_, (Object)pc.toString());
                IllegalArgumentException error = new IllegalArgumentException(message);
                OCLPlugin.throwing(this.getClass(), "visitPropertyCallExp", error);
                throw error;
            }
            Iterator eiter = expectedQualifierTypes.iterator();
            Iterator qiter = qualifiers.iterator();
            while (eiter.hasNext()) {
                EClassifier expectedType = TypeUtil.getOCLType((ETypedElement)eiter.next());
                OCLExpression qualifier = (OCLExpression)qiter.next();
                EClassifier qualifierType = qualifier.getType();
                if ((TypeUtil.getRelationship(qualifierType, expectedType) & 3) != 0) continue;
                String message = OCLMessages.bind((String)OCLMessages.MismatchedQualifiers_ERROR_, (Object)pc.toString());
                IllegalArgumentException error = new IllegalArgumentException(message);
                OCLPlugin.throwing(this.getClass(), "visitPropertyCallExp", error);
                throw error;
            }
        }
        this.visitFeatureCallExp(pc);
        source.accept(this);
        EClassifier refType = this.getPropertyType(this.getEnvironment(source), source.getType(), property);
        if (!pc.getQualifier().isEmpty() && refType instanceof CollectionType) {
            refType = ((CollectionType)refType).getElementType();
        }
        return TypeUtil.typeCompare(refType, type) == 0;
    }

    private EClassifier getPropertyType(Environment env, EClassifier owner, EStructuralFeature property) {
        EClass eclass;
        EClassifier result = TypeUtil.getOCLType((ETypedElement)property);
        if (owner instanceof EClass && env.isAssociationClass(eclass = (EClass)owner) && env.getMemberEnds(eclass).contains((Object)property) && result instanceof CollectionType) {
            result = ((CollectionType)result).getElementType();
        }
        return result;
    }

    public Object visitAssociationClassCallExp(AssociationClassCallExp ae) {
        EStructuralFeature end;
        EClass ref = ae.getReferredAssociationClass();
        OCLExpression source = ae.getSource();
        EClassifier type = ae.getType();
        if (ref == null) {
            String message = OCLMessages.bind((String)OCLMessages.MissingAssociationClass_ERROR_, (Object)ae.toString());
            IllegalArgumentException error = new IllegalArgumentException(message);
            OCLPlugin.throwing(this.getClass(), "visitAssociationClassCallExp", error);
            throw error;
        }
        if (source == null) {
            String message = OCLMessages.bind((String)OCLMessages.NullNavigationSource_ERROR_, (Object)ae.toString());
            IllegalArgumentException error = new IllegalArgumentException(message);
            OCLPlugin.throwing(this.getClass(), "visitAssociationClassCallExp", error);
            throw error;
        }
        EClassifier sourceType = source.getType();
        if (type == null) {
            String message = OCLMessages.bind((String)OCLMessages.NullNavigationType_ERROR_, (Object)ae.toString());
            IllegalArgumentException error = new IllegalArgumentException(message);
            OCLPlugin.throwing(this.getClass(), "visitAssociationClassCallExp", error);
            throw error;
        }
        if (type instanceof CollectionType) {
            type = ((CollectionType)type).getElementType();
        }
        if (!(ae.getNavigationSource() == null || (end = ae.getNavigationSource()) instanceof EReference && ref == this.getEnvironment(ae).getAssociationClass((EReference)end) && end == this.getEnvironment(ae).lookupProperty(sourceType, end.getName()))) {
            String message = OCLMessages.bind((String)OCLMessages.AssociationClassQualifierType_ERROR_, (Object)ae.toString());
            IllegalArgumentException error = new IllegalArgumentException(message);
            OCLPlugin.throwing(this.getClass(), "visitAssociationClassCallExp", error);
            throw error;
        }
        this.visitFeatureCallExp(ae);
        source.accept(this);
        EClassifier refType = TypeUtil.getOCLType((EClassifier)ref);
        if (TypeUtil.typeCompare(refType, type) == 0) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public Object visitVariable(Variable vd) {
        String varName = vd.getName();
        if (varName == null) {
            IllegalArgumentException error = new IllegalArgumentException(OCLMessages.MissingNameInVariableDeclaration_ERROR_);
            OCLPlugin.throwing(this.getClass(), "visitVariableDeclaration", error);
            throw error;
        }
        EClassifier type = vd.getType();
        OCLExpression init = vd.getInitExpression();
        if (init != null) {
            init.accept(this);
            if (TypeUtil.typeCompare(init.getType(), type) > 0) {
                IllegalArgumentException error = new IllegalArgumentException(OCLMessages.bind((String)OCLMessages.TypeConformanceInit_ERROR_, (Object)varName));
                OCLPlugin.throwing(this.getClass(), "visitVariableDeclaration", error);
                throw error;
            }
        }
        return Boolean.TRUE;
    }

    public Object visitIfExp(IfExp i) {
        OCLExpression cond = i.getCondition();
        OCLExpression thenexp = i.getThenExpression();
        OCLExpression elseexp = i.getElseExpression();
        if (cond == null || thenexp == null | elseexp == null) {
            String message = OCLMessages.bind((String)OCLMessages.IncompleteIfExp_ERROR_, (Object)i.toString());
            IllegalArgumentException error = new IllegalArgumentException(message);
            OCLPlugin.throwing(this.getClass(), "visitIfExp", error);
            throw error;
        }
        cond.accept(this);
        thenexp.accept(this);
        elseexp.accept(this);
        if (cond.getType() != Types.OCL_BOOLEAN) {
            String message = OCLMessages.bind((String)OCLMessages.NonBooleanIfExp_ERROR_, (Object)cond.toString());
            IllegalArgumentException error = new IllegalArgumentException(message);
            OCLPlugin.throwing(this.getClass(), "visitIfExp", error);
            throw error;
        }
        EClassifier thenelsetype = null;
        try {
            thenelsetype = TypeUtil.commonSuperType(thenexp.getType(), elseexp.getType());
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e.getMessage());
        }
        if (TypeUtil.typeCompare(i.getType(), thenelsetype) != 0) {
            String message = OCLMessages.bind((String)OCLMessages.TypeConformanceIfExp_ERROR_, (Object)i.toString());
            IllegalArgumentException error = new IllegalArgumentException(message);
            OCLPlugin.throwing(this.getClass(), "visitIfExp", error);
            throw error;
        }
        return Boolean.TRUE;
    }

    public Object visitMessageExp(MessageExp m) {
        EList parameters;
        if (m.getTarget() == null) {
            IllegalArgumentException error = new IllegalArgumentException(OCLMessages.bind((String)OCLMessages.MissingMessageTarget_ERROR_, (Object)m.toString()));
            OCLPlugin.throwing(this.getClass(), "visitMessageExp", error);
            throw error;
        }
        m.getTarget().accept(this);
        if (m.getCalledOperation() == null && m.getSentSignal() == null) {
            IllegalArgumentException error = new IllegalArgumentException(OCLMessages.UnrecognizedMessageType_ERROR_);
            OCLPlugin.throwing(this.getClass(), "visitMessageExp", error);
            throw error;
        }
        if (m.getCalledOperation() != null && m.getSentSignal() != null) {
            IllegalArgumentException error = new IllegalArgumentException(OCLMessages.AmbiguousMessageType_ERROR_);
            OCLPlugin.throwing(this.getClass(), "visitMessageExp", error);
            throw error;
        }
        if (m.getCalledOperation() != null) {
            EOperation operation = m.getCalledOperation().getOperation();
            if (operation == null) {
                IllegalArgumentException error = new IllegalArgumentException(OCLMessages.bind((String)OCLMessages.MissingOperationInCallAction_ERROR_, (Object)m.toString()));
                OCLPlugin.throwing(this.getClass(), "visitMessageExp", error);
                throw error;
            }
            parameters = operation.getEParameters();
        } else {
            EClass signal = m.getSentSignal().getSignal();
            if (signal == null) {
                IllegalArgumentException error = new IllegalArgumentException(OCLMessages.bind((String)OCLMessages.MissingSignalInCallAction_ERROR_, (Object)m.toString()));
                OCLPlugin.throwing(this.getClass(), "visitMessageExp", error);
                throw error;
            }
            parameters = TypeUtil.getProperties((EClassifier)signal);
        }
        EList arguments = m.getArgument();
        if (arguments.size() != parameters.size()) {
            IllegalArgumentException error = new IllegalArgumentException(OCLMessages.bind((String)OCLMessages.MessageArgumentCount_ERROR_, (Object)ValidationVisitorImpl.getName((ENamedElement)m.getType())));
            OCLPlugin.throwing(this.getClass(), "visitMessageExp", error);
            throw error;
        }
        Iterator paramsIter = parameters.iterator();
        Iterator argsIter = arguments.iterator();
        while (paramsIter.hasNext()) {
            ETypedElement param = (ETypedElement)paramsIter.next();
            OCLExpression arg = (OCLExpression)argsIter.next();
            if (TypeUtil.typeCompare(arg.getType(), TypeUtil.getOCLType(param)) > 0) {
                IllegalArgumentException error = new IllegalArgumentException(OCLMessages.bind((String)OCLMessages.MessageArgConformance_ERROR_, (Object)param.getName(), (Object)arg.toString()));
                OCLPlugin.throwing(this.getClass(), "visitMessageExp", error);
                throw error;
            }
            arg.accept(this);
        }
        return Boolean.TRUE;
    }

    public Object visitUnspecifiedValueExp(UnspecifiedValueExp uv) {
        if (!(uv.eContainer() instanceof MessageExp)) {
            IllegalArgumentException error = new IllegalArgumentException(OCLMessages.bind((String)OCLMessages.IllegalUnspecifiedValueExp_ERROR_, (Object)uv.toString()));
            OCLPlugin.throwing(this.getClass(), "visitUnspecifiedValueExp", error);
            throw error;
        }
        return Boolean.TRUE;
    }

    public Object visitTypeExp(TypeExp t) {
        if (!(t.getType() instanceof TypeType)) {
            IllegalArgumentException error = new IllegalArgumentException(OCLMessages.bind((String)OCLMessages.TypeConformanceTypeExp_ERROR_, (Object)ValidationVisitorImpl.getName((ENamedElement)t.getType())));
            OCLPlugin.throwing(this.getClass(), "visitTypeExp", error);
            throw error;
        }
        if (t.getReferredType() == null) {
            IllegalArgumentException error = new IllegalArgumentException(OCLMessages.bind((String)OCLMessages.TypeExpMissingType_ERROR_, (Object)t.toString()));
            OCLPlugin.throwing(this.getClass(), "visitTypeExp", error);
            throw error;
        }
        return Boolean.TRUE;
    }

    public Object visitIntegerLiteralExp(IntegerLiteralExp il) {
        if (il.getType() != Types.OCL_INTEGER) {
            IllegalArgumentException error = new IllegalArgumentException(OCLMessages.TypeConformanceIntegerLiteral_ERROR_);
            OCLPlugin.throwing(this.getClass(), "visitIntegerLiteralExp", error);
            throw error;
        }
        return Boolean.TRUE;
    }

    public Object visitRealLiteralExp(RealLiteralExp rl) {
        if (rl.getType() != Types.OCL_REAL) {
            IllegalArgumentException error = new IllegalArgumentException(OCLMessages.TypeConformanceRealLiteral_ERROR_);
            OCLPlugin.throwing(this.getClass(), "visitRealLiteralExp", error);
            throw error;
        }
        return Boolean.TRUE;
    }

    public Object visitStringLiteralExp(StringLiteralExp sl) {
        if (sl.getType() != Types.OCL_STRING) {
            IllegalArgumentException error = new IllegalArgumentException(OCLMessages.TypeConformanceStringLiteral_ERROR_);
            OCLPlugin.throwing(this.getClass(), "visitStringLiteralExp", error);
            throw error;
        }
        return Boolean.TRUE;
    }

    public Object visitBooleanLiteralExp(BooleanLiteralExp bl) {
        if (bl.getType() != Types.OCL_BOOLEAN) {
            IllegalArgumentException error = new IllegalArgumentException(OCLMessages.TypeConformanceBooleanLiteral_ERROR_);
            OCLPlugin.throwing(this.getClass(), "visitBooleanLiteralExp", error);
            throw error;
        }
        return Boolean.TRUE;
    }

    public Object visitLetExp(LetExp l) {
        Variable vd = l.getVariable();
        OCLExpression in = l.getIn();
        EClassifier type = l.getType();
        if (vd == null || in == null || type == null) {
            String message = OCLMessages.bind((String)OCLMessages.IncompleteLetExp_ERROR_, (Object)l.toString());
            IllegalArgumentException error = new IllegalArgumentException(message);
            OCLPlugin.throwing(this.getClass(), "visitLetExp", error);
            throw error;
        }
        vd.accept(this);
        in.accept(this);
        if (TypeUtil.typeCompare(type, in.getType()) != 0) {
            String message = OCLMessages.bind((String)OCLMessages.TypeConformanceLetExp_ERROR_, (Object)type, (Object)in.getType());
            IllegalArgumentException error = new IllegalArgumentException(message);
            OCLPlugin.throwing(this.getClass(), "visitLetExp", error);
            throw error;
        }
        return Boolean.TRUE;
    }

    public Object visitIterateExp(IterateExp ie) {
        Variable vd = ie.getResult();
        EClassifier type = ie.getType();
        OCLExpression body = ie.getBody();
        OCLExpression source = ie.getSource();
        EList iterators = ie.getIterator();
        if (vd == null || type == null || source == null || body == null || iterators.isEmpty()) {
            String message = OCLMessages.bind((String)OCLMessages.IncompleteIterateExp_ERROR_, (Object)ie.toString());
            IllegalArgumentException error = new IllegalArgumentException(message);
            OCLPlugin.throwing(this.getClass(), "visitIterateExp", error);
            throw error;
        }
        int numIters = iterators.size();
        source.accept(this);
        vd.accept(this);
        body.accept(this);
        if (vd.getInitExpression() == null) {
            String message = OCLMessages.bind((String)OCLMessages.MissingInitIterateExp_ERROR_, (Object)ie.toString());
            IllegalArgumentException error = new IllegalArgumentException(message);
            OCLPlugin.throwing(this.getClass(), "visitIterateExp", error);
            throw error;
        }
        if (TypeUtil.typeCompare(type, vd.getType()) != 0) {
            String message = OCLMessages.bind((String)OCLMessages.TypeConformanceIterateExp_ERROR_, (Object)ie.toString());
            IllegalArgumentException error = new IllegalArgumentException(message);
            OCLPlugin.throwing(this.getClass(), "visitIterateExp", error);
            throw error;
        }
        if (TypeUtil.typeCompare(body.getType(), vd.getType()) > 0) {
            String message = OCLMessages.bind((String)OCLMessages.TypeConformanceIterateExpBody_ERROR_, (Object)ie.toString());
            IllegalArgumentException error = new IllegalArgumentException(message);
            OCLPlugin.throwing(this.getClass(), "visitIterateExp", error);
            throw error;
        }
        EClassifier sourceType = source.getType();
        if (!(sourceType instanceof CollectionType)) {
            String message = OCLMessages.bind((String)OCLMessages.IteratorSource_ERROR_, (Object)ie.toString());
            IllegalArgumentException error = new IllegalArgumentException(message);
            OCLPlugin.throwing(this.getClass(), "visitIterateExp", error);
            throw error;
        }
        int i = 0;
        while (i < numIters) {
            Variable loopiter = (Variable)iterators.get(i);
            loopiter.accept(this);
            if (loopiter.getInitExpression() != null) {
                String message = OCLMessages.bind((String)OCLMessages.IterateExpLoopVarInit_ERROR_, (Object)ie.toString());
                IllegalArgumentException error = new IllegalArgumentException(message);
                OCLPlugin.throwing(this.getClass(), "visitIterateExp", error);
                throw error;
            }
            if (TypeUtil.typeCompare(loopiter.getType(), ((CollectionType)sourceType).getElementType()) != 0) {
                String message = OCLMessages.bind((String)OCLMessages.TypeConformanceIterateExpLoopVar_ERROR_, (Object)ie.toString());
                IllegalArgumentException error = new IllegalArgumentException(message);
                OCLPlugin.throwing(this.getClass(), "visitIterateExp", error);
                throw error;
            }
            ++i;
        }
        return Boolean.TRUE;
    }

    public Object visitIteratorExp(IteratorExp ie) {
        EClassifier type = ie.getType();
        OCLExpression body = ie.getBody();
        OCLExpression source = ie.getSource();
        EList iterators = ie.getIterator();
        String name = ie.getName();
        if (type == null || name == null || source == null || body == null || iterators.isEmpty()) {
            String message = OCLMessages.bind((String)OCLMessages.IncompleteIteratorExp_ERROR_, (Object)ie.toString());
            IllegalArgumentException error = new IllegalArgumentException(message);
            OCLPlugin.throwing(this.getClass(), "visitIteratorExp", error);
            throw error;
        }
        int opcode = 0;
        if (source.getType() instanceof PredefinedType) {
            opcode = ((PredefinedType)source.getType()).getOperationCodeFor(name);
        }
        int numIters = iterators.size();
        source.accept(this);
        body.accept(this);
        switch (opcode) {
            case 201: 
            case 202: 
            case 203: {
                if (type == Types.OCL_BOOLEAN) break;
                String message = OCLMessages.bind((String)OCLMessages.TypeConformanceIteratorResult_ERROR_, (Object)ie.toString());
                IllegalArgumentException error = new IllegalArgumentException(message);
                OCLPlugin.throwing(this.getClass(), "visitIteratorExp", error);
                throw error;
            }
        }
        if (opcode == 206) {
            if (source.getType() instanceof SequenceType || source.getType() instanceof OrderedSetType) {
                if (!(type instanceof SequenceType)) {
                    String message = OCLMessages.bind((String)OCLMessages.TypeConformanceCollectSequence_ERROR_, (Object)ie.toString());
                    IllegalArgumentException error = new IllegalArgumentException(message);
                    OCLPlugin.throwing(this.getClass(), "visitIteratorExp", error);
                    throw error;
                }
            } else if (!(type instanceof BagType)) {
                String message = OCLMessages.bind((String)OCLMessages.TypeConformanceCollectBag_ERROR_, (Object)ie.toString());
                IllegalArgumentException error = new IllegalArgumentException(message);
                OCLPlugin.throwing(this.getClass(), "visitIteratorExp", error);
                throw error;
            }
        }
        switch (opcode) {
            case 209: 
            case 210: {
                if (TypeUtil.typeCompare(type, source.getType()) == 0) break;
                String message = OCLMessages.bind((String)OCLMessages.TypeConformanceSelectReject_ERROR_, (Object)ie.toString());
                IllegalArgumentException error = new IllegalArgumentException(message);
                OCLPlugin.throwing(this.getClass(), "visitIteratorExp", error);
                throw error;
            }
        }
        switch (opcode) {
            case 201: 
            case 202: 
            case 204: 
            case 205: 
            case 209: 
            case 210: {
                if (body.getType() == Types.OCL_BOOLEAN) break;
                String message = OCLMessages.bind((String)OCLMessages.TypeConformanceIteratorBodyBoolean_ERROR_, (Object)ie.toString());
                IllegalArgumentException error = new IllegalArgumentException(message);
                OCLPlugin.throwing(this.getClass(), "visitIteratorExp", error);
                throw error;
            }
        }
        EClassifier sourceType = source.getType();
        if (!(sourceType instanceof CollectionType)) {
            String message = OCLMessages.bind((String)OCLMessages.IteratorSource_ERROR_, (Object)ie.toString());
            IllegalArgumentException error = new IllegalArgumentException(message);
            OCLPlugin.throwing(this.getClass(), "visitIteratorExp", error);
            throw error;
        }
        if (opcode == 208) {
            EClassifier bodyType;
            if (!(type instanceof SetType)) {
                String message = OCLMessages.bind((String)OCLMessages.TypeConformanceClosure_ERROR_, (Object)ie.toString());
                IllegalArgumentException error = new IllegalArgumentException(message);
                OCLPlugin.throwing(this.getClass(), "visitIteratorExp", error);
                throw error;
            }
            EClassifier sourceElementType = ((CollectionType)source.getType()).getElementType();
            if (TypeUtil.typeCompare(sourceElementType, bodyType = ((CollectionType)type).getElementType()) < 0) {
                String message = OCLMessages.bind((String)OCLMessages.ElementTypeConformanceClosure_ERROR_, (Object)ValidationVisitorImpl.getName((ENamedElement)bodyType), (Object)ValidationVisitorImpl.getName((ENamedElement)sourceElementType));
                IllegalArgumentException error = new IllegalArgumentException(message);
                OCLPlugin.throwing(this.getClass(), "visitIteratorExp", error);
                throw error;
            }
        }
        if (opcode == 211 && !this.isComparable(body.getType())) {
            String message = OCLMessages.bind((String)OCLMessages.OperationNotFound_ERROR_, (Object)"<", (Object)ValidationVisitorImpl.getName((ENamedElement)body.getType()));
            IllegalArgumentException error = new IllegalArgumentException(message);
            OCLPlugin.throwing(this.getClass(), "visitIteratorExp", error);
            throw error;
        }
        int i = 0;
        while (i < numIters) {
            Variable loopiter = (Variable)iterators.get(i);
            loopiter.accept(this);
            if (loopiter.getInitExpression() != null) {
                String message = OCLMessages.bind((String)OCLMessages.IterateExpLoopVarInit_ERROR_, (Object)ie.toString());
                IllegalArgumentException error = new IllegalArgumentException(message);
                OCLPlugin.throwing(this.getClass(), "visitIteratorExp", error);
                throw error;
            }
            if (TypeUtil.typeCompare(loopiter.getType(), ((CollectionType)sourceType).getElementType()) != 0) {
                String message = OCLMessages.bind((String)OCLMessages.TypeConformanceIteratorExpLoopVar_ERROR_, (Object)ie.toString());
                IllegalArgumentException error = new IllegalArgumentException(message);
                OCLPlugin.throwing(this.getClass(), "visitIteratorExp", error);
                throw error;
            }
            ++i;
        }
        return Boolean.TRUE;
    }

    private boolean isComparable(EClassifier type) {
        boolean result;
        boolean bl = result = type instanceof EDataType && Comparable.class.isAssignableFrom(((EDataType)type).getInstanceClass());
        if (!result) {
            result = type instanceof EClass && this.hasLessThanOperation((EClass)type);
        }
        return result;
    }

    private boolean hasLessThanOperation(EClass owner) {
        boolean result = false;
        for (EOperation oper : owner.getEAllOperations()) {
            if (!"<".equals(oper.getName()) || oper.getEParameters().size() != 1 || TypeUtil.getOCLType((ETypedElement)oper) != Types.OCL_BOOLEAN) continue;
            result = true;
            break;
        }
        return result;
    }

    public Object visitCollectionLiteralExp(CollectionLiteralExp cl) {
        EList parts;
        CollectionKind kind = cl.getKind();
        EClassifier collectionType = cl.getType();
        if (collectionType == null || !(collectionType instanceof CollectionType)) {
            String message = OCLMessages.bind((String)OCLMessages.TypeConformanceCollectionLiteralExp_ERROR_, (Object)cl.toString());
            IllegalArgumentException error = new IllegalArgumentException(message);
            OCLPlugin.throwing(this.getClass(), "visitCollectionLiteralExp", error);
            throw error;
        }
        if (kind == CollectionKind.SET_LITERAL) {
            if (!(collectionType instanceof SetType)) {
                String message = OCLMessages.bind((String)OCLMessages.TypeConformanceSetLiteral_ERROR_, (Object)cl.toString());
                IllegalArgumentException error = new IllegalArgumentException(message);
                OCLPlugin.throwing(this.getClass(), "visitCollectionLiteralExp", error);
                throw error;
            }
        } else if (kind == CollectionKind.ORDERED_SET_LITERAL) {
            if (!(collectionType instanceof OrderedSetType)) {
                String message = OCLMessages.bind((String)OCLMessages.TypeConformanceOrderedSetLiteral_ERROR_, (Object)cl.toString());
                IllegalArgumentException error = new IllegalArgumentException(message);
                OCLPlugin.throwing(this.getClass(), "visitCollectionLiteralExp", error);
                throw error;
            }
        } else if (kind == CollectionKind.BAG_LITERAL) {
            if (!(collectionType instanceof BagType)) {
                String message = OCLMessages.bind((String)OCLMessages.TypeConformanceBagLiteral_ERROR_, (Object)cl.toString());
                IllegalArgumentException error = new IllegalArgumentException(message);
                OCLPlugin.throwing(this.getClass(), "visitCollectionLiteralExp", error);
                throw error;
            }
        } else if (kind != CollectionKind.SEQUENCE_LITERAL || !(collectionType instanceof SequenceType)) {
            String message = OCLMessages.bind((String)OCLMessages.TypeConformanceSequenceLiteral_ERROR_, (Object)cl.toString());
            IllegalArgumentException error = new IllegalArgumentException(message);
            OCLPlugin.throwing(this.getClass(), "visitCollectionLiteralExp", error);
            throw error;
        }
        if ((parts = cl.getPart()).isEmpty()) {
            if (((CollectionType)collectionType).getElementType() != Types.OCL_VOID) {
                String message = OCLMessages.bind((String)OCLMessages.TypeConformanceEmptyCollection_ERROR_, (Object)cl.toString());
                IllegalArgumentException error = new IllegalArgumentException(message);
                OCLPlugin.throwing(this.getClass(), "visitCollectionLiteralExp", error);
                throw error;
            }
            return Boolean.TRUE;
        }
        EClassifier partsType = ((CollectionLiteralPart)parts.get(0)).getType();
        for (CollectionLiteralPart part : parts) {
            if (part instanceof CollectionItem) {
                ((CollectionItem)part).getItem().accept(this);
            } else {
                ((CollectionRange)part).getFirst().accept(this);
                ((CollectionRange)part).getLast().accept(this);
            }
            try {
                partsType = TypeUtil.commonSuperType(partsType, part.getType());
            }
            catch (Exception e) {
                throw new IllegalArgumentException(e.getMessage());
            }
        }
        if (TypeUtil.typeCompare(partsType, ((CollectionType)collectionType).getElementType()) != 0) {
            String message = OCLMessages.bind((String)OCLMessages.TypeConformanceCollectionElementType_ERROR_, (Object)cl.toString());
            IllegalArgumentException error = new IllegalArgumentException(message);
            OCLPlugin.throwing(this.getClass(), "visitCollectionLiteralExp", error);
            throw error;
        }
        return Boolean.TRUE;
    }

    public Object visitTupleLiteralExp(TupleLiteralExp tl) {
        EClassifier type = tl.getType();
        if (!(type instanceof TupleType)) {
            IllegalArgumentException error = new IllegalArgumentException(OCLMessages.bind((String)OCLMessages.TypeConformanceTupleLiteralExp_ERROR_, (Object)tl.toString()));
            OCLPlugin.throwing(this.getClass(), "visitTupleLiteralExp", error);
            throw error;
        }
        EClass eclazz = (EClass)type;
        EList tp = tl.getPart();
        if (tp.size() != eclazz.getEStructuralFeatures().size()) {
            IllegalArgumentException error = new IllegalArgumentException(OCLMessages.bind((String)OCLMessages.TypeConformanceTupleLiteralExpParts_ERROR_, (Object)tl.toString()));
            OCLPlugin.throwing(this.getClass(), "visitTupleLiteralExp", error);
            throw error;
        }
        HashSet<String> names = new HashSet<String>();
        for (TupleLiteralPart part : tl.getPart()) {
            String name = part.getName();
            EStructuralFeature property = eclazz.getEStructuralFeature(name);
            if (property == null) {
                String message = OCLMessages.bind((String)OCLMessages.TupleLiteralExpressionPart_ERROR_, (Object)name, (Object)tl.toString());
                IllegalArgumentException error = new IllegalArgumentException(message);
                OCLPlugin.throwing(this.getClass(), "visitTupleLiteralExp", error);
                throw error;
            }
            if (!names.add(name)) {
                String message = OCLMessages.bind((String)OCLMessages.TupleDuplicateName_ERROR_, (Object)name, (Object)tl.toString());
                IllegalArgumentException error = new IllegalArgumentException(message);
                OCLPlugin.throwing(this.getClass(), "visitTupleLiteralExp", error);
                throw error;
            }
            part.accept(this);
        }
        return Boolean.TRUE;
    }

    public Object visitTupleLiteralPart(TupleLiteralPart tp) {
        EStructuralFeature property = tp.getAttribute();
        if (property == null) {
            IllegalArgumentException error = new IllegalArgumentException(OCLMessages.bind((String)OCLMessages.MissingPropertyInTupleLiteralPart_ERROR_, (Object)tp.getName(), (Object)tp.eContainer().toString()));
            OCLPlugin.throwing(this.getClass(), "visitTupleLiteralPart", error);
            throw error;
        }
        EClassifier type = tp.getType();
        if (type == null) {
            IllegalArgumentException error = new IllegalArgumentException(OCLMessages.bind((String)OCLMessages.MissingTypeInTupleLiteralPart_ERROR_, (Object)tp.getName(), (Object)tp.eContainer().toString()));
            OCLPlugin.throwing(this.getClass(), "visitTupleLiteralPart", error);
            throw error;
        }
        if (TypeUtil.typeCompare(TypeUtil.getOCLType((ETypedElement)property), type) != 0) {
            IllegalArgumentException error = new IllegalArgumentException(OCLMessages.bind((String)OCLMessages.TuplePartType_ERROR_, (Object)tp.getName(), (Object)tp.eContainer().toString()));
            OCLPlugin.throwing(this.getClass(), "visitTupleLiteralPart", error);
            throw error;
        }
        OCLExpression init = tp.getValue();
        if (init != null) {
            init.accept(this);
            if (TypeUtil.typeCompare(init.getType(), type) > 0) {
                IllegalArgumentException error = new IllegalArgumentException(OCLMessages.TypeConformanceTuplePartValue_ERROR_);
                OCLPlugin.throwing(this.getClass(), "visitTupleLiteralPart", error);
                throw error;
            }
        }
        return Boolean.TRUE;
    }

    public Object visitStateExp(StateExp s) {
        EObject state = s.getReferredState();
        if (state == null) {
            IllegalArgumentException error = new IllegalArgumentException(OCLMessages.bind((String)OCLMessages.MissingStateInStateExp_ERROR_, (Object)s.toString()));
            OCLPlugin.throwing(this.getClass(), "visitStateExp", error);
            throw error;
        }
        return Boolean.TRUE;
    }

    public Object visitConstraint(Constraint constraint) {
        IllegalArgumentException error;
        String message;
        String stereo = constraint.getStereotype();
        EClassifier bodyType = constraint.getBody().getType();
        VoidType operationType = null;
        VoidType propertyType = null;
        String operationName = null;
        String propertyName = null;
        String classifierName = null;
        if (!constraint.getConstrainedElement().isEmpty()) {
            Object constrained = constraint.getConstrainedElement().get(0);
            if (constrained instanceof EOperation) {
                EOperation operation = (EOperation)constrained;
                operationName = operation.getName();
                if (operation.getEContainingClass() != null) {
                    classifierName = operation.getEContainingClass().getName();
                }
                if (operation.getEType() != null) {
                    operationType = TypeUtil.getOCLType((ETypedElement)operation);
                }
            } else if (constrained instanceof EStructuralFeature) {
                EStructuralFeature property = (EStructuralFeature)constrained;
                propertyName = property.getName();
                if (property.getEContainingClass() != null) {
                    classifierName = property.getEContainingClass().getName();
                }
                if (property.getEType() != null) {
                    propertyType = TypeUtil.getOCLType((ETypedElement)property);
                }
            } else if (constrained instanceof EClassifier) {
                classifierName = ((EClassifier)constrained).getName();
            }
        }
        if (operationType == null) {
            operationType = Types.OCL_VOID;
        }
        if (propertyType == null) {
            propertyType = Types.OCL_VOID;
        }
        if ("body".equals(stereo) || "postcondition".equals(stereo) || "precondition".equals(stereo)) {
            if (!(bodyType instanceof PrimitiveBoolean)) {
                message = OCLMessages.bind((String)OCLMessages.OperationConstraintBoolean_ERROR_, (Object)operationName);
                error = new IllegalArgumentException(message);
                OCLPlugin.throwing(this.getClass(), "visitConstraint", error);
                throw error;
            }
        } else if ("invariant".equals(stereo)) {
            if (!(bodyType instanceof PrimitiveBoolean)) {
                message = OCLMessages.bind((String)OCLMessages.InvariantConstraintBoolean_ERROR_, (Object)classifierName);
                error = new IllegalArgumentException(message);
                OCLPlugin.throwing(this.getClass(), "visitConstraint", error);
                throw error;
            }
        } else if ("definition".equals(stereo)) {
            Object constrained;
            ETypedElement feature = null;
            if (constraint.getConstrainedElement().size() >= 2 && (constrained = constraint.getConstrainedElement().get(1)) instanceof ETypedElement) {
                feature = (ETypedElement)constrained;
            }
            if (feature == null) {
                String message2 = OCLMessages.bind((String)OCLMessages.DefinitionConstraintFeature_ERROR_, (Object)classifierName);
                IllegalArgumentException error2 = new IllegalArgumentException(message2);
                OCLPlugin.throwing(this.getClass(), "visitConstraint", error2);
                throw error2;
            }
            EClassifier featureType = TypeUtil.getOCLType(feature);
            if (featureType == null || TypeUtil.typeCompare(bodyType, featureType) > 0) {
                String message3 = OCLMessages.bind((String)OCLMessages.DefinitionConstraintConformance_ERROR_, (Object)ValidationVisitorImpl.getName((ENamedElement)bodyType), (Object)ValidationVisitorImpl.getName((ENamedElement)featureType));
                IllegalArgumentException error3 = new IllegalArgumentException(message3);
                OCLPlugin.throwing(this.getClass(), "visitConstraint", error3);
                throw error3;
            }
        } else if (("initial".equals(stereo) || "derivation".equals(stereo)) && TypeUtil.typeCompare(bodyType, propertyType) > 0) {
            message = OCLMessages.bind((String)OCLMessages.InitOrDerConstraintConformance_ERROR_, (Object[])new Object[]{ValidationVisitorImpl.getName((ENamedElement)bodyType), propertyName, ValidationVisitorImpl.getName((ENamedElement)propertyType)});
            error = new IllegalArgumentException(message);
            OCLPlugin.throwing(this.getClass(), "visitConstraint", error);
            throw error;
        }
        if ("body".equals(constraint.getStereotype())) {
            OCLExpression bodyExpr;
            if (operationType instanceof VoidType) {
                message = OCLMessages.bind((String)OCLMessages.BodyConditionNotAllowed_ERROR_, (Object)operationName);
                error = new IllegalArgumentException(message);
                OCLPlugin.throwing(this.getClass(), "visitConstraint", error);
                throw error;
            }
            OCLExpression exp = constraint.getBody();
            while (exp instanceof LetExp) {
                exp = ((LetExp)exp).getIn();
            }
            OperationCallExp body = null;
            if (exp instanceof OperationCallExp) {
                body = (OperationCallExp)exp;
            }
            if (body == null || body.getOperationCode() != 60 || body.getArgument().size() != 1) {
                String message4 = OCLMessages.bind((String)OCLMessages.BodyConditionForm_ERROR_, (Object)operationName);
                IllegalArgumentException error4 = new IllegalArgumentException(message4);
                OCLPlugin.throwing(this.getClass(), "visitConstraint", error4);
                throw error4;
            }
            if (ValidationVisitorImpl.isResultVariable(body.getSource(), operationType)) {
                bodyExpr = (OCLExpression)body.getArgument().get(0);
            } else if (ValidationVisitorImpl.isResultVariable((OCLExpression)body.getArgument().get(0), operationType)) {
                bodyExpr = body.getSource();
            } else {
                String message5 = OCLMessages.bind((String)OCLMessages.BodyConditionForm_ERROR_, (Object)operationName);
                IllegalArgumentException error5 = new IllegalArgumentException(message5);
                OCLPlugin.throwing(this.getClass(), "visitConstraint", error5);
                throw error5;
            }
            bodyType = bodyExpr.getType();
            if ((TypeUtil.getRelationship(bodyType, operationType) & 3) == 0) {
                String message6 = OCLMessages.bind((String)OCLMessages.BodyConditionConformance_ERROR_, (Object[])new Object[]{operationName, ValidationVisitorImpl.getName((ENamedElement)bodyType), ValidationVisitorImpl.getName((ENamedElement)operationType)});
                IllegalArgumentException error6 = new IllegalArgumentException(message6);
                OCLPlugin.throwing(this.getClass(), "visitConstraint", error6);
                throw error6;
            }
            if (ValidationVisitorImpl.findResultVariable(bodyExpr, operationType)) {
                String message7 = OCLMessages.bind((String)OCLMessages.BodyConditionForm_ERROR_, (Object)operationName);
                IllegalArgumentException error7 = new IllegalArgumentException(message7);
                OCLPlugin.throwing(this.getClass(), "visitConstraint", error7);
                throw error7;
            }
        }
        return constraint.getBody().accept(this);
    }

    static String getName(ENamedElement element) {
        return element == null ? null : element.getName();
    }

    private static boolean isResultVariable(OCLExpression expr, EClassifier expectedType) {
        boolean result = expr instanceof VariableExp;
        if (result) {
            try {
                result = TypeUtil.typeCompare(expr.getType(), expectedType) == 0;
            }
            catch (Exception exception) {
                result = false;
            }
        }
        if (result) {
            Variable var = ((VariableExp)expr).getReferredVariable();
            result = var != null && "result".equals(var.getName());
        }
        return result;
    }

    private static boolean findResultVariable(OCLExpression expr, EClassifier expectedType) {
        class ResultFinder
        extends AbstractVisitor {
            boolean found = false;
            private final /* synthetic */ EClassifier val$expectedType;

            ResultFinder(EClassifier eClassifier) {
                this.val$expectedType = eClassifier;
            }

            public Object visitVariableExp(VariableExp v) {
                if (ValidationVisitorImpl.isResultVariable(v, this.val$expectedType)) {
                    this.found = true;
                }
                return null;
            }
        }
        ResultFinder finder = new ResultFinder(expectedType);
        expr.accept(finder);
        return finder.found;
    }

    private void visitFeatureCallExp(FeatureCallExp exp) {
        if (exp.isMarkedPre() && !ExpressionsUtil.isInPostcondition(exp)) {
            IllegalArgumentException error = new IllegalArgumentException(OCLMessages.AtPreInPostcondition_ERROR_);
            OCLPlugin.throwing(this.getClass(), "visitModelPropertyCallExp", error);
            throw error;
        }
    }

    public Object visitInvalidLiteralExp(InvalidLiteralExp il) {
        if (il.getType() != Types.INVALID) {
            IllegalArgumentException error = new IllegalArgumentException(OCLMessages.TypeConformanceInvalidLiteral_ERROR_);
            OCLPlugin.throwing(this.getClass(), "visitInvalidLiteralExp", error);
            throw error;
        }
        return Boolean.TRUE;
    }

    public Object visitNullLiteralExp(NullLiteralExp il) {
        if (il.getType() != Types.OCL_VOID) {
            IllegalArgumentException error = new IllegalArgumentException(OCLMessages.TypeConformanceNullLiteral_ERROR_);
            OCLPlugin.throwing(this.getClass(), "visitNullLiteralExp", error);
            throw error;
        }
        return Boolean.TRUE;
    }

    private static class NullEnvironment
    extends EcoreEnvironment {
        public NullEnvironment() {
            super((EPackage)EcorePackage.eINSTANCE);
            Variable selfVar = ExpressionsFactory.eINSTANCE.createVariable();
            selfVar.setName("self");
            selfVar.setType(Types.OCL_ANY_TYPE);
            this.setSelfVariable(selfVar);
        }
    }
}

