/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.diagram.clazz.action;

import java.util.List;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.ui.actions.DiagramAction;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.emf.type.core.commands.EditElementCommand;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.uml2.diagram.clazz.details.UMLDetailLevel;
import org.eclipse.uml2.diagram.clazz.details.UMLDetailLevelService;

public class ChangeDetailLevel
extends DiagramAction {
    private UMLDetailLevel myNewLevel;

    public ChangeDetailLevel(IWorkbenchPage workbenchPage, UMLDetailLevel level) {
        super(workbenchPage);
        this.myNewLevel = level;
        this.setText(level.getLabel());
    }

    public void refresh() {
        super.refresh();
        this.setChecked(this.calculateChecked());
    }

    protected boolean calculateEnabled() {
        DiagramEditPart diagram = this.getDiagramEditPart();
        if (diagram == null || diagram.getDiagramView() == null) {
            return false;
        }
        return UMLDetailLevelService.getLevel((View)diagram.getDiagramView()) != this.myNewLevel && super.calculateEnabled();
    }

    protected Command getCommand() {
        CompoundCommand result = new CompoundCommand();
        DiagramEditPart diagramEditPart = this.getDiagramEditPart();
        Diagram diagram = diagramEditPart.getDiagramView();
        TransactionalEditingDomain editingDomain = diagramEditPart.getEditingDomain();
        UMLDetailLevel oldLevel = UMLDetailLevelService.getLevel((View)diagram);
        List<View> affectedViews = oldLevel.getAffectedViews(diagram);
        for (View affected : affectedViews) {
            for (EditElementCommand command : oldLevel.getUnapplyCommands(editingDomain, affected)) {
                result.add((Command)new ICommandProxy((ICommand)command));
            }
        }
        affectedViews = this.myNewLevel.getAffectedViews(diagram);
        for (View affected : affectedViews) {
            for (EditElementCommand command : this.myNewLevel.getApplyCommands(editingDomain, affected)) {
                result.add((Command)new ICommandProxy((ICommand)command));
            }
        }
        result.add((Command)new ICommandProxy((ICommand)this.myNewLevel.getSetLevelCommand(editingDomain, diagram)));
        return result;
    }

    protected Request createTargetRequest() {
        return null;
    }

    protected boolean isSelectionListener() {
        return true;
    }

    private boolean calculateChecked() {
        DiagramEditPart diagram = this.getDiagramEditPart();
        if (diagram == null || diagram.getDiagramView() == null) {
            return false;
        }
        return UMLDetailLevelService.getLevel((View)diagram.getDiagramView()) == this.myNewLevel;
    }
}

