/*
 * Copyright (c) 2005, 2018 IBM Corporation, Embarcadero Technologies, CEA, and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *   IBM - initial API and implementation
 *   Kenn Hussey (Embarcadero Technologies) - 215418, 204200
 *   Kenn Hussey - 323181, 438123
 *   Kenn Hussey (CEA) - 327039, 351774, 418466, 414970, 370089, 511674
 *
 */
package org.eclipse.uml2.uml.edit.providers;

import java.util.Collection;
import java.util.List;

import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;

import org.eclipse.emf.ecore.EStructuralFeature;

import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.ViewerNotification;

import org.eclipse.uml2.uml.ActivityEdge;
import org.eclipse.uml2.uml.UMLFactory;
import org.eclipse.uml2.uml.UMLPackage;

/**
 * This is the item provider adapter for a {@link org.eclipse.uml2.uml.ActivityEdge} object.
 * <!-- begin-user-doc -->
 * <!-- end-user-doc -->
 * @generated
 */
public class ActivityEdgeItemProvider
		extends RedefinableElementItemProvider {

	/**
	 * This constructs an instance from a factory and a notifier.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ActivityEdgeItemProvider(AdapterFactory adapterFactory) {
		super(adapterFactory);
	}

	/**
	 * This returns the property descriptors for the adapted class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public List<IItemPropertyDescriptor> getPropertyDescriptors(Object object) {
		if (itemPropertyDescriptors == null) {
			super.getPropertyDescriptors(object);

			addActivityPropertyDescriptor(object);
			addGuardPropertyDescriptor(object);
			addInPartitionPropertyDescriptor(object);
			addInterruptsPropertyDescriptor(object);
			addInStructuredNodePropertyDescriptor(object);
			addTargetPropertyDescriptor(object);
			addSourcePropertyDescriptor(object);
			addRedefinedEdgePropertyDescriptor(object);
			addWeightPropertyDescriptor(object);
			addInGroupPropertyDescriptor(object);
		}
		return itemPropertyDescriptors;
	}

	/**
	 * This adds a property descriptor for the Activity feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected void addActivityPropertyDescriptor(Object object) {
		itemPropertyDescriptors.add(createItemPropertyDescriptor(
			((ComposeableAdapterFactory) adapterFactory)
				.getRootAdapterFactory(),
			getResourceLocator(),
			getString("_UI_ActivityEdge_activity_feature"), //$NON-NLS-1$
			getString("_UI_PropertyDescriptor_description", //$NON-NLS-1$
				"_UI_ActivityEdge_activity_feature", "_UI_ActivityEdge_type"), //$NON-NLS-1$ //$NON-NLS-2$
			UMLPackage.Literals.ACTIVITY_EDGE__ACTIVITY, true, false, true,
			null, null, new String[]{"org.eclipse.ui.views.properties.expert" //$NON-NLS-1$
			}));
	}

	/**
	 * This adds a property descriptor for the In Group feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected void addInGroupPropertyDescriptor(Object object) {
		itemPropertyDescriptors.add(createItemPropertyDescriptor(
			((ComposeableAdapterFactory) adapterFactory)
				.getRootAdapterFactory(),
			getResourceLocator(), getString("_UI_ActivityEdge_inGroup_feature"), //$NON-NLS-1$
			getString("_UI_PropertyDescriptor_description", //$NON-NLS-1$
				"_UI_ActivityEdge_inGroup_feature", "_UI_ActivityEdge_type"), //$NON-NLS-1$ //$NON-NLS-2$
			UMLPackage.Literals.ACTIVITY_EDGE__IN_GROUP, false, false, false,
			null, null, new String[]{"org.eclipse.ui.views.properties.expert" //$NON-NLS-1$
			}));
	}

	/**
	 * This adds a property descriptor for the In Partition feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected void addInPartitionPropertyDescriptor(Object object) {
		itemPropertyDescriptors.add(createItemPropertyDescriptor(
			((ComposeableAdapterFactory) adapterFactory)
				.getRootAdapterFactory(),
			getResourceLocator(),
			getString("_UI_ActivityEdge_inPartition_feature"), //$NON-NLS-1$
			getString("_UI_PropertyDescriptor_description", //$NON-NLS-1$
				"_UI_ActivityEdge_inPartition_feature", //$NON-NLS-1$
				"_UI_ActivityEdge_type"), //$NON-NLS-1$
			UMLPackage.Literals.ACTIVITY_EDGE__IN_PARTITION, true, false, true,
			null, null, null));
	}

	/**
	 * This adds a property descriptor for the In Structured Node feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected void addInStructuredNodePropertyDescriptor(Object object) {
		itemPropertyDescriptors.add(createItemPropertyDescriptor(
			((ComposeableAdapterFactory) adapterFactory)
				.getRootAdapterFactory(),
			getResourceLocator(),
			getString("_UI_ActivityEdge_inStructuredNode_feature"), //$NON-NLS-1$
			getString("_UI_PropertyDescriptor_description", //$NON-NLS-1$
				"_UI_ActivityEdge_inStructuredNode_feature", //$NON-NLS-1$
				"_UI_ActivityEdge_type"), //$NON-NLS-1$
			UMLPackage.Literals.ACTIVITY_EDGE__IN_STRUCTURED_NODE, true, false,
			true, null, null,
			new String[]{"org.eclipse.ui.views.properties.expert" //$NON-NLS-1$
			}));
	}

	/**
	 * This adds a property descriptor for the Target feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected void addTargetPropertyDescriptor(Object object) {
		itemPropertyDescriptors.add(createItemPropertyDescriptor(
			((ComposeableAdapterFactory) adapterFactory)
				.getRootAdapterFactory(),
			getResourceLocator(), getString("_UI_ActivityEdge_target_feature"), //$NON-NLS-1$
			getString("_UI_PropertyDescriptor_description", //$NON-NLS-1$
				"_UI_ActivityEdge_target_feature", "_UI_ActivityEdge_type"), //$NON-NLS-1$ //$NON-NLS-2$
			UMLPackage.Literals.ACTIVITY_EDGE__TARGET, true, false, true, null,
			null, null));
	}

	/**
	 * This adds a property descriptor for the Redefined Edge feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected void addRedefinedEdgePropertyDescriptor(Object object) {
		itemPropertyDescriptors.add(createItemPropertyDescriptor(
			((ComposeableAdapterFactory) adapterFactory)
				.getRootAdapterFactory(),
			getResourceLocator(),
			getString("_UI_ActivityEdge_redefinedEdge_feature"), //$NON-NLS-1$
			getString("_UI_PropertyDescriptor_description", //$NON-NLS-1$
				"_UI_ActivityEdge_redefinedEdge_feature", //$NON-NLS-1$
				"_UI_ActivityEdge_type"), //$NON-NLS-1$
			UMLPackage.Literals.ACTIVITY_EDGE__REDEFINED_EDGE, true, false,
			true, null, null, null));
	}

	/**
	 * This adds a property descriptor for the Guard feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected void addGuardPropertyDescriptor(Object object) {
		itemPropertyDescriptors.add(createItemPropertyDescriptor(
			((ComposeableAdapterFactory) adapterFactory)
				.getRootAdapterFactory(),
			getResourceLocator(), getString("_UI_ActivityEdge_guard_feature"), //$NON-NLS-1$
			getString("_UI_PropertyDescriptor_description", //$NON-NLS-1$
				"_UI_ActivityEdge_guard_feature", "_UI_ActivityEdge_type"), //$NON-NLS-1$ //$NON-NLS-2$
			UMLPackage.Literals.ACTIVITY_EDGE__GUARD, true, false, true, null,
			null, new String[]{"org.eclipse.ui.views.properties.expert" //$NON-NLS-1$
			}));
	}

	/**
	 * This adds a property descriptor for the Weight feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected void addWeightPropertyDescriptor(Object object) {
		itemPropertyDescriptors.add(createItemPropertyDescriptor(
			((ComposeableAdapterFactory) adapterFactory)
				.getRootAdapterFactory(),
			getResourceLocator(), getString("_UI_ActivityEdge_weight_feature"), //$NON-NLS-1$
			getString("_UI_PropertyDescriptor_description", //$NON-NLS-1$
				"_UI_ActivityEdge_weight_feature", "_UI_ActivityEdge_type"), //$NON-NLS-1$ //$NON-NLS-2$
			UMLPackage.Literals.ACTIVITY_EDGE__WEIGHT, true, false, true, null,
			null, new String[]{"org.eclipse.ui.views.properties.expert" //$NON-NLS-1$
			}));
	}

	/**
	 * This adds a property descriptor for the Interrupts feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected void addInterruptsPropertyDescriptor(Object object) {
		itemPropertyDescriptors.add(createItemPropertyDescriptor(
			((ComposeableAdapterFactory) adapterFactory)
				.getRootAdapterFactory(),
			getResourceLocator(),
			getString("_UI_ActivityEdge_interrupts_feature"), //$NON-NLS-1$
			getString("_UI_PropertyDescriptor_description", //$NON-NLS-1$
				"_UI_ActivityEdge_interrupts_feature", "_UI_ActivityEdge_type"), //$NON-NLS-1$ //$NON-NLS-2$
			UMLPackage.Literals.ACTIVITY_EDGE__INTERRUPTS, true, false, true,
			null, null, null));
	}

	/**
	 * This adds a property descriptor for the Source feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected void addSourcePropertyDescriptor(Object object) {
		itemPropertyDescriptors.add(createItemPropertyDescriptor(
			((ComposeableAdapterFactory) adapterFactory)
				.getRootAdapterFactory(),
			getResourceLocator(), getString("_UI_ActivityEdge_source_feature"), //$NON-NLS-1$
			getString("_UI_PropertyDescriptor_description", //$NON-NLS-1$
				"_UI_ActivityEdge_source_feature", "_UI_ActivityEdge_type"), //$NON-NLS-1$ //$NON-NLS-2$
			UMLPackage.Literals.ACTIVITY_EDGE__SOURCE, true, false, true, null,
			null, null));
	}

	/**
	 * This specifies how to implement {@link #getChildren} and is used to deduce an appropriate feature for an
	 * {@link org.eclipse.emf.edit.command.AddCommand}, {@link org.eclipse.emf.edit.command.RemoveCommand} or
	 * {@link org.eclipse.emf.edit.command.MoveCommand} in {@link #createCommand}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Collection<? extends EStructuralFeature> getChildrenFeatures(
			Object object) {
		if (childrenFeatures == null) {
			super.getChildrenFeatures(object);
			childrenFeatures.add(UMLPackage.Literals.ACTIVITY_EDGE__GUARD);
			childrenFeatures.add(UMLPackage.Literals.ACTIVITY_EDGE__WEIGHT);
		}
		return childrenFeatures;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EStructuralFeature getChildFeature(Object object, Object child) {
		// Check the type of the specified child object and return the proper feature to use for
		// adding (see {@link AddCommand}) it as a child.

		return super.getChildFeature(object, child);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected boolean shouldComposeCreationImage() {
		return true;
	}

	/**
	 * This returns the label text for the adapted class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getText(Object object) {
		String label = ((ActivityEdge) object).getName();
		return label == null || label.length() == 0
			? getString("_UI_ActivityEdge_type") //$NON-NLS-1$
			: getString("_UI_ActivityEdge_type") + " " + label; //$NON-NLS-1$ //$NON-NLS-2$
	}

	/**
	 * This handles model notifications by calling {@link #updateChildren} to update any cached
	 * children and by creating a viewer notification, which it passes to {@link #fireNotifyChanged}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void notifyChanged(Notification notification) {
		updateChildren(notification);

		switch (notification.getFeatureID(ActivityEdge.class)) {
			case UMLPackage.ACTIVITY_EDGE__GUARD :
			case UMLPackage.ACTIVITY_EDGE__WEIGHT :
				fireNotifyChanged(new ViewerNotification(notification,
					notification.getNotifier(), true, false));
				return;
		}
		super.notifyChanged(notification);
	}

	/**
	 * This adds {@link org.eclipse.emf.edit.command.CommandParameter}s describing the children
	 * that can be created under this object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected void collectNewChildDescriptors(
			Collection<Object> newChildDescriptors, Object object) {
		super.collectNewChildDescriptors(newChildDescriptors, object);

		newChildDescriptors
			.add(createChildParameter(UMLPackage.Literals.ACTIVITY_EDGE__GUARD,
				UMLFactory.eINSTANCE.createOpaqueExpression()));

		newChildDescriptors
			.add(createChildParameter(UMLPackage.Literals.ACTIVITY_EDGE__GUARD,
				UMLFactory.eINSTANCE.createExpression()));

		newChildDescriptors
			.add(createChildParameter(UMLPackage.Literals.ACTIVITY_EDGE__GUARD,
				UMLFactory.eINSTANCE.createStringExpression()));

		newChildDescriptors
			.add(createChildParameter(UMLPackage.Literals.ACTIVITY_EDGE__GUARD,
				UMLFactory.eINSTANCE.createInstanceValue()));

		newChildDescriptors
			.add(createChildParameter(UMLPackage.Literals.ACTIVITY_EDGE__GUARD,
				UMLFactory.eINSTANCE.createTimeExpression()));

		newChildDescriptors
			.add(createChildParameter(UMLPackage.Literals.ACTIVITY_EDGE__GUARD,
				UMLFactory.eINSTANCE.createDuration()));

		newChildDescriptors
			.add(createChildParameter(UMLPackage.Literals.ACTIVITY_EDGE__GUARD,
				UMLFactory.eINSTANCE.createInterval()));

		newChildDescriptors
			.add(createChildParameter(UMLPackage.Literals.ACTIVITY_EDGE__GUARD,
				UMLFactory.eINSTANCE.createDurationInterval()));

		newChildDescriptors
			.add(createChildParameter(UMLPackage.Literals.ACTIVITY_EDGE__GUARD,
				UMLFactory.eINSTANCE.createLiteralBoolean()));

		newChildDescriptors
			.add(createChildParameter(UMLPackage.Literals.ACTIVITY_EDGE__GUARD,
				UMLFactory.eINSTANCE.createLiteralInteger()));

		newChildDescriptors
			.add(createChildParameter(UMLPackage.Literals.ACTIVITY_EDGE__GUARD,
				UMLFactory.eINSTANCE.createLiteralNull()));

		newChildDescriptors
			.add(createChildParameter(UMLPackage.Literals.ACTIVITY_EDGE__GUARD,
				UMLFactory.eINSTANCE.createLiteralReal()));

		newChildDescriptors
			.add(createChildParameter(UMLPackage.Literals.ACTIVITY_EDGE__GUARD,
				UMLFactory.eINSTANCE.createLiteralString()));

		newChildDescriptors
			.add(createChildParameter(UMLPackage.Literals.ACTIVITY_EDGE__GUARD,
				UMLFactory.eINSTANCE.createLiteralUnlimitedNatural()));

		newChildDescriptors
			.add(createChildParameter(UMLPackage.Literals.ACTIVITY_EDGE__GUARD,
				UMLFactory.eINSTANCE.createTimeInterval()));

		newChildDescriptors
			.add(createChildParameter(UMLPackage.Literals.ACTIVITY_EDGE__WEIGHT,
				UMLFactory.eINSTANCE.createOpaqueExpression()));

		newChildDescriptors
			.add(createChildParameter(UMLPackage.Literals.ACTIVITY_EDGE__WEIGHT,
				UMLFactory.eINSTANCE.createExpression()));

		newChildDescriptors
			.add(createChildParameter(UMLPackage.Literals.ACTIVITY_EDGE__WEIGHT,
				UMLFactory.eINSTANCE.createStringExpression()));

		newChildDescriptors
			.add(createChildParameter(UMLPackage.Literals.ACTIVITY_EDGE__WEIGHT,
				UMLFactory.eINSTANCE.createInstanceValue()));

		newChildDescriptors
			.add(createChildParameter(UMLPackage.Literals.ACTIVITY_EDGE__WEIGHT,
				UMLFactory.eINSTANCE.createTimeExpression()));

		newChildDescriptors
			.add(createChildParameter(UMLPackage.Literals.ACTIVITY_EDGE__WEIGHT,
				UMLFactory.eINSTANCE.createDuration()));

		newChildDescriptors
			.add(createChildParameter(UMLPackage.Literals.ACTIVITY_EDGE__WEIGHT,
				UMLFactory.eINSTANCE.createInterval()));

		newChildDescriptors
			.add(createChildParameter(UMLPackage.Literals.ACTIVITY_EDGE__WEIGHT,
				UMLFactory.eINSTANCE.createDurationInterval()));

		newChildDescriptors
			.add(createChildParameter(UMLPackage.Literals.ACTIVITY_EDGE__WEIGHT,
				UMLFactory.eINSTANCE.createLiteralBoolean()));

		newChildDescriptors
			.add(createChildParameter(UMLPackage.Literals.ACTIVITY_EDGE__WEIGHT,
				UMLFactory.eINSTANCE.createLiteralInteger()));

		newChildDescriptors
			.add(createChildParameter(UMLPackage.Literals.ACTIVITY_EDGE__WEIGHT,
				UMLFactory.eINSTANCE.createLiteralNull()));

		newChildDescriptors
			.add(createChildParameter(UMLPackage.Literals.ACTIVITY_EDGE__WEIGHT,
				UMLFactory.eINSTANCE.createLiteralReal()));

		newChildDescriptors
			.add(createChildParameter(UMLPackage.Literals.ACTIVITY_EDGE__WEIGHT,
				UMLFactory.eINSTANCE.createLiteralString()));

		newChildDescriptors
			.add(createChildParameter(UMLPackage.Literals.ACTIVITY_EDGE__WEIGHT,
				UMLFactory.eINSTANCE.createLiteralUnlimitedNatural()));

		newChildDescriptors
			.add(createChildParameter(UMLPackage.Literals.ACTIVITY_EDGE__WEIGHT,
				UMLFactory.eINSTANCE.createTimeInterval()));
	}

	/**
	 * This returns the label text for {@link org.eclipse.emf.edit.command.CreateChildCommand}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getCreateChildText(Object owner, Object feature, Object child,
			Collection<?> selection) {
		Object childFeature = feature;
		Object childObject = child;

		boolean qualify = childFeature == UMLPackage.Literals.NAMED_ELEMENT__NAME_EXPRESSION
			|| childFeature == UMLPackage.Literals.ACTIVITY_EDGE__GUARD
			|| childFeature == UMLPackage.Literals.ACTIVITY_EDGE__WEIGHT;

		if (qualify) {
			return getString("_UI_CreateChild_text2", //$NON-NLS-1$
				new Object[]{getTypeText(childObject),
					getFeatureText(childFeature), getTypeText(owner)});
		}
		return super.getCreateChildText(owner, feature, child, selection);
	}

}