/**
 * Copyright (c) 2006, 2009, 2013 Borland Software Corporation and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *    Dmitry Stadnik (Borland) - initial API and implementation
 *    Alexander Shatalin (Borland) - initial API and implementation
 *    Michael Golubev (Montages) - #386838 - migrate to Xtend2
 */
package aspects.diagram.editparts;

import com.google.common.base.Objects;
import com.google.common.collect.Iterators;
import com.google.inject.Singleton;
import org.eclipse.gmf.codegen.gmfgen.GenChildLabelNode;
import org.eclipse.papyrus.papyrusgmfgenextension.ExtendedGenView;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IteratorExtensions;

@Singleton
@SuppressWarnings("all")
public class ChildNodeLabelEditPart extends diagram.editparts.ChildNodeLabelEditPart {
  @Override
  public CharSequence extendsList(final GenChildLabelNode it) {
    StringConcatenation _builder = new StringConcatenation();
    {
      final Function1<ExtendedGenView, Boolean> _function = new Function1<ExtendedGenView, Boolean>() {
        @Override
        public Boolean apply(final ExtendedGenView v) {
          return Boolean.valueOf((v.getGenView().contains(it) && (!Objects.equal(v.getSuperOwnedEditPart(), null))));
        }
      };
      int _size = IteratorExtensions.size(IteratorExtensions.<ExtendedGenView>filter(Iterators.<ExtendedGenView>filter(it.eResource().getAllContents(), ExtendedGenView.class), _function));
      boolean _notEquals = (_size != 0);
      if (_notEquals) {
        _builder.append("extends ");
        {
          final Function1<ExtendedGenView, Boolean> _function_1 = new Function1<ExtendedGenView, Boolean>() {
            @Override
            public Boolean apply(final ExtendedGenView v) {
              return Boolean.valueOf((v.getGenView().contains(it) && (!Objects.equal(v.getSuperOwnedEditPart(), null))));
            }
          };
          Iterable<ExtendedGenView> _iterable = IteratorExtensions.<ExtendedGenView>toIterable(IteratorExtensions.<ExtendedGenView>filter(Iterators.<ExtendedGenView>filter(it.eResource().getAllContents(), ExtendedGenView.class), _function_1));
          for(final ExtendedGenView extendedObject : _iterable) {
            _builder.newLineIfNotEmpty();
            CharSequence _specifyInheritance = this.specifyInheritance(((ExtendedGenView) extendedObject));
            _builder.append(_specifyInheritance);
            _builder.newLineIfNotEmpty();
          }
        }
      } else {
        _builder.append("extends org.eclipse.gmf.runtime.diagram.ui.editparts.CompartmentEditPart");
        _builder.newLine();
      }
    }
    return _builder;
  }
  
  public CharSequence specifyInheritance(final ExtendedGenView it) {
    StringConcatenation _builder = new StringConcatenation();
    String _superOwnedEditPart = it.getSuperOwnedEditPart();
    _builder.append(_superOwnedEditPart);
    return _builder;
  }
  
  @Override
  public CharSequence implementsList(final GenChildLabelNode it) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("implements org.eclipse.gmf.runtime.diagram.ui.editparts.ITextAwareEditPart, org.eclipse.gmf.runtime.diagram.ui.editparts.IPrimaryEditPart, org.eclipse.papyrus.infra.gmfdiag.common.editpart.IControlParserForDirectEdit");
    return _builder;
  }
}
