/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.ui.lifecycleevents;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.papyrus.infra.ui.lifecycleevents.DoSaveEvent;
import org.eclipse.papyrus.infra.ui.lifecycleevents.ILifeCycleEventsProvider;
import org.eclipse.papyrus.infra.ui.lifecycleevents.ISaveEventListener;

public class LifeCycleEventsProvider
implements ILifeCycleEventsProvider {
    protected SaveEventListenerLazyList preSaveListeners = new SaveEventListenerLazyList();
    protected SaveEventListenerLazyList saveListeners = new SaveEventListenerLazyList();
    protected SaveEventListenerLazyList postSaveListeners = new SaveEventListenerLazyList();

    @Override
    public void addDoSaveListener(ISaveEventListener listener) {
        this.saveListeners.addListener(listener);
    }

    @Override
    public void removeDoSaveListener(ISaveEventListener listener) {
        this.saveListeners.removeListener(listener);
    }

    @Override
    public void addAboutToDoSaveListener(ISaveEventListener listener) {
        this.preSaveListeners.addListener(listener);
    }

    @Override
    public void removeAboutToDoSaveListener(ISaveEventListener listener) {
        this.preSaveListeners.removeListener(listener);
    }

    @Override
    public void addPostDoSaveListener(ISaveEventListener listener) {
        this.postSaveListeners.addListener(listener);
    }

    @Override
    public void removePostDoSaveListener(ISaveEventListener listener) {
        this.postSaveListeners.removeListener(listener);
    }

    public void fireAboutToDoSaveEvent(DoSaveEvent event) {
        this.preSaveListeners.fireSaveEvent(event);
    }

    public void fireAboutToDoSaveAsEvent(DoSaveEvent event) {
        this.preSaveListeners.fireSaveAsEvent(event);
    }

    public void fireDoSaveEvent(DoSaveEvent event) {
        this.saveListeners.fireSaveEvent(event);
    }

    public void fireDoSaveAsEvent(DoSaveEvent event) {
        this.saveListeners.fireSaveAsEvent(event);
    }

    public void firePostDoSaveEvent(DoSaveEvent event) {
        this.postSaveListeners.fireSaveEvent(event);
    }

    public void firePostDoSaveAsEvent(DoSaveEvent event) {
        this.postSaveListeners.fireSaveAsEvent(event);
    }

    public void fireAllDoSaveEvent(DoSaveEvent event) {
        this.fireAboutToDoSaveEvent(event);
        this.fireDoSaveEvent(event);
        this.firePostDoSaveEvent(event);
    }

    public void fireAllDoSaveAsEvent(DoSaveEvent event) {
        this.fireAboutToDoSaveAsEvent(event);
        this.fireDoSaveAsEvent(event);
        this.firePostDoSaveAsEvent(event);
    }

    protected abstract class AbstractEventListenersLazyList<T> {
        List<T> listeners;

        protected AbstractEventListenersLazyList() {
        }

        public void addListener(T listener) {
            if (this.listeners == null) {
                this.listeners = new ArrayList<T>();
            }
            if (this.listeners.contains(listener)) {
                return;
            }
            this.listeners.add(listener);
        }

        public void removeListener(T listener) {
            if (this.listeners == null) {
                return;
            }
            this.listeners.remove(listener);
        }

        protected List<T> getListeners() {
            return this.listeners;
        }

        protected void clear() {
            if (this.listeners != null) {
                this.listeners.clear();
            }
        }
    }

    protected class SaveEventListenerLazyList
    extends AbstractEventListenersLazyList<ISaveEventListener> {
        protected SaveEventListenerLazyList() {
        }

        public void fireSaveEvent(DoSaveEvent event) {
            if (this.listeners == null) {
                return;
            }
            for (ISaveEventListener listener : this.listeners) {
                listener.doSave(event);
            }
        }

        public void fireSaveAsEvent(DoSaveEvent event) {
            if (this.listeners == null) {
                return;
            }
            for (ISaveEventListener listener : this.listeners) {
                listener.doSaveAs(event);
            }
        }
    }
}

