/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.statemachine.custom.parsers;

import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.papyrus.infra.gmfdiag.common.model.NotationUtils;
import org.eclipse.papyrus.uml.diagram.statemachine.part.UMLDiagramEditorPlugin;
import org.eclipse.papyrus.uml.tools.utils.OpaqueBehaviorUtil;
import org.eclipse.papyrus.uml.tools.utils.OpaqueExpressionUtil;
import org.eclipse.uml2.uml.OpaqueBehavior;
import org.eclipse.uml2.uml.OpaqueExpression;

public class OpaqueBehaviorViewUtil {
    public static final String DOTS = "...";
    public static final String PARAM_DOTS = "(...)";
    public static final String EMPTY_STRING = "";

    public static String cutBodyString(View view, String body) {
        int prefCutLength;
        IPreferenceStore preferenceStore = UMLDiagramEditorPlugin.getInstance().getPreferenceStore();
        int cutLength = prefCutLength = preferenceStore.getInt("bodyCutLength");
        if (view != null) {
            cutLength = NotationUtils.getIntValue((View)view, (String)"bodyCutLength", (int)prefCutLength);
        }
        if (cutLength == 0) {
            return DOTS;
        }
        int start = 0;
        int newStart = 0;
        while (cutLength > 0) {
            newStart = body.indexOf("\n", start);
            if (newStart > 0) {
                --cutLength;
                start = newStart + 1;
                continue;
            }
            return body;
        }
        if (newStart > 0) {
            if (newStart >= 1 && body.charAt(newStart - 1) == '\r') {
                return String.valueOf(body.substring(0, start - 1)) + DOTS;
            }
            return String.valueOf(body.substring(0, newStart)) + DOTS;
        }
        return body;
    }

    public static String retrieveBody(View view, OpaqueBehavior ob) {
        String body = OpaqueBehaviorUtil.getBody((OpaqueBehavior)ob, (String)"Natural Language");
        if (body.equals(EMPTY_STRING) && ob.getBodies().size() > 0) {
            body = (String)ob.getBodies().get(0);
        }
        return OpaqueBehaviorViewUtil.cutBodyString(view, body);
    }

    public static String retrieveBody(View view, OpaqueExpression exp) {
        String body = OpaqueExpressionUtil.getBodyForLanguage((OpaqueExpression)exp, (String)"Natural Language");
        if (body.equals(EMPTY_STRING)) {
            body = OpaqueExpressionUtil.getBodyForLanguage((OpaqueExpression)exp, null);
        }
        return OpaqueBehaviorViewUtil.cutBodyString(view, body);
    }

    public static boolean displayParamDots(View view) {
        IPreferenceStore preferenceStore = UMLDiagramEditorPlugin.getInstance().getPreferenceStore();
        boolean prefValue = preferenceStore.getBoolean("indicateParameters");
        return NotationUtils.getBooleanValue((View)view, (String)"indicateParameters", (boolean)prefValue);
    }
}

