/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.sequence.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.commands.SetBoundsCommand;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramRootEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ShapeNodeEditPart;
import org.eclipse.gmf.runtime.diagram.ui.l10n.DiagramUIMessages;
import org.eclipse.gmf.runtime.emf.core.util.EObjectAdapter;
import org.eclipse.gmf.runtime.gef.ui.figures.NodeFigure;
import org.eclipse.gmf.runtime.notation.Bounds;
import org.eclipse.gmf.runtime.notation.DecorationNode;
import org.eclipse.gmf.runtime.notation.Shape;
import org.eclipse.gmf.runtime.notation.impl.ShapeImpl;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.BehaviorExecutionSpecificationEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.CCombinedCompartmentEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.CLifeLineEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.LifelineEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.MessageCreateEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.MessageDeleteEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.figures.LifelineDotLineCustomFigure;
import org.eclipse.papyrus.uml.diagram.sequence.referencialgrilling.GridManagementEditPolicy;
import org.eclipse.papyrus.uml.diagram.sequence.util.LifelineMessageCreateHelper;
import org.eclipse.papyrus.uml.diagram.sequence.util.LifelineMessageDeleteHelper;
import org.eclipse.uml2.uml.Lifeline;
import org.eclipse.uml2.uml.MessageEnd;

public class LifelineEditPartUtil {
    private LifelineEditPartUtil() {
    }

    public static List<ShapeNodeEditPart> getChildShapeNodeEditPart(LifelineEditPart lifeline) {
        if (lifeline == null) {
            return Collections.emptyList();
        }
        ArrayList<ShapeNodeEditPart> executionSpecificationList = new ArrayList<ShapeNodeEditPart>();
        for (Object obj : lifeline.getChildren()) {
            if (obj instanceof BehaviorExecutionSpecificationEditPart) {
                executionSpecificationList.add((ShapeNodeEditPart)obj);
                continue;
            }
            if (!(obj instanceof CCombinedCompartmentEditPart)) continue;
            executionSpecificationList.add((ShapeNodeEditPart)obj);
        }
        return executionSpecificationList;
    }

    public static List<LifelineEditPart> getInnerConnectableElementList(LifelineEditPart lifeline) {
        if (lifeline == null) {
            return Collections.emptyList();
        }
        ArrayList<LifelineEditPart> propertyList = new ArrayList<LifelineEditPart>();
        for (Object obj : lifeline.getChildren()) {
            if (!(obj instanceof LifelineEditPart)) continue;
            propertyList.add((LifelineEditPart)((Object)obj));
        }
        return propertyList;
    }

    public static NodeFigure getNodeFigure(LifelineEditPart lifelineEditPart) {
        if (lifelineEditPart == null) {
            return null;
        }
        IFigure contentPane = lifelineEditPart.getContentPane();
        if (contentPane instanceof LifelineDotLineCustomFigure) {
            return ((LifelineDotLineCustomFigure)contentPane).getDashLineRectangle();
        }
        return null;
    }

    public static Command getRestoreLifelinePositionOnMessageCreateRemovedCommand(ConnectionEditPart editPart) {
        ShapeImpl view;
        LifelineEditPart target;
        MessageCreateEditPart part;
        ICommandProxy commands = null;
        if (editPart instanceof MessageCreateEditPart && (part = (MessageCreateEditPart)editPart).getTarget() instanceof LifelineEditPart && LifelineMessageCreateHelper.hasIncomingMessageCreate(part.getTarget()) && (target = (LifelineEditPart)part.getTarget()).getModel() instanceof Shape && (view = (ShapeImpl)target.getModel()).getLayoutConstraint() instanceof Bounds) {
            Bounds bounds = (Bounds)view.getLayoutConstraint();
            Point newLocation = new Point(bounds.getX(), 10);
            Dimension newDimension = new Dimension(bounds.getWidth(), bounds.getHeight() + (bounds.getY() - 10));
            Rectangle newBounds = new Rectangle(newLocation, newDimension);
            SetBoundsCommand boundsCommand = new SetBoundsCommand(target.getEditingDomain(), DiagramUIMessages.SetLocationCommand_Label_Resize, (IAdaptable)new EObjectAdapter((EObject)view), newBounds);
            commands = new ICommandProxy((ICommand)boundsCommand);
        }
        return commands;
    }

    public static Command getRestoreLifelinePositionOnMessageDeleteRemovedCommand(ConnectionEditPart editPart) {
        ShapeImpl view;
        LifelineEditPart target;
        MessageDeleteEditPart part;
        ICommandProxy commands = null;
        if (editPart instanceof MessageDeleteEditPart && (part = (MessageDeleteEditPart)editPart).getTarget() instanceof LifelineEditPart && LifelineMessageDeleteHelper.hasIncomingMessageDelete(part.getTarget()) && (target = (LifelineEditPart)part.getTarget()).getModel() instanceof Shape && (view = (ShapeImpl)target.getModel()).getLayoutConstraint() instanceof Bounds) {
            Bounds bounds = (Bounds)view.getLayoutConstraint();
            Point newLocation = new Point(bounds.getX(), bounds.getY());
            Dimension newDimension = new Dimension(bounds.getWidth(), CLifeLineEditPart.DEFAUT_HEIGHT - bounds.getY());
            Rectangle newBounds = new Rectangle(newLocation, newDimension);
            SetBoundsCommand boundsCommand = new SetBoundsCommand(target.getEditingDomain(), DiagramUIMessages.SetLocationCommand_Label_Resize, (IAdaptable)new EObjectAdapter((EObject)view), newBounds);
            commands = new ICommandProxy((ICommand)boundsCommand);
        }
        return commands;
    }

    public static List<MessageEnd> getPreviousEventsFromPosition(Point position, LifelineEditPart lifelineEditPart) {
        ArrayList<MessageEnd> previous = new ArrayList<MessageEnd>();
        DiagramEditPart diagramEditPart = LifelineEditPartUtil.getDiagramEditPart((EditPart)lifelineEditPart);
        Lifeline lifeline = (Lifeline)lifelineEditPart.resolveSemanticElement();
        try {
            GridManagementEditPolicy grilling = (GridManagementEditPolicy)diagramEditPart.getEditPolicy((Object)GridManagementEditPolicy.GRID_MANAGEMENT);
            if (grilling != null) {
                for (DecorationNode row : grilling.rows) {
                    EObject referedElement;
                    Point currentPoint = GridManagementEditPolicy.getLocation(row);
                    if (currentPoint.y >= position.y || row.getElement() == null || !((referedElement = row.getElement()) instanceof MessageEnd) || !lifeline.getCoveredBys().contains((Object)referedElement)) continue;
                    previous.add((MessageEnd)referedElement);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return previous;
    }

    public static boolean hasPreviousEvent(Point position, LifelineEditPart lifelineEditPart) {
        return !LifelineEditPartUtil.getPreviousEventsFromPosition(position, lifelineEditPart).isEmpty();
    }

    public static boolean hasNextEvent(Point position, LifelineEditPart lifelineEditPart) {
        return !LifelineEditPartUtil.getNextEventsFromPosition(position, lifelineEditPart).isEmpty();
    }

    public static List<MessageEnd> getNextEventsFromPosition(Point position, LifelineEditPart lifelineEditPart) {
        ArrayList<MessageEnd> previous = new ArrayList<MessageEnd>();
        DiagramEditPart diagramEditPart = LifelineEditPartUtil.getDiagramEditPart((EditPart)lifelineEditPart);
        Lifeline lifeline = (Lifeline)lifelineEditPart.resolveSemanticElement();
        try {
            GridManagementEditPolicy grilling = (GridManagementEditPolicy)diagramEditPart.getEditPolicy((Object)GridManagementEditPolicy.GRID_MANAGEMENT);
            if (grilling != null) {
                for (DecorationNode row : grilling.rows) {
                    EObject referedElement;
                    Point currentPoint = GridManagementEditPolicy.getLocation(row);
                    if (currentPoint.y <= position.y || row.getElement() == null || !((referedElement = row.getElement()) instanceof MessageEnd) || !lifeline.getCoveredBys().contains((Object)referedElement)) continue;
                    previous.add((MessageEnd)referedElement);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return previous;
    }

    public static DiagramEditPart getDiagramEditPart(EditPart editPart) {
        while (editPart instanceof IGraphicalEditPart) {
            if (editPart instanceof DiagramEditPart) {
                return (DiagramEditPart)editPart;
            }
            editPart = editPart.getParent();
        }
        if (editPart instanceof DiagramRootEditPart) {
            return (DiagramEditPart)((DiagramRootEditPart)editPart).getChildren().get(0);
        }
        return null;
    }
}

