/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.emf.nattable.manager.cell;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.common.core.command.UnexecutableCommand;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.DestroyElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.SetRequest;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.papyrus.infra.emf.gmf.command.GMFtoEMFCommandWrapper;
import org.eclipse.papyrus.infra.nattable.command.ErrorTransactionalCommand;
import org.eclipse.papyrus.infra.nattable.manager.cell.AbstractCellManager;
import org.eclipse.papyrus.infra.nattable.manager.table.INattableModelManager;
import org.eclipse.papyrus.infra.nattable.paste.ReferenceValueSetter;
import org.eclipse.papyrus.infra.nattable.utils.AxisUtils;
import org.eclipse.papyrus.infra.nattable.utils.CellHelper;
import org.eclipse.papyrus.infra.services.edit.service.ElementEditServiceUtils;
import org.eclipse.papyrus.infra.services.edit.service.IElementEditService;
import org.eclipse.papyrus.infra.ui.converter.AbstractStringValueConverter;
import org.eclipse.papyrus.infra.ui.converter.ConvertedValueContainer;
import org.eclipse.papyrus.infra.ui.converter.EMFStringValueConverter;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class EMFFeatureValueCellManager
extends AbstractCellManager {
    public boolean handles(Object columnElement, Object rowElement, INattableModelManager tableManager) {
        return this.organizeAndResolvedObjects(columnElement, rowElement, null) != null;
    }

    protected Object doGetValue(Object columnElement, Object rowElement, INattableModelManager tableManager) {
        List<Object> objects = this.organizeAndResolvedObjects(columnElement, rowElement, null);
        EObject eobject = (EObject)objects.get(0);
        EStructuralFeature feature = (EStructuralFeature)objects.get(1);
        if (eobject.eClass().getEAllStructuralFeatures().contains((Object)feature)) {
            return eobject.eGet(feature);
        }
        return CellHelper.getUnsupportedCellContentsText();
    }

    protected List<Object> organizeAndResolvedObjects(Object columnElement, Object rowElement, Map<?, ?> sharedMap) {
        ArrayList<Object> objects = null;
        Object row = AxisUtils.getRepresentedElement((Object)rowElement);
        Object column = AxisUtils.getRepresentedElement((Object)columnElement);
        if (row instanceof EObject && column instanceof EStructuralFeature) {
            objects = new ArrayList<Object>();
            objects.add(row);
            objects.add(column);
        } else if (column instanceof EObject && row instanceof EStructuralFeature) {
            objects = new ArrayList();
            objects.add(column);
            objects.add(row);
        }
        return objects;
    }

    public boolean isCellEditable(Object columnElement, Object rowElement, INattableModelManager tableManager) {
        List<Object> objects = this.organizeAndResolvedObjects(columnElement, rowElement, null);
        EObject object = (EObject)objects.get(0);
        EStructuralFeature feature = (EStructuralFeature)objects.get(1);
        if (object.eClass().getEAllStructuralFeatures().contains((Object)feature) && !feature.isDerived()) {
            return feature.isChangeable();
        }
        return false;
    }

    public Command getSetValueCommand(TransactionalEditingDomain domain, Object columnElement, Object rowElement, Object newValue, INattableModelManager tableManager) {
        List<Object> objects = this.organizeAndResolvedObjects(columnElement, rowElement, null);
        return this.getSetValueCommand(domain, (EObject)objects.get(0), (EStructuralFeature)objects.get(1), newValue, columnElement, rowElement, tableManager);
    }

    protected Command getSetValueCommand(TransactionalEditingDomain domain, EObject elementToEdit, EStructuralFeature featureToEdit, Object newValue, Object columnElement, Object rowElement, INattableModelManager tableManager) {
        CompositeCommand result = new CompositeCommand("Set Value Command");
        Object currentValue = elementToEdit.eGet(featureToEdit);
        if (newValue == null && currentValue != null || newValue != null && !newValue.equals(currentValue)) {
            SetRequest request = new SetRequest(domain, elementToEdit, featureToEdit, newValue);
            IElementEditService provider = ElementEditServiceUtils.getCommandProvider((EObject)elementToEdit);
            ICommand cmd = provider.getEditCommand((IEditCommandRequest)request);
            if (cmd != null) {
                ICommand returnedCommand = cmd;
                if (cmd.canExecute() && featureToEdit instanceof EReference) {
                    boolean shouldOpenDialog = false;
                    EReference editedReference = (EReference)featureToEdit;
                    if (editedReference.isContainment()) {
                        if (newValue instanceof Collection) {
                            if (!editedReference.isMany()) {
                                return org.eclipse.emf.common.command.UnexecutableCommand.INSTANCE;
                            }
                            ArrayList currentValues = new ArrayList((Collection)elementToEdit.eGet((EStructuralFeature)editedReference));
                            ArrayList addedValues = new ArrayList((Collection)newValue);
                            addedValues.removeAll(currentValues);
                            Iterator iter = addedValues.iterator();
                            while (iter.hasNext() && !shouldOpenDialog) {
                                Object current = iter.next();
                                if (!(current instanceof EObject)) continue;
                                if (elementToEdit == current) {
                                    return org.eclipse.emf.common.command.UnexecutableCommand.INSTANCE;
                                }
                                boolean bl = shouldOpenDialog = ((EObject)current).eContainer() != elementToEdit;
                            }
                        } else {
                            if (elementToEdit == newValue) {
                                return org.eclipse.emf.common.command.UnexecutableCommand.INSTANCE;
                            }
                            if (newValue instanceof EObject) {
                                boolean bl = shouldOpenDialog = ((EObject)newValue).eContainer() != elementToEdit;
                            }
                        }
                        if (shouldOpenDialog) {
                            returnedCommand = this.getOpenConfirmChangeContainmentDialogCommand(domain, returnedCommand, editedReference.isMany());
                        }
                    }
                }
                result.add((IUndoableOperation)returnedCommand);
            } else {
                result.add((IUndoableOperation)UnexecutableCommand.INSTANCE);
            }
        }
        return result.isEmpty() ? null : new GMFtoEMFCommandWrapper((ICommand)result);
    }

    protected final ICommand getOpenConfirmChangeContainmentDialogCommand(TransactionalEditingDomain domain, final ICommand defaultCommand, boolean isMany) {
        final String messageDialog = isMany ? "Your are setting a value in a containment feature. This action will change the owner of the dropped element(s).\nContinue?" : "Your are setting a value in a containment feature. The previous value will be erased and the owner of the dropped element(s) will be changed.\nContinue?";
        AbstractTransactionalCommand cmd = new AbstractTransactionalCommand(domain, "Set Value Command Dialog", null){

            protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                boolean result = MessageDialog.openConfirm((Shell)Display.getDefault().getActiveShell(), (String)"Set Containment Value", (String)messageDialog);
                if (result) {
                    defaultCommand.execute(monitor, info);
                    return CommandResult.newOKCommandResult();
                }
                return CommandResult.newCancelledCommandResult();
            }
        };
        return cmd;
    }

    public Command getSetStringValueCommand(TransactionalEditingDomain domain, Object columnElement, Object rowElement, String newValue, AbstractStringValueConverter valueSolver, INattableModelManager tableManager) {
        ConvertedValueContainer solvedValue;
        Object convertedValue;
        EStructuralFeature editedFeature;
        List<Object> objects = this.organizeAndResolvedObjects(columnElement, rowElement, null);
        EObject editedObject = (EObject)objects.get(0);
        Command setValueCommand = this.getSetValueCommand(domain, editedObject, editedFeature = (EStructuralFeature)objects.get(1), convertedValue = (solvedValue = valueSolver.deduceValueFromString((Object)editedFeature, newValue)).getConvertedValue(), columnElement, rowElement, tableManager);
        if (setValueCommand != null && !solvedValue.getStatus().isOK()) {
            setValueCommand = new GMFtoEMFCommandWrapper((ICommand)new ErrorTransactionalCommand(domain, null, null, solvedValue.getStatus()));
        }
        return setValueCommand;
    }

    @Deprecated
    protected Command getCreateStringResolutionProblemCommand(TransactionalEditingDomain domain, INattableModelManager tableManager, Object columnElement, Object rowElement, String pastedText, ConvertedValueContainer<?> valueContainer) {
        return CellHelper.getCreateStringResolutionProblemCommand((TransactionalEditingDomain)domain, (INattableModelManager)tableManager, (Object)columnElement, (Object)rowElement, (String)pastedText, valueContainer);
    }

    public AbstractStringValueConverter getOrCreateStringValueConverterClass(Map<Class<? extends AbstractStringValueConverter>, AbstractStringValueConverter> existingConverters, String multiValueSeparator, INattableModelManager tableManager) {
        AbstractStringValueConverter converter = existingConverters.get(EMFStringValueConverter.class);
        if (converter == null) {
            converter = new EMFStringValueConverter(tableManager.getTable().getContext(), multiValueSeparator);
            existingConverters.put(EMFStringValueConverter.class, converter);
        }
        return converter;
    }

    public void setValue(TransactionalEditingDomain domain, Object columnElement, Object rowElement, Object newValue, INattableModelManager tableManager) {
        if (domain == null) {
            List<Object> objects = this.organizeAndResolvedObjects(columnElement, rowElement, null);
            EObject elementToEdit = (EObject)objects.get(0);
            EStructuralFeature editedFeature = (EStructuralFeature)objects.get(1);
            elementToEdit.eSet(editedFeature, newValue);
        } else {
            super.setValue(domain, columnElement, rowElement, newValue, tableManager);
        }
    }

    @Deprecated
    protected void createStringResolutionProblem(INattableModelManager tableManager, Object columnElement, Object rowElement, String pastedText, ConvertedValueContainer<?> valueContainer, Map<?, ?> sharedMap) {
        CellHelper.createStringResolutionProblem((INattableModelManager)tableManager, (Object)columnElement, (Object)rowElement, (String)pastedText, valueContainer, sharedMap);
    }

    public void setStringValue(Object columnElement, Object rowElement, String valueAsString, AbstractStringValueConverter valueConverter, Map<?, ?> sharedMap, INattableModelManager tableManager) {
        List<Object> objects = this.organizeAndResolvedObjects(columnElement, rowElement, sharedMap);
        EObject editedObject = (EObject)objects.get(0);
        EStructuralFeature editedFeature = (EStructuralFeature)objects.get(1);
        ConvertedValueContainer solvedValue = valueConverter.deduceValueFromString((Object)editedFeature, valueAsString);
        if (editedFeature instanceof EReference) {
            List references = (List)sharedMap.get("referencesToSet");
            ReferenceValueSetter structure = new ReferenceValueSetter(editedObject, (EReference)editedFeature, solvedValue.getConvertedValue());
            references.add(structure);
        } else {
            editedObject.eSet(editedFeature, solvedValue.getConvertedValue());
        }
    }

    public void unsetCellValue(TransactionalEditingDomain domain, Object columnElement, Object rowElement, INattableModelManager tableManager) {
        Command cmd = this.getUnsetCellValueCommand(domain, columnElement, rowElement, tableManager);
        if (cmd != null && cmd.canExecute()) {
            domain.getCommandStack().execute(cmd);
        }
    }

    public Command getUnsetCellValueCommand(TransactionalEditingDomain domain, Object columnElement, Object rowElement, INattableModelManager tableManager) {
        if (this.isCellEditable(columnElement, rowElement, tableManager)) {
            List<Object> objects = this.organizeAndResolvedObjects(columnElement, rowElement, null);
            EObject elementToEdit = (EObject)objects.get(0);
            EStructuralFeature editedFeature = (EStructuralFeature)objects.get(1);
            return this.doGetUnsetCellValueCommand(domain, elementToEdit, editedFeature, tableManager);
        }
        return null;
    }

    protected Command doGetUnsetCellValueCommand(TransactionalEditingDomain domain, EObject elementToEdit, EStructuralFeature editedFeature, INattableModelManager tableManager) {
        ICommand setDefaultValueCommand;
        IElementEditService provider = ElementEditServiceUtils.getCommandProvider((EObject)elementToEdit);
        CompositeCommand cc = new CompositeCommand("Unset cell value");
        if (editedFeature.isMany()) {
            if (editedFeature instanceof EReference && ((EReference)editedFeature).isContainment()) {
                for (Object current : (Collection)elementToEdit.eGet(editedFeature)) {
                    DestroyElementRequest request;
                    ICommand command;
                    if (!(current instanceof EObject) || (command = provider.getEditCommand((IEditCommandRequest)(request = new DestroyElementRequest(domain, (EObject)current, false)))) == null || !command.canExecute()) continue;
                    cc.add((IUndoableOperation)command);
                }
            } else {
                SetRequest request = new SetRequest(domain, elementToEdit, editedFeature, Collections.emptyList());
                ICommand command = provider.getEditCommand((IEditCommandRequest)request);
                if (command != null && command.canExecute()) {
                    cc.add((IUndoableOperation)command);
                }
            }
        }
        if ((setDefaultValueCommand = this.getSetDefaultValueCommand(domain, elementToEdit, editedFeature)) != null && setDefaultValueCommand.canExecute()) {
            cc.add((IUndoableOperation)setDefaultValueCommand);
        }
        if (!cc.isEmpty() && cc.canExecute()) {
            return new GMFtoEMFCommandWrapper((ICommand)cc);
        }
        return null;
    }

    protected final ICommand getSetDefaultValueCommand(TransactionalEditingDomain domain, EObject elementToEdit, EStructuralFeature editedFeature) {
        SetRequest setRequest;
        IElementEditService provider = ElementEditServiceUtils.getCommandProvider((EObject)elementToEdit);
        Object defaultValue = editedFeature.getDefaultValue();
        String defaultLiteralValue = editedFeature.getDefaultValueLiteral();
        ICommand cmd = null;
        if (defaultValue != null) {
            setRequest = new SetRequest(domain, elementToEdit, editedFeature, defaultValue);
            cmd = provider.getEditCommand((IEditCommandRequest)setRequest);
        }
        if (cmd == null || !cmd.canExecute()) {
            setRequest = new SetRequest(domain, elementToEdit, editedFeature, (Object)defaultLiteralValue);
            cmd = provider.getEditCommand((IEditCommandRequest)setRequest);
        }
        return cmd;
    }
}

