/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.emf.nattable.filter.configuration;

import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.matchers.MatcherEditor;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.nebula.widgets.nattable.config.CellConfigAttributes;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.data.IColumnAccessor;
import org.eclipse.nebula.widgets.nattable.data.convert.DisplayConverter;
import org.eclipse.nebula.widgets.nattable.edit.EditConfigAttributes;
import org.eclipse.nebula.widgets.nattable.edit.editor.IComboBoxDataProvider;
import org.eclipse.nebula.widgets.nattable.filterrow.combobox.FilterRowComboBoxCellEditor;
import org.eclipse.papyrus.infra.emf.nattable.filter.configuration.EReferenceFilterComboBoxDataProvider;
import org.eclipse.papyrus.infra.nattable.filter.IPapyrusMatcherEditorFactory;
import org.eclipse.papyrus.infra.nattable.filter.ObjectMatcherEditor;
import org.eclipse.papyrus.infra.nattable.filter.configuration.IFilterConfiguration;
import org.eclipse.papyrus.infra.nattable.utils.AxisUtils;
import org.eclipse.papyrus.infra.nattable.utils.NattableConfigAttributes;

public class EReferenceFilterRowComboBoxCellEditorConfiguration
implements IFilterConfiguration {
    private static final String ID = "org.eclipse.papyrus.infra.emf.nattable.ereference.checkboxcombo";

    public boolean handles(IConfigRegistry registry, Object columnElement) {
        Object representedElement = AxisUtils.getRepresentedElement((Object)columnElement);
        return representedElement instanceof EReference;
    }

    public void configureFilter(IConfigRegistry configRegistry, Object columnElement, String configLabel) {
        EReferenceFilterComboBoxDataProvider dataProvider = new EReferenceFilterComboBoxDataProvider(configRegistry, columnElement);
        FilterRowComboBoxCellEditor editor = new FilterRowComboBoxCellEditor((IComboBoxDataProvider)dataProvider);
        configRegistry.registerConfigAttribute(EditConfigAttributes.CELL_EDITOR, (Object)editor, "NORMAL", configLabel);
        DisplayConverter converter = (DisplayConverter)configRegistry.getConfigAttribute(NattableConfigAttributes.OBJECT_NAME_AND_PATH_DISPLAY_CONVERTER, "NORMAL", new String[]{"object_name_and_path_display_converter_id"});
        configRegistry.registerConfigAttribute(CellConfigAttributes.DISPLAY_CONVERTER, (Object)converter, "NORMAL", configLabel);
        IPapyrusMatcherEditorFactory<Object> factory = new IPapyrusMatcherEditorFactory<Object>(){

            public EventList<MatcherEditor<Object>> instantiateMatcherEditors(IColumnAccessor<Object> columnAccessor, Integer columnIndex, Object wantedValue, IConfigRegistry configRegistry) {
                BasicEventList list = new BasicEventList();
                list.add((Object)new ObjectMatcherEditor(columnAccessor, columnIndex.intValue(), wantedValue, configRegistry));
                return list;
            }
        };
        configRegistry.registerConfigAttribute(NattableConfigAttributes.MATCHER_EDITOR_FACTORY, (Object)factory, "NORMAL", configLabel);
    }

    public String getConfigurationId() {
        return ID;
    }

    public String getConfigurationDescription() {
        return "This configuration provides a combo with checkbox to filter EReference";
    }
}

