/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.toolsmiths.profilemigration.ui.dialogs;

import org.eclipse.osgi.util.NLS;
import org.eclipse.papyrus.toolsmiths.profilemigration.ui.Messages;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.FormDialog;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;

public class ProfileMigrationToolConfigurationDialog
extends FormDialog {
    public static final int SKIP = 3;
    protected Button selectTargetDirectoryButton;
    protected Text selectedPathText;
    protected String filePath = "";
    protected String profileName;
    protected String fileExtension = "*.profile.uml";
    protected static final String IMPORT_FILE_BUTTON_NAME = Messages.ProfileMigrationToolConfigurationDialog_ImportButtonName;
    protected static final String IMPORT_FILE_BUTTON_TOOLTIP = Messages.ProfileMigrationToolConfigurationDialog_ImportButtonTooltip;
    protected static final String SKIP_BUTTON_NAME = Messages.ProfileMigrationToolConfigurationDialog_SkipButtonName;
    protected static final String SKIP_BUTTON_TOOLTIP = Messages.ProfileMigrationToolConfigurationDialog_SkipButtonTooltip;
    protected static final String DIALOG_TITLE = Messages.ProfileMigrationToolConfigurationDialog_Title;
    protected static final String FILE_SELECTION_SECTION_TITLE = Messages.ProfileMigrationToolConfigurationDialog_FileSelectionSelectionTitle;
    protected static final String FILE_SELECTION_SECTION_DESCRIPTION = Messages.ProfileMigrationToolConfigurationDialog_FileSelectionSelectionDescription;
    private static final String EMPTY_STRING = "";

    public ProfileMigrationToolConfigurationDialog(Shell parentShell, String profileName) {
        super(parentShell);
        this.profileName = profileName;
    }

    protected Control createButtonBar(Composite parent) {
        Control control = super.createButtonBar(parent);
        this.getButton(0).setEnabled(false);
        return control;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        Button button = this.createButton(parent, 5, SKIP_BUTTON_NAME, true);
        button.setToolTipText(SKIP_BUTTON_TOOLTIP);
        super.createButtonsForButtonBar(parent);
    }

    protected void createFormContent(IManagedForm mform) {
        mform.getForm().setText(DIALOG_TITLE);
        ScrolledForm scrolledForm = mform.getForm();
        FormToolkit toolkit = mform.getToolkit();
        Composite parent = scrolledForm.getBody();
        parent.setLayout((Layout)new GridLayout());
        this.createSelectionFileSection(scrolledForm.getBody(), toolkit);
    }

    protected void buttonPressed(int buttonId) {
        super.buttonPressed(buttonId);
        if (buttonId == 5) {
            this.skipPress();
        }
    }

    private void createSelectionFileSection(Composite body, FormToolkit toolkit) {
        String lSectionTitle = FILE_SELECTION_SECTION_TITLE;
        Section lSection = toolkit.createSection(body, 320);
        lSection.setLayoutData((Object)new GridData(1040));
        if (lSectionTitle != null) {
            lSection.setText(lSectionTitle);
        }
        ScrolledForm lInsideScrolledForm = toolkit.createScrolledForm((Composite)lSection);
        lInsideScrolledForm.setExpandHorizontal(true);
        lInsideScrolledForm.setExpandVertical(true);
        Composite lBody = lInsideScrolledForm.getBody();
        GridLayout lLayout = new GridLayout();
        lLayout.numColumns = 1;
        lBody.setLayout((Layout)lLayout);
        toolkit.createLabel(lBody, NLS.bind((String)FILE_SELECTION_SECTION_DESCRIPTION, (Object)this.profileName), 64);
        lSection.setClient((Control)lInsideScrolledForm);
        this.createSelectDir(lBody, toolkit);
    }

    private void createSelectDir(final Composite container, FormToolkit toolkit) {
        Composite composite = new Composite(container, 0);
        composite.setLayoutData((Object)new GridData(4, 0, true, true));
        composite.setBackground(container.getBackground());
        GridLayout layout = new GridLayout(2, false);
        composite.setLayout((Layout)layout);
        this.selectTargetDirectoryButton = new Button(composite, 8);
        this.selectTargetDirectoryButton.setText(IMPORT_FILE_BUTTON_NAME);
        this.selectTargetDirectoryButton.setToolTipText(IMPORT_FILE_BUTTON_TOOLTIP);
        this.selectTargetDirectoryButton.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.selectedPathText = new Text(composite, 2056);
        this.selectedPathText.setText(EMPTY_STRING);
        this.selectedPathText.setLayoutData((Object)new GridData(4, 0x1000000, true, true));
        this.selectTargetDirectoryButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Shell shell = container.getShell();
                FileDialog fileDialog = new FileDialog(shell, 0);
                fileDialog.setText(Messages.ProfileMigrationToolConfigurationDialog_FileSelection);
                if (ProfileMigrationToolConfigurationDialog.this.fileExtension != null && !ProfileMigrationToolConfigurationDialog.this.fileExtension.isEmpty()) {
                    fileDialog.setFilterExtensions(new String[]{ProfileMigrationToolConfigurationDialog.this.fileExtension, "*"});
                }
                String filePath = null;
                filePath = fileDialog.open();
                if (filePath != null) {
                    ProfileMigrationToolConfigurationDialog.this.selectedPathText.setText(filePath);
                    ProfileMigrationToolConfigurationDialog.this.filePath = filePath;
                }
                ProfileMigrationToolConfigurationDialog.this.checkInformation();
            }
        });
    }

    public String getFilePath() {
        return this.filePath;
    }

    protected void skipPress() {
        this.setReturnCode(3);
        this.close();
    }

    private boolean checkInformation() {
        boolean validSelectedDirectory;
        String text = this.selectedPathText.getText();
        boolean bl = validSelectedDirectory = text != null && text != EMPTY_STRING;
        if (validSelectedDirectory) {
            this.getButton(0).setEnabled(validSelectedDirectory);
        } else {
            this.getButton(0).setEnabled(validSelectedDirectory);
        }
        return validSelectedDirectory;
    }
}

