/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.toolsmiths.validation.properties.internal.quickfix;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.command.RemoveCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.osgi.util.NLS;
import org.eclipse.papyrus.customization.properties.generation.extensionpoint.LayoutExtensionPoint;
import org.eclipse.papyrus.customization.properties.generation.layout.ILayoutGenerator;
import org.eclipse.papyrus.infra.properties.contexts.Context;
import org.eclipse.papyrus.infra.properties.contexts.ContextsPackage;
import org.eclipse.papyrus.infra.properties.contexts.DataContextElement;
import org.eclipse.papyrus.infra.properties.contexts.DataContextPackage;
import org.eclipse.papyrus.infra.properties.contexts.View;
import org.eclipse.papyrus.infra.properties.contexts.command.ContextDeleteCommand;
import org.eclipse.papyrus.toolsmiths.validation.properties.internal.constants.PropertiesPluginValidationConstants;
import org.eclipse.papyrus.toolsmiths.validation.properties.internal.messages.Messages;
import org.eclipse.papyrus.toolsmiths.validation.properties.internal.quickfix.AbstractModelEditResolutionFactory;
import org.eclipse.papyrus.toolsmiths.validation.properties.internal.util.PropertiesCache;
import org.eclipse.ui.IMarkerResolution;

class DataContextElementResolutionFactory
extends AbstractModelEditResolutionFactory {
    DataContextElementResolutionFactory(int problemID) {
        super(problemID);
    }

    @Override
    protected Iterable<IMarkerResolution> createResolutions() {
        switch (this.getProblemID()) {
            case 16715852: {
                return List.copyOf(Lists.asList((Object)this.addDataContextPackage(), (Object[])this.addDataContextPackageAndViews()));
            }
            case 16715843: {
                return List.copyOf(Lists.asList((Object)this.addDataContextElement(), (Object[])this.addDataContextElementAndViews()));
            }
            case 16715844: {
                return List.of(this.removeDataContextElement());
            }
        }
        return List.of();
    }

    IMarkerResolution addDataContextPackage() {
        return this.createResolution(Messages.DataContextElementResolutionFactory_6, Messages.DataContextElementResolutionFactory_7, DataContextPackage.class, this::createAddDataContextPackageCommand);
    }

    IMarkerResolution[] addDataContextPackageAndViews() {
        return (IMarkerResolution[])this.getLayoutGeneratorClass().map(this::instantiateLayout).map(Stream::of).orElseGet(() -> new LayoutExtensionPoint().getGenerators().stream()).map(this::addDataContextPackageAndViews).toArray(IMarkerResolution[]::new);
    }

    private IMarkerResolution addDataContextPackageAndViews(ILayoutGenerator generator) {
        return this.createResolution(NLS.bind((String)Messages.DataContextElementResolutionFactory_8, (Object)generator.getName()), NLS.bind((String)Messages.DataContextElementResolutionFactory_9, (Object)generator.getName()), DataContextPackage.class, (domain, package_) -> this.createDataContextPackageAndViewsCommand((EditingDomain)domain, (DataContextPackage)package_, generator));
    }

    private Command createAddDataContextPackageCommand(EditingDomain domain, DataContextPackage package_) {
        return PropertiesPluginValidationConstants.getObjectToReference(this.getMarker(), EObject.class, domain).map(sourcePackage -> this.createDataContextPackage(domain, (EObject)sourcePackage)).map(nested -> AddCommand.create((EditingDomain)domain, (Object)package_, (Object)ContextsPackage.Literals.DATA_CONTEXT_PACKAGE__ELEMENTS, (Object)nested)).orElse(null);
    }

    private Command createDataContextPackageAndViewsCommand(EditingDomain domain, DataContextPackage package_, ILayoutGenerator layout) {
        return PropertiesPluginValidationConstants.getObjectToReference(this.getMarker(), EObject.class, domain).map(sourcePackage -> this.createDataContextPackage(domain, (EObject)sourcePackage)).map(nested -> {
            CompoundCommand result = new CompoundCommand();
            result.append(AddCommand.create((EditingDomain)domain, (Object)package_, (Object)ContextsPackage.Literals.DATA_CONTEXT_PACKAGE__ELEMENTS, (Object)nested));
            this.createCreateViewCommands(domain, this.getContext((DataContextElement)package_), (DataContextElement)nested, layout).forEach(arg_0 -> ((CompoundCommand)result).append(arg_0));
            return result.unwrap();
        }).orElse(null);
    }

    IMarkerResolution addDataContextElement() {
        return this.createResolution(Messages.DataContextElementResolutionFactory_0, Messages.DataContextElementResolutionFactory_1, DataContextPackage.class, this::createAddDataContextElementCommand);
    }

    IMarkerResolution[] addDataContextElementAndViews() {
        return (IMarkerResolution[])this.getLayoutGeneratorClass().map(this::instantiateLayout).map(Stream::of).orElseGet(() -> new LayoutExtensionPoint().getGenerators().stream()).map(this::addDataContextElementAndViews).toArray(IMarkerResolution[]::new);
    }

    private IMarkerResolution addDataContextElementAndViews(ILayoutGenerator generator) {
        return this.createResolution(NLS.bind((String)Messages.DataContextElementResolutionFactory_2, (Object)generator.getName()), NLS.bind((String)Messages.DataContextElementResolutionFactory_3, (Object)generator.getName()), DataContextPackage.class, (domain, package_) -> this.createDataContextElementAndViewsCommand((EditingDomain)domain, (DataContextPackage)package_, generator));
    }

    private Command createAddDataContextElementCommand(EditingDomain domain, DataContextPackage package_) {
        return PropertiesPluginValidationConstants.getObjectToReference(this.getMarker(), EObject.class, domain).map(sourceClass -> this.createDataContextElement(domain, (EObject)sourceClass)).map(element -> AddCommand.create((EditingDomain)domain, (Object)package_, (Object)ContextsPackage.Literals.DATA_CONTEXT_PACKAGE__ELEMENTS, (Object)element)).orElse(null);
    }

    private Command createDataContextElementAndViewsCommand(EditingDomain domain, DataContextPackage package_, ILayoutGenerator layout) {
        return PropertiesPluginValidationConstants.getObjectToReference(this.getMarker(), EObject.class, domain).map(sourceClass -> this.createDataContextElement(domain, (EObject)sourceClass)).map(element -> {
            CompoundCommand result = new CompoundCommand();
            result.append(AddCommand.create((EditingDomain)domain, (Object)package_, (Object)ContextsPackage.Literals.DATA_CONTEXT_PACKAGE__ELEMENTS, (Object)element));
            this.createCreateViewCommands(domain, this.getContext((DataContextElement)package_), (DataContextElement)element, layout).forEach(arg_0 -> ((CompoundCommand)result).append(arg_0));
            return result.unwrap();
        }).orElse(null);
    }

    private Stream<Command> createCreateViewCommands(EditingDomain domain, Context context, DataContextElement element, ILayoutGenerator layout) {
        Stream<Command> result = element instanceof DataContextPackage ? ((DataContextPackage)element).getElements().stream().flatMap(child -> this.createCreateViewCommands(domain, context, (DataContextElement)child, layout)) : Stream.of(this.createView(context, element, 1), this.createView(context, element, -1)).map(view -> this.createLayoutCommand(domain, layout, context, element, (View)view));
        return result;
    }

    IMarkerResolution removeDataContextElement() {
        return this.createResolution(Messages.DataContextElementResolutionFactory_4, Messages.DataContextElementResolutionFactory_5, DataContextElement.class, this::createDeleteDataContextElementCommand);
    }

    private Command createDeleteDataContextElementCommand(EditingDomain domain, DataContextElement element) {
        DataContextPackage package_ = element.getPackage();
        return Optional.ofNullable(package_).map(container -> {
            CompoundCommand result = new CompoundCommand();
            result.append(ContextDeleteCommand.create((EditingDomain)domain, (Object)element));
            Stream.concat(PropertiesCache.getInstance((Notifier)element).getViews(element).stream(), PropertiesCache.getInstance((Notifier)element).getSections(element).stream()).map(viewOrSection -> RemoveCommand.create((EditingDomain)domain, (Object)viewOrSection)).forEach(arg_0 -> ((CompoundCommand)result).append(arg_0));
            return result.unwrap();
        }).orElse(null);
    }
}

