/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.nattable.controlmode.commands;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.papyrus.infra.nattable.controlmode.commands.PapyrusNattableControlCommand;
import org.eclipse.papyrus.infra.nattable.controlmode.helpers.TableControlModeHelper;
import org.eclipse.papyrus.infra.services.controlmode.ControlModeRequest;
import org.eclipse.papyrus.infra.services.controlmode.participants.IControlCommandParticipant;
import org.eclipse.papyrus.infra.services.controlmode.participants.IUncontrolCommandParticipant;

public class PapyrusNattableControlModeParticipant
implements IControlCommandParticipant,
IUncontrolCommandParticipant {
    public static final String PARTICIPANT_ID = "org.eclipse.papyrus.infra.nattable.controlmode.NatTableControlModeParticipant";

    public String getID() {
        return PARTICIPANT_ID;
    }

    public int getPriority() {
        return 50;
    }

    public boolean provideControlCommand(ControlModeRequest request) {
        EObject objectToControl = request.getTargetObject();
        if (objectToControl == null) {
            return false;
        }
        Iterable<EObject> iter = TableControlModeHelper.createDescendantTablesIterable(objectToControl);
        return iter.iterator().hasNext();
    }

    public boolean provideUnControlCommand(ControlModeRequest request) {
        return this.provideControlCommand(request);
    }

    public ICommand getPreUncontrolCommand(ControlModeRequest request) {
        return new PapyrusNattableControlCommand(request);
    }

    public ICommand getPreControlCommand(ControlModeRequest request) {
        return null;
    }

    public ICommand getPostUncontrolCommand(ControlModeRequest request) {
        return null;
    }

    public ICommand getPostControlCommand(ControlModeRequest request) {
        return new PapyrusNattableControlCommand(request);
    }
}

