/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.gmf.internal.xpand.model;

import org.eclipse.papyrus.gmf.internal.xpand.expression.ast.SyntaxElement;
import org.eclipse.papyrus.gmf.internal.xpand.ocl.ExpressionHelper;

public class AnalysationIssue {
    private final Type type;
    private final String message;
    private final boolean isWarningNotError;
    private final int start;
    private final int end;
    private final int line;

    public AnalysationIssue(Type type, String message, SyntaxElement element) {
        this(type, message, element, false);
    }

    public AnalysationIssue(Type type, String message, SyntaxElement element, boolean isWarning) {
        this(type, message, element.getStart(), element.getEnd(), element.getLine(), isWarning);
    }

    public AnalysationIssue(Type type, String message, ExpressionHelper exprHelper) {
        this(type, message, exprHelper.getStart(), exprHelper.getEnd(), -1, false);
    }

    private AnalysationIssue(Type type, String message, int start, int end, int line, boolean isWarningNotError) {
        this.type = type;
        this.message = message;
        this.isWarningNotError = isWarningNotError;
        this.start = start;
        this.end = end;
        this.line = line;
    }

    public boolean isWarningNotError() {
        return this.isWarningNotError;
    }

    public String getMessage() {
        return this.message;
    }

    public Type getType() {
        return this.type;
    }

    public int getStart() {
        return this.start;
    }

    public int getEnd() {
        return this.end;
    }

    public int getLine() {
        return this.line;
    }

    public String toString() {
        return "[" + this.type.name + "] - " + this.message;
    }

    public static enum Type {
        INCOMPATIBLE_TYPES("Incompatible types"),
        UNNECESSARY_CAST("Unnecessary cast"),
        FEATURE_NOT_FOUND("Callable not found"),
        TYPE_NOT_FOUND("Type not found"),
        INTERNAL_ERROR("Internal error"),
        JAVA_TYPE_NOT_FOUND("Java Type not found"),
        SYNTAX_ERROR("Syntax error"),
        DEFINITION_NOT_FOUND("Definition not found"),
        EXTENSION_NOT_FOUND("Extension not found"),
        NAMESPACE_NOT_FOUND("Namespace not found"),
        UNUSED_IMPORT("Unused import");

        private String name;

        private Type(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

