/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.gmf.internal.xpand.parser;

import java.util.List;
import lpg.runtime.IToken;
import org.eclipse.ocl.cst.OCLExpressionCS;
import org.eclipse.ocl.cst.PathNameCS;
import org.eclipse.ocl.cst.StringLiteralExpCS;
import org.eclipse.ocl.cst.TypeCS;
import org.eclipse.ocl.cst.VariableCS;
import org.eclipse.papyrus.gmf.internal.xpand.ast.Advice;
import org.eclipse.papyrus.gmf.internal.xpand.ast.Definition;
import org.eclipse.papyrus.gmf.internal.xpand.ast.ErrorStatement;
import org.eclipse.papyrus.gmf.internal.xpand.ast.ExpandStatement;
import org.eclipse.papyrus.gmf.internal.xpand.ast.ExpressionStatement;
import org.eclipse.papyrus.gmf.internal.xpand.ast.FileStatement;
import org.eclipse.papyrus.gmf.internal.xpand.ast.ForEachStatement;
import org.eclipse.papyrus.gmf.internal.xpand.ast.IfStatement;
import org.eclipse.papyrus.gmf.internal.xpand.ast.ImportDeclaration;
import org.eclipse.papyrus.gmf.internal.xpand.ast.LetStatement;
import org.eclipse.papyrus.gmf.internal.xpand.ast.NamespaceImport;
import org.eclipse.papyrus.gmf.internal.xpand.ast.ProtectStatement;
import org.eclipse.papyrus.gmf.internal.xpand.ast.Statement;
import org.eclipse.papyrus.gmf.internal.xpand.ast.Template;
import org.eclipse.papyrus.gmf.internal.xpand.ast.TextStatement;
import org.eclipse.papyrus.gmf.internal.xpand.expression.ast.Identifier;
import org.eclipse.papyrus.gmf.internal.xpand.expression.ast.SyntaxElement;
import org.eclipse.papyrus.gmf.internal.xpand.ocl.DeclaredParameter;

public class XpandFactory {
    private final String fileName;

    public XpandFactory(String fileName) {
        this.fileName = fileName;
    }

    public Template createTemplate(List<NamespaceImport> imports, List<ImportDeclaration> extensions, List<Definition> defines, List<Advice> advices, IToken eof) {
        NamespaceImport[] i = imports.toArray(new NamespaceImport[imports.size()]);
        ImportDeclaration[] ext = extensions.toArray(new ImportDeclaration[extensions.size()]);
        Definition[] d = defines.toArray(new Definition[defines.size()]);
        Advice[] a = advices.toArray(new Advice[advices.size()]);
        Template t = new Template(0, XpandFactory.end(eof), 0, i, ext, d, a);
        return this.handle(t);
    }

    public Definition createDefinition(IToken startToken, IToken endToken, IToken n, List<VariableCS> p, TypeCS type, List<Statement> s) {
        int start = XpandFactory.start(startToken);
        int end = XpandFactory.end(endToken);
        int line = XpandFactory.line(startToken);
        Identifier name = this.createIdentifier(n);
        Statement[] body = s.toArray(new Statement[s.size()]);
        return this.handle(new Definition(start, end, line, name, type, DeclaredParameter.create(p), body));
    }

    public TextStatement createTextStatement(IToken t, IToken m) {
        String text = t.toString();
        text = text.length() > 1 ? text.substring(1, text.length() - 1) : "";
        return this.handle(new TextStatement(XpandFactory.start(m != null ? m : t), XpandFactory.end(t), XpandFactory.line(m != null ? m : t), text, m != null));
    }

    public ForEachStatement createForEachStatement(IToken start, IToken end, OCLExpressionCS e, IToken v, OCLExpressionCS sep, IToken iter, List<SyntaxElement> s) {
        Statement[] body = s.toArray(new Statement[s.size()]);
        return this.handle(new ForEachStatement(XpandFactory.start(start), XpandFactory.end(end), XpandFactory.line(start), this.createIdentifier(v), e, body, sep, iter != null ? this.createIdentifier(iter) : null));
    }

    public IfStatement createIfStatement(IToken start, OCLExpressionCS condition, List<SyntaxElement> statements, IfStatement elseIf) {
        Statement[] body = statements.toArray(new Statement[statements.size()]);
        int end = body[body.length - 1].getEnd();
        return this.handle(new IfStatement(XpandFactory.start(start), end, XpandFactory.line(start), condition, body, elseIf));
    }

    public LetStatement createLetStatement(IToken start, IToken end, OCLExpressionCS e, IToken name, List<SyntaxElement> statements) {
        Statement[] body = statements.toArray(new Statement[statements.size()]);
        return this.handle(new LetStatement(XpandFactory.start(start), XpandFactory.end(end), XpandFactory.line(start), this.createIdentifier(name), e, body));
    }

    public ErrorStatement createErrorStatement(IToken start, OCLExpressionCS expr) {
        return this.handle(new ErrorStatement(XpandFactory.start(start), expr.getEndOffset(), XpandFactory.line(start), expr));
    }

    public ExpressionStatement createExpressionStatement(OCLExpressionCS e, int lineNumber) {
        return this.handle(new ExpressionStatement(e.getStartOffset(), e.getEndOffset(), lineNumber, e));
    }

    public FileStatement createFileStatement(IToken start, IToken end, OCLExpressionCS fileName, Identifier option, List<SyntaxElement> statements) {
        Statement[] body = statements.toArray(new Statement[statements.size()]);
        return this.handle(new FileStatement(XpandFactory.start(start), XpandFactory.end(end), XpandFactory.line(start), fileName, body, option));
    }

    public ProtectStatement createProtectStatement(IToken start, IToken end, OCLExpressionCS startC, OCLExpressionCS endC, OCLExpressionCS id, IToken disabled, List<SyntaxElement> statements) {
        Statement[] body = statements.toArray(new Statement[statements.size()]);
        return this.handle(new ProtectStatement(XpandFactory.start(start), XpandFactory.end(end), XpandFactory.line(start), startC, endC, body, id, disabled != null));
    }

    public ExpandStatement createExpandStatement(IToken start, PathNameCS definition, List<OCLExpressionCS> parameters, OCLExpressionCS target, boolean foreach, OCLExpressionCS sep) {
        OCLExpressionCS[] params = parameters.toArray(new OCLExpressionCS[parameters.size()]);
        int end = definition.getEndOffset();
        if (sep != null) {
            end = sep.getEndOffset();
        } else if (target != null) {
            end = target.getEndOffset();
        } else if (params.length > 0) {
            end = params[params.length - 1].getEndOffset();
        }
        return this.handle(new ExpandStatement(XpandFactory.start(start), end, XpandFactory.line(start), definition, target, sep, params, foreach));
    }

    public NamespaceImport createNamespaceImport(IToken start, StringLiteralExpCS namespace) {
        return this.handle(new NamespaceImport(XpandFactory.start(start), namespace.getEndOffset(), XpandFactory.line(start), namespace));
    }

    public ImportDeclaration createImportDeclaration(IToken start, PathNameCS namespace) {
        return this.handle(new ImportDeclaration(XpandFactory.start(start), namespace.getEndOffset(), XpandFactory.line(start), namespace));
    }

    public Advice createAround(IToken start, IToken end, Identifier n, List<VariableCS> p, boolean wildparams, TypeCS t, List<Statement> s) {
        Statement[] body = s.toArray(new Statement[s.size()]);
        Advice a = new Advice(XpandFactory.start(start), XpandFactory.end(end), XpandFactory.line(start), n, t, DeclaredParameter.create(p), wildparams, body);
        return this.handle(a);
    }

    private <T extends SyntaxElement> T handle(T expr) {
        expr.setFileName(this.fileName);
        return expr;
    }

    private static int end(IToken c) {
        return c.getEndOffset();
    }

    private static int start(IToken c) {
        return c.getStartOffset();
    }

    private static int line(IToken c) {
        return c.getLine();
    }

    public Identifier createIdentifier(IToken name) {
        return new Identifier(XpandFactory.start(name), XpandFactory.end(name), XpandFactory.line(name), name.toString());
    }
}

