/**
 * Copyright (c) 2007, 2020 Borland Software Corporation, CEA LIST, Artal and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *    Dmitry Stadnik (Borland) - initial API and implementation
 *    Michael Golubev (Montages) - #386838 - migrate to Xtend2
 *    Aurelien Didier (ARTAL) - aurelien.didier51@gmail.com - Bug 569174
 */
package xpt.diagram.preferences;

import com.google.common.base.Objects;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import impl.preferences.CustomPage;
import impl.preferences.StandardPage;
import java.util.Arrays;
import java.util.List;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenCustomPreferencePage;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenDiagram;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenPreferencePage;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenStandardPreferencePage;
import org.eclipse.papyrus.gmf.codegen.xtend.annotations.Localization;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.StringExtensions;
import xpt.Common;
import xpt.Common_qvto;
import xpt.diagram.Utils_qvto;

@Singleton
@SuppressWarnings("all")
public class extensions {
  @Inject
  @Extension
  private Common _common;
  
  @Inject
  @Extension
  private Common_qvto _common_qvto;
  
  @Inject
  @Extension
  private Utils_qvto _utils_qvto;
  
  @Inject
  private PreferenceInitializer xptPreferenceInitializer;
  
  @Inject
  private CustomPage xptCustomPage;
  
  @Inject
  private StandardPage xptStandardPage;
  
  public CharSequence extensions(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.newLine();
    String _tripleSpace = this._common.tripleSpace(1);
    _builder.append(_tripleSpace);
    _builder.append("<extension point=\"org.eclipse.core.runtime.preferences\" id=\"prefs\">");
    _builder.newLineIfNotEmpty();
    String _tripleSpace_1 = this._common.tripleSpace(2);
    _builder.append(_tripleSpace_1);
    CharSequence _xmlGeneratedTag = this._common.xmlGeneratedTag();
    _builder.append(_xmlGeneratedTag);
    _builder.newLineIfNotEmpty();
    String _tripleSpace_2 = this._common.tripleSpace(2);
    _builder.append(_tripleSpace_2);
    _builder.append("<initializer class=\"");
    CharSequence _qualifiedClassName = this.xptPreferenceInitializer.qualifiedClassName(it);
    _builder.append(_qualifiedClassName);
    _builder.append("\"/>");
    _builder.newLineIfNotEmpty();
    String _tripleSpace_3 = this._common.tripleSpace(1);
    _builder.append(_tripleSpace_3);
    _builder.append("</extension>");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    {
      boolean _notEmpty = this._common_qvto.<GenPreferencePage>notEmpty(it.getPreferencePages());
      if (_notEmpty) {
        String _tripleSpace_4 = this._common.tripleSpace(1);
        _builder.append(_tripleSpace_4);
        _builder.append("<extension point=\"org.eclipse.ui.preferencePages\" id=\"prefpages\">");
        _builder.newLineIfNotEmpty();
        String _tripleSpace_5 = this._common.tripleSpace(2);
        _builder.append(_tripleSpace_5);
        CharSequence _xmlGeneratedTag_1 = this._common.xmlGeneratedTag();
        _builder.append(_xmlGeneratedTag_1);
        _builder.newLineIfNotEmpty();
        {
          List<GenPreferencePage> _allPreferencePages = this._utils_qvto.allPreferencePages(it);
          for(final GenPreferencePage pref : _allPreferencePages) {
            CharSequence _preferencePage = this.preferencePage(pref);
            _builder.append(_preferencePage);
            _builder.newLineIfNotEmpty();
          }
        }
        String _tripleSpace_6 = this._common.tripleSpace(1);
        _builder.append(_tripleSpace_6);
        _builder.append("</extension>");
        _builder.newLineIfNotEmpty();
      }
    }
    return _builder;
  }
  
  public CharSequence preferencePage(final GenPreferencePage it) {
    StringConcatenation _builder = new StringConcatenation();
    String _tripleSpace = this._common.tripleSpace(2);
    _builder.append(_tripleSpace);
    _builder.append("<page");
    _builder.newLineIfNotEmpty();
    String _tripleSpace_1 = this._common.tripleSpace(4);
    _builder.append(_tripleSpace_1);
    _builder.append("id=\"");
    String _iD = it.getID();
    _builder.append(_iD);
    _builder.append("\"");
    _builder.newLineIfNotEmpty();
    String _tripleSpace_2 = this._common.tripleSpace(4);
    _builder.append(_tripleSpace_2);
    _builder.append("name=\"%prefpage.");
    String _iD_1 = it.getID();
    _builder.append(_iD_1);
    _builder.append("\"");
    _builder.newLineIfNotEmpty();
    {
      GenPreferencePage _parent = it.getParent();
      boolean _notEquals = (!Objects.equal(null, _parent));
      if (_notEquals) {
        String _tripleSpace_3 = this._common.tripleSpace(4);
        _builder.append(_tripleSpace_3);
        _builder.append("category=\"");
        String _iD_2 = it.getParent().getID();
        _builder.append(_iD_2);
        _builder.append("\"");
        _builder.newLineIfNotEmpty();
      } else {
        boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty(it.getParentCategory());
        boolean _not = (!_isNullOrEmpty);
        if (_not) {
          String _tripleSpace_4 = this._common.tripleSpace(4);
          _builder.append(_tripleSpace_4);
          _builder.append("category=\"");
          String _parentCategory = it.getParentCategory();
          _builder.append(_parentCategory);
          _builder.append("\"");
          _builder.newLineIfNotEmpty();
        }
      }
    }
    String _tripleSpace_5 = this._common.tripleSpace(4);
    _builder.append(_tripleSpace_5);
    _builder.append("class=\"");
    CharSequence _qualifiedPageName = this.getQualifiedPageName(it);
    _builder.append(_qualifiedPageName);
    _builder.append("\">");
    _builder.newLineIfNotEmpty();
    String _tripleSpace_6 = this._common.tripleSpace(2);
    _builder.append(_tripleSpace_6);
    _builder.append("</page>");
    _builder.newLineIfNotEmpty();
    return _builder;
  }
  
  @Localization
  public CharSequence i18n(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("# Preferences");
    _builder.newLine();
    {
      List<GenPreferencePage> _allPreferencePages = this._utils_qvto.allPreferencePages(it);
      for(final GenPreferencePage pref : _allPreferencePages) {
        _builder.append("prefpage.");
        String _iD = pref.getID();
        _builder.append(_iD);
        _builder.append("=");
        String _name = pref.getName();
        _builder.append(_name);
        _builder.newLineIfNotEmpty();
      }
    }
    CharSequence _extraLineBreak = this._common.extraLineBreak();
    _builder.append(_extraLineBreak);
    _builder.newLineIfNotEmpty();
    return _builder;
  }
  
  protected CharSequence _getQualifiedPageName(final GenPreferencePage it) {
    StringConcatenation _builder = new StringConcatenation();
    return _builder;
  }
  
  protected CharSequence _getQualifiedPageName(final GenCustomPreferencePage it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _qualifiedClassName = this.xptCustomPage.qualifiedClassName(it);
    _builder.append(_qualifiedClassName);
    return _builder;
  }
  
  protected CharSequence _getQualifiedPageName(final GenStandardPreferencePage it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _qualifiedClassName = this.xptStandardPage.qualifiedClassName(it);
    _builder.append(_qualifiedClassName);
    return _builder;
  }
  
  public CharSequence getQualifiedPageName(final GenPreferencePage it) {
    if (it instanceof GenCustomPreferencePage) {
      return _getQualifiedPageName((GenCustomPreferencePage)it);
    } else if (it instanceof GenStandardPreferencePage) {
      return _getQualifiedPageName((GenStandardPreferencePage)it);
    } else if (it != null) {
      return _getQualifiedPageName(it);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(it).toString());
    }
  }
}
