/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.toolsmiths.nattable.wizard.pages;

import java.util.Collection;
import java.util.HashSet;
import org.eclipse.papyrus.infra.architecture.ArchitectureDomainManager;
import org.eclipse.papyrus.infra.core.architecture.merged.MergedArchitectureContext;
import org.eclipse.papyrus.infra.nattable.model.nattable.Table;
import org.eclipse.papyrus.infra.viewpoints.policy.PolicyChecker;
import org.eclipse.papyrus.infra.viewpoints.policy.ViewPrototype;
import org.eclipse.papyrus.toolsmiths.nattable.messages.Messages;
import org.eclipse.papyrus.toolsmiths.nattable.wizard.pages.AbstractExportTableAsTableConfigurationWizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class DefineTableConfigurationDataWizardPage
extends AbstractExportTableAsTableConfigurationWizardPage
implements ModifyListener {
    public static final String DATA_PAGE_TITLE = Messages.DefineTableConfigurationDataWizardPage_DataPageTitle;
    private static final Collection<String> forbiddenIDs = DefineTableConfigurationDataWizardPage.getAllExistingIds();
    private String newTableType;
    private String newTableConfigurationName;
    private String newTableConfigurationDescription;
    private Text tableNameField;
    private Text tableTypeField;
    private Text tableDescriptionField;

    public DefineTableConfigurationDataWizardPage() {
        super(DATA_PAGE_TITLE);
        this.setMessage(Messages.DefineTableConfigurationDataWizardPage_ConfigureTableConfiguration);
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 2048);
        composite.setLayout((Layout)new GridLayout(1, true));
        Group outputGroup = new Group(composite, 0);
        outputGroup.setText(Messages.DefineTableConfigurationDataWizardPage_EnterNewTableConfigurationInformation);
        outputGroup.setLayout((Layout)new GridLayout(2, true));
        outputGroup.setLayoutData((Object)new GridData(4, 4, true, true));
        Label tableNameLabel = new Label((Composite)outputGroup, 0);
        tableNameLabel.setText(Messages.DefineTableConfigurationDataWizardPage_DefineTableTable);
        tableNameLabel.setLayoutData((Object)new GridData(4, 4, true, false));
        this.tableNameField = new Text((Composite)outputGroup, 2048);
        this.tableNameField.setText(this.newTableConfigurationName);
        this.tableNameField.setLayoutData((Object)new GridData(4, 4, true, false));
        this.tableNameField.addModifyListener((ModifyListener)this);
        Label tableTypeLabel = new Label((Composite)outputGroup, 0);
        tableTypeLabel.setText(Messages.DefineTableConfigurationDataWizardPage_DefineTableType);
        tableTypeLabel.setLayoutData((Object)new GridData(4, 4, true, false));
        this.tableTypeField = new Text((Composite)outputGroup, 2048);
        this.tableTypeField.setText(this.buildNewTableType());
        this.tableTypeField.setLayoutData((Object)new GridData(4, 4, true, false));
        this.tableTypeField.addModifyListener((ModifyListener)this);
        Label tableDescriptionLabel = new Label((Composite)outputGroup, 0);
        tableDescriptionLabel.setText(Messages.DefineTableConfigurationDataWizardPage_DefineTableConfigurationDescription);
        tableDescriptionLabel.setLayoutData((Object)new GridData(4, 4, true, false));
        this.tableDescriptionField = new Text((Composite)outputGroup, 2050);
        this.tableDescriptionField.setText(this.newTableConfigurationDescription);
        GridData descriptionData = new GridData(4, 4, true, true);
        descriptionData.horizontalSpan = 2;
        this.tableDescriptionField.setLayoutData((Object)descriptionData);
        this.tableDescriptionField.addModifyListener((ModifyListener)this);
        this.setControl((Control)composite);
    }

    private String buildNewTableConfigurationDescription() {
        return this.getExportedTable().getDescription() != null ? this.getExportedTable().getDescription() : "";
    }

    private String buildNewTableName() {
        return this.getExportedTable().getName() != null ? this.getExportedTable().getName() : "";
    }

    private String buildNewTableType() {
        StringBuilder builder = new StringBuilder(this.buildNewTableName());
        builder.append("Type");
        return builder.toString();
    }

    private void setPageComplete() {
        boolean isComplete = true;
        this.setErrorMessage(null);
        if (!this.checkDefaultTableName()) {
            isComplete = false;
        }
        if (!this.checkTableType()) {
            isComplete = false;
        }
        if (!this.checkTableDescription()) {
            isComplete = false;
        }
        this.setPageComplete(isComplete);
    }

    private boolean checkDefaultTableName() {
        boolean res;
        boolean bl = res = this.newTableConfigurationName != null && this.newTableConfigurationName.length() > 0;
        if (!res) {
            this.setErrorMessage(Messages.DefineTableConfigurationDataWizardPage_PleaseSetAName);
        }
        return res;
    }

    private boolean checkTableType() {
        boolean res;
        boolean bl = res = this.newTableType != null && this.newTableType.length() > 0;
        if (res) {
            if (forbiddenIDs.contains(this.newTableType)) {
                res = false;
                this.setErrorMessage(Messages.DefineTableConfigurationDataWizardPage_TableTypeAlreadyExists);
            }
        } else {
            this.setErrorMessage(Messages.DefineTableConfigurationDataWizardPage_PleaseSetAType);
        }
        return res;
    }

    private boolean checkTableDescription() {
        return true;
    }

    private static final Collection<String> getAllExistingIds() {
        HashSet<String> tableType = new HashSet<String>();
        for (MergedArchitectureContext mac : ArchitectureDomainManager.getInstance().getVisibleArchitectureContexts()) {
            for (ViewPrototype proto : PolicyChecker.getFor((MergedArchitectureContext)mac).getAllPrototypes()) {
                String impl = proto.getImplementation();
                String implId = proto.getRepresentationKind().getImplementationID();
                if (impl != null) {
                    tableType.add(impl);
                }
                if (implId == null) continue;
                tableType.add(implId);
            }
        }
        return tableType;
    }

    @Override
    public void setExportedTable(Table exportedTable) {
        super.setExportedTable(exportedTable);
        this.newTableConfigurationDescription = this.buildNewTableConfigurationDescription();
        this.newTableConfigurationName = this.buildNewTableName();
        this.newTableType = this.buildNewTableType();
    }

    public void modifyText(ModifyEvent e) {
        Object source = e.getSource();
        if (source instanceof Text) {
            Text txt = (Text)source;
            if (this.tableNameField == txt) {
                this.newTableConfigurationName = this.tableNameField.getText();
            }
            if (this.tableTypeField == txt) {
                this.newTableType = this.tableTypeField.getText();
            }
            if (this.tableDescriptionField == txt) {
                this.newTableConfigurationDescription = this.tableDescriptionField.getText();
            }
        }
        this.setPageComplete();
    }

    public String getNewTableType() {
        return this.newTableType;
    }

    public String getNewTableDefaultName() {
        return this.newTableConfigurationName;
    }

    public String getNewTableConfigurationDescription() {
        return this.newTableConfigurationDescription;
    }

    public String getFileName() {
        return this.getNewTableType();
    }
}

