/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.timing.custom.utils;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.osgi.util.NLS;
import org.eclipse.papyrus.infra.widgets.toolbox.notification.dialogs.PapyrusAsyncNotificationPopup;
import org.eclipse.papyrus.uml.diagram.timing.custom.Messages;
import org.eclipse.papyrus.uml.diagram.timing.custom.utils.OccurrenceSpecificationUtils;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.uml2.uml.DestructionOccurrenceSpecification;
import org.eclipse.uml2.uml.Interaction;
import org.eclipse.uml2.uml.InteractionFragment;
import org.eclipse.uml2.uml.Lifeline;
import org.eclipse.uml2.uml.OccurrenceSpecification;
import org.eclipse.uml2.uml.StateInvariant;
import org.eclipse.uml2.uml.UMLFactory;

public final class ModelValidationUtils {
    private ModelValidationUtils() {
    }

    public static boolean validate(Interaction interaction, boolean autoCorrection, boolean interactive) {
        StringBuilder messageBuilder = new StringBuilder();
        ModelValidationUtils.reorderLifelineCoveredBy(interaction, messageBuilder);
        boolean isDestructionOccurrenceOK = false;
        boolean isOSbetweenSIOK = false;
        for (Lifeline lifeline : interaction.getLifelines()) {
            isDestructionOccurrenceOK = ModelValidationUtils.validateDestructionOccurrence(lifeline, autoCorrection, messageBuilder);
            isOSbetweenSIOK = ModelValidationUtils.validateOSbetweenSI(lifeline, autoCorrection, messageBuilder);
        }
        Display display = Display.getCurrent();
        if (display != null) {
            String popupMessage = messageBuilder.toString().trim();
            if (popupMessage.length() > 0) {
                PapyrusAsyncNotificationPopup popup = new PapyrusAsyncNotificationPopup(display, new FormToolkit(display));
                popup.setTitle(Messages.ModelValidationUtils_ModelValidation);
                popup.setText(popupMessage);
                popup.open();
            }
        } else if (interactive) {
            throw new IllegalStateException("This method must be called on the UI thread when executed interactively");
        }
        return isDestructionOccurrenceOK && isOSbetweenSIOK;
    }

    private static void appendMessage(StringBuilder message, String string) {
        if (message.length() > 0) {
            if (message.charAt(0) != '-') {
                String msg = message.toString();
                message.setLength(0);
                message.append("- ").append(msg);
            }
            message.append("\n- ");
        }
        message.append(string);
    }

    private static void reorderLifelineCoveredBy(Interaction interaction, StringBuilder messageBuilder) {
        int reorderCount = 0;
        for (Lifeline lifeline : interaction.getLifelines()) {
            EList coveredBy = lifeline.getCoveredBys();
            if (coveredBy.isEmpty()) continue;
            List<InteractionFragment> fragments = ModelValidationUtils.filterFragments((EList<InteractionFragment>)interaction.getFragments(), lifeline);
            int indexInFragments = 0;
            for (InteractionFragment interactionFragment : fragments) {
                int indexInLifeline = coveredBy.indexOf((Object)interactionFragment);
                if (indexInFragments != indexInLifeline) {
                    coveredBy.move(indexInFragments, indexInLifeline);
                    ++reorderCount;
                }
                ++indexInFragments;
            }
        }
        if (reorderCount > 0) {
            ModelValidationUtils.appendMessage(messageBuilder, NLS.bind((String)Messages.ModelValidationUtils_CoveredByFragmentsWereReOrdered, (Object)Integer.toString(reorderCount)));
        }
    }

    private static List<InteractionFragment> filterFragments(EList<InteractionFragment> fragments, Lifeline lifeline) {
        ArrayList<InteractionFragment> result = new ArrayList<InteractionFragment>();
        for (InteractionFragment interactionFragment : fragments) {
            if (!interactionFragment.getCovereds().contains((Object)lifeline)) continue;
            result.add(interactionFragment);
        }
        return result;
    }

    private static boolean validateDestructionOccurrence(Lifeline lifeline, boolean autoCorrection, StringBuilder messageBuilder) {
        int wrongFragmentsFound = 0;
        int wrongFragmentsRemoved = 0;
        ListIterator listIterator = lifeline.getCoveredBys().listIterator();
        boolean afterDestructionOccurrenceSpecification = false;
        while (listIterator.hasNext()) {
            InteractionFragment fragment = (InteractionFragment)listIterator.next();
            if (afterDestructionOccurrenceSpecification) {
                if (autoCorrection) {
                    listIterator.remove();
                    ++wrongFragmentsRemoved;
                } else {
                    ++wrongFragmentsFound;
                }
            }
            if (!(fragment instanceof DestructionOccurrenceSpecification)) continue;
            afterDestructionOccurrenceSpecification = true;
        }
        if (wrongFragmentsFound > 0) {
            ModelValidationUtils.appendMessage(messageBuilder, NLS.bind((String)Messages.ModelValidationUtils_FragmentsFoundAfterDestructionOccurrenceSpecification, (Object)Integer.toString(wrongFragmentsFound)));
        }
        if (wrongFragmentsRemoved > 0) {
            ModelValidationUtils.appendMessage(messageBuilder, NLS.bind((String)Messages.ModelValidationUtils_FragmentsRemovedAfterDestructionOccurrenceSpecification, (Object)Integer.toString(wrongFragmentsRemoved)));
        }
        return wrongFragmentsFound == 0;
    }

    private static boolean validateOSbetweenSI(Lifeline lifeline, boolean autoCorrection, StringBuilder messageBuilder) {
        OccurrenceSpecification occurrence;
        EList coveredBys = lifeline.getCoveredBys();
        int missingOccurrences = 0;
        LinkedHashMap<OccurrenceSpecification, Integer> occurencesToBeAdded = new LinkedHashMap<OccurrenceSpecification, Integer>();
        InteractionFragment previousElement = null;
        int offset = 0;
        for (InteractionFragment interactionFragment : coveredBys) {
            if (interactionFragment instanceof StateInvariant && previousElement instanceof StateInvariant) {
                if (autoCorrection) {
                    occurrence = UMLFactory.eINSTANCE.createOccurrenceSpecification();
                    OccurrenceSpecificationUtils.setAutogeneratedName(occurrence, true);
                    occurencesToBeAdded.put(occurrence, coveredBys.indexOf(interactionFragment) + offset++);
                } else {
                    ++missingOccurrences;
                }
            }
            previousElement = interactionFragment;
        }
        if (!occurencesToBeAdded.isEmpty()) {
            for (Map.Entry entry : occurencesToBeAdded.entrySet()) {
                InteractionFragment previousFragment;
                occurrence = (OccurrenceSpecification)entry.getKey();
                int indexInCoveredBys = (Integer)entry.getValue();
                StateInvariant stateInvariant = (StateInvariant)lifeline.getCoveredBys().get(indexInCoveredBys);
                lifeline.getCoveredBys().add(indexInCoveredBys, (Object)occurrence);
                EList fragments = lifeline.getInteraction().getFragments();
                int indexInFragments = fragments.indexOf((Object)stateInvariant);
                fragments.add(indexInFragments, (Object)occurrence);
                String previousName = null;
                if (indexInCoveredBys > 0 && (previousFragment = (InteractionFragment)lifeline.getCoveredBys().get(indexInCoveredBys - 1)) instanceof StateInvariant) {
                    StateInvariant previousStateInvariant = (StateInvariant)previousFragment;
                    previousName = previousStateInvariant.getName();
                }
                String followingName = stateInvariant.getName();
                if (previousName == null) {
                    previousName = "<unnamed>";
                }
                if (followingName == null) {
                    followingName = "<unnamed>";
                }
                occurrence.setName(String.valueOf(previousName) + "_To_" + followingName);
            }
            ModelValidationUtils.appendMessage(messageBuilder, NLS.bind((String)Messages.ModelValidationUtils_MissingOccurrenceSpecificationAdded, (Object)occurencesToBeAdded.size()));
        }
        if (missingOccurrences > 0) {
            ModelValidationUtils.appendMessage(messageBuilder, NLS.bind((String)Messages.ModelValidationUtils_MissingOccurrenceSpecificationFound, (Object)missingOccurrences));
        }
        return missingOccurrences == 0;
    }
}

