/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.common.commands;

import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.PrecisionPoint;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.Request;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.diagram.core.util.ViewUtil;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ShapeNodeEditPart;
import org.eclipse.gmf.runtime.draw2d.ui.figures.BaseSlidableAnchor;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.IdentityAnchor;
import org.eclipse.gmf.runtime.notation.View;

public class PreserveAnchorsPositionCommand
extends AbstractTransactionalCommand {
    private ShapeNodeEditPart shapeEP;
    private Dimension sizeDelta;
    private int preserveAxis;
    private IFigure figure;
    private int resizeDirection;
    protected static final String COMMAND_LABEL = "Modify Anchors to Preserve Position";
    protected static final String COMMAND_ERROR_MESSAGE = "One of the anchors is left outside of the new figure's size";
    public static final int PRESERVE_Y = 0;
    public static final int PRESERVE_X = 1;
    public static final int PRESERVE_XY = 2;

    public PreserveAnchorsPositionCommand(ShapeNodeEditPart shapeEP, Dimension sizeDelta, int preserveAxis) {
        super(shapeEP.getEditingDomain(), COMMAND_LABEL, null);
        this.setShapeEP(shapeEP);
        this.setSizeDelta(sizeDelta);
        this.setPreserveAxis(preserveAxis);
    }

    public PreserveAnchorsPositionCommand(ShapeNodeEditPart shapeEP, Dimension sizeDelta, int preserveAxis, IFigure figure, int resizeDirection) {
        this(shapeEP, sizeDelta, preserveAxis);
        this.figure = figure;
        this.resizeDirection = resizeDirection;
    }

    public void setPreserveAxis(int preserveAxis) {
        this.preserveAxis = preserveAxis != 0 && preserveAxis != 1 && preserveAxis != 2 ? 0 : preserveAxis;
    }

    public int getPreserveAxis() {
        return this.preserveAxis;
    }

    public void setShapeEP(ShapeNodeEditPart shapeEP) {
        this.shapeEP = shapeEP;
    }

    public ShapeNodeEditPart getShapeEP() {
        return this.shapeEP;
    }

    public Rectangle getFigureBounds() {
        if (this.figure != null) {
            return this.figure.getBounds();
        }
        return this.getShapeEP().getFigure().getBounds();
    }

    public View getView() {
        return (View)this.getShapeEP().getModel();
    }

    protected void setSizeDelta(Dimension sizeDelta) {
        this.sizeDelta = sizeDelta;
    }

    public Dimension getSizeDelta() {
        return this.sizeDelta;
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        IdentityAnchor anchor;
        View view = this.getView();
        List sourceList = ViewUtil.getSourceConnections((View)view);
        List targetList = ViewUtil.getTargetConnections((View)view);
        for (Edge edge : sourceList) {
            anchor = (IdentityAnchor)edge.getSourceAnchor();
            if (anchor == null) continue;
            anchor.setId(this.getNewIdStr(anchor));
        }
        for (Edge edge : targetList) {
            anchor = (IdentityAnchor)edge.getTargetAnchor();
            if (anchor == null) continue;
            anchor.setId(this.getNewIdStr(anchor));
        }
        return CommandResult.newOKCommandResult();
    }

    protected String getNewIdStr(IdentityAnchor anchor) {
        Dimension sizeDelta = this.getSizeDelta();
        Rectangle figureBounds = this.getFigureBounds();
        PrecisionPoint pp = BaseSlidableAnchor.parseTerminalString((String)anchor.getId());
        int figureHeight = figureBounds.height;
        if (figureHeight != 0) {
            if (pp == null) {
                pp = new PrecisionPoint();
            }
            if (this.getPreserveAxis() == 0 || 2 == this.getPreserveAxis()) {
                double anchorYPos = (double)figureHeight * pp.preciseY();
                pp.setPreciseY(anchorYPos / (double)(figureHeight + sizeDelta.height));
                if (1 == this.resizeDirection || 17 == this.resizeDirection || 9 == this.resizeDirection) {
                    pp.setPreciseY(pp.preciseY() + (double)sizeDelta.height / (double)(figureHeight + sizeDelta.height));
                }
                if (pp.preciseY() > 1.0) {
                    pp.setPreciseY(1.0);
                } else if (pp.preciseY() < 0.0) {
                    pp.setPreciseY(0.0);
                }
            }
            if (1 == this.getPreserveAxis() || 2 == this.getPreserveAxis()) {
                double anchorXPos = (double)figureBounds.width * pp.preciseX();
                pp.setPreciseX(anchorXPos / (double)(figureBounds.width + sizeDelta.width));
                if (8 == this.resizeDirection || 9 == this.resizeDirection || 12 == this.resizeDirection) {
                    pp.setPreciseX(pp.preciseX() + (double)sizeDelta.width / (double)(figureBounds.width + sizeDelta.width));
                }
                if (pp.preciseX() > 1.0) {
                    pp.setPreciseX(1.0);
                } else if (pp.preciseX() < 0.0) {
                    pp.setPreciseX(0.0);
                }
            }
        }
        return new BaseSlidableAnchor(null, pp).getTerminal();
    }

    public static Dimension getSizeDeltaToFitAnchors(ShapeNodeEditPart shapeEP, Dimension sizeDelta, int preserveAxis) {
        IdentityAnchor anchor;
        Dimension newSizeDelta = new Dimension(sizeDelta);
        View view = (View)shapeEP.getModel();
        Rectangle figureBounds = shapeEP.getFigure().getBounds();
        List sourceList = ViewUtil.getSourceConnections((View)view);
        List targetList = ViewUtil.getTargetConnections((View)view);
        for (Edge edge : sourceList) {
            anchor = (IdentityAnchor)edge.getSourceAnchor();
            PreserveAnchorsPositionCommand.modifySizeDeltaToFitAnchor(anchor, newSizeDelta, preserveAxis, figureBounds);
        }
        for (Edge edge : targetList) {
            anchor = (IdentityAnchor)edge.getTargetAnchor();
            PreserveAnchorsPositionCommand.modifySizeDeltaToFitAnchor(anchor, newSizeDelta, preserveAxis, figureBounds);
        }
        return newSizeDelta;
    }

    protected static void modifySizeDeltaToFitAnchor(IdentityAnchor anchor, Dimension sizeDelta, int preserveAxis, Rectangle figureBounds) {
        int newWidth;
        int anchorXPos;
        int newHeight;
        int anchorYPos;
        if (anchor == null) {
            return;
        }
        PrecisionPoint pp = BaseSlidableAnchor.parseTerminalString((String)anchor.getId());
        if (pp == null) {
            pp = new PrecisionPoint();
        }
        int margin = 6;
        if ((preserveAxis == 0 || preserveAxis == 2) && (anchorYPos = (int)Math.round((double)figureBounds.height * pp.preciseY())) + margin > (newHeight = figureBounds.height + sizeDelta.height)) {
            sizeDelta.height = anchorYPos - figureBounds.height + margin;
        }
        if ((preserveAxis == 1 || preserveAxis == 2) && (anchorXPos = (int)Math.round((double)figureBounds.width * pp.preciseX())) + margin > (newWidth = figureBounds.width + sizeDelta.width)) {
            sizeDelta.width = anchorXPos - figureBounds.width + margin;
        }
    }

    public static Request getNewSourceFeedbackRequest(Request request, ShapeNodeEditPart editPart) {
        if (request instanceof ChangeBoundsRequest) {
            ChangeBoundsRequest currRequest = (ChangeBoundsRequest)request;
            Dimension oldDelta = currRequest.getSizeDelta();
            Dimension newDelta = PreserveAnchorsPositionCommand.getSizeDeltaToFitAnchors(editPart, oldDelta, 0);
            ChangeBoundsRequest newRequest = new ChangeBoundsRequest();
            newRequest.setMoveDelta(currRequest.getMoveDelta());
            newRequest.setSizeDelta(newDelta);
            newRequest.setLocation(currRequest.getLocation());
            newRequest.setExtendedData(currRequest.getExtendedData());
            newRequest.setResizeDirection(currRequest.getResizeDirection());
            newRequest.setType(currRequest.getType());
            return newRequest;
        }
        return request;
    }
}

