/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.papyrusgmfgenextension.popupaction;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.codegen.ecore.genmodel.GenClass;
import org.eclipse.emf.codegen.ecore.genmodel.GenFeature;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.gmf.codegen.gmfgen.Behaviour;
import org.eclipse.gmf.codegen.gmfgen.CustomBehaviour;
import org.eclipse.gmf.codegen.gmfgen.CustomParser;
import org.eclipse.gmf.codegen.gmfgen.FeatureLabelModelFacet;
import org.eclipse.gmf.codegen.gmfgen.FigureViewmap;
import org.eclipse.gmf.codegen.gmfgen.GMFGenFactory;
import org.eclipse.gmf.codegen.gmfgen.GenChildNode;
import org.eclipse.gmf.codegen.gmfgen.GenDiagram;
import org.eclipse.gmf.codegen.gmfgen.GenEditorGenerator;
import org.eclipse.gmf.codegen.gmfgen.GenElementInitializer;
import org.eclipse.gmf.codegen.gmfgen.GenExpressionInterpreter;
import org.eclipse.gmf.codegen.gmfgen.GenExpressionProviderBase;
import org.eclipse.gmf.codegen.gmfgen.GenExpressionProviderContainer;
import org.eclipse.gmf.codegen.gmfgen.GenFeatureSeqInitializer;
import org.eclipse.gmf.codegen.gmfgen.GenFeatureValueSpec;
import org.eclipse.gmf.codegen.gmfgen.GenNode;
import org.eclipse.gmf.codegen.gmfgen.GenNodeLabel;
import org.eclipse.gmf.codegen.gmfgen.GenParserImplementation;
import org.eclipse.gmf.codegen.gmfgen.GenParsers;
import org.eclipse.gmf.codegen.gmfgen.GenTopLevelNode;
import org.eclipse.gmf.codegen.gmfgen.LabelModelFacet;
import org.eclipse.gmf.codegen.gmfgen.OpenDiagramBehaviour;
import org.eclipse.gmf.codegen.gmfgen.ParentAssignedViewmap;
import org.eclipse.gmf.codegen.gmfgen.StyleAttributes;
import org.eclipse.gmf.codegen.gmfgen.TypeModelFacet;
import org.eclipse.gmf.codegen.gmfgen.ValueExpression;
import org.eclipse.gmf.codegen.gmfgen.Viewmap;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.papyrus.papyrusgmfgenextension.popupaction.Action;
import org.eclipse.papyrus.papyrusgmfgenextension.popupaction.SetVisualIDWithUnusedValue;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class AddOrUpdateCommentEditParts
extends Action {
    protected List<String> messages = new ArrayList<String>();
    protected int modifiedElements = 0;
    protected List<GenTopLevelNode> topNodeComments = new ArrayList<GenTopLevelNode>();
    protected List<GenChildNode> childNodeComments = new ArrayList<GenChildNode>();
    protected CustomParser commentParser = null;
    final URI uri_UML2 = URI.createPlatformPluginURI((String)"org.eclipse.uml2.uml/model/UML.genmodel", (boolean)false);
    final URI uri_notation = URI.createPlatformPluginURI((String)"org.eclipse.gmf.runtime.notation/model/notation.genmodel", (boolean)false);

    public void run(IAction action) {
        NullProgressMonitor monitor = new NullProgressMonitor();
        this.messages.clear();
        this.modifiedElements = 0;
        boolean generateTopNode = true;
        boolean generateChildNode = true;
        for (EObject eObject : this.getSelectedEObject()) {
            if (eObject instanceof GenEditorGenerator) {
                monitor.beginTask("Retrieve existing comments", -1);
                this.retrieveTopNodeCommentEditPart((GenEditorGenerator)eObject, (IProgressMonitor)monitor);
                monitor.worked(1);
                this.retrieveChildNodeCommentEditPart((GenEditorGenerator)eObject, (IProgressMonitor)monitor);
                monitor.worked(1);
                this.retrieveCommentParser((GenEditorGenerator)eObject, (IProgressMonitor)monitor);
                monitor.worked(1);
            }
            if (this.commentParser == null) {
                this.commentParser = this.createCommentParser((GenEditorGenerator)eObject, (IProgressMonitor)monitor);
            }
            if (this.topNodeComments.isEmpty()) {
                generateTopNode = false;
            }
            if (this.childNodeComments.isEmpty()) {
                generateChildNode = false;
            }
            if (this.commentParser == null || this.topNodeComments.isEmpty() && generateTopNode || this.childNodeComments.isEmpty() && generateChildNode) {
                return;
            }
            this.updateCommentParser();
            if (generateTopNode) {
                this.updateTopLevelNodes();
            }
            if (generateChildNode) {
                this.updateChildNodes();
            }
            try {
                eObject.eResource().save(new HashMap());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            if (this.messages.isEmpty()) continue;
            MessageDialog.openInformation((Shell)Display.getCurrent().getActiveShell(), (String)"Information", (String)this.messages.toString());
        }
    }

    protected void updateChildNodes() {
        for (GenChildNode childNode : this.childNodeComments) {
            FigureViewmap figureViewmap = GMFGenFactory.eINSTANCE.createFigureViewmap();
            figureViewmap.setFigureQualifiedClassName("org.eclipse.papyrus.diagram.common.figure.node.HTMLCornerBentFigure");
            childNode.setViewmap((Viewmap)figureViewmap);
            this.updateBehaviours((GenNode)childNode);
            this.updateTypeModelFacet((GenNode)childNode);
            this.updateGenNodeLabel((GenNode)childNode);
            this.messages.add("update child: " + childNode);
        }
    }

    protected void updateGenNodeLabel(GenNode childNode) {
        int childVisualID = -1;
        String editPartClassName = "";
        String itemSemantic = "";
        if (childNode.getLabels().size() > 0) {
            childVisualID = ((GenNodeLabel)childNode.getLabels().get(0)).getVisualID();
            editPartClassName = ((GenNodeLabel)childNode.getLabels().get(0)).getEditPartClassName();
            itemSemantic = ((GenNodeLabel)childNode.getLabels().get(0)).getItemSemanticEditPolicyClassName();
            EcoreUtil.delete((EObject)((GenNodeLabel)childNode.getLabels().get(0)).getModelFacet());
            EcoreUtil.delete((EObject)((EObject)childNode.getLabels().get(0)));
        }
        if (childVisualID < 1) {
            childVisualID = SetVisualIDWithUnusedValue.getNewVisualID(childNode.eResource(), childNode.getClass());
        }
        if (editPartClassName == null || editPartClassName == "") {
            String parentEditPartClassName = childNode.getEditPartClassName();
            String number = parentEditPartClassName.substring("Comment".length(), parentEditPartClassName.length() - "EditPart".length());
            editPartClassName = "CommentBody" + (number == null ? "" : number) + "EditPart";
            itemSemantic = "CommentBody" + (number == null ? "" : number) + "ItemSemanticEditPolicy";
        }
        GenNodeLabel bodyGenNode = GMFGenFactory.eINSTANCE.createGenNodeLabel();
        bodyGenNode.setEditPartClassName(editPartClassName);
        bodyGenNode.setItemSemanticEditPolicyClassName(itemSemantic);
        bodyGenNode.setVisualID(childVisualID);
        GenClass nodeGenClass = this.findGenClassForNotation((EObject)childNode, "Node");
        bodyGenNode.setDiagramRunTimeClass(nodeGenClass);
        bodyGenNode.setElementIcon(false);
        bodyGenNode.setReadOnly(false);
        childNode.getLabels().add((Object)bodyGenNode);
        FeatureLabelModelFacet childModelFacet = GMFGenFactory.eINSTANCE.createFeatureLabelModelFacet();
        childModelFacet.setParser((GenParserImplementation)this.commentParser);
        GenFeature bodyFeature = this.findGenAttributeForMetaclass((EObject)childNode, "Comment", "body");
        childModelFacet.getMetaFeatures().add((Object)bodyFeature);
        bodyGenNode.setModelFacet((LabelModelFacet)childModelFacet);
        ParentAssignedViewmap viewMap = GMFGenFactory.eINSTANCE.createParentAssignedViewmap();
        viewMap.setGetterName("getCornerBentFigure");
        viewMap.setFigureQualifiedClassName("org.eclipse.papyrus.diagram.common.figure.node.HTMLCornerBentFigure");
        StyleAttributes styleAttribute = GMFGenFactory.eINSTANCE.createStyleAttributes();
        styleAttribute.setFixedBackground(false);
        styleAttribute.setFixedFont(true);
        styleAttribute.setFixedForeground(false);
        viewMap.getAttributes().add((Object)styleAttribute);
        bodyGenNode.setViewmap((Viewmap)viewMap);
    }

    protected void updateTypeModelFacet(GenNode childNode) {
        TypeModelFacet typeModelFacet = GMFGenFactory.eINSTANCE.createTypeModelFacet();
        GenClass commentMetaClass = this.findGenClassForMetaclass((EObject)childNode, "Comment");
        typeModelFacet.setMetaClass(commentMetaClass);
        GenFeature containmentMetaFeature = this.findGenAttributeForMetaclass((EObject)childNode, "Element", "ownedComment");
        typeModelFacet.setContainmentMetaFeature(containmentMetaFeature);
        GenFeature childMetaFeature = this.findGenAttributeForMetaclass((EObject)childNode, "Element", "ownedComment");
        typeModelFacet.setChildMetaFeature(childMetaFeature);
        GenFeatureSeqInitializer elementInitializer = GMFGenFactory.eINSTANCE.createGenFeatureSeqInitializer();
        GenFeatureValueSpec featureValueSpec = GMFGenFactory.eINSTANCE.createGenFeatureValueSpec();
        GenFeature bodyFeature = this.findGenAttributeForMetaclass((EObject)childNode, "Comment", "body");
        featureValueSpec.setFeature(bodyFeature);
        featureValueSpec.setValue(this.retrieveValueExpression(childNode));
        elementInitializer.getInitializers().add((Object)featureValueSpec);
        typeModelFacet.setModelElementInitializer((GenElementInitializer)elementInitializer);
    }

    protected ValueExpression retrieveValueExpression(GenNode childNode) {
        GenExpressionProviderBase base2;
        String expressionBody = "' '";
        GenExpressionProviderContainer expressionProviderContainer = childNode.getDiagram().getEditorGen().getExpressionProviders();
        for (GenExpressionProviderBase base2 : expressionProviderContainer.getProviders()) {
            if (!(base2 instanceof GenExpressionInterpreter)) continue;
            for (ValueExpression expression : ((GenExpressionInterpreter)base2).getExpressions()) {
                if (!"' '".equals(expression.getBody())) continue;
                return expression;
            }
        }
        base2 = null;
        for (GenExpressionProviderBase provider : expressionProviderContainer.getProviders()) {
            if (!(provider instanceof GenExpressionInterpreter)) continue;
            base2 = (GenExpressionInterpreter)provider;
        }
        if (base2 == null) {
            base2 = GMFGenFactory.eINSTANCE.createGenExpressionInterpreter();
            expressionProviderContainer.getProviders().add((Object)base2);
        }
        ValueExpression expression = GMFGenFactory.eINSTANCE.createValueExpression();
        expression.setBody("' '");
        base2.getExpressions().add((Object)expression);
        return expression;
    }

    protected void updateBehaviours(GenNode childNode) {
        boolean createOpenDiagramBehaviour = true;
        boolean createGraphicalNodeRole = false;
        boolean createStereotypeBehaviour = true;
        EList behaviours = childNode.getBehaviour();
        for (Behaviour behaviour : behaviours) {
            if (behaviour instanceof OpenDiagramBehaviour) {
                createOpenDiagramBehaviour = false;
                continue;
            }
            if (!(behaviour instanceof CustomBehaviour)) continue;
            if ("org.eclipse.gef.EditPolicy.GRAPHICAL_NODE_ROLE".equals(((CustomBehaviour)behaviour).getKey())) {
                createGraphicalNodeRole = false;
                continue;
            }
            if (!"org.eclipse.papyrus.diagram.common.editpolicies.AppliedStereotypeLabelDisplayEditPolicy.STEREOTYPE_LABEL_POLICY".equals(((CustomBehaviour)behaviour).getKey())) continue;
            createStereotypeBehaviour = false;
        }
        if (createGraphicalNodeRole) {
            CustomBehaviour customBehaviour = GMFGenFactory.eINSTANCE.createCustomBehaviour();
            customBehaviour.setEditPolicyQualifiedClassName("");
            customBehaviour.setKey("org.eclipse.gef.EditPolicy.GRAPHICAL_NODE_ROLE");
            childNode.getBehaviour().add((Object)customBehaviour);
        }
        if (createStereotypeBehaviour) {
            CustomBehaviour stereotypeBehaviour = GMFGenFactory.eINSTANCE.createCustomBehaviour();
            stereotypeBehaviour.setEditPolicyQualifiedClassName("org.eclipse.papyrus.diagram.common.editpolicies.AppliedStereotypeNodeLabelDisplayEditPolicy");
            stereotypeBehaviour.setKey("org.eclipse.papyrus.diagram.common.editpolicies.AppliedStereotypeLabelDisplayEditPolicy.STEREOTYPE_LABEL_POLICY");
            childNode.getBehaviour().add((Object)stereotypeBehaviour);
        }
    }

    protected void updateTopLevelNodes() {
        for (GenTopLevelNode node : this.topNodeComments) {
            FigureViewmap figureViewmap = GMFGenFactory.eINSTANCE.createFigureViewmap();
            figureViewmap.setFigureQualifiedClassName("org.eclipse.papyrus.diagram.common.figure.node.HTMLCornerBentFigure");
            node.setViewmap((Viewmap)figureViewmap);
            this.updateBehaviours((GenNode)node);
            this.updateTypeModelFacet((GenNode)node);
            this.updateGenNodeLabel((GenNode)node);
            this.messages.add("update top: " + node);
        }
    }

    protected void updateCommentParser() {
        if (!"org.eclipse.papyrus.diagram.common.parser.CommentParser".equals(this.commentParser.getQualifiedName())) {
            this.commentParser.setQualifiedName("org.eclipse.papyrus.diagram.common.parser.CommentParser");
        }
        if (this.commentParser.isGenerateBoilerplate()) {
            this.commentParser.setGenerateBoilerplate(false);
        }
    }

    protected CustomParser createCommentParser(GenEditorGenerator editorGenerator, IProgressMonitor monitor) {
        GenParsers parsers = editorGenerator.getLabelParsers();
        if (parsers == null) {
            MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)"Impossible to find the parsers associated to this editor", (String)"No parser container was found for this editor. \n\nYou should create the parsers container before running this action");
        }
        CustomParser parser = GMFGenFactory.eINSTANCE.createCustomParser();
        parsers.getImplementations().add((Object)parser);
        return parser;
    }

    protected void createTopNodeComment(GenEditorGenerator editorGenerator, IProgressMonitor monitor) {
        GenDiagram diagram = editorGenerator.getDiagram();
        if (diagram == null) {
            return;
        }
        GenTopLevelNode topNode = GMFGenFactory.eINSTANCE.createGenTopLevelNode();
        diagram.getTopLevelNodes().add((Object)topNode);
        this.topNodeComments.add(topNode);
    }

    protected void createChildNodeComment(GenEditorGenerator editorGenerator, IProgressMonitor monitor) {
        GenDiagram diagram = editorGenerator.getDiagram();
        if (diagram == null) {
            return;
        }
        GenChildNode childNode = GMFGenFactory.eINSTANCE.createGenChildNode();
        diagram.getChildNodes().add((Object)childNode);
        this.childNodeComments.add(childNode);
    }

    protected void retrieveTopNodeCommentEditPart(GenEditorGenerator editorGenerator, IProgressMonitor monitor) {
        GenDiagram diagram = editorGenerator.getDiagram();
        if (diagram == null) {
            MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)"Impossible to find the diagram associated to this editor", (String)"No diagram was found for this editor. \n\nYou should create one diagram before running this action");
        }
        GenClass commentGenClass = this.findGenClassForMetaclass((EObject)editorGenerator, "Comment");
        for (GenTopLevelNode topLevelNode : diagram.getTopLevelNodes()) {
            TypeModelFacet modelFacet = topLevelNode.getModelFacet();
            if (modelFacet == null || modelFacet.getMetaClass() == null || !commentGenClass.equals(modelFacet.getMetaClass())) continue;
            this.topNodeComments.add(topLevelNode);
        }
    }

    protected void retrieveChildNodeCommentEditPart(GenEditorGenerator editorGenerator, IProgressMonitor monitor) {
        GenDiagram diagram = editorGenerator.getDiagram();
        if (diagram == null) {
            MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)"Impossible to find the diagram associated to this editor", (String)"No diagram was found for this editor. \n\nYou should create one diagram before running this action");
        }
        GenClass commentGenClass = this.findGenClassForMetaclass((EObject)editorGenerator, "Comment");
        for (GenChildNode childNode : diagram.getChildNodes()) {
            TypeModelFacet modelFacet = childNode.getModelFacet();
            if (modelFacet == null || modelFacet.getMetaClass() == null || !commentGenClass.equals(modelFacet.getMetaClass())) continue;
            this.childNodeComments.add(childNode);
        }
    }

    protected void retrieveCommentParser(GenEditorGenerator editorGenerator, IProgressMonitor monitor) {
        GenParsers parsers = editorGenerator.getLabelParsers();
        if (parsers == null) {
            MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)"Impossible to find the parsers associated to this editor", (String)"No parser container was found for this editor. \n\nYou should create the parsers container before running this action");
        }
        for (GenParserImplementation parserImplementation : parsers.getImplementations()) {
            if (!(parserImplementation instanceof CustomParser) || !"org.eclipse.papyrus.diagram.common.parser.CommentParser".equals(((CustomParser)parserImplementation).getQualifiedName())) continue;
            this.commentParser = (CustomParser)parserImplementation;
        }
    }

    protected GenClass findGenClassForMetaclass(EObject eObject, String name) {
        Resource notation = eObject.eResource().getResourceSet().getResource(this.uri_UML2, true);
        return this.findGenClass(notation, name);
    }

    protected GenClass findGenClassForNotation(EObject eObject, String name) {
        Resource notation = eObject.eResource().getResourceSet().getResource(this.uri_notation, true);
        return this.findGenClass(notation, name);
    }

    protected GenFeature findGenAttributeForMetaclass(EObject eObject, String genClassName, String genFeatureName) {
        Resource notation = eObject.eResource().getResourceSet().getResource(this.uri_UML2, true);
        return this.findGenFeature(notation, genClassName, genFeatureName);
    }
}

