/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.sequence.edit.parts;

import java.util.List;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.PolylineShape;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.PrecisionPoint;
import org.eclipse.draw2d.geometry.PrecisionRectangle;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editpolicies.LayoutEditPolicy;
import org.eclipse.gef.editpolicies.NonResizableEditPolicy;
import org.eclipse.gef.handles.HandleBounds;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.gef.requests.ReconnectRequest;
import org.eclipse.gmf.runtime.diagram.core.util.ViewUtil;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IBorderItemEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.ResizableShapeEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.figures.IBorderItemLocator;
import org.eclipse.gmf.runtime.diagram.ui.render.editparts.RenderedDiagramRootEditPart;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateConnectionViewRequest;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateUnspecifiedTypeRequest;
import org.eclipse.gmf.runtime.draw2d.ui.geometry.PointListUtilities;
import org.eclipse.gmf.runtime.draw2d.ui.mapmode.IMapMode;
import org.eclipse.gmf.runtime.draw2d.ui.mapmode.MapModeUtil;
import org.eclipse.gmf.runtime.emf.type.core.IHintedType;
import org.eclipse.gmf.runtime.gef.ui.figures.DefaultSizeNodeFigure;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.papyrus.infra.gmfdiag.common.editpart.IPapyrusEditPart;
import org.eclipse.papyrus.uml.diagram.common.draw2d.LinesBorder;
import org.eclipse.papyrus.uml.diagram.common.helper.PreferenceInitializerForElementHelper;
import org.eclipse.papyrus.uml.diagram.common.locator.ExternalLabelPositionLocator;
import org.eclipse.papyrus.uml.diagram.sequence.edit.helpers.AnchorHelper;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.CommentAnnotatedElementEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.CustomCommentAnnotatedElementEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.DurationConstraintAppliedStereotypeEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.DurationConstraintEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.DurationConstraintLabelEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.LifelineEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.policies.AppliedStereotypeCommentCreationEditPolicyEx;
import org.eclipse.papyrus.uml.diagram.sequence.edit.policies.ExternalLabelPrimaryDragRoleEditPolicy;
import org.eclipse.papyrus.uml.diagram.sequence.figures.DurationConstraintFigure;
import org.eclipse.papyrus.uml.diagram.sequence.part.UMLDiagramEditorPlugin;
import org.eclipse.papyrus.uml.diagram.sequence.part.UMLVisualIDRegistry;
import org.eclipse.papyrus.uml.diagram.sequence.providers.UMLElementTypes;
import org.eclipse.papyrus.uml.diagram.sequence.util.SequenceUtil;
import org.eclipse.uml2.uml.DurationConstraint;
import org.eclipse.uml2.uml.InteractionFragment;
import org.eclipse.uml2.uml.MessageOccurrenceSpecification;

public class CustomDurationConstraintEditPart
extends DurationConstraintEditPart
implements IPapyrusEditPart {
    private static final String ARROW = "Arrow";
    private static final String DIRECTION = "Direction";
    private static final String VERTICAL = "vertical";
    private static final String HORIZONTAL = "horizontal";

    public CustomDurationConstraintEditPart(View view) {
        super(view);
    }

    @Override
    protected void createDefaultEditPolicies() {
        super.createDefaultEditPolicies();
        this.installEditPolicy("AppliedStereotypeComment", (EditPolicy)new AppliedStereotypeCommentCreationEditPolicyEx());
    }

    public ConnectionAnchor getSourceConnectionAnchor(Request request) {
        ConnectionEditPart linkPart;
        IHintedType type = (IHintedType)UMLElementTypes.Comment_AnnotatedElementEdge;
        if (request instanceof CreateConnectionViewRequest) {
            String hint = ((CreateConnectionViewRequest)request).getConnectionViewDescriptor().getSemanticHint();
            if (hint.equals(type.getSemanticHint())) {
                return new RotateAnchor(this.getFigure(), this.computeAnchorLocation(((CreateConnectionViewRequest)request).getLocation()));
            }
        } else if (request instanceof ReconnectRequest && (linkPart = ((ReconnectRequest)request).getConnectionEditPart()) instanceof CommentAnnotatedElementEditPart) {
            return new RotateAnchor(this.getFigure(), this.computeAnchorLocation(((ReconnectRequest)request).getLocation()));
        }
        return super.getSourceConnectionAnchor(request);
    }

    protected int computeAnchorLocation(Point location) {
        Rectangle box = this.getBox();
        if (this.isArrowVertical()) {
            if (location.getDistance2(box.getTop()) > location.getDistance2(box.getBottom())) {
                return 32;
            }
            return 8;
        }
        if (location.getDistance2(box.getLeft()) > location.getDistance2(box.getRight())) {
            return 4;
        }
        return 1;
    }

    protected Rectangle getBox() {
        PrecisionRectangle rBox = this.getFigure() instanceof HandleBounds ? new PrecisionRectangle(((HandleBounds)this.getFigure()).getHandleBounds()) : new PrecisionRectangle(this.getFigure().getBounds());
        this.getFigure().translateToAbsolute((Translatable)rBox);
        return rBox;
    }

    public boolean canCreateLink(Point point) {
        DurationConstraint dc = (DurationConstraint)this.resolveSemanticElement();
        int count = 0;
        List list = this.getSourceConnections();
        for (Object o : list) {
            if (!(o instanceof CustomCommentAnnotatedElementEditPart)) continue;
            ++count;
        }
        if (count >= 2) {
            return false;
        }
        if (count < 1) {
            return true;
        }
        int targetPosition = this.computeAnchorLocation(point);
        return !this.findLinkAtPosition(targetPosition);
    }

    public boolean hasTopLink() {
        return this.findLinkAtPosition(8);
    }

    public boolean hasBottomLink() {
        return this.findLinkAtPosition(32);
    }

    protected boolean findLinkAtPosition(int targetPos) {
        List list = this.getSourceConnections();
        for (Object o : list) {
            CustomCommentAnnotatedElementEditPart connPart;
            if (!(o instanceof CustomCommentAnnotatedElementEditPart) || (targetPos & this.getSourceAnchorPosition(connPart = (CustomCommentAnnotatedElementEditPart)((Object)o))) <= 0) continue;
            return true;
        }
        return false;
    }

    public ConnectionAnchor getSourceConnectionAnchor(ConnectionEditPart connEditPart) {
        Object anchor = null;
        anchor = connEditPart instanceof CommentAnnotatedElementEditPart ? new RotateAnchor(this.getFigure(), this.getSourceAnchorPosition((CommentAnnotatedElementEditPart)connEditPart)) : super.getSourceConnectionAnchor(connEditPart);
        return anchor;
    }

    private int getSourceAnchorPosition(CommentAnnotatedElementEditPart connEditPart) {
        String terminal = AnchorHelper.getAnchorId(this.getEditingDomain(), (ConnectionEditPart)connEditPart, true);
        if (terminal.length() > 0) {
            return this.parseLocation(terminal);
        }
        return 8;
    }

    protected void refreshBounds() {
        super.refreshBounds();
        int width = (Integer)this.getStructuralFeatureValue((EStructuralFeature)NotationPackage.eINSTANCE.getSize_Width());
        int height = (Integer)this.getStructuralFeatureValue((EStructuralFeature)NotationPackage.eINSTANCE.getSize_Height());
        if (width == -1) {
            width = this.getFigure().getPreferredSize().width;
        }
        if (height == -1) {
            height = this.getFigure().getPreferredSize().height;
        }
        if (width != -1 && height != -1) {
            Dimension size = this.primaryShape.getBounds().getSize();
            this.primaryShape.setBounds(new Rectangle(this.primaryShape.getBounds().getLocation(), new Dimension(width, height)));
        }
        this.getFigure().getParent().getLayoutManager().layout(this.getFigure().getParent());
        this.relocateLabelEditPart();
    }

    @Override
    protected IFigure createNodeShape() {
        this.primaryShape = new CustomDurationConstraintFigure();
        return this.primaryShape;
    }

    @Override
    protected IFigure setupContentPane(IFigure nodeShape) {
        nodeShape = super.setupContentPane(nodeShape);
        DefaultSizeNodeFigure parent = (DefaultSizeNodeFigure)nodeShape.getParent();
        nodeShape.setPreferredSize(parent.getDefaultSize());
        return nodeShape;
    }

    public EditPolicy getPrimaryDragEditPolicy() {
        EditPolicy policy = this.getEditPolicy("PrimaryDrag Policy");
        return policy != null ? policy : new ResizableShapeEditPolicy(){

            protected Command getResizeCommand(ChangeBoundsRequest request) {
                ChangeBoundsRequest req = new ChangeBoundsRequest((Object)"resize children");
                req.setEditParts(this.getHost());
                req.setMoveDelta(request.getMoveDelta());
                req.setSizeDelta(request.getSizeDelta());
                req.setLocation(request.getLocation());
                req.setExtendedData(request.getExtendedData());
                req.setResizeDirection(request.getResizeDirection());
                return this.getHost().getParent().getCommand((Request)req);
            }

            protected void showChangeBoundsFeedback(ChangeBoundsRequest request) {
                IFigure feedback = this.getDragSourceFeedbackFigure();
                PrecisionRectangle rect = new PrecisionRectangle(this.getInitialFeedbackBounds().getCopy());
                this.getHostFigure().translateToAbsolute((Translatable)rect);
                rect.translate(request.getMoveDelta());
                rect.resize(request.getSizeDelta());
                IFigure f = this.getHostFigure();
                Dimension max = f.getMaximumSize().getCopy();
                IMapMode mmode = MapModeUtil.getMapMode((IFigure)f);
                max.height = mmode.LPtoDP(max.height);
                max.width = mmode.LPtoDP(max.width);
                if (max.width < rect.width) {
                    rect.width = max.width;
                }
                if (max.height < rect.height) {
                    rect.height = max.height;
                }
                feedback.translateToRelative((Translatable)rect);
                feedback.setBounds((Rectangle)rect);
            }
        };
    }

    @Override
    protected LayoutEditPolicy createLayoutEditPolicy() {
        org.eclipse.gmf.runtime.diagram.ui.editpolicies.LayoutEditPolicy lep = new org.eclipse.gmf.runtime.diagram.ui.editpolicies.LayoutEditPolicy(){

            protected EditPolicy createChildEditPolicy(EditPart child) {
                View childView = (View)child.getModel();
                switch (UMLVisualIDRegistry.getVisualID(childView)) {
                    case "DurationConstraint_BodyLabel": 
                    case "DurationConstraint_StereotypeLabel": {
                        return new ExternalLabelPrimaryDragRoleEditPolicy();
                    }
                }
                EditPolicy result = child.getEditPolicy((Object)"PrimaryDrag Policy");
                if (result == null) {
                    result = new NonResizableEditPolicy();
                }
                return result;
            }

            protected Command getMoveChildrenCommand(Request request) {
                return null;
            }

            protected Command getCreateCommand(CreateRequest request) {
                return null;
            }
        };
        return lep;
    }

    @Override
    protected void addBorderItem(IFigure borderItemContainer, IBorderItemEditPart borderItemEditPart) {
        if (borderItemEditPart instanceof DurationConstraintLabelEditPart) {
            DurationConstraintLabelLocator locator = new DurationConstraintLabelLocator(this.getMainFigure());
            locator.setParentEditPart(this);
            borderItemContainer.add(borderItemEditPart.getFigure(), (Object)locator);
        } else if (borderItemEditPart instanceof DurationConstraintAppliedStereotypeEditPart) {
            ExternalLabelPositionLocator locator = new ExternalLabelPositionLocator(this.getMainFigure());
            borderItemContainer.add(borderItemEditPart.getFigure(), (Object)locator);
        } else {
            super.addBorderItem(borderItemContainer, borderItemEditPart);
        }
    }

    public Command getCommand(Request request) {
        if (request instanceof CreateUnspecifiedTypeRequest) {
            return this.getParent().getCommand(request);
        }
        return super.getCommand(request);
    }

    public void showSourceFeedback(Request request) {
        if (request instanceof CreateUnspecifiedTypeRequest) {
            this.getParent().showSourceFeedback(request);
        }
        super.showSourceFeedback(request);
    }

    public void eraseSourceFeedback(Request request) {
        if (request instanceof CreateUnspecifiedTypeRequest) {
            this.getParent().eraseSourceFeedback(request);
        }
        super.eraseSourceFeedback(request);
    }

    protected void handleNotificationEvent(Notification notification) {
        super.handleNotificationEvent(notification);
        Object feature = notification.getFeature();
        if (this.getModel() != null && this.getModel() == notification.getNotifier() && NotationPackage.eINSTANCE.getLineStyle_LineWidth().equals(feature)) {
            this.refreshLineWidth();
        }
        if (notification.getNewValue() instanceof EAnnotation && ARROW.equals(((EAnnotation)notification.getNewValue()).getSource())) {
            this.refreshArrowDirection((EAnnotation)notification.getNewValue());
        } else if (notification.getNotifier() instanceof EAnnotation && ARROW.equals(((EAnnotation)notification.getNotifier()).getSource())) {
            this.refreshArrowDirection((EAnnotation)notification.getNotifier());
        }
    }

    protected void refreshVisuals() {
        super.refreshVisuals();
        this.refreshArrowDirection(null);
        this.refreshLineWidth();
    }

    private void relocateLabelEditPart() {
        List list = this.getChildren();
        for (Object o : list) {
            DurationConstraintLabelEditPart label;
            if (!(o instanceof DurationConstraintLabelEditPart) || (label = (DurationConstraintLabelEditPart)((Object)o)).getBorderItemLocator() == null) continue;
            IBorderItemLocator loc = label.getBorderItemLocator();
            loc.relocate(label.getFigure());
        }
    }

    public Rectangle updateMoveBounds(Rectangle newBounds) {
        if (this.getCurrentSideOfParent() == 8) {
            Rectangle bounds = this.getFigure().getBounds();
            return newBounds.translate(-bounds.width, 0);
        }
        return newBounds;
    }

    public int getCurrentSideOfParent() {
        IBorderItemLocator locator = this.getBorderItemLocator();
        if (locator != null) {
            return locator.getCurrentSideOfParent();
        }
        return 16;
    }

    public static Rectangle fixMessageBounds(Rectangle newBounds, Request cvr, LifelineEditPart host) {
        Object oc1 = CustomDurationConstraintEditPart.getFirstElement(cvr.getExtendedData().get("Nearest occurrence specification"));
        Object oc2 = CustomDurationConstraintEditPart.getFirstElement(cvr.getExtendedData().get("Nearest occurrence specification (end)"));
        if (oc1 != null && oc2 != null && (oc1 instanceof MessageOccurrenceSpecification || oc2 instanceof MessageOccurrenceSpecification)) {
            Point start = null;
            Point end = null;
            Rectangle bounds = null;
            if (oc1 instanceof InteractionFragment) {
                start = SequenceUtil.findLocationOfEvent(host, (InteractionFragment)oc1, true);
            }
            if (oc2 instanceof InteractionFragment) {
                end = SequenceUtil.findLocationOfEvent(host, (InteractionFragment)oc2, true);
            }
            if (start != null && end != null) {
                Rectangle rectangle = bounds = start.y < end.y ? new Rectangle(start, end) : new Rectangle(end, start);
            }
            if (bounds != null) {
                IFigure parentFigure = host.getFigure();
                Point parentFigDelta = parentFigure.getBounds().getLocation().getCopy().negate();
                parentFigure.translateToRelative((Translatable)bounds);
                bounds.translate(parentFigDelta);
                if (bounds.y != newBounds.y || newBounds.height != bounds.height) {
                    newBounds.y = bounds.y;
                    newBounds.height = bounds.height;
                }
            }
        }
        return newBounds;
    }

    static Object getFirstElement(Object obj) {
        List list;
        if (obj != null && obj instanceof List && (list = (List)obj).size() > 0) {
            return list.get(0);
        }
        return null;
    }

    protected void refreshArrowDirection(EAnnotation newValue) {
        CustomDurationConstraintFigure dc = (CustomDurationConstraintFigure)this.getPrimaryShape();
        dc.setVertical(this.isArrowVertical());
        this.refreshBounds();
    }

    public void setArrowDirection(String dir) {
        View view = this.getNotationView();
        if (view == null) {
            return;
        }
        EAnnotation ea = view.getEAnnotation(ARROW);
        if (ea == null) {
            ea = EcoreFactory.eINSTANCE.createEAnnotation();
            ea.setSource(ARROW);
            ea.getDetails().put((Object)DIRECTION, (Object)dir);
            view.getEAnnotations().add((Object)ea);
        } else {
            ea.getDetails().clear();
            ea.getDetails().put((Object)DIRECTION, (Object)dir);
        }
    }

    public String getArrowDirection() {
        String pos;
        View view = this.getNotationView();
        if (view == null) {
            return "";
        }
        EAnnotation ea = view.getEAnnotation(ARROW);
        if (ea != null && (pos = (String)ea.getDetails().get((Object)DIRECTION)) != null) {
            return pos;
        }
        return VERTICAL;
    }

    public boolean isArrowVertical() {
        return VERTICAL.equals(this.getArrowDirection());
    }

    public void rotateArrow() {
        if (this.isArrowVertical()) {
            this.setArrowDirection(HORIZONTAL);
        } else {
            this.setArrowDirection(VERTICAL);
        }
    }

    private Object getStructuralFeatureValue(View view, EStructuralFeature feature) {
        return ViewUtil.getPropertyValue((View)view, (EStructuralFeature)feature, (EClass)feature.getEContainingClass());
    }

    public Rectangle getBounds() {
        View view = this.getNotationView();
        int width = (Integer)this.getStructuralFeatureValue(view, (EStructuralFeature)NotationPackage.eINSTANCE.getSize_Width());
        int height = (Integer)this.getStructuralFeatureValue(view, (EStructuralFeature)NotationPackage.eINSTANCE.getSize_Height());
        int x = (Integer)this.getStructuralFeatureValue(view, (EStructuralFeature)NotationPackage.eINSTANCE.getLocation_X());
        int y = (Integer)this.getStructuralFeatureValue(view, (EStructuralFeature)NotationPackage.eINSTANCE.getLocation_Y());
        String prefElementId = ViewUtil.resolveSemanticElement((View)view).eClass().getName();
        IPreferenceStore store = UMLDiagramEditorPlugin.getInstance().getPreferenceStore();
        String preferenceConstantWitdh = PreferenceInitializerForElementHelper.getpreferenceKey((View)view, (String)prefElementId, (int)17);
        String preferenceConstantHeight = PreferenceInitializerForElementHelper.getpreferenceKey((View)view, (String)prefElementId, (int)16);
        if (width <= 0) {
            width = store.getInt(preferenceConstantWitdh);
        }
        if (height <= 0) {
            height = store.getInt(preferenceConstantHeight);
        }
        return new Rectangle(x, y, width, height);
    }

    private int parseLocation(String terminal) {
        int start;
        if (terminal.length() > 0 && (start = terminal.indexOf("{") + 1) > 0) {
            char ch = Character.toUpperCase(terminal.charAt(start));
            switch (ch) {
                case 'L': {
                    return 1;
                }
                case 'R': {
                    return 4;
                }
                case 'D': {
                    return 32;
                }
            }
            return 8;
        }
        return 8;
    }

    public class CustomDurationConstraintFigure
    extends DurationConstraintFigure {
        private static final int ARROW_HEIGHT = 8;
        private static final int ARROW_SEMI_WIDTH = 7;
        boolean vertical = true;

        public CustomDurationConstraintFigure() {
            this.setBorder(this.createBorder0());
            this.setDashBorder();
        }

        private Border createBorder0() {
            LinesBorder result = new LinesBorder(){

                public void paint(IFigure figure, Graphics graphics, Insets insets) {
                    tempRect.setBounds(1.getPaintRectangle((IFigure)figure, (Insets)insets));
                    int one = MapModeUtil.getMapMode((IFigure)figure).DPtoLP(1);
                    int widthInDP = this.getWidth() / one;
                    int halfWidthInLP = MapModeUtil.getMapMode((IFigure)figure).DPtoLP(widthInDP / 2);
                    graphics.setLineWidth(this.getWidth());
                    graphics.setLineStyle(this.getStyle());
                    1.tempRect.x += halfWidthInLP;
                    1.tempRect.width -= this.getWidth();
                    1.tempRect.y += halfWidthInLP;
                    1.tempRect.height -= this.getWidth();
                    if ((this.getPositions() & 8) > 0) {
                        graphics.drawLine(new Point(tempRect.getTopLeft().x(), tempRect.getTopLeft().y() + 1), new Point(tempRect.getTopRight().x(), tempRect.getTopRight().y() + 1));
                    }
                    if ((this.getPositions() & 1) > 0) {
                        graphics.drawLine(new Point(tempRect.getTopLeft().x() + 1, tempRect.getTopLeft().y()), new Point(tempRect.getBottomLeft().x() + 1, tempRect.getBottomLeft().y()));
                    }
                    if ((this.getPositions() & 0x20) > 0) {
                        graphics.drawLine(tempRect.getBottomLeft(), tempRect.getBottomRight());
                    }
                    if ((this.getPositions() & 4) > 0) {
                        graphics.drawLine(tempRect.getTopRight(), tempRect.getBottomRight());
                    }
                }
            };
            result.setSides(40);
            return result;
        }

        protected void setDashBorder() {
            if (this.getBorder() instanceof LinesBorder) {
                LinesBorder lb = (LinesBorder)this.getBorder();
                lb.setStyle(2);
                if (this.vertical) {
                    lb.setSides(40);
                } else {
                    lb.setSides(5);
                }
            }
        }

        public Insets getInsets() {
            if (this.getBorder() != null) {
                return this.getBorder().getInsets((IFigure)this);
            }
            return NO_INSETS;
        }

        public void setVertical(boolean val) {
            if (val != this.vertical) {
                this.vertical = val;
                this.setDashBorder();
                this.revalidate();
            }
        }

        public void setBounds(Rectangle rect) {
            this.updateArrow(rect.width, rect.height);
            Rectangle c = rect.getCopy();
            this.getParent().translateToAbsolute((Translatable)c);
            super.setBounds(rect);
        }

        public void updateArrow(int figureWidth, int figureHeight) {
            figureWidth -= this.getInsets().left + this.getInsets().right;
            figureHeight -= this.getInsets().top + this.getInsets().bottom;
            if (this.getDurationArrow() != null) {
                int halfLineWidth = this.getLineWidth() / 2;
                if (this.vertical) {
                    PointList points = new PointList(8);
                    int centerX = figureWidth / 2;
                    points.addPoint(centerX - 7, halfLineWidth + 8);
                    points.addPoint(centerX, halfLineWidth);
                    points.addPoint(centerX + 7, halfLineWidth + 8);
                    points.addPoint(centerX, halfLineWidth);
                    points.addPoint(centerX, figureHeight - halfLineWidth);
                    points.addPoint(centerX - 7, figureHeight - halfLineWidth - 8);
                    points.addPoint(centerX, figureHeight - halfLineWidth);
                    points.addPoint(centerX + 7, figureHeight - halfLineWidth - 8);
                    this.getDurationArrow().setPoints(points);
                    Point topLeft = this.getLocation().getTranslated(this.getInsets().left, this.getInsets().top);
                    this.getDurationArrow().setBounds(new Rectangle(topLeft, new Dimension(figureWidth, figureHeight)));
                } else {
                    PointList points = new PointList(8);
                    int centerY = figureHeight / 2;
                    points.addPoint(halfLineWidth + 8, centerY - 7);
                    points.addPoint(halfLineWidth, centerY);
                    points.addPoint(halfLineWidth + 8, centerY + 7);
                    points.addPoint(halfLineWidth, centerY);
                    points.addPoint(figureWidth - halfLineWidth, centerY);
                    points.addPoint(figureWidth - halfLineWidth - 8, centerY - 7);
                    points.addPoint(figureWidth - halfLineWidth, centerY);
                    points.addPoint(figureWidth - halfLineWidth - 8, centerY + 7);
                    this.getDurationArrow().setPoints(points);
                    Point topLeft = this.getLocation().getTranslated(this.getInsets().left, this.getInsets().top);
                    this.getDurationArrow().setBounds(new Rectangle(topLeft, new Dimension(figureWidth, figureHeight)));
                }
            }
        }

        public boolean containsPoint(int x, int y) {
            boolean containsPoint = super.containsPoint(x, y);
            if (!containsPoint) {
                return false;
            }
            PolylineShape durationArrow = this.getDurationArrow();
            if (durationArrow != null) {
                return PointListUtilities.containsPoint((PointList)durationArrow.getPoints(), (Point)new Point(x, y));
            }
            return containsPoint;
        }

        public void paintFigure(Graphics graphics) {
            graphics.setLineWidth(this.lineWidth);
            super.paintFigure(graphics);
        }

        public void setLineWidth(int w) {
            LinesBorder lb = (LinesBorder)this.getBorder();
            lb.setWidth(w);
            this.getDurationArrow().setLineWidth(w);
            super.setLineWidth(w);
        }
    }

    static class DurationConstraintLabelLocator
    extends ExternalLabelPositionLocator {
        private CustomDurationConstraintEditPart durationConstraintEditPart;

        public DurationConstraintLabelLocator(IFigure mainFigure) {
            super(mainFigure);
        }

        public void setParentEditPart(CustomDurationConstraintEditPart durationConstraintEditPart) {
            this.durationConstraintEditPart = durationConstraintEditPart;
        }

        public void relocate(IFigure target) {
            if (this.constraint.y == 0) {
                if (this.durationConstraintEditPart.getCurrentSideOfParent() == 8) {
                    Point r = this.parentFigure.getBounds().getLeft().translate(-20, -5);
                    target.setBounds(new Rectangle(r, target.getPreferredSize()));
                } else {
                    Point r = this.parentFigure.getBounds().getRight().translate(5, -5);
                    target.setBounds(new Rectangle(r, target.getPreferredSize()));
                }
            } else {
                super.relocate(target);
            }
        }
    }

    class RotateAnchor
    extends AnchorHelper.FixedAnchorEx {
        public RotateAnchor(IFigure f, int location) {
            super(f, location);
        }

        @Override
        public Point getLocation(Point reference) {
            double zoom = 0.0;
            if (CustomDurationConstraintEditPart.this.getRoot() instanceof RenderedDiagramRootEditPart) {
                RenderedDiagramRootEditPart render = (RenderedDiagramRootEditPart)CustomDurationConstraintEditPart.this.getRoot();
                zoom = render.getZoomManager().getZoom();
            }
            if (this.position == 8) {
                return new PrecisionPoint(this.getBox().getTop().preciseX(), this.getBox().getTop().preciseY() + 1.0 * zoom);
            }
            if (this.position == 32) {
                if (zoom > 1.0) {
                    zoom -= 1.0;
                }
                return new PrecisionPoint(this.getBox().getBottom().preciseX(), this.getBox().getBottom().preciseY() - 1.0 * zoom);
            }
            if (this.position == 1) {
                if (zoom > 1.0) {
                    zoom -= 1.0;
                }
                return new PrecisionPoint(this.getBox().getLeft().preciseX(), this.getBox().getLeft().preciseY() + 1.0 * zoom);
            }
            if (this.position == 4) {
                if (zoom > 1.0) {
                    zoom -= 1.0;
                }
                return new PrecisionPoint(this.getBox().getRight().preciseX(), this.getBox().getRight().preciseY() + 1.0 * zoom);
            }
            return super.getLocation(reference);
        }

        @Override
        public String getTerminal() {
            if (this.isDefaultAnchor()) {
                return "";
            }
            if (this.position == 8) {
                return "(0.5,0){T}";
            }
            if (this.position == 32) {
                return "(0.5,1){D}";
            }
            if (this.position == 1) {
                return "(0,0.5){L}";
            }
            if (this.position == 4) {
                return "(1,0.5){R}";
            }
            return "(0.5,0){T}";
        }
    }

    public static class RotateArrowCommand
    extends RecordingCommand {
        private CustomDurationConstraintEditPart part;

        public RotateArrowCommand(TransactionalEditingDomain domain, CustomDurationConstraintEditPart part) {
            super(domain);
            this.part = part;
        }

        protected void doExecute() {
            List list = this.part.getSourceConnections();
            if (this.part.isArrowVertical()) {
                this.part.setArrowDirection(CustomDurationConstraintEditPart.HORIZONTAL);
            } else {
                this.part.setArrowDirection(CustomDurationConstraintEditPart.VERTICAL);
            }
        }
    }
}

