/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.databinding.conversion.text;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.Format;
import org.eclipse.core.internal.databinding.conversion.AbstractStringToNumberConverter;
import org.eclipse.core.internal.databinding.conversion.StringToNumberParser;

public final class StringToNumberConverter<T extends Number>
extends AbstractStringToNumberConverter<T> {
    private StringToNumberConverter(Format numberFormat, Class<T> toType, Number min, Number max, Class<T> boxedType) {
        super(numberFormat, toType, min, max, boxedType);
    }

    public static StringToNumberConverter<Integer> toInteger(boolean primitive) {
        return StringToNumberConverter.toInteger(StringToNumberParser.getDefaultIntegerFormat(), primitive);
    }

    public static StringToNumberConverter<Integer> toInteger(Format numberFormat, boolean primitive) {
        return new StringToNumberConverter<Integer>(numberFormat, primitive ? Integer.TYPE : Integer.class, MIN_INTEGER, MAX_INTEGER, Integer.class);
    }

    public static StringToNumberConverter<Double> toDouble(boolean primitive) {
        return StringToNumberConverter.toDouble(StringToNumberParser.getDefaultFormat(), primitive);
    }

    public static StringToNumberConverter<Double> toDouble(Format numberFormat, boolean primitive) {
        return new StringToNumberConverter<Double>(numberFormat, primitive ? Double.TYPE : Double.class, MIN_DOUBLE, MAX_DOUBLE, Double.class);
    }

    public static StringToNumberConverter<Long> toLong(boolean primitive) {
        return StringToNumberConverter.toLong(StringToNumberParser.getDefaultIntegerFormat(), primitive);
    }

    public static StringToNumberConverter<Long> toLong(Format numberFormat, boolean primitive) {
        return new StringToNumberConverter<Long>(numberFormat, primitive ? Long.TYPE : Long.class, MIN_LONG, MAX_LONG, Long.class);
    }

    public static StringToNumberConverter<Float> toFloat(boolean primitive) {
        return StringToNumberConverter.toFloat(StringToNumberParser.getDefaultNumberFormat(), primitive);
    }

    public static StringToNumberConverter<Float> toFloat(Format numberFormat, boolean primitive) {
        return new StringToNumberConverter<Float>(numberFormat, primitive ? Float.TYPE : Float.class, MIN_FLOAT, MAX_FLOAT, Float.class);
    }

    public static StringToNumberConverter<BigInteger> toBigInteger() {
        return StringToNumberConverter.toBigInteger(StringToNumberParser.getDefaultIntegerBigDecimalFormat());
    }

    public static StringToNumberConverter<BigInteger> toBigInteger(Format numberFormat) {
        return new StringToNumberConverter<BigInteger>(numberFormat, BigInteger.class, null, null, BigInteger.class);
    }

    public static StringToNumberConverter<BigDecimal> toBigDecimal() {
        return StringToNumberConverter.toBigDecimal(StringToNumberParser.getDefaultBigDecimalFormat());
    }

    public static StringToNumberConverter<BigDecimal> toBigDecimal(Format numberFormat) {
        return new StringToNumberConverter<BigDecimal>(numberFormat, BigDecimal.class, null, null, BigDecimal.class);
    }

    public static StringToNumberConverter<Short> toShort(boolean primitive) {
        return StringToNumberConverter.toShort(StringToNumberParser.getDefaultIntegerFormat(), primitive);
    }

    public static StringToNumberConverter<Short> toShort(Format numberFormat, boolean primitive) {
        return new StringToNumberConverter<Short>(numberFormat, primitive ? Short.TYPE : Short.class, MIN_SHORT, MAX_SHORT, Short.class);
    }

    public static StringToNumberConverter<Byte> toByte(boolean primitive) {
        return StringToNumberConverter.toByte(StringToNumberParser.getDefaultIntegerFormat(), primitive);
    }

    public static StringToNumberConverter<Byte> toByte(Format numberFormat, boolean primitive) {
        return new StringToNumberConverter<Byte>(numberFormat, primitive ? Byte.TYPE : Byte.class, MIN_BYTE, MAX_BYTE, Byte.class);
    }
}

