/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.decoratormodel.internal.ui.wizards;

import com.google.common.collect.Maps;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import com.google.common.eventbus.EventBus;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.osgi.util.NLS;
import org.eclipse.papyrus.uml.decoratormodel.internal.resource.DecoratorModelIndex;
import org.eclipse.papyrus.uml.decoratormodel.internal.ui.Activator;
import org.eclipse.papyrus.uml.decoratormodel.internal.ui.messages.Messages;
import org.eclipse.papyrus.uml.decoratormodel.internal.ui.wizards.DecoratorModelSelectionPage;
import org.eclipse.ui.statushandlers.StatusManager;
import org.eclipse.uml2.uml.Package;

public class LoadDecoratorModelsPage
extends DecoratorModelSelectionPage {
    private Map<IFile, SetMultimap<URI, URI>> externalApplications;

    public LoadDecoratorModelsPage(EventBus bus) {
        super(bus);
    }

    @Override
    public void setInput(Package package_, Set<URI> input) {
        super.setInput(package_, input);
        this.externalApplications = Maps.newHashMap();
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        for (URI profileApplicationResource : input) {
            IFile file = root.getFile((IPath)new Path(profileApplicationResource.toPlatformString(true)));
            try {
                SetMultimap profileApplications = DecoratorModelIndex.getInstance().getAppliedProfilesByPackage(profileApplicationResource);
                this.externalApplications.put(file, (SetMultimap<URI, URI>)profileApplications);
            }
            catch (CoreException e) {
                Activator.getDefault().getLog().log(e.getStatus());
                StatusManager.getManager().handle(e.getStatus(), 2);
            }
        }
    }

    protected String computeConflict() {
        String result = null;
        IFile[] selected = this.getCheckedFiles();
        if (selected.length > 1) {
            int i = 0;
            block0: while (i < selected.length) {
                IFile a = selected[i];
                SetMultimap<URI, URI> applicationsFromA = this.externalApplications.get(a);
                int j = i + 1;
                while (j < selected.length) {
                    IFile b = selected[j];
                    SetMultimap<URI, URI> applicationsFromB = this.externalApplications.get(b);
                    if (LoadDecoratorModelsPage.intersect(applicationsFromA, applicationsFromB)) {
                        result = NLS.bind((String)Messages.LoadDecoratorModelsPage_0, (Object)a.getName(), (Object)b.getName());
                        break block0;
                    }
                    ++j;
                }
                ++i;
            }
        }
        return result;
    }

    static <K, V> boolean intersect(SetMultimap<K, V> a, SetMultimap<K, V> b) {
        boolean result = false;
        for (Object next : a.keySet()) {
            if (Sets.intersection((Set)a.get(next), (Set)b.get(next)).isEmpty()) continue;
            result = true;
            break;
        }
        return result;
    }

    @Override
    void validatePage() {
        this.setErrorMessage(null);
        String conflict = this.computeConflict();
        if (conflict != null) {
            this.setErrorMessage(conflict);
            this.setPageComplete(false);
        } else {
            super.validatePage();
        }
    }
}

