/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.views.properties;

import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.papyrus.infra.core.log.LogHelper;
import org.eclipse.papyrus.infra.properties.spi.IPropertiesResolver;
import org.eclipse.papyrus.views.properties.runtime.ConfigurationManager;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;

public class Activator
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "org.eclipse.papyrus.views.properties";
    private static Activator plugin;
    public static LogHelper log;
    private ServiceRegistration<IPropertiesResolver> propertiesResolverReg;

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        log = new LogHelper((Plugin)plugin);
        this.propertiesResolverReg = context.registerService(IPropertiesResolver.class, ppeURI -> ppeURI.resolve(URI.createFileURI((String)(this.getPreferencesPath().toString() + "/"))), null);
        Job startProperties = new Job("Starting Configuration Manager"){

            protected IStatus run(IProgressMonitor monitor) {
                ConfigurationManager.getInstance();
                return Status.OK_STATUS;
            }
        };
        startProperties.setSystem(true);
        startProperties.schedule();
    }

    public IPath getPreferencesPath() {
        return this.getStateLocation();
    }

    public void stop(BundleContext context) throws Exception {
        if (this.propertiesResolverReg != null) {
            this.propertiesResolverReg.unregister();
            this.propertiesResolverReg = null;
        }
        plugin = null;
        super.stop(context);
    }

    public static Activator getDefault() {
        return plugin;
    }

    public Image getImage(String path) {
        return this.getImage(PLUGIN_ID, path);
    }

    public Image getImage(String pluginId, String path) {
        String key;
        ImageRegistry registry = this.getImageRegistry();
        Image image = registry.get(key = pluginId + "/" + path);
        if (image == null) {
            registry.put(key, AbstractUIPlugin.imageDescriptorFromPlugin((String)pluginId, (String)path));
            image = registry.get(key);
        }
        return image;
    }

    public Image getImageFromPlugin(String imagePath) {
        if (imagePath.startsWith("/")) {
            imagePath = imagePath.substring(1, imagePath.length());
            String pluginId = imagePath.substring(0, imagePath.indexOf("/"));
            String path = imagePath.substring(imagePath.indexOf("/"), imagePath.length());
            return this.getImage(pluginId, path);
        }
        return this.getImage(imagePath);
    }
}

