/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.common.editpolicies;

import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PrecisionRectangle;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.handles.MoveHandle;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.commands.SetBoundsCommand;
import org.eclipse.gmf.runtime.diagram.ui.editparts.LabelEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.NonResizableLabelEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.l10n.DiagramUIMessages;
import org.eclipse.gmf.runtime.emf.core.util.EObjectAdapter;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.gmfdiag.common.editpart.PapyrusLabelEditPart;
import org.eclipse.papyrus.infra.gmfdiag.common.helper.PapyrusLabelHelper;

public class PapyrusLinkLabelDragPolicy
extends NonResizableLabelEditPolicy {
    protected List<MoveHandle> createSelectionHandles() {
        MoveHandle mh = new MoveHandle(this.getHost());
        mh.setBorder(null);
        return Collections.singletonList(mh);
    }

    protected Command getMoveCommand(ChangeBoundsRequest request) {
        LabelEditPart editPart = (LabelEditPart)this.getHost();
        Point refPoint = editPart.getReferencePoint();
        PrecisionRectangle rect = new PrecisionRectangle(this.getInitialFeedbackBounds().getCopy());
        this.getHostFigure().translateToAbsolute((Translatable)rect);
        rect.translate(request.getMoveDelta());
        rect.resize(request.getSizeDelta());
        this.getHostFigure().translateToRelative((Translatable)rect);
        if (editPart instanceof PapyrusLabelEditPart) {
            switch (((PapyrusLabelEditPart)editPart).getTextAlignment()) {
                case 1: {
                    rect.translate(-this.getHostFigure().getBounds().width / 2, 0);
                    break;
                }
                case 2: {
                    break;
                }
                case 4: {
                    rect.translate(this.getHostFigure().getBounds().width / 2, 0);
                    break;
                }
            }
        }
        Point normalPoint = PapyrusLabelHelper.offsetFromRelativeCoordinate(this.getHostFigure(), (Rectangle)rect, refPoint);
        SetBoundsCommand moveCommand = new SetBoundsCommand(editPart.getEditingDomain(), DiagramUIMessages.MoveLabelCommand_Label_Location, (IAdaptable)new EObjectAdapter((EObject)((View)editPart.getModel())), normalPoint);
        return new ICommandProxy((ICommand)moveCommand);
    }
}

