/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.toolsmiths.validation.properties.internal.constants;

import java.util.Optional;
import org.eclipse.core.resources.IMarker;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.papyrus.toolsmiths.validation.common.checkers.IPluginChecker2;
import org.eclipse.papyrus.toolsmiths.validation.common.quickfix.CommonMarkerResolutionUtils;

public class PropertiesPluginValidationConstants {
    public static final String PROPERTIES_PLUGIN_VALIDATION_MARKER_TYPE = "org.eclipse.papyrus.toolsmiths.validation.properties.diagnostic";
    public static final String CONTEXTS_EXTENSION_POINT_IDENTIFIER = "org.eclipse.papyrus.infra.properties.contexts";
    public static final String E_CONTEXT = "context";
    public static final String A_CONTEXT_MODEL = "contextModel";
    public static final String ENVIRONMENTS_EXTENSION_POINT_IDENTIFIER = "org.eclipse.papyrus.infra.properties.environments";
    public static final String E_ENVIRONMENT = "environment";
    public static final String A_ENVIRONMENT_MODEL = "environmentModel";
    public static final String ATTR_PATH = "path";
    public static final String MARKER_ATTR_REF = "object_to_reference";
    public static final String MARKER_ATTR_VALUE = "value_to_set";
    public static final String MARKER_ATTR_LAYOUT_GENERATOR = "layout_generator";
    public static final int PROBLEM_ID_BASE = 16715840;
    public static final int MISSING_CONTEXT_MODEL_EXTENSION_ID = 16715840;
    public static final int MISSING_ENVIRONMENT_MODEL_EXTENSION_ID = 16715841;
    public static final int OBSOLETE_DATA_CONTEXT_PACKAGE = 16715842;
    public static final int MISSING_DATA_CONTEXT_ELEMENT = 16715843;
    public static final int OBSOLETE_DATA_CONTEXT_ELEMENT = 16715844;
    public static final int MISSING_DATA_CONTEXT_PROPERTY = 16715845;
    public static final int OBSOLETE_DATA_CONTEXT_PROPERTY = 16715846;
    public static final int INCONSISTENT_DATA_CONTEXT_PROPERTY_TYPE = 16715847;
    public static final int INCONSISTENT_WIDGET_TYPE = 16715848;
    public static final int RENAMED_PROPERTY = 16715849;
    public static final int RENAMED_CLASS = 16715850;
    public static final int RENAMED_PACKAGE = 16715851;
    public static final int MISSING_DATA_CONTEXT_PACKAGE = 16715852;
    public static final int OBSOLETE_DATA_CONTEXT_ROOT = 16715853;
    public static final int UNRESOLVED_CONSTRAINT_CLASS = 16715854;
    public static final int UNRESOLVED_CONSTRAINT_CLASS_MULTIPLE_CHOICE = 16715855;
    public static final int INCONSISTENT_DATA_CONTEXT_PROPERTY_MULTIPLICITY = 16715856;
    public static final int MAX_PROBLEM_ID = 16715903;

    public static <T extends EObject> Optional<T> getObjectToReference(IMarker marker, Class<T> type, EditingDomain domain) {
        return CommonMarkerResolutionUtils.getModelObject((IMarker)marker, (String)MARKER_ATTR_REF, type, (EditingDomain)domain);
    }

    public static IPluginChecker2.MarkerAttribute objectToReference(EObject object) {
        return new IPluginChecker2.MarkerAttribute(MARKER_ATTR_REF, (Object)EcoreUtil.getURI((EObject)object));
    }

    public static <V> Optional<V> getValueToSet(IMarker marker, Class<V> type, EDataType dataType) {
        return CommonMarkerResolutionUtils.getValue((IMarker)marker, (String)MARKER_ATTR_VALUE, type, (EDataType)dataType);
    }

    public static IPluginChecker2.MarkerAttribute valueToSet(Object value, EDataType dataType) {
        if (value instanceof Boolean) {
            return new IPluginChecker2.MarkerAttribute(MARKER_ATTR_VALUE, ((Boolean)value).booleanValue());
        }
        if (value instanceof Integer) {
            return new IPluginChecker2.MarkerAttribute(MARKER_ATTR_VALUE, ((Integer)value).intValue());
        }
        return new IPluginChecker2.MarkerAttribute(MARKER_ATTR_VALUE, (Object)EcoreUtil.convertToString((EDataType)dataType, (Object)value));
    }
}

