/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.activity.edit.part;

import org.eclipse.draw2d.IFigure;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.tools.CellEditorLocator;
import org.eclipse.gef.tools.DirectEditManager;
import org.eclipse.gmf.runtime.diagram.ui.l10n.DiagramColorRegistry;
import org.eclipse.gmf.runtime.draw2d.ui.figures.WrappingLabel;
import org.eclipse.gmf.runtime.emf.ui.services.parser.ISemanticParser;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.gmfdiag.tooling.runtime.directedit.locator.TextCellEditorLocator;
import org.eclipse.papyrus.uml.diagram.activity.edit.parts.ObjectFlowSelectionEditPart;
import org.eclipse.papyrus.uml.diagram.common.directedit.MultilineLabelDirectEditManager;
import org.eclipse.swt.graphics.Image;
import org.eclipse.uml2.uml.Behavior;
import org.eclipse.uml2.uml.ObjectFlow;

public class CustomObjectFlowSelectionEditPart
extends ObjectFlowSelectionEditPart {
    private DirectEditManager manager;

    public CustomObjectFlowSelectionEditPart(View view) {
        super(view);
    }

    protected String getLabelTextHelper(IFigure figure) {
        if (figure instanceof ObjectFlowSelectionEditPart.LinkAndCornerBentWithTextFigure) {
            return ((ObjectFlowSelectionEditPart.LinkAndCornerBentWithTextFigure)figure).getCornerBentContent().getText();
        }
        return super.getLabelTextHelper(figure);
    }

    protected void setLabelTextHelper(IFigure figure, String text) {
        if (figure instanceof ObjectFlowSelectionEditPart.LinkAndCornerBentWithTextFigure) {
            ((ObjectFlowSelectionEditPart.LinkAndCornerBentWithTextFigure)figure).getCornerBentContent().setText(text);
        } else {
            super.setLabelTextHelper(figure, text);
        }
    }

    protected Image getLabelIconHelper(IFigure figure) {
        if (figure instanceof ObjectFlowSelectionEditPart.LinkAndCornerBentWithTextFigure) {
            return ((ObjectFlowSelectionEditPart.LinkAndCornerBentWithTextFigure)figure).getCornerBentContent().getIcon();
        }
        return super.getLabelIconHelper(figure);
    }

    protected void setLabelIconHelper(IFigure figure, Image icon) {
        if (figure instanceof ObjectFlowSelectionEditPart.LinkAndCornerBentWithTextFigure) {
            ((ObjectFlowSelectionEditPart.LinkAndCornerBentWithTextFigure)figure).getCornerBentContent().setIcon(icon);
        } else {
            super.setLabelIconHelper(figure, icon);
        }
    }

    protected void setVisibility(boolean vis) {
        Behavior selection;
        EObject element = this.resolveSemanticElement();
        if (element instanceof ObjectFlow && (selection = ((ObjectFlow)element).getSelection()) == null) {
            vis = false;
        }
        super.setVisibility(vis);
    }

    protected void handleNotificationEvent(Notification event) {
        Object feature = event.getFeature();
        if (NotationPackage.eINSTANCE.getFontStyle_FontColor().equals(feature)) {
            Integer c = (Integer)event.getNewValue();
            this.setFontColor(DiagramColorRegistry.getInstance().getColor(c));
        } else if (NotationPackage.eINSTANCE.getFontStyle_Underline().equals(feature)) {
            this.refreshUnderline();
        } else if (NotationPackage.eINSTANCE.getFontStyle_StrikeThrough().equals(feature)) {
            this.refreshStrikeThrough();
        } else if (NotationPackage.eINSTANCE.getFontStyle_FontHeight().equals(feature) || NotationPackage.eINSTANCE.getFontStyle_FontName().equals(feature) || NotationPackage.eINSTANCE.getFontStyle_Bold().equals(feature) || NotationPackage.eINSTANCE.getFontStyle_Italic().equals(feature)) {
            this.refreshFont();
        } else {
            ISemanticParser modelParser;
            if (this.getParser() != null && this.getParser().isAffectingEvent((Object)event, this.getParserOptions().intValue())) {
                this.refreshLabel();
            }
            if (this.getParser() instanceof ISemanticParser && (modelParser = (ISemanticParser)this.getParser()).areSemanticElementsAffected(null, (Object)event)) {
                this.removeSemanticListeners();
                if (this.resolveSemanticElement() != null) {
                    this.addSemanticListeners();
                }
                this.refreshLabel();
                this.refreshVisibility();
            }
        }
        super.handleNotificationEvent(event);
    }

    protected DirectEditManager getManager() {
        if (this.manager == null) {
            this.setManager((DirectEditManager)new MultilineLabelDirectEditManager((GraphicalEditPart)this, MultilineLabelDirectEditManager.getTextCellEditorClass((GraphicalEditPart)this), (CellEditorLocator)new TextCellEditorLocator((WrappingLabel)((ObjectFlowSelectionEditPart.LinkAndCornerBentWithTextFigure)this.getFigure()).getCornerBentContent())));
        }
        return this.manager;
    }

    protected void setManager(DirectEditManager manager) {
        this.manager = manager;
    }
}

