/*
 * Decompiled with CFR 0.152.
 */
package impl.preferences;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.Objects;
import org.eclipse.emf.common.util.EList;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenCustomPreferencePage;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenPreference;
import org.eclipse.papyrus.gmf.codegen.xtend.annotations.MetaDef;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import xpt.Common;

@Singleton
public class CustomPage {
    @Inject
    @Extension
    private Common _common;

    protected String computePackageName(GenCustomPreferencePage it) {
        String _className;
        String _qualifiedClassName = it.getQualifiedClassName();
        boolean _equals = Objects.equals(_qualifiedClassName, _className = it.getClassName());
        if (_equals) {
            return it.getDiagram().getPreferencesPackageName();
        }
        String _qualifiedClassName_1 = it.getQualifiedClassName();
        int _length = it.getQualifiedClassName().length();
        int _length_1 = it.getClassName().length();
        int _minus = _length - _length_1;
        int _length_2 = ".".length();
        int _minus_1 = _minus - _length_2;
        return _qualifiedClassName_1.substring(0, _minus_1);
    }

    public CharSequence className(GenCustomPreferencePage it) {
        StringConcatenation _builder = new StringConcatenation();
        String _className = it.getClassName();
        _builder.append(_className);
        return _builder;
    }

    public CharSequence packageName(GenCustomPreferencePage it) {
        StringConcatenation _builder = new StringConcatenation();
        String _computePackageName = this.computePackageName(it);
        _builder.append(_computePackageName);
        return _builder;
    }

    public CharSequence qualifiedClassName(GenCustomPreferencePage it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _packageName = this.packageName(it);
        _builder.append((Object)_packageName);
        _builder.append(".");
        CharSequence _className = this.className(it);
        _builder.append((Object)_className);
        return _builder;
    }

    public CharSequence Main(GenCustomPreferencePage it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _copyright = this._common.copyright(it.getDiagram().getEditorGen());
        _builder.append((Object)_copyright);
        _builder.newLineIfNotEmpty();
        _builder.append("package ");
        CharSequence _packageName = this.packageName(it);
        _builder.append((Object)_packageName);
        _builder.append(";");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        CharSequence _generatedClassComment = this._common.generatedClassComment();
        _builder.append((Object)_generatedClassComment);
        _builder.newLineIfNotEmpty();
        _builder.append("public class ");
        CharSequence _className = this.className(it);
        _builder.append((Object)_className);
        _builder.append(" ");
        CharSequence _extendsList = this.extendsList(it);
        _builder.append((Object)_extendsList);
        _builder.append(" ");
        CharSequence _implementsList = this.implementsList(it);
        _builder.append((Object)_implementsList);
        _builder.append(" {");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        EList _preferences = it.getPreferences();
        for (GenPreference pref : _preferences) {
            _builder.append("\t");
            CharSequence _constant = this.constant(pref);
            _builder.append((Object)_constant, "\t");
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        _builder.append("\t");
        CharSequence _generatedMemberComment = this._common.generatedMemberComment();
        _builder.append((Object)_generatedMemberComment, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("public ");
        CharSequence _className_1 = this.className(it);
        _builder.append((Object)_className_1, "\t");
        _builder.append("() {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("setPreferenceStore(");
        String _activatorQualifiedClassName = it.getDiagram().getEditorGen().getPlugin().getActivatorQualifiedClassName();
        _builder.append(_activatorQualifiedClassName, "\t\t");
        _builder.append(".getInstance().getPreferenceStore());");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t");
        CharSequence _methods = this.methods(it);
        _builder.append((Object)_methods, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        CharSequence _initDefaultsMethod = this.initDefaultsMethod(it);
        _builder.append((Object)_initDefaultsMethod, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence extendsList(GenCustomPreferencePage it) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("extends org.eclipse.gmf.runtime.common.ui.preferences.AbstractPreferencePage");
        return _builder;
    }

    public CharSequence implementsList(GenCustomPreferencePage it) {
        StringConcatenation _builder = new StringConcatenation();
        return _builder;
    }

    public CharSequence methods(GenCustomPreferencePage it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _generatedMemberComment = this._common.generatedMemberComment();
        _builder.append((Object)_generatedMemberComment);
        _builder.newLineIfNotEmpty();
        _builder.append("protected void addFields(org.eclipse.swt.widgets.Composite parent) {");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("// TODO  Provide method implementation");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("throw new UnsupportedOperationException();");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        CharSequence _generatedMemberComment_1 = this._common.generatedMemberComment();
        _builder.append((Object)_generatedMemberComment_1);
        _builder.newLineIfNotEmpty();
        _builder.append("protected void initHelp() {");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("// TODO implement this method if needed, or leave as no-op");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence initDefaultsMethod(GenCustomPreferencePage it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _generatedMemberComment = this._common.generatedMemberComment();
        _builder.append((Object)_generatedMemberComment);
        _builder.newLineIfNotEmpty();
        _builder.append("public static void initDefaults(org.eclipse.jface.preference.IPreferenceStore store) {");
        _builder.newLine();
        if (it.getPreferences().isEmpty() || IterableExtensions.exists((Iterable)it.getPreferences(), p -> {
            String _defaultValue = p.getDefaultValue();
            return _defaultValue == null;
        })) {
            _builder.append("\t");
            _builder.append("// TODO this code is invoked during preference store initialization, please fill");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("// the store passed with default preference values.");
            _builder.newLine();
        }
        Functions.Function1 _function = p -> {
            String _defaultValue = p.getDefaultValue();
            return _defaultValue != null;
        };
        Iterable _filter = IterableExtensions.filter((Iterable)it.getPreferences(), (Functions.Function1)_function);
        for (GenPreference pref : _filter) {
            _builder.append("\t");
            CharSequence _setDefaultValue = this.setDefaultValue(pref, "store");
            _builder.append((Object)_setDefaultValue, "\t");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    @MetaDef
    public CharSequence call_initDefaults(GenCustomPreferencePage it, String storeVarName) {
        StringConcatenation _builder = new StringConcatenation();
        boolean _isGenerateBoilerplate = it.isGenerateBoilerplate();
        if (_isGenerateBoilerplate) {
            CharSequence _qualifiedClassName = this.qualifiedClassName(it);
            _builder.append((Object)_qualifiedClassName);
            _builder.append(".initDefaults(");
            _builder.append(storeVarName);
            _builder.append(");");
        }
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    public CharSequence constant(GenPreference it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _generatedMemberComment = this._common.generatedMemberComment();
        _builder.append((Object)_generatedMemberComment);
        _builder.newLineIfNotEmpty();
        _builder.append("public static final String ");
        String _name = it.getName();
        _builder.append(_name);
        _builder.append(" = \"");
        String _key = it.getKey();
        _builder.append(_key);
        _builder.append("\"; ");
        CharSequence _nonNLS = this._common.nonNLS(1);
        _builder.append((Object)_nonNLS);
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    public CharSequence setDefaultValue(GenPreference it, String store) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append(store);
        _builder.append(".setDefault(");
        String _name = it.getName();
        _builder.append(_name);
        _builder.append(", ");
        String _defaultValue = it.getDefaultValue();
        _builder.append(_defaultValue);
        _builder.append(");");
        _builder.newLineIfNotEmpty();
        return _builder;
    }
}

