/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.textedit.message.xtext.ui.contributions;

import com.google.inject.Injector;
import java.util.Iterator;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.common.core.command.UnexecutableCommand;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.papyrus.infra.internationalization.common.utils.InternationalizationPreferencesUtils;
import org.eclipse.papyrus.uml.internationalization.utils.utils.UMLLabelInternationalization;
import org.eclipse.papyrus.uml.textedit.message.xtext.ui.internal.UmlMessageActivator;
import org.eclipse.papyrus.uml.textedit.message.xtext.umlMessage.MessageRule;
import org.eclipse.papyrus.uml.textedit.message.xtext.umlMessage.SequenceTermRule;
import org.eclipse.papyrus.uml.xtext.integration.DefaultXtextDirectEditorConfiguration;
import org.eclipse.uml2.uml.Interaction;
import org.eclipse.uml2.uml.Message;
import org.eclipse.uml2.uml.NamedElement;

public class MessagePopupEditor
extends DefaultXtextDirectEditorConfiguration {
    public Injector getInjector() {
        return UmlMessageActivator.getInstance().getInjector("org.eclipse.papyrus.uml.textedit.message.xtext.UmlMessage");
    }

    protected ICommand getParseCommand(EObject umlObject, EObject xtextObject) {
        Message message = (Message)umlObject;
        EObject modifiedObject = xtextObject;
        while (modifiedObject != null && !(modifiedObject instanceof MessageRule)) {
            modifiedObject = modifiedObject.eContainer();
        }
        if (modifiedObject == null) {
            return UnexecutableCommand.INSTANCE;
        }
        MessageRule messageRuleObject = (MessageRule)xtextObject;
        String newName = messageRuleObject.getName();
        int ocnumber = ((SequenceTermRule)messageRuleObject.getSequenceTerm().get(0)).getSequencialOrder();
        String ocname = "";
        Object newSequenceTermList = "";
        int i = 0;
        i = 0;
        while (i < messageRuleObject.getSequenceTerm().size()) {
            if (((SequenceTermRule)messageRuleObject.getSequenceTerm().get(i)).getSequenceName() != null) {
                ocname = ((SequenceTermRule)messageRuleObject.getSequenceTerm().get(i)).getSequenceName().toString();
            }
            ocnumber = ((SequenceTermRule)messageRuleObject.getSequenceTerm().get(i)).getSequencialOrder();
            if (((SequenceTermRule)messageRuleObject.getSequenceTerm().get(i)).getRecurrence() != null) {
                String string = ((SequenceTermRule)messageRuleObject.getSequenceTerm().get(i)).getRecurrence().trim();
            }
            newSequenceTermList = i == 0 ? (String)newSequenceTermList + ocnumber + ocname : (String)newSequenceTermList + "." + ocnumber + ocname;
            ++i;
        }
        return new UpdateUMLMessageCommand(message, newName, (String)newSequenceTermList);
    }

    public String getTextToEdit(Object editedObject) {
        if (editedObject instanceof Message) {
            String name = UMLLabelInternationalization.getInstance().getLabel((NamedElement)((Message)editedObject));
            if (name == null) {
                name = "";
            }
            Object texttoedit = name.trim();
            Interaction interaction = ((Message)editedObject).getInteraction();
            int sequencenumber = 0;
            Iterator it = interaction.getMessages().iterator();
            while (it.hasNext()) {
                ++sequencenumber;
                Message childElement = (Message)it.next();
                if (!childElement.equals(editedObject)) continue;
                if (!((String)texttoedit).isEmpty() && Character.isDigit(((String)texttoedit).charAt(0))) {
                    return texttoedit;
                }
                texttoedit = sequencenumber + ":" + (String)texttoedit;
                return texttoedit;
            }
        }
        return "not a Message";
    }

    protected static class UpdateUMLMessageCommand
    extends AbstractTransactionalCommand {
        private Message message;
        private String newName;
        private String newSequenceTermList;

        protected CommandResult doExecuteWithResult(IProgressMonitor arg0, IAdaptable arg1) throws ExecutionException {
            if (InternationalizationPreferencesUtils.getInternationalizationPreference((EObject)this.message) && UMLLabelInternationalization.getInstance().getLabelWithoutUML((NamedElement)this.message) != null) {
                UMLLabelInternationalization.getInstance().setLabel((NamedElement)this.message, this.newName, null);
            } else {
                this.message.setName(this.newSequenceTermList + ":" + this.newName);
            }
            return CommandResult.newOKCommandResult((Object)this.message);
        }

        public UpdateUMLMessageCommand(Message message, String newName, String newSequenceTermList) {
            super(TransactionUtil.getEditingDomain((EObject)message), "Message Update", UpdateUMLMessageCommand.getWorkspaceFiles((EObject)message));
            this.message = message;
            this.newName = newName;
            this.newSequenceTermList = newSequenceTermList;
        }
    }
}

