/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.robotics.ros2.codegen.python.component;

import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.papyrus.designer.uml.tools.utils.ElementUtils;
import org.eclipse.papyrus.designer.uml.tools.utils.StereotypeUtil;
import org.eclipse.papyrus.robotics.codegen.common.utils.ActivityUtils;
import org.eclipse.papyrus.robotics.codegen.common.utils.ApplyProfiles;
import org.eclipse.papyrus.robotics.codegen.common.utils.TopicUtils;
import org.eclipse.papyrus.robotics.core.utils.InteractionUtils;
import org.eclipse.papyrus.robotics.core.utils.PortUtils;
import org.eclipse.papyrus.robotics.profile.robotics.commpattern.CommunicationPattern;
import org.eclipse.papyrus.robotics.profile.robotics.components.Activity;
import org.eclipse.papyrus.robotics.profile.robotics.components.ComponentPort;
import org.eclipse.papyrus.robotics.ros2.codegen.common.component.CallbackGroups;
import org.eclipse.papyrus.robotics.ros2.codegen.common.utils.MessageUtils;
import org.eclipse.papyrus.robotics.ros2.codegen.common.utils.RosHelpers;
import org.eclipse.papyrus.robotics.ros2.codegen.python.component.Callbacks;
import org.eclipse.papyrus.robotics.ros2.codegen.python.component.ComponentTransformations;
import org.eclipse.papyrus.robotics.ros2.codegen.python.utils.RosPythonTypes;
import org.eclipse.uml2.uml.Behavior;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Dependency;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.EncapsulatedClassifier;
import org.eclipse.uml2.uml.Interface;
import org.eclipse.uml2.uml.LiteralString;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.OpaqueBehavior;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.Port;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.ValueSpecification;
import org.eclipse.uml2.uml.profile.standard.Create;
import org.eclipse.uml2.uml.util.UMLUtil;
import org.eclipse.xtend2.lib.StringConcatenation;

public class Constructor {
    public static Dependency createConstructor(Class component) {
        Dependency _xblockexpression = null;
        Type lcNodeSC = RosPythonTypes.getType((Element)component, "rclpy::lifecycle::Node");
        if (lcNodeSC instanceof Classifier) {
            component.createGeneralization((Classifier)lcNodeSC);
        }
        Operation op = Constructor.addConstrOp(component);
        Constructor.addConstrMethod(component, op);
        Type qosRPolicy = RosPythonTypes.getType((Element)component, "rclpy::qos::ReliabilityPolicy");
        Type qosHPolicy = RosPythonTypes.getType((Element)component, "rclpy::qos::HistoryPolicy");
        component.createDependency((NamedElement)qosRPolicy);
        _xblockexpression = component.createDependency((NamedElement)qosHPolicy);
        return _xblockexpression;
    }

    public static Operation addConstrOp(Class component) {
        Type string = RosPythonTypes.getType((Element)component, "PrimitiveTypes::String");
        Operation init = component.createOwnedOperation(component.getName(), null, null);
        init.createOwnedParameter("instName", string);
        Create create = (Create)StereotypeUtil.applyApp((Element)init, Create.class);
        if (create == null) {
            ApplyProfiles.applyStdProfile((Element)init);
            create = (Create)StereotypeUtil.applyApp((Element)init, Create.class);
        }
        return init;
    }

    public static boolean addConstrMethod(Class component, Operation constructorOp) {
        boolean _xblockexpression = false;
        Behavior _createOwnedBehavior = component.createOwnedBehavior(component.getName(), UMLPackage.eINSTANCE.getOpaqueBehavior());
        OpaqueBehavior ob = (OpaqueBehavior)_createOwnedBehavior;
        constructorOp.getMethods().add((Object)ob);
        ob.getLanguages().add((Object)"Python");
        EList _bodies = ob.getBodies();
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("super().__init__(instName)");
        _builder.newLine();
        List _activities = ActivityUtils.getActivities((Class)component);
        for (Activity activity : _activities) {
            Constructor.createCallbackGroupVar(activity, component);
            _builder.newLineIfNotEmpty();
        }
        EList _allPorts = PortUtils.getAllPorts((EncapsulatedClassifier)component);
        for (Port port : _allPorts) {
            boolean _tripleNotEquals;
            CommunicationPattern _communicationPattern = InteractionUtils.getCommunicationPattern((Port)port);
            boolean bl = _tripleNotEquals = _communicationPattern != null;
            if (!_tripleNotEquals) continue;
            CommunicationPattern pattern = InteractionUtils.getCommunicationPattern((Port)port);
            _builder.newLineIfNotEmpty();
            if (InteractionUtils.isPush((CommunicationPattern)pattern) || InteractionUtils.isPubSub((CommunicationPattern)pattern)) {
                CharSequence _createPush = Constructor.createPush(port);
                _builder.append((Object)_createPush);
                _builder.newLineIfNotEmpty();
                _builder.newLine();
                continue;
            }
            boolean _isSend = InteractionUtils.isSend((CommunicationPattern)pattern);
            if (_isSend) {
                CharSequence _createSend = Constructor.createSend(port);
                _builder.append((Object)_createSend);
                _builder.newLineIfNotEmpty();
                _builder.newLine();
                continue;
            }
            boolean _isQuery = InteractionUtils.isQuery((CommunicationPattern)pattern);
            if (_isQuery) {
                CharSequence _createQuery = Constructor.createQuery(port);
                _builder.append((Object)_createQuery);
                _builder.newLineIfNotEmpty();
                _builder.newLine();
                continue;
            }
            boolean _isAction = InteractionUtils.isAction((CommunicationPattern)pattern);
            if (_isAction) {
                CharSequence _createAction = Constructor.createAction(port);
                _builder.append((Object)_createAction);
                _builder.newLineIfNotEmpty();
                _builder.newLine();
                continue;
            }
            boolean bl2 = InteractionUtils.isEvent((CommunicationPattern)pattern);
        }
        _xblockexpression = _bodies.add((Object)_builder.toString());
        return _xblockexpression;
    }

    public static void createCallbackGroupVar(Activity activity, Class component) {
        boolean _tripleNotEquals;
        Type cbgType = RosPythonTypes.getType((Element)component, "rclpy::callback_groups::MutuallyExclusiveCallbackGroup");
        Property cbgAttr = component.createOwnedAttribute(CallbackGroups.callbackGroupName((Class)activity.getBase_Class()), cbgType);
        ValueSpecification _createDefaultValue = cbgAttr.createDefaultValue(null, null, UMLPackage.eINSTANCE.getLiteralString());
        LiteralString defaultV = (LiteralString)_createDefaultValue;
        defaultV.setValue("MutuallyExclusiveCallbackGroup()");
        String _period = ActivityUtils.getPeriod((Activity)activity);
        boolean bl = _tripleNotEquals = _period != null;
        if (_tripleNotEquals) {
            Property tCbgAttr = component.createOwnedAttribute(CallbackGroups.tCallbackGroupName((Class)activity.getBase_Class()), cbgType);
            ValueSpecification _createDefaultValue_1 = tCbgAttr.createDefaultValue(null, null, UMLPackage.eINSTANCE.getLiteralString());
            LiteralString tDevaultV = (LiteralString)_createDefaultValue_1;
            tDevaultV.setValue(defaultV.getValue());
        }
    }

    public static CharSequence createPush(Port port) {
        boolean _greaterThan;
        StringConcatenation _builder = new StringConcatenation();
        int _size = port.getProvideds().size();
        boolean bl = _greaterThan = _size > 0;
        if (_greaterThan) {
            _builder.append("self.");
            String _varName = ElementUtils.varName((NamedElement)port);
            _builder.append(_varName);
            _builder.append("_pub_ = self.create_publisher(");
            String _name = InteractionUtils.getCommObject((Port)port).getName();
            _builder.append(_name);
            _builder.append(", \"");
            String _topic = TopicUtils.getTopic((Port)port);
            _builder.append(_topic);
            _builder.append("\",");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            String _qos = Constructor.qos(port, "1");
            _builder.append(_qos, "\t");
            _builder.append(", callback_group = self.");
            String _callbackGroupName = CallbackGroups.callbackGroupName((Port)port);
            _builder.append(_callbackGroupName, "\t");
            _builder.append(")");
            _builder.newLineIfNotEmpty();
        } else {
            boolean _greaterThan_1;
            int _size_1 = port.getRequireds().size();
            boolean bl2 = _greaterThan_1 = _size_1 > 0;
            if (_greaterThan_1) {
                _builder.append("defaultQoSProfile = rclpy.qos.QoSProfile(");
                _builder.newLine();
                _builder.append("\t\t");
                _builder.append("reliability=ReliabilityPolicy.BEST_EFFORT,");
                _builder.newLine();
                _builder.append("\t\t");
                _builder.append("history=HistoryPolicy.KEEP_LAST,");
                _builder.newLine();
                _builder.append("\t\t");
                _builder.append("depth = 100)");
                _builder.newLine();
                _builder.append("self.");
                String _varName_1 = ElementUtils.varName((NamedElement)port);
                _builder.append(_varName_1);
                _builder.append("_sub_ = self.create_subscription(");
                String _name_1 = InteractionUtils.getCommObject((Port)port).getName();
                _builder.append(_name_1);
                _builder.append(", \"");
                String _topic_1 = TopicUtils.getTopic((Port)port);
                _builder.append(_topic_1);
                _builder.append("\", ");
                String _callBackMethodForPush = Callbacks.callBackMethodForPush(port.getClass_(), port);
                _builder.append(_callBackMethodForPush);
                _builder.append(",");
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                _builder.append("qos_profile = defaultQoSProfile, callback_group = self.");
                String _callbackGroupName_1 = CallbackGroups.callbackGroupName((Port)port);
                _builder.append(_callbackGroupName_1, "\t");
                _builder.append(")");
                _builder.newLineIfNotEmpty();
            }
        }
        return _builder;
    }

    public static CharSequence createSend(Port port) {
        boolean _greaterThan;
        StringConcatenation _builder = new StringConcatenation();
        int _size = port.getProvideds().size();
        boolean bl = _greaterThan = _size > 0;
        if (_greaterThan) {
            _builder.append("defaultQoSProfile = rclpy.qos.QoSProfile(");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("reliability=ReliabilityPolicy.BEST_EFFORT,");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("history=HistoryPolicy.KEEP_LAST,");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("depth = 100)");
            _builder.newLine();
            _builder.append("self.");
            String _varName = ElementUtils.varName((NamedElement)port);
            _builder.append(_varName);
            _builder.append("_recv_ = self.create_subscription(");
            String _name = InteractionUtils.getCommObject((Port)port).getName();
            _builder.append(_name);
            _builder.append(", \"");
            String _topic = TopicUtils.getTopic((Port)port);
            _builder.append(_topic);
            _builder.append("\", ");
            String _callBackMethodForPush = Callbacks.callBackMethodForPush(port.getClass_(), port);
            _builder.append(_callBackMethodForPush);
            _builder.append(", qos_profile = defaultQoSProfile, callback_group = self.");
            String _callbackGroupName = CallbackGroups.callbackGroupName((Port)port);
            _builder.append(_callbackGroupName);
            _builder.append(")");
            _builder.newLineIfNotEmpty();
        } else {
            boolean _greaterThan_1;
            int _size_1 = port.getRequireds().size();
            boolean bl2 = _greaterThan_1 = _size_1 > 0;
            if (_greaterThan_1) {
                _builder.append("self.");
                String _varName_1 = ElementUtils.varName((NamedElement)port);
                _builder.append(_varName_1);
                _builder.append("_send_ = self.create_publisher(");
                String _name_1 = InteractionUtils.getCommObject((Port)port).getName();
                _builder.append(_name_1);
                _builder.append(", \"");
                String _topic_1 = TopicUtils.getTopic((Port)port);
                _builder.append(_topic_1);
                _builder.append("\", ");
                String _qos = Constructor.qos(port, "1");
                _builder.append(_qos);
                _builder.append(", callback_group = self.");
                String _callbackGroupName_1 = CallbackGroups.callbackGroupName((Port)port);
                _builder.append(_callbackGroupName_1);
                _builder.append(")");
                _builder.newLineIfNotEmpty();
                _builder.append("// directly activate a publisher");
                _builder.newLine();
            }
        }
        return _builder;
    }

    public static CharSequence createQuery(Port port) {
        boolean _greaterThan;
        StringConcatenation _builder = new StringConcatenation();
        int _size = port.getProvideds().size();
        boolean bl = _greaterThan = _size > 0;
        if (_greaterThan) {
            _builder.append("self.");
            String _varName = ElementUtils.varName((NamedElement)port);
            _builder.append(_varName);
            _builder.append("_srv_ = self.create_service(");
            String _srvName = ComponentTransformations.getSrvName(RosHelpers.externalName((Type)MessageUtils.getServiceType((Port)port)));
            _builder.append(_srvName);
            _builder.append(", \"");
            String _topic = TopicUtils.getTopic((Port)port);
            _builder.append(_topic);
            _builder.append("\", ");
            String _serverCallBackMethodForService = Callbacks.serverCallBackMethodForService(port.getClass_(), port);
            _builder.append(_serverCallBackMethodForService);
            _builder.append(", callback_group = self.");
            String _callbackGroupName = CallbackGroups.callbackGroupName((Port)port);
            _builder.append(_callbackGroupName);
            _builder.append(")");
            _builder.newLineIfNotEmpty();
        } else {
            boolean _greaterThan_1;
            int _size_1 = port.getRequireds().size();
            boolean bl2 = _greaterThan_1 = _size_1 > 0;
            if (_greaterThan_1) {
                _builder.append("self.");
                String _varName_1 = ElementUtils.varName((NamedElement)port);
                _builder.append(_varName_1);
                _builder.append("_client_ = self.create_client(");
                String _srvName_1 = ComponentTransformations.getSrvName(RosHelpers.externalName((Type)MessageUtils.getServiceType((Port)port)));
                _builder.append(_srvName_1);
                _builder.append(", \"");
                String _topic_1 = TopicUtils.getTopic((Port)port);
                _builder.append(_topic_1);
                _builder.append("\", callback_group = self.");
                String _callbackGroupName_1 = CallbackGroups.callbackGroupName((Port)port);
                _builder.append(_callbackGroupName_1);
                _builder.append(")");
                _builder.newLineIfNotEmpty();
            }
        }
        return _builder;
    }

    public static CharSequence createAction(Port port) {
        boolean _greaterThan;
        StringConcatenation _builder = new StringConcatenation();
        int _size = port.getProvideds().size();
        boolean bl = _greaterThan = _size > 0;
        if (_greaterThan) {
            _builder.append("self.");
            String _varName = ElementUtils.varName((NamedElement)port);
            _builder.append(_varName);
            _builder.append("_actsrv_ = ActionServer(");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("self, ");
            String _srvName = ComponentTransformations.getSrvName(RosHelpers.externalName((Type)MessageUtils.getServiceType((Port)port)));
            _builder.append(_srvName, "\t");
            _builder.append(", '");
            String _topic = TopicUtils.getTopic((Port)port);
            _builder.append(_topic, "\t");
            _builder.append("',");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            String _serverCallsbacksForAction = Callbacks.serverCallsbacksForAction(port.getClass_(), port);
            _builder.append(_serverCallsbacksForAction, "\t");
            _builder.append(",");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("callback_group = self.");
            String _callbackGroupName = CallbackGroups.callbackGroupName((Port)port);
            _builder.append(_callbackGroupName, "\t");
            _builder.append(")");
            _builder.newLineIfNotEmpty();
            Constructor.createSvcDependency(port.getClass_(), MessageUtils.getServiceType((Port)port));
            _builder.newLineIfNotEmpty();
        } else {
            _builder.append("self.");
            String _varName_1 = ElementUtils.varName((NamedElement)port);
            _builder.append(_varName_1);
            _builder.append("_actcli_ = ActionClient(");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("self, ");
            String _srvName_1 = ComponentTransformations.getSrvName(RosHelpers.externalName((Type)MessageUtils.getServiceType((Port)port)));
            _builder.append(_srvName_1, "\t");
            _builder.append(", '");
            String _topic_1 = TopicUtils.getTopic((Port)port);
            _builder.append(_topic_1, "\t");
            _builder.append("',");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("callback_group = self.");
            String _callbackGroupName_1 = CallbackGroups.callbackGroupName((Port)port);
            _builder.append(_callbackGroupName_1, "\t");
            _builder.append(")");
            _builder.newLineIfNotEmpty();
            Callbacks.clientCallsbacksForAction(port.getClass_(), port);
            _builder.newLineIfNotEmpty();
            Constructor.createSvcDependency(port.getClass_(), MessageUtils.getServiceType((Port)port));
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    public static CharSequence createEvent(Port port) {
        StringConcatenation _builder = new StringConcatenation();
        return _builder;
    }

    public static String qos(Port port, String defaultQoS) {
        ComponentPort compPort = (ComponentPort)UMLUtil.getStereotypeApplication((Element)port, ComponentPort.class);
        if (compPort != null && compPort.getQos() != null && compPort.getQos().length() > 0) {
            return compPort.getQos();
        }
        return defaultQoS;
    }

    public static void createSvcDependency(Class component, Interface svcType) {
        EList _clientDependencies = component.getClientDependencies();
        for (Dependency dep : _clientDependencies) {
            boolean _contains = dep.getTargets().contains((Object)svcType);
            if (!_contains) continue;
            return;
        }
        component.createDependency((NamedElement)svcType);
    }
}

