/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.robotics.ros2.codegen.python.component;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.emf.common.util.EList;
import org.eclipse.papyrus.designer.languages.common.base.file.IPFileSystemAccess;
import org.eclipse.papyrus.designer.languages.python.profile.python.Module;
import org.eclipse.papyrus.designer.transformation.base.utils.TransformationException;
import org.eclipse.papyrus.designer.transformation.core.transformations.ExecuteTransformationChain;
import org.eclipse.papyrus.designer.transformation.core.transformations.TransformationContext;
import org.eclipse.papyrus.designer.uml.tools.utils.ElementUtils;
import org.eclipse.papyrus.designer.uml.tools.utils.StereotypeUtil;
import org.eclipse.papyrus.robotics.codegen.common.utils.ActivityUtils;
import org.eclipse.papyrus.robotics.codegen.common.utils.ComponentUtils;
import org.eclipse.papyrus.robotics.core.utils.FunctionUtils;
import org.eclipse.papyrus.robotics.core.utils.InteractionUtils;
import org.eclipse.papyrus.robotics.core.utils.ParameterUtils;
import org.eclipse.papyrus.robotics.core.utils.PortUtils;
import org.eclipse.papyrus.robotics.profile.robotics.commpattern.CommunicationPattern;
import org.eclipse.papyrus.robotics.profile.robotics.components.Activity;
import org.eclipse.papyrus.robotics.profile.robotics.components.ComponentDefinition;
import org.eclipse.papyrus.robotics.profile.robotics.functions.Function;
import org.eclipse.papyrus.robotics.profile.robotics.functions.FunctionKind;
import org.eclipse.papyrus.robotics.ros2.codegen.common.component.AbstractCompTransformations;
import org.eclipse.papyrus.robotics.ros2.codegen.common.component.CallbackGroups;
import org.eclipse.papyrus.robotics.ros2.codegen.common.component.ComponentTransformationUtils;
import org.eclipse.papyrus.robotics.ros2.codegen.common.message.CreateMsgPackage;
import org.eclipse.papyrus.robotics.ros2.codegen.common.utils.MessageUtils;
import org.eclipse.papyrus.robotics.ros2.codegen.common.utils.RosHelpers;
import org.eclipse.papyrus.robotics.ros2.codegen.python.component.Constructor;
import org.eclipse.papyrus.robotics.ros2.codegen.python.component.CreateMain;
import org.eclipse.papyrus.robotics.ros2.codegen.python.component.ParameterTransformations;
import org.eclipse.papyrus.robotics.ros2.codegen.python.component.RoboticsPythonCreator;
import org.eclipse.papyrus.robotics.ros2.codegen.python.component.Ros2CodeSkeleton;
import org.eclipse.papyrus.robotics.ros2.codegen.python.utils.ApplyPythonProfile;
import org.eclipse.papyrus.robotics.ros2.codegen.python.utils.ProjectTools;
import org.eclipse.papyrus.robotics.ros2.codegen.python.utils.RosPythonTypes;
import org.eclipse.uml2.uml.Behavior;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.EncapsulatedClassifier;
import org.eclipse.uml2.uml.Interface;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.OpaqueBehavior;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.PackageableElement;
import org.eclipse.uml2.uml.Parameter;
import org.eclipse.uml2.uml.Port;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.UMLFactory;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.util.UMLUtil;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;

public class ComponentTransformations
extends AbstractCompTransformations {
    public ComponentTransformations(IPFileSystemAccess fileAccess, IProject genProject) {
        super(fileAccess, genProject);
    }

    public boolean createOnConfigureMethod(Class component) {
        boolean _xblockexpression = false;
        Operation op = component.createOwnedOperation("on_configure", null, null);
        Behavior _createOwnedBehavior = component.createOwnedBehavior("on_configure", UMLPackage.eINSTANCE.getOpaqueBehavior());
        OpaqueBehavior ob = (OpaqueBehavior)_createOwnedBehavior;
        op.getMethods().add((Object)ob);
        op.createOwnedParameter("state", RosPythonTypes.getType((Element)component, "rclpy::lifecycle::State"));
        ob.getLanguages().add((Object)"Python");
        EList _bodies = ob.getBodies();
        StringConcatenation _builder = new StringConcatenation();
        List _activities = ActivityUtils.getActivities((Class)component);
        for (Activity activity : _activities) {
            boolean _greaterThan;
            Class activityCl = activity.getBase_Class();
            _builder.newLineIfNotEmpty();
            String period = ActivityUtils.getPeriod((Activity)activity);
            _builder.newLineIfNotEmpty();
            List activateFcts = FunctionUtils.getFunctions((Activity)activity, (FunctionKind)FunctionKind.ON_CONFIGURE);
            _builder.newLineIfNotEmpty();
            List periodicFcts = FunctionUtils.getFunctions((Activity)activity, (FunctionKind)FunctionKind.PERIODIC);
            _builder.newLineIfNotEmpty();
            int _size = activateFcts.size();
            boolean bl = _greaterThan = _size > 0;
            if (_greaterThan) {
                for (Behavior activateFct : activateFcts) {
                    _builder.append("self.");
                    String _name = activateFct.getName();
                    _builder.append(_name);
                    _builder.append("()");
                    _builder.newLineIfNotEmpty();
                }
            }
            if (period == null || periodicFcts.size() <= 0) continue;
            _builder.append("# periodic execution (");
            _builder.append(period);
            _builder.append(") for ");
            String _name_1 = activityCl.getName();
            _builder.append(_name_1);
            _builder.append(" using a timer");
            _builder.newLineIfNotEmpty();
            for (Behavior periodicFct : periodicFcts) {
                _builder.append("self.timer_");
                String _name_2 = activityCl.getName();
                _builder.append(_name_2);
                _builder.append(" = self.create_timer(");
                String _convertPeriod = ComponentTransformations.convertPeriod(period);
                _builder.append(_convertPeriod);
                _builder.append(", self.");
                String _name_3 = periodicFct.getName();
                _builder.append(_name_3);
                _builder.append(", self.");
                String _tCallbackGroupName = CallbackGroups.tCallbackGroupName((Class)activityCl);
                _builder.append(_tCallbackGroupName);
                _builder.append(")");
                _builder.newLineIfNotEmpty();
            }
        }
        _builder.newLine();
        _builder.append("return TransitionCallbackReturn.SUCCESS");
        _builder.newLine();
        _xblockexpression = _bodies.add((Object)_builder.toString());
        return _xblockexpression;
    }

    public static String convertPeriod(String period) {
        boolean _contains = period.contains("ms");
        if (_contains) {
            float _parseFloat = Float.parseFloat(period.replace("ms", ""));
            float floatPeriod = _parseFloat / 1000.0f;
            return Float.valueOf(floatPeriod).toString();
        }
        boolean _contains_1 = period.contains("s");
        if (_contains_1) {
            return period.replace("s", "");
        }
        return period;
    }

    public boolean createOnActivateMethod(Class component) {
        boolean _xblockexpression = false;
        Operation op = component.createOwnedOperation("on_activate", null, null);
        Behavior _createOwnedBehavior = component.createOwnedBehavior("on_activate", UMLPackage.eINSTANCE.getOpaqueBehavior());
        OpaqueBehavior ob = (OpaqueBehavior)_createOwnedBehavior;
        ob.getLanguages().add((Object)"Python");
        op.getMethods().add((Object)ob);
        op.createOwnedParameter("state", RosPythonTypes.getType((Element)component, "rclpy::lifecycle::State"));
        EList _bodies = ob.getBodies();
        StringConcatenation _builder = new StringConcatenation();
        List _activities = ActivityUtils.getActivities((Class)component);
        for (Activity activity : _activities) {
            boolean _greaterThan;
            List activateFcts = FunctionUtils.getFunctions((Activity)activity, (FunctionKind)FunctionKind.ON_ACTIVATE);
            _builder.newLineIfNotEmpty();
            int _size = activateFcts.size();
            boolean bl = _greaterThan = _size > 0;
            if (!_greaterThan) continue;
            for (Behavior activateFct : activateFcts) {
                _builder.append("self.");
                String _name = activateFct.getName();
                _builder.append(_name);
                _builder.append("()");
                _builder.newLineIfNotEmpty();
            }
        }
        _builder.newLine();
        _builder.append("return TransitionCallbackReturn.SUCCESS");
        _builder.newLine();
        _xblockexpression = _bodies.add((Object)_builder.toString());
        return _xblockexpression;
    }

    public boolean createOnDeactivateMethod(Class component) {
        boolean _xblockexpression = false;
        Operation op = component.createOwnedOperation("on_deactivate", null, null);
        Behavior _createOwnedBehavior = component.createOwnedBehavior("on_deactivate", UMLPackage.eINSTANCE.getOpaqueBehavior());
        OpaqueBehavior ob = (OpaqueBehavior)_createOwnedBehavior;
        ob.getLanguages().add((Object)"Python");
        op.getMethods().add((Object)ob);
        op.createOwnedParameter("state", RosPythonTypes.getType((Element)component, "rclpy::lifecycle::State"));
        EList _bodies = ob.getBodies();
        StringConcatenation _builder = new StringConcatenation();
        List _activities = ActivityUtils.getActivities((Class)component);
        for (Activity activity : _activities) {
            int _size_1;
            boolean _greaterThan_1;
            boolean _greaterThan;
            Class activityCl = activity.getBase_Class();
            _builder.newLineIfNotEmpty();
            List deactivateFcts = FunctionUtils.getFunctions((Activity)activity, (FunctionKind)FunctionKind.ON_DEACTIVATE);
            _builder.newLineIfNotEmpty();
            List periodicFcts = FunctionUtils.getFunctions((Activity)activity, (FunctionKind)FunctionKind.PERIODIC);
            _builder.newLineIfNotEmpty();
            int _size = deactivateFcts.size();
            boolean bl = _greaterThan = _size > 0;
            if (_greaterThan) {
                for (Behavior deactivateFct : deactivateFcts) {
                    _builder.append("self.");
                    String _name = deactivateFct.getName();
                    _builder.append(_name);
                    _builder.append("()");
                    _builder.newLineIfNotEmpty();
                }
            }
            boolean bl2 = _greaterThan_1 = (_size_1 = periodicFcts.size()) > 0;
            if (!_greaterThan_1) continue;
            for (Behavior periodicFct : periodicFcts) {
                _builder.append("self.timer_");
                String _name_1 = activityCl.getName();
                _builder.append(_name_1);
                _builder.append(".cancel()");
                _builder.newLineIfNotEmpty();
            }
        }
        _builder.newLine();
        _builder.append("return TransitionCallbackReturn.SUCCESS");
        _builder.newLine();
        _xblockexpression = _bodies.add((Object)_builder.toString());
        return _xblockexpression;
    }

    public Parameter createOnCleanupMethod(Class component) {
        Parameter _xblockexpression = null;
        Operation op = component.createOwnedOperation("on_cleanup", null, null);
        Behavior _createOwnedBehavior = component.createOwnedBehavior("on_cleanup", UMLPackage.eINSTANCE.getOpaqueBehavior());
        OpaqueBehavior ob = (OpaqueBehavior)_createOwnedBehavior;
        ob.getLanguages().add((Object)"Python");
        op.getMethods().add((Object)ob);
        _xblockexpression = op.createOwnedParameter("state", RosPythonTypes.getType((Element)component, "rclpy::lifecycle::State"));
        return _xblockexpression;
    }

    public boolean createOnShutdownMethod(Class component) {
        boolean _xblockexpression = false;
        Operation op = component.createOwnedOperation("on_shutdown", null, null);
        Behavior _createOwnedBehavior = component.createOwnedBehavior("on_shutdown", UMLPackage.eINSTANCE.getOpaqueBehavior());
        OpaqueBehavior ob = (OpaqueBehavior)_createOwnedBehavior;
        ob.getLanguages().add((Object)"Python");
        op.getMethods().add((Object)ob);
        op.createOwnedParameter("state", RosPythonTypes.getType((Element)component, "rclpy::lifecycle::State"));
        EList _bodies = ob.getBodies();
        StringConcatenation _builder = new StringConcatenation();
        List _activities = ActivityUtils.getActivities((Class)component);
        for (Activity activity : _activities) {
            int _size_1;
            boolean _greaterThan_1;
            boolean _greaterThan;
            Class activityCl = activity.getBase_Class();
            _builder.newLineIfNotEmpty();
            List shutdownFcts = FunctionUtils.getFunctions((Activity)activity, (FunctionKind)FunctionKind.ON_SHUTDOWN);
            _builder.newLineIfNotEmpty();
            List periodicFcts = FunctionUtils.getFunctions((Activity)activity, (FunctionKind)FunctionKind.PERIODIC);
            _builder.newLineIfNotEmpty();
            int _size = shutdownFcts.size();
            boolean bl = _greaterThan = _size > 0;
            if (_greaterThan) {
                for (Behavior shutdownFct : shutdownFcts) {
                    _builder.append("self.");
                    String _name = shutdownFct.getName();
                    _builder.append(_name);
                    _builder.append("()");
                    _builder.newLineIfNotEmpty();
                }
            }
            boolean bl2 = _greaterThan_1 = (_size_1 = periodicFcts.size()) > 0;
            if (!_greaterThan_1) continue;
            for (Behavior periodicFct : periodicFcts) {
                _builder.append("self.timer_");
                String _name_1 = activityCl.getName();
                _builder.append(_name_1);
                _builder.append(".destroy()");
                _builder.newLineIfNotEmpty();
            }
        }
        _builder.newLine();
        _builder.append("return TransitionCallbackReturn.SUCCESS");
        _builder.newLine();
        _xblockexpression = _bodies.add((Object)_builder.toString());
        return _xblockexpression;
    }

    public void createROS2Dependencies(Class component) {
        try {
            Type lcTransitionCallbackReturnSC = RosPythonTypes.getType((Element)component, "rclpy::lifecycle::TransitionCallbackReturn");
            component.createDependency((NamedElement)RosPythonTypes.getRclPy((Element)component));
            if (lcTransitionCallbackReturnSC instanceof Classifier) {
                component.createDependency((NamedElement)lcTransitionCallbackReturnSC);
            }
            EList _allPorts = PortUtils.getAllPorts((EncapsulatedClassifier)component);
            for (Port port : _allPorts) {
                boolean _isQuery = InteractionUtils.isQuery((CommunicationPattern)InteractionUtils.getCommunicationPattern((Port)port));
                if (_isQuery) {
                    Interface msg_type = MessageUtils.getServiceType((Port)port);
                    msg_type.setName(ComponentTransformations.getSrvName(RosHelpers.externalName((Type)MessageUtils.getServiceType((Port)port))));
                    Package pkg = msg_type.getPackage();
                    pkg.setName("srv");
                    ApplyPythonProfile.apply((Element)pkg);
                    StereotypeUtil.applyApp((Element)pkg, Module.class);
                    component.createDependency((NamedElement)msg_type);
                    continue;
                }
                boolean _isAction = InteractionUtils.isAction((CommunicationPattern)InteractionUtils.getCommunicationPattern((Port)port));
                if (_isAction) continue;
                Type msg_type_1 = InteractionUtils.getCommObject((Port)port);
                Package pkg_1 = msg_type_1.getPackage();
                ApplyPythonProfile.apply((Element)pkg_1);
                StereotypeUtil.applyApp((Element)pkg_1, Module.class);
                component.createDependency((NamedElement)msg_type_1);
            }
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public static String getSrvName(String externalName) {
        int index = externalName.lastIndexOf("::");
        if (index != -1) {
            return externalName.substring(index + 2);
        }
        return "";
    }

    public static boolean hasProvidedsPort(Class component) {
        EList _allPorts = PortUtils.getAllPorts((EncapsulatedClassifier)component);
        for (Port port : _allPorts) {
            CommunicationPattern cp = InteractionUtils.getCommunicationPattern((Port)port);
            if (port.getProvideds().size() <= 0 || !InteractionUtils.isPush((CommunicationPattern)cp) && !InteractionUtils.isPubSub((CommunicationPattern)cp) && !InteractionUtils.isSend((CommunicationPattern)cp)) continue;
            return true;
        }
        return false;
    }

    public boolean createParentPkg(Class component) {
        boolean _xblockexpression = false;
        Package aPkg = UMLFactory.eINSTANCE.createPackage();
        aPkg.setName(this.genProject.getName().toLowerCase());
        _xblockexpression = aPkg.getPackagedElements().add((Object)component.getNearestPackage());
        return _xblockexpression;
    }

    public static void createPubsSubsAttrs(Class component) {
        EList _allPorts = PortUtils.getAllPorts((EncapsulatedClassifier)component);
        for (Port port : _allPorts) {
            boolean _greaterThan_1;
            boolean _greaterThan;
            CommunicationPattern cp = InteractionUtils.getCommunicationPattern((Port)port);
            if (!InteractionUtils.isPush((CommunicationPattern)cp) && !InteractionUtils.isPubSub((CommunicationPattern)cp)) continue;
            int _size = port.getProvideds().size();
            boolean bl = _greaterThan = _size > 0;
            if (_greaterThan) {
                Type rosPublisher = RosPythonTypes.getType((Element)port, "rclpy::lifecycle::Publisher");
                StringConcatenation _builder = new StringConcatenation();
                String _varName = ElementUtils.varName((NamedElement)port);
                _builder.append(_varName);
                _builder.append("_pub_");
                component.createOwnedAttribute(_builder.toString(), rosPublisher);
                continue;
            }
            int _size_1 = port.getRequireds().size();
            boolean bl2 = _greaterThan_1 = _size_1 > 0;
            if (!_greaterThan_1) continue;
            Type rosSubscriber = RosPythonTypes.getType((Element)port, "rclpy::subscription::Subscription");
            StringConcatenation _builder_1 = new StringConcatenation();
            String _varName_1 = ElementUtils.varName((NamedElement)port);
            _builder_1.append(_varName_1);
            _builder_1.append("_sub_");
            component.createOwnedAttribute(_builder_1.toString(), rosSubscriber);
        }
    }

    public static void createSendAttrs(Class component) {
        EList _allPorts = PortUtils.getAllPorts((EncapsulatedClassifier)component);
        for (Port port : _allPorts) {
            boolean _greaterThan_1;
            boolean _greaterThan;
            boolean _isSend = InteractionUtils.isSend((CommunicationPattern)InteractionUtils.getCommunicationPattern((Port)port));
            if (!_isSend) continue;
            int _size = port.getProvideds().size();
            boolean bl = _greaterThan = _size > 0;
            if (_greaterThan) {
                Type rosSubscriber = RosPythonTypes.getType((Element)port, "rclpy::subscription::Subscription");
                StringConcatenation _builder = new StringConcatenation();
                String _varName = ElementUtils.varName((NamedElement)port);
                _builder.append(_varName);
                _builder.append("_recv_");
                component.createOwnedAttribute(_builder.toString(), rosSubscriber);
                continue;
            }
            int _size_1 = port.getRequireds().size();
            boolean bl2 = _greaterThan_1 = _size_1 > 0;
            if (!_greaterThan_1) continue;
            Type rosPublisher = RosPythonTypes.getType((Element)port, "rclpy::lifecycle::Publisher");
            StringConcatenation _builder_1 = new StringConcatenation();
            String _varName_1 = ElementUtils.varName((NamedElement)port);
            _builder_1.append(_varName_1);
            _builder_1.append("_send_");
            component.createOwnedAttribute(_builder_1.toString(), rosPublisher);
        }
    }

    public static void createServiceAttrs(Class component) {
        EList _allPorts = PortUtils.getAllPorts((EncapsulatedClassifier)component);
        for (Port port : _allPorts) {
            boolean _greaterThan_1;
            boolean _greaterThan;
            boolean _isQuery = InteractionUtils.isQuery((CommunicationPattern)InteractionUtils.getCommunicationPattern((Port)port));
            if (!_isQuery) continue;
            int _size = port.getProvideds().size();
            boolean bl = _greaterThan = _size > 0;
            if (_greaterThan) {
                Type rosService = RosPythonTypes.getType((Element)port, "rclpy::service::Service");
                StringConcatenation _builder = new StringConcatenation();
                String _varName = ElementUtils.varName((NamedElement)port);
                _builder.append(_varName);
                _builder.append("_srv_");
                component.createOwnedAttribute(_builder.toString(), rosService);
                continue;
            }
            int _size_1 = port.getRequireds().size();
            boolean bl2 = _greaterThan_1 = _size_1 > 0;
            if (!_greaterThan_1) continue;
            Type rosClient = RosPythonTypes.getType((Element)port, "rclpy::client::Client");
            StringConcatenation _builder_1 = new StringConcatenation();
            String _varName_1 = ElementUtils.varName((NamedElement)port);
            _builder_1.append(_varName_1);
            _builder_1.append("_client_");
            component.createOwnedAttribute(_builder_1.toString(), rosClient);
        }
    }

    public static void createActionAttrs(Class component) {
        EList _allPorts = PortUtils.getAllPorts((EncapsulatedClassifier)component);
        for (Port port : _allPorts) {
            boolean _greaterThan_1;
            boolean _greaterThan;
            boolean _isAction = InteractionUtils.isAction((CommunicationPattern)InteractionUtils.getCommunicationPattern((Port)port));
            if (!_isAction) continue;
            int _size = port.getProvideds().size();
            boolean bl = _greaterThan = _size > 0;
            if (_greaterThan) {
                Type rosService = RosPythonTypes.getType((Element)port, "rclpy::action::ActionServer");
                component.createDependency((NamedElement)rosService);
                StringConcatenation _builder = new StringConcatenation();
                String _varName = ElementUtils.varName((NamedElement)port);
                _builder.append(_varName);
                _builder.append("_actsrv_");
                component.createOwnedAttribute(_builder.toString(), rosService);
                continue;
            }
            int _size_1 = port.getRequireds().size();
            boolean bl2 = _greaterThan_1 = _size_1 > 0;
            if (!_greaterThan_1) continue;
            Type rosClient = RosPythonTypes.getType((Element)port, "rclpy::action::ActionClient");
            component.createDependency((NamedElement)rosClient);
            StringConcatenation _builder_1 = new StringConcatenation();
            String _varName_1 = ElementUtils.varName((NamedElement)port);
            _builder_1.append(_varName_1);
            _builder_1.append("_actcli_");
            component.createOwnedAttribute(_builder_1.toString(), rosClient);
        }
    }

    public static void removeUnrefFunctions(Class component) {
        PackageableElement[] _clone;
        ComponentDefinition cd = (ComponentDefinition)UMLUtil.getStereotypeApplication((Element)component, ComponentDefinition.class);
        ArrayList fctList = new ArrayList();
        EList _activities = cd.getActivities();
        for (Activity activity : _activities) {
            fctList.addAll(activity.getFunctions());
        }
        PackageableElement[] packageableElementArray = _clone = (PackageableElement[])((PackageableElement[])Conversions.unwrapArray((Object)component.getNearestPackage().getPackagedElements(), PackageableElement.class)).clone();
        int n = _clone.length;
        int n2 = 0;
        while (n2 < n) {
            Function fct;
            PackageableElement pe = packageableElementArray[n2];
            if (pe instanceof OpaqueBehavior && (fct = (Function)UMLUtil.getStereotypeApplication((Element)pe, Function.class)) != null && !fctList.contains(fct)) {
                ((OpaqueBehavior)pe).destroy();
            }
            ++n2;
        }
    }

    public static void createTimerAttrs(Class component) {
        List _activities = ActivityUtils.getActivities((Class)component);
        for (Activity activity : _activities) {
            String period = ActivityUtils.getPeriod((Activity)activity);
            if (period == null) continue;
            NamedElement _qualifiedElementFromRS = ElementUtils.getQualifiedElementFromRS((Element)component, (String)"rclpy::timer::Timer");
            Type timerBase = (Type)_qualifiedElementFromRS;
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("timer_");
            String _name = activity.getBase_Class().getName();
            _builder.append(_name);
            _builder.append("_");
            component.createOwnedAttribute(_builder.toString(), timerBase);
        }
    }

    public void componentTrafo(Class component, CreateMsgPackage msgPkgCreator) {
        try {
            boolean _greaterThan;
            MessageUtils.createMessagesOrServices((CreateMsgPackage)msgPkgCreator, (Class)component);
            this.createParentPkg(component);
            ApplyPythonProfile.apply((Element)component);
            if (this.genProject == null) {
                throw new TransformationException(ExecuteTransformationChain.USER_CANCEL);
            }
            this.createOnConfigureMethod(component);
            this.createOnActivateMethod(component);
            this.createOnDeactivateMethod(component);
            this.createOnCleanupMethod(component);
            this.createOnShutdownMethod(component);
            ComponentTransformationUtils.liftFunctions((Class)component);
            Constructor.createConstructor(component);
            this.createROS2Dependencies(component);
            boolean _isRegistered = ComponentUtils.isRegistered((Class)component);
            boolean _hasExternalCode = ActivityUtils.hasExternalCode((Class)component);
            if (_hasExternalCode) {
                new Ros2CodeSkeleton(component).createSkeleton();
            }
            CreateMain.createMain(component);
            ComponentTransformationUtils.removeActivities((Class)component);
            ComponentTransformations.createPubsSubsAttrs(component);
            ComponentTransformations.createSendAttrs(component);
            ComponentTransformations.createServiceAttrs(component);
            ComponentTransformations.createActionAttrs(component);
            ComponentTransformations.createTimerAttrs(component);
            int _size = ParameterUtils.getAllParameters((Class)component).size();
            boolean bl = _greaterThan = _size > 0;
            if (_greaterThan) {
                ParameterTransformations.declareParameters(component);
                ParameterTransformations.initParameters(component);
            }
            ParameterTransformations.moveParameters(component);
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public void componentCodegen(Class component, CreateMsgPackage msgPkgCreator) {
        RoboticsPythonCreator codeGen = new RoboticsPythonCreator(this.genProject, this.fileAccess);
        ComponentTransformationUtils.removeTemplateSig((Class)component);
        ComponentTransformationUtils.removePorts((Class)component);
        ComponentTransformations.removeUnrefFunctions(component);
        TransformationContext.current.project = this.genProject;
        ProjectTools.genCode(codeGen, component);
    }
}

