/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.robotics.ros2.codegen.python.component;

import org.eclipse.papyrus.designer.languages.common.profile.Codegen.TemplateBinding;
import org.eclipse.papyrus.designer.transformation.base.utils.TransformationException;
import org.eclipse.papyrus.designer.uml.tools.utils.StereotypeUtil;
import org.eclipse.papyrus.robotics.codegen.common.utils.ActivityUtils;
import org.eclipse.papyrus.robotics.codegen.common.utils.ApplyProfiles;
import org.eclipse.papyrus.robotics.core.utils.FunctionUtils;
import org.eclipse.papyrus.robotics.core.utils.InteractionUtils;
import org.eclipse.papyrus.robotics.profile.robotics.components.ActivityPort;
import org.eclipse.papyrus.robotics.profile.robotics.functions.FunctionKind;
import org.eclipse.papyrus.robotics.ros2.codegen.common.utils.MessageUtils;
import org.eclipse.papyrus.robotics.ros2.codegen.common.utils.RosHelpers;
import org.eclipse.papyrus.robotics.ros2.codegen.python.utils.RosPythonTypes;
import org.eclipse.uml2.uml.Behavior;
import org.eclipse.uml2.uml.BehavioralFeature;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Parameter;
import org.eclipse.uml2.uml.ParameterDirectionKind;
import org.eclipse.uml2.uml.Port;
import org.eclipse.uml2.uml.Type;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Exceptions;

public class Callbacks {
    private static final String PUSH = "PUSH or SEND";
    private static final String QUERY = "QUERY";
    private static final String ACTION = "ACTION";
    private static final String WHOLE_PKG = "Please note that code gets generated for the whole ROS 2 package, not only for the currently open component";

    public static String callBackMethodForPush(Class component, Port port) {
        boolean _tripleNotEquals;
        ActivityPort activity = ActivityUtils.getActivityForPort((Class)component, (Port)port);
        Callbacks.checkActivity(activity, PUSH, port);
        Behavior fct = FunctionUtils.getFunction((ActivityPort)activity, (FunctionKind)FunctionKind.HANDLER);
        Callbacks.checkFunction(fct, PUSH, activity, port);
        Behavior fctCopy = component.getOwnedBehavior(fct.getName());
        BehavioralFeature _specification = fctCopy.getSpecification();
        boolean bl = _tripleNotEquals = _specification != null;
        if (_tripleNotEquals) {
            fctCopy.getSpecification().createOwnedParameter("commobj", InteractionUtils.getCommObject((Port)port));
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("self.");
            String _name = fct.getName();
            _builder.append(_name);
            return _builder.toString();
        }
        return null;
    }

    public static void clientCallBackMethodForService(Class component, Port port) {
        ActivityPort activityPort = ActivityUtils.getActivityForPort((Class)component, (Port)port);
        Callbacks.checkActivity(activityPort, QUERY, port);
        Behavior resultFct = FunctionUtils.getFunction((ActivityPort)activityPort, (FunctionKind)FunctionKind.HANDLER, (String)"result");
        if (resultFct != null) {
            Type clientType = RosPythonTypes.getType((Element)port, "rclpy::client::Client");
            Behavior lResultFct = component.getOwnedBehavior(resultFct.getName());
            Parameter resultParam = lResultFct.getSpecification().createOwnedParameter("future", clientType);
            ApplyProfiles.applyCommonProfile((Element)resultParam);
            TemplateBinding resultTpl = (TemplateBinding)StereotypeUtil.applyApp((Element)resultParam, TemplateBinding.class);
            resultTpl.getActuals().add((Object)MessageUtils.getServiceType((Port)port));
        }
    }

    public static String serverCallBackMethodForService(Class component, Port port) {
        boolean _tripleNotEquals;
        ActivityPort activityPort = ActivityUtils.getActivityForPort((Class)component, (Port)port);
        Callbacks.checkActivity(activityPort, QUERY, port);
        Behavior fct = FunctionUtils.getFunction((ActivityPort)activityPort, (FunctionKind)FunctionKind.HANDLER);
        Callbacks.checkFunction(fct, QUERY, activityPort, port);
        Behavior fctCopy = component.getOwnedBehavior(fct.getName());
        BehavioralFeature _specification = fctCopy.getSpecification();
        boolean bl = _tripleNotEquals = _specification != null;
        if (_tripleNotEquals) {
            fctCopy.getSpecification().createOwnedParameter("request", (Type)MessageUtils.getServiceType((Port)port));
            fctCopy.getSpecification().createOwnedParameter("response", (Type)MessageUtils.getServiceType((Port)port));
            Parameter retParam = fctCopy.getSpecification().createOwnedParameter("ret", RosHelpers.getRosPrimitiveType((Element)port, (String)"primitive::bool"));
            retParam.setDirection(ParameterDirectionKind.RETURN_LITERAL);
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("self.");
            String _name = fct.getName();
            _builder.append(_name);
            return _builder.toString();
        }
        return null;
    }

    public static void clientCallsbacksForAction(Class component, Port port) {
        Behavior goalFct;
        Behavior resultFct;
        ActivityPort activityPort = ActivityUtils.getActivityForPort((Class)component, (Port)port);
        Callbacks.checkActivity(activityPort, ACTION, port);
        Behavior feedbackFct = FunctionUtils.getFunction((ActivityPort)activityPort, (FunctionKind)FunctionKind.HANDLER, (String)"feedback");
        if (feedbackFct != null) {
            Behavior lFeedbackFct = component.getOwnedBehavior(feedbackFct.getName());
            lFeedbackFct.getSpecification().createOwnedParameter("handle", null);
            lFeedbackFct.getSpecification().createOwnedParameter("feedback", null);
        }
        if ((resultFct = FunctionUtils.getFunction((ActivityPort)activityPort, (FunctionKind)FunctionKind.HANDLER, (String)"result")) != null) {
            Behavior lResultFct = component.getOwnedBehavior(resultFct.getName());
            lResultFct.getSpecification().createOwnedParameter("result", null);
        }
        if ((goalFct = FunctionUtils.getFunction((ActivityPort)activityPort, (FunctionKind)FunctionKind.HANDLER, (String)"goal")) != null) {
            Behavior lGoalFct = component.getOwnedBehavior(goalFct.getName());
            lGoalFct.getSpecification().createOwnedParameter("future", null);
        }
    }

    public static String serverCallsbacksForAction(Class component, Port port) {
        ActivityPort activityPort = ActivityUtils.getActivityForPort((Class)component, (Port)port);
        Callbacks.checkActivity(activityPort, ACTION, port);
        Behavior goalFct = FunctionUtils.getFunction((ActivityPort)activityPort, (FunctionKind)FunctionKind.HANDLER, (String)"goal");
        Callbacks.checkFunction(goalFct, "ACTION/feedback", activityPort, port);
        Behavior cancelFct = FunctionUtils.getFunction((ActivityPort)activityPort, (FunctionKind)FunctionKind.HANDLER, (String)"cancel");
        Callbacks.checkFunction(cancelFct, "ACTION/result", activityPort, port);
        Behavior acceptedFct = FunctionUtils.getFunction((ActivityPort)activityPort, (FunctionKind)FunctionKind.HANDLER, (String)"accepted");
        Callbacks.checkFunction(acceptedFct, "ACTION/goal", activityPort, port);
        Behavior lGoalFct = component.getOwnedBehavior(goalFct.getName());
        Behavior lCancelFct = component.getOwnedBehavior(cancelFct.getName());
        Behavior lAcceptedFct = component.getOwnedBehavior(acceptedFct.getName());
        Type goalResponse = RosPythonTypes.getType((Element)port, "rclpy::action::GoalResponse");
        Type cancelResponse = RosPythonTypes.getType((Element)port, "rclpy::action::CancelResponse");
        lGoalFct.getSpecification().createOwnedParameter("goal", goalResponse);
        Parameter goalRetParam = lGoalFct.getSpecification().createOwnedParameter("return", goalResponse);
        goalRetParam.setDirection(ParameterDirectionKind.RETURN_LITERAL);
        lCancelFct.getSpecification().createOwnedParameter("goal_handle", goalResponse);
        Parameter cancelRetParam = lCancelFct.getSpecification().createOwnedParameter("return", cancelResponse);
        cancelRetParam.setDirection(ParameterDirectionKind.RETURN_LITERAL);
        lAcceptedFct.getSpecification().createOwnedParameter("goal_handle", null);
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("execute_callback = self.");
        String _name = acceptedFct.getName();
        _builder.append(_name);
        _builder.append(",");
        _builder.newLineIfNotEmpty();
        _builder.append("goal_callback = self.");
        String _name_1 = goalFct.getName();
        _builder.append(_name_1);
        _builder.append(",");
        _builder.newLineIfNotEmpty();
        _builder.append("cancel_callback = self.");
        String _name_2 = cancelFct.getName();
        _builder.append(_name_2);
        return _builder.toString();
    }

    public static void checkActivity(ActivityPort activityPort, String portKind, Port port) {
        try {
            if (activityPort == null) {
                String _format = String.format("The %s port \"%s\" of component \"%s\" is not connected with any activity port. Please note that code gets generated for the whole ROS 2 package, not only for the currently open component", portKind, port.getName(), port.getClass_().getName());
                throw new TransformationException(_format);
            }
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public static void checkFunction(Behavior function, String portKind, ActivityPort activity, Port port) {
        try {
            if (function == null) {
                String _format = String.format("No handler function (for %s) is found for activity port \"%s\" associated with port \"%s\" of component \"%s\". Please note that code gets generated for the whole ROS 2 package, not only for the currently open component", portKind, activity.getBase_Port().getName(), port.getName(), port.getClass_().getName());
                throw new TransformationException(_format);
            }
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }
}

