/**
 * Copyright (c) 2022 CEA LIST.
 * 
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 * 
 * Contributors:
 *  Ansgar Radermacher  ansgar.radermacher@cea.fr
 */
package org.eclipse.papyrus.robotics.ros2.codegen.python.utils;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.papyrus.robotics.ros2.codegen.common.builder.ColconBuilderUtils;
import org.eclipse.papyrus.robotics.ros2.codegen.python.component.RoboticsPythonCreator;
import org.eclipse.xtext.xbase.lib.Exceptions;

/**
 * get or create a project with a given name
 */
@SuppressWarnings("all")
public class ProjectTools {
  /**
   * get a simple project
   */
  public static IProject getProject(final String projectName) {
    try {
      IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
      IProject genProject = root.getProject(projectName);
      boolean _exists = genProject.exists();
      boolean _not = (!_exists);
      if (_not) {
        NullProgressMonitor _nullProgressMonitor = new NullProgressMonitor();
        genProject.create(_nullProgressMonitor);
        genProject.open(null);
        if (((genProject != null) && (!genProject.exists()))) {
          String _format = String.format(
            "project does not exist");
          throw new RuntimeException(_format);
        }
      }
      boolean _hasBuilder = ColconBuilderUtils.hasBuilder(genProject);
      boolean _not_1 = (!_hasBuilder);
      if (_not_1) {
        ColconBuilderUtils.add(genProject);
      }
      return genProject;
    } catch (Throwable _e) {
      throw Exceptions.sneakyThrow(_e);
    }
  }

  public static void genCode(final RoboticsPythonCreator codeGen, final org.eclipse.uml2.uml.Class component) {
    final UniqueEList<org.eclipse.uml2.uml.Package> packagesToGenerate = new UniqueEList<org.eclipse.uml2.uml.Package>();
    packagesToGenerate.add(component.getNearestPackage());
    for (final org.eclipse.uml2.uml.Package pkg : packagesToGenerate) {
      NullProgressMonitor _nullProgressMonitor = new NullProgressMonitor();
      codeGen.createPackageableElement(pkg, _nullProgressMonitor);
    }
  }
}
