package org.eclipse.papyrus.robotics.ros2.codegen.python.build;

import java.util.List;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.papyrus.designer.languages.common.base.file.IPFileSystemAccess;
import org.eclipse.papyrus.designer.languages.python.codegen.transformation.PythonCodeGenUtils;
import org.eclipse.papyrus.robotics.codegen.common.utils.PackageTools;
import org.eclipse.papyrus.robotics.ros2.codegen.common.utils.PackageXMLUtils;
import org.eclipse.xtend2.lib.StringConcatenation;

@SuppressWarnings("all")
public class CreateCompSetupPy {
  public static CharSequence createSetupfile(final org.eclipse.uml2.uml.Package pkg, final List<org.eclipse.uml2.uml.Class> allComponents, final List<org.eclipse.uml2.uml.Class> componentsInPkg, final org.eclipse.uml2.uml.Class system) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("from setuptools import setup");
    _builder.newLine();
    _builder.append("import glob");
    _builder.newLine();
    _builder.newLine();
    _builder.append("package_name = \'");
    String _pkgName = PackageTools.pkgName(pkg);
    _builder.append(_pkgName);
    _builder.append("\'");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("setup(");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("name=package_name,");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("version=\'0.0.0\',");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("packages=[package_name, ");
    {
      UniqueEList<org.eclipse.uml2.uml.Package> _usedPackages = CreateCompSetupPy.usedPackages(componentsInPkg);
      boolean _hasElements = false;
      for(final org.eclipse.uml2.uml.Package compPkg : _usedPackages) {
        if (!_hasElements) {
          _hasElements = true;
        } else {
          _builder.appendImmediate(", ", "\t");
        }
        _builder.append("\'");
        String _pkgName_1 = PackageTools.pkgName(pkg);
        _builder.append(_pkgName_1, "\t");
        _builder.append(".");
        String _lowerCase = compPkg.getName().toLowerCase();
        _builder.append(_lowerCase, "\t");
        _builder.append("\'");
      }
    }
    _builder.append("],");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("data_files = [");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("(\'share/ament_index/resource_index/packages\',");
    _builder.newLine();
    _builder.append("\t\t\t\t");
    _builder.append("[\'resource/\' + package_name]),");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("(\'share/\' + package_name, [\'package.xml\']),");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("(\'share/\' + package_name + \'/launch\', glob.glob(\'launch/*.py\')),");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("(\'share/\' + package_name + \'/launch\', glob.glob(\'launch/*.launch\')),");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("(\'share/\' + package_name + \'/launch/cfg\', glob.glob(\'launch/cfg/*.yaml\')),");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("],");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("install_requires=[\'setuptools\'],");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("zip_safe=True,");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("maintainer=\'");
    String _maintainerName = PackageXMLUtils.getMaintainerName(pkg);
    _builder.append(_maintainerName, "\t");
    _builder.append("\',");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("maintainer_email=\'");
    String _maintainerMail = PackageXMLUtils.getMaintainerMail(pkg);
    _builder.append(_maintainerMail, "\t");
    _builder.append("\',");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("description=\'TODO: Package description\',");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("license=\'TODO: License declaration\',");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("tests_require=[\'pytest\'],");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("entry_points={");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("\'console_scripts\': [");
    _builder.newLine();
    {
      for(final org.eclipse.uml2.uml.Class component : componentsInPkg) {
        _builder.append("\t\t\t");
        _builder.append("\'");
        String _name = component.getName();
        _builder.append(_name, "\t\t\t");
        _builder.append(" = ");
        String _pkgName_2 = PackageTools.pkgName(pkg);
        _builder.append(_pkgName_2, "\t\t\t");
        _builder.append(".");
        String _pythonQName = PythonCodeGenUtils.getPythonQName(component);
        _builder.append(_pythonQName, "\t\t\t");
        _builder.append("_main:main\',");
        _builder.newLineIfNotEmpty();
      }
    }
    _builder.append("\t\t\t");
    _builder.append("]");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.append(")");
    _builder.newLine();
    return _builder;
  }

  protected static UniqueEList<org.eclipse.uml2.uml.Package> usedPackages(final List<org.eclipse.uml2.uml.Class> componentsInPkg) {
    final UniqueEList<org.eclipse.uml2.uml.Package> pkgs = new UniqueEList<org.eclipse.uml2.uml.Package>();
    for (final org.eclipse.uml2.uml.Class component : componentsInPkg) {
      pkgs.add(component.getNearestPackage());
    }
    return pkgs;
  }

  public static void generate(final IPFileSystemAccess fileAccess, final org.eclipse.uml2.uml.Package pkg, final List<org.eclipse.uml2.uml.Class> allComponents, final List<org.eclipse.uml2.uml.Class> componentsInPkg, final org.eclipse.uml2.uml.Class system) {
    fileAccess.generateFile("setup.py", CreateCompSetupPy.createSetupfile(pkg, allComponents, componentsInPkg, system).toString());
  }
}
