/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.robotics.ros2.codegen.cpp.component;

import java.util.List;
import org.eclipse.papyrus.designer.languages.cpp.profile.C_Cpp.Include;
import org.eclipse.papyrus.designer.languages.cpp.profile.C_Cpp.ManualGeneration;
import org.eclipse.papyrus.robotics.codegen.common.utils.ActivityUtils;
import org.eclipse.papyrus.robotics.codegen.common.utils.ComponentUtils;
import org.eclipse.papyrus.robotics.core.utils.FunctionUtils;
import org.eclipse.papyrus.robotics.core.utils.ParameterUtils;
import org.eclipse.papyrus.robotics.profile.robotics.components.Activity;
import org.eclipse.papyrus.robotics.profile.robotics.functions.FunctionKind;
import org.eclipse.papyrus.robotics.ros2.codegen.common.component.CallbackGroups;
import org.eclipse.papyrus.robotics.ros2.codegen.common.utils.RosHelpers;
import org.eclipse.papyrus.robotics.ros2.codegen.cpp.utils.RosCppTypes;
import org.eclipse.papyrus.uml.tools.utils.StereotypeUtil;
import org.eclipse.uml2.uml.Behavior;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.TypedElement;
import org.eclipse.xtend2.lib.StringConcatenation;

public class CreateMain {
    public static CharSequence registerComponent(Class component) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("#include \"rclcpp_components/register_node_macro.hpp\"");
        _builder.newLine();
        _builder.newLine();
        _builder.append("// Register the component with class_loader.");
        _builder.newLine();
        _builder.append("// This acts as a sort of entry point, allowing the component to be discoverable when its library");
        _builder.newLine();
        _builder.append("// is being loaded into a running process.");
        _builder.newLine();
        _builder.append("RCLCPP_COMPONENTS_REGISTER_NODE(");
        String _qualifiedName = component.getQualifiedName();
        _builder.append(_qualifiedName);
        _builder.append(")");
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    public static void createMain(Class component) {
        Package _nearestPackage = component.getNearestPackage();
        String _name = component.getName();
        String _plus = _name + "_main";
        Class main = _nearestPackage.createOwnedClass(_plus, false);
        component.createDependency((NamedElement)main);
        StereotypeUtil.apply((Element)main, ManualGeneration.class);
        Include include = (Include)StereotypeUtil.applyApp((Element)main, Include.class);
        include.setBody(CreateMain.createMainCode(component).toString());
    }

    public static CharSequence lambdaStart(Class component) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("[&");
        String _instName = ComponentUtils.getInstName((Class)component);
        _builder.append(_instName);
        _builder.append("](const rclcpp_lifecycle::State&) {");
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    public static CharSequence lambdaEnd() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("return rclcpp_lifecycle::node_interfaces::LifecycleNodeInterface::CallbackReturn::SUCCESS;");
        _builder.newLine();
        return _builder;
    }

    public static CharSequence createMainCode(Class component) {
        int _size;
        boolean _greaterThan_5;
        int _length_4;
        boolean _greaterThan_4;
        int _length_3;
        boolean _greaterThan_3;
        int _length_2;
        boolean _greaterThan_2;
        int _length_1;
        boolean _greaterThan_1;
        boolean _greaterThan;
        StringConcatenation _builder = new StringConcatenation();
        String _instName = ComponentUtils.getInstName((Class)component);
        String instRef = _instName + "->";
        _builder.newLineIfNotEmpty();
        CharSequence onConfigure = CreateMain.onLifecycleEvent(component, instRef, FunctionKind.ON_CONFIGURE);
        _builder.newLineIfNotEmpty();
        CharSequence onActivate = CreateMain.onActivate(component, instRef);
        _builder.newLineIfNotEmpty();
        CharSequence onDeActivate = CreateMain.onQuitActive(component, instRef, FunctionKind.ON_DEACTIVATE);
        _builder.newLineIfNotEmpty();
        CharSequence onShutdown = CreateMain.onQuitActive(component, instRef, FunctionKind.ON_SHUTDOWN);
        _builder.newLineIfNotEmpty();
        CharSequence onCleanup = CreateMain.onLifecycleEvent(component, instRef, FunctionKind.ON_CLEANUP);
        _builder.newLineIfNotEmpty();
        String _qualifiedName = component.getQualifiedName();
        String _postfix = ActivityUtils.getPostfix((Class)component);
        String compClassName = _qualifiedName + _postfix;
        _builder.newLineIfNotEmpty();
        _builder.append("#include \"");
        String _name = component.getNearestPackage().getName();
        _builder.append(_name);
        _builder.append("/");
        String _name_1 = component.getName();
        _builder.append(_name_1);
        String _postfix_1 = ActivityUtils.getPostfix((Class)component);
        _builder.append(_postfix_1);
        _builder.append(".h\"");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        boolean _hasPeriodicActivities = ActivityUtils.hasPeriodicActivities((Class)component);
        if (_hasPeriodicActivities) {
            _builder.append("using namespace std::chrono_literals;");
            _builder.newLine();
        }
        CreateMain.createTimer(component);
        _builder.newLineIfNotEmpty();
        _builder.append("// declare options");
        _builder.newLine();
        _builder.append("rclcpp::NodeOptions ");
        String _instName_1 = ComponentUtils.getInstName((Class)component);
        _builder.append(_instName_1);
        _builder.append("_options;");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("int main(int argc, char **argv) {");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("rclcpp::init(argc, argv);");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("auto ");
        String _instName_2 = ComponentUtils.getInstName((Class)component);
        _builder.append(_instName_2, "\t");
        _builder.append(" = std::make_shared<");
        _builder.append(compClassName, "\t");
        _builder.append(">(");
        String _instName_3 = ComponentUtils.getInstName((Class)component);
        _builder.append(_instName_3, "\t");
        _builder.append("_options);");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("RCLCPP_INFO(");
        _builder.append(instRef, "\t");
        _builder.append("get_logger(), \"");
        String _name_2 = component.getName();
        _builder.append(_name_2, "\t");
        _builder.append(" has been initialized\");");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        int _length = onConfigure.length();
        boolean bl = _greaterThan = _length > 0;
        if (_greaterThan) {
            _builder.append("\t");
            _builder.append(instRef, "\t");
            _builder.append("register_on_configure(");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("\t");
            CharSequence _lambdaStart = CreateMain.lambdaStart(component);
            _builder.append((Object)_lambdaStart, "\t\t");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("\t\t");
            _builder.append((Object)onConfigure, "\t\t\t");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("\t\t");
            CharSequence _lambdaEnd = CreateMain.lambdaEnd();
            _builder.append((Object)_lambdaEnd, "\t\t\t");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("}");
            _builder.newLine();
            _builder.append("\t");
            _builder.append(");");
            _builder.newLine();
        }
        boolean bl2 = _greaterThan_1 = (_length_1 = onActivate.length()) > 0;
        if (_greaterThan_1) {
            _builder.append("\t");
            _builder.append(instRef, "\t");
            _builder.append("register_on_activate(");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("\t");
            CharSequence _lambdaStart_1 = CreateMain.lambdaStart(component);
            _builder.append((Object)_lambdaStart_1, "\t\t");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("\t\t");
            _builder.append((Object)onActivate, "\t\t\t");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("\t\t");
            CharSequence _lambdaEnd_1 = CreateMain.lambdaEnd();
            _builder.append((Object)_lambdaEnd_1, "\t\t\t");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("}");
            _builder.newLine();
            _builder.append("\t");
            _builder.append(");");
            _builder.newLine();
        }
        boolean bl3 = _greaterThan_2 = (_length_2 = onDeActivate.length()) > 0;
        if (_greaterThan_2) {
            _builder.append("\t");
            _builder.append(instRef, "\t");
            _builder.append("register_on_deactivate(");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("\t");
            CharSequence _lambdaStart_2 = CreateMain.lambdaStart(component);
            _builder.append((Object)_lambdaStart_2, "\t\t");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("\t\t");
            _builder.append((Object)onDeActivate, "\t\t\t");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("\t\t");
            CharSequence _lambdaEnd_2 = CreateMain.lambdaEnd();
            _builder.append((Object)_lambdaEnd_2, "\t\t\t");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("}");
            _builder.newLine();
            _builder.append("\t");
            _builder.append(");");
            _builder.newLine();
        }
        boolean bl4 = _greaterThan_3 = (_length_3 = onShutdown.length()) > 0;
        if (_greaterThan_3) {
            _builder.append("\t");
            _builder.append(instRef, "\t");
            _builder.append("register_on_shutdown(");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("\t");
            CharSequence _lambdaStart_3 = CreateMain.lambdaStart(component);
            _builder.append((Object)_lambdaStart_3, "\t\t");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("\t\t");
            _builder.append((Object)onShutdown, "\t\t\t");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("\t\t");
            CharSequence _lambdaEnd_3 = CreateMain.lambdaEnd();
            _builder.append((Object)_lambdaEnd_3, "\t\t\t");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("}");
            _builder.newLine();
            _builder.append("\t");
            _builder.append(");");
            _builder.newLine();
        }
        boolean bl5 = _greaterThan_4 = (_length_4 = onCleanup.length()) > 0;
        if (_greaterThan_4) {
            _builder.append("\t");
            _builder.append(instRef, "\t");
            _builder.append("register_on_cleanup(");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("\t");
            CharSequence _lambdaStart_4 = CreateMain.lambdaStart(component);
            _builder.append((Object)_lambdaStart_4, "\t\t");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("\t\t");
            _builder.append((Object)onCleanup, "\t\t\t");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("\t\t");
            CharSequence _lambdaEnd_4 = CreateMain.lambdaEnd();
            _builder.append((Object)_lambdaEnd_4, "\t\t\t");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("}");
            _builder.newLine();
            _builder.append("\t");
            _builder.append(");");
            _builder.newLine();
        }
        boolean bl6 = _greaterThan_5 = (_size = ParameterUtils.getAllParameters((Class)component).size()) > 0;
        if (_greaterThan_5) {
            _builder.append("\t");
            _builder.append(instRef, "\t");
            _builder.append("declareParameters();");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append(instRef, "\t");
            _builder.append("initParameterVars();");
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        _builder.append("\t");
        _builder.append("rclcpp::executors::MultiThreadedExecutor executor;");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("executor.add_node(");
        _builder.append(instRef, "\t");
        _builder.append("get_node_base_interface());");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("executor.spin();");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("rclcpp::shutdown();");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    public static void createTimer(Class component) {
        List _activities = ActivityUtils.getActivities((Class)component);
        for (Activity activity : _activities) {
            String period = ActivityUtils.getPeriod((Activity)activity);
            if (period == null) continue;
            Type timerBase = RosCppTypes.getType((Element)component, "ros2Library::rclcpp::timer::TimerBase");
            Type cbgType = RosCppTypes.getType((Element)component, "ros2Library::rclcpp::CallbackGroup");
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("timer_");
            String _name = activity.getBase_Class().getName();
            _builder.append(_name);
            _builder.append("_");
            Property timer = component.createOwnedAttribute(_builder.toString(), timerBase);
            Property t_cbg = component.createOwnedAttribute(CallbackGroups.tCallbackGroupName((Class)activity.getBase_Class()), cbgType);
            RosHelpers.useSharedPtr((TypedElement)timer);
            RosHelpers.useSharedPtr((TypedElement)t_cbg);
        }
    }

    public static CharSequence onLifecycleEvent(Class component, String instRef, FunctionKind kind) {
        StringConcatenation _builder = new StringConcatenation();
        List _activities = ActivityUtils.getActivities((Class)component);
        for (Activity activity : _activities) {
            boolean _greaterThan;
            List associatedFcts = FunctionUtils.getFunctions((Activity)activity, (FunctionKind)kind);
            _builder.newLineIfNotEmpty();
            int _size = associatedFcts.size();
            boolean bl = _greaterThan = _size > 0;
            if (!_greaterThan) continue;
            for (Behavior associatedFct : associatedFcts) {
                _builder.append(instRef);
                String _name = associatedFct.getName();
                _builder.append(_name);
                _builder.append("();");
                _builder.newLineIfNotEmpty();
            }
        }
        return _builder;
    }

    public static CharSequence onActivate(Class component, String instRef) {
        StringConcatenation _builder = new StringConcatenation();
        List _activities = ActivityUtils.getActivities((Class)component);
        for (Activity activity : _activities) {
            boolean _greaterThan;
            Class activityCl = activity.getBase_Class();
            _builder.newLineIfNotEmpty();
            String period = ActivityUtils.getPeriod((Activity)activity);
            _builder.newLineIfNotEmpty();
            List activateFcts = FunctionUtils.getFunctions((Activity)activity, (FunctionKind)FunctionKind.ON_ACTIVATE);
            _builder.newLineIfNotEmpty();
            List periodicFcts = FunctionUtils.getFunctions((Activity)activity, (FunctionKind)FunctionKind.PERIODIC);
            _builder.newLineIfNotEmpty();
            int _size = activateFcts.size();
            boolean bl = _greaterThan = _size > 0;
            if (_greaterThan) {
                for (Behavior activateFct : activateFcts) {
                    _builder.append(instRef);
                    String _name = activateFct.getName();
                    _builder.append(_name);
                    _builder.append("();");
                    _builder.newLineIfNotEmpty();
                }
            }
            if (period == null || periodicFcts.size() <= 0) continue;
            _builder.append("// periodic execution (");
            _builder.append(period);
            _builder.append(") for ");
            String _name_1 = activityCl.getName();
            _builder.append(_name_1);
            _builder.append(" using a wall timer");
            _builder.newLineIfNotEmpty();
            _builder.append("// create a callback group for the timer");
            _builder.newLine();
            for (Behavior periodicFct : periodicFcts) {
                _builder.append(instRef);
                _builder.append("timer_");
                String _name_2 = activityCl.getName();
                _builder.append(_name_2);
                _builder.append("_ = ");
                _builder.append(instRef);
                _builder.append("create_wall_timer(");
                _builder.append(period);
                _builder.append(",");
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                _builder.append("std::bind(&");
                String _name_3 = component.getNearestPackage().getName();
                _builder.append(_name_3, "\t");
                _builder.append("::");
                String _name_4 = component.getName();
                _builder.append(_name_4, "\t");
                String _postfix = ActivityUtils.getPostfix((Class)component);
                _builder.append(_postfix, "\t");
                _builder.append("::");
                String _name_5 = periodicFct.getName();
                _builder.append(_name_5, "\t");
                _builder.append(", ");
                String _instName = ComponentUtils.getInstName((Class)component);
                _builder.append(_instName, "\t");
                _builder.append("), ");
                _builder.append(instRef, "\t");
                String _tCallbackGroupName = CallbackGroups.tCallbackGroupName((Class)activityCl);
                _builder.append(_tCallbackGroupName, "\t");
                _builder.append(");");
                _builder.newLineIfNotEmpty();
            }
        }
        return _builder;
    }

    public static CharSequence onQuitActive(Class component, String instRef, FunctionKind kind) {
        StringConcatenation _builder = new StringConcatenation();
        List _activities = ActivityUtils.getActivities((Class)component);
        for (Activity activity : _activities) {
            Class activityCl = activity.getBase_Class();
            _builder.newLineIfNotEmpty();
            String period = ActivityUtils.getPeriod((Activity)activity);
            _builder.newLineIfNotEmpty();
            List associatedFcts = FunctionUtils.getFunctions((Activity)activity, (FunctionKind)kind);
            _builder.newLineIfNotEmpty();
            List periodicFcts = FunctionUtils.getFunctions((Activity)activity, (FunctionKind)FunctionKind.PERIODIC);
            _builder.newLineIfNotEmpty();
            if ((period == null || periodicFcts.size() <= 0) && associatedFcts.size() <= 0) continue;
            for (Behavior activateFct : associatedFcts) {
                _builder.append(instRef);
                String _name = activateFct.getName();
                _builder.append(_name);
                _builder.append("();");
                _builder.newLineIfNotEmpty();
            }
            if (period == null || periodicFcts.size() <= 0) continue;
            _builder.append("// stop timer of ");
            String _name_1 = activityCl.getName();
            _builder.append(_name_1);
            _builder.newLineIfNotEmpty();
            _builder.append(instRef);
            _builder.append("timer_");
            String _name_2 = activityCl.getName();
            _builder.append(_name_2);
            _builder.append("_->cancel();");
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }
}

