/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.weaving.aspectj;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.aspectj.weaver.loadtime.definition.Definition;
import org.eclipse.equinox.service.weaving.ISupplementerRegistry;
import org.eclipse.equinox.service.weaving.IWeavingService;
import org.eclipse.equinox.weaving.aspectj.AspectAdmin;
import org.eclipse.equinox.weaving.aspectj.AspectConfiguration;
import org.eclipse.equinox.weaving.aspectj.AspectJWeavingStarter;
import org.eclipse.equinox.weaving.aspectj.loadtime.AspectResolver;
import org.eclipse.equinox.weaving.aspectj.loadtime.OSGiWeavingAdaptor;
import org.eclipse.equinox.weaving.aspectj.loadtime.OSGiWeavingContext;
import org.osgi.framework.Bundle;
import org.osgi.framework.wiring.BundleRevision;

public class AspectJWeavingService
implements IWeavingService {
    private List<Definition> aspectDefinitions;
    private BundleRevision bundleRevision;
    private boolean enabled;
    private String namespaceAddOn;
    private OSGiWeavingAdaptor weavingAdaptor;
    private OSGiWeavingContext weavingContext;

    public AspectJWeavingService() {
        if (AspectJWeavingStarter.DEBUG) {
            System.out.println("- WeavingService.<init>");
        }
    }

    public AspectJWeavingService(ClassLoader loader, Bundle bundle, BundleRevision bundleRevision, ISupplementerRegistry supplementerRegistry, AspectAdmin aspectAdmin) {
        this.bundleRevision = bundleRevision;
        AspectResolver aspectResolver = new AspectResolver(supplementerRegistry, aspectAdmin, AspectJWeavingStarter.getDefault().getContext());
        AspectConfiguration aspectConfig = aspectResolver.resolveAspectsFor(bundle, bundleRevision);
        this.namespaceAddOn = aspectConfig.getFingerprint();
        this.aspectDefinitions = aspectConfig.getAspectDefinitions();
        boolean bl = this.enabled = this.aspectDefinitions.size() > 0;
        if (this.enabled) {
            this.weavingContext = new OSGiWeavingContext(loader, bundleRevision, this.aspectDefinitions);
            this.weavingAdaptor = new OSGiWeavingAdaptor(loader, this.weavingContext, this.namespaceAddOn);
        } else if (AspectJWeavingStarter.DEBUG) {
            System.err.println("[org.eclipse.equinox.weaving.aspectj] info not weaving bundle '" + bundle.getSymbolicName() + "'");
        }
    }

    private void ensureAdaptorInit() {
        this.weavingAdaptor.initialize();
    }

    public void flushGeneratedClasses(ClassLoader loader) {
        if (this.enabled) {
            this.ensureAdaptorInit();
            this.weavingAdaptor.flushGeneratedClasses();
        }
    }

    public boolean generatedClassesExistFor(ClassLoader loader, String className) {
        if (this.enabled) {
            this.ensureAdaptorInit();
            return this.weavingAdaptor.generatedClassesExistFor(className);
        }
        return false;
    }

    public Map<String, byte[]> getGeneratedClassesFor(String className) {
        if (this.enabled) {
            this.ensureAdaptorInit();
            return this.weavingAdaptor.getGeneratedClassesFor(className);
        }
        return new HashMap<String, byte[]>();
    }

    public String getKey() {
        if (AspectJWeavingStarter.DEBUG) {
            System.out.println("> WeavingService.getKey() bundle=" + this.bundleRevision.getSymbolicName());
        }
        String namespace = this.namespaceAddOn;
        if (AspectJWeavingStarter.DEBUG) {
            System.out.println("< WeavingService.getKey() key='" + namespace + "'");
        }
        return namespace;
    }

    public byte[] preProcess(String name, byte[] classbytes, ClassLoader loader) throws IOException {
        if (this.enabled) {
            if (AspectJWeavingStarter.DEBUG) {
                System.out.println("> WeavingService.preProcess() bundle=" + this.bundleRevision.getSymbolicName() + ", name=" + name + ", bytes=" + classbytes.length);
            }
            this.ensureAdaptorInit();
            byte[] newBytes = this.weavingAdaptor.weaveClass(name, classbytes, false);
            if (AspectJWeavingStarter.DEBUG) {
                System.out.println("< WeavingService.preProcess() bytes=" + newBytes.length);
            }
            return newBytes;
        }
        return null;
    }
}

