/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.model2doc.integration.nattable.template2structure.internal.mapping;

import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.LabelStack;
import org.eclipse.nebula.widgets.nattable.style.DisplayMode;
import org.eclipse.papyrus.infra.nattable.provider.NattableTopLabelProvider;
import org.eclipse.papyrus.infra.nattable.utils.ILabelProviderCellContextElementWrapper;
import org.eclipse.swt.graphics.Rectangle;

class CustomNattableLabelProvider
extends NattableTopLabelProvider {
    private final StubILabelProviderCellContextElementWrapper wrapper;
    private IConfigRegistry configRegistry;

    public CustomNattableLabelProvider(IConfigRegistry registry) {
        this.wrapper = new StubILabelProviderCellContextElementWrapper(registry);
        this.configRegistry = registry;
    }

    public String getRowHeaderLabel(Object element) {
        this.wrapper.setColumn(false);
        this.wrapper.setObject(element);
        String res = this.getRowHeaderLabel(this.wrapper, this.configRegistry);
        return res != null ? res : "";
    }

    public String getColumnHeaderLabel(Object element) {
        this.wrapper.setColumn(true);
        this.wrapper.setObject(element);
        String res = this.getColumnHeaderLabel(this.wrapper, this.configRegistry);
        return res != null ? res : "";
    }

    private class StubILabelProviderCellContextElementWrapper
    implements ILabelProviderCellContextElementWrapper {
        private Object object;
        private final IConfigRegistry configRegistry;
        private boolean isColumn;
        private final LabelStack COLUMN_HEADER_STACK = new LabelStack(new String[]{"COLUMN_HEADER"});
        private final LabelStack ROW_HEADER_STACK = new LabelStack(new String[]{"ROW_HEADER"});

        StubILabelProviderCellContextElementWrapper(IConfigRegistry configRegistry) {
            this.configRegistry = configRegistry;
        }

        public void setObject(Object object) {
            this.object = object;
        }

        public void setColumn(boolean isColumn) {
            this.isColumn = isColumn;
        }

        public IConfigRegistry getConfigRegistry() {
            return this.configRegistry;
        }

        public Object getObject() {
            return this.object;
        }

        public int getOriginColumnPosition() {
            return 0;
        }

        public int getOriginRowPosition() {
            return 0;
        }

        public ILayer getLayer() {
            return null;
        }

        public int getColumnPosition() {
            return 0;
        }

        public int getRowPosition() {
            return 0;
        }

        public int getColumnIndex() {
            return 0;
        }

        public int getRowIndex() {
            return 0;
        }

        public int getColumnSpan() {
            return 0;
        }

        public int getRowSpan() {
            return 0;
        }

        public boolean isSpannedCell() {
            return false;
        }

        public DisplayMode getDisplayMode() {
            return null;
        }

        public LabelStack getConfigLabels() {
            if (this.isColumn) {
                return this.COLUMN_HEADER_STACK;
            }
            return this.ROW_HEADER_STACK;
        }

        public Object getDataValue() {
            return this.object;
        }

        public Rectangle getBounds() {
            return null;
        }
    }
}

